/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.JoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

class MergeJoinResultSet
extends JoinResultSet {
    private static final int GREATER_THAN = 1;
    private static final int EQUAL = 0;
    private static final int LESS_THAN = -1;
    private GeneratedMethod leftGreaterThanRight;

    MergeJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, Activation activation, GeneratedMethod leftGreaterThanRight, GeneratedMethod restriction, int resultSetNumber, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, int leftResultColumnNames, int rightResultColumnNames) {
        super(leftResultSet, leftNumCols, rightResultSet, rightNumCols, activation, restriction, resultSetNumber, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, null, leftResultColumnNames, rightResultColumnNames);
        this.leftGreaterThanRight = leftGreaterThanRight;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (!this.isRightOpen) {
            this.openRight();
        }
        while (this.leftRow != null) {
            int compareResult;
            while ((compareResult = ((Integer)this.leftGreaterThanRight.invoke(this.activation)).intValue()) == 1) {
                this.rightRow = this.rightResultSet.getNextRowCore();
                ++this.rowsSeenRight;
                if (this.rightRow != null) continue;
                this.clearCurrentRow();
                return null;
            }
            if (compareResult == 0 && this.restrictionIsTrue()) {
                ExecRow returnRow = this.getReturnRow(this.leftRow, this.rightRow);
                this.leftRow = this.leftResultSet.getNextRowCore();
                return returnRow;
            }
            this.leftRow = this.leftResultSet.getNextRowCore();
            ++this.rowsSeenLeft;
        }
        this.clearCurrentRow();
        return null;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"MergeJoinResultSet not open");
        if (this.isOpen) {
            this.clearCurrentRow();
            super.close(cleanupOnError);
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.leftResultSet.getTimeSpent(1, timeType) - this.rightResultSet.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    private ExecRow getReturnRow(ExecRow leftRow, ExecRow rightRow) throws StandardException {
        if (this.mergedRow == null) {
            this.mergedRow = this.getExecutionFactory().getValueRow(this.leftNumCols + this.rightNumCols);
        }
        int colInCtr = 1;
        int colOutCtr = 1;
        while (colInCtr <= this.leftNumCols) {
            this.mergedRow.setColumn(colOutCtr, leftRow.getColumn(colInCtr));
            ++colInCtr;
            ++colOutCtr;
        }
        colInCtr = 1;
        while (colInCtr <= this.rightNumCols) {
            this.mergedRow.setColumn(colOutCtr, rightRow.getColumn(colInCtr));
            ++colInCtr;
            ++colOutCtr;
        }
        this.setCurrentRow(this.mergedRow);
        ++this.rowsReturned;
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return this.mergedRow;
    }

    private boolean restrictionIsTrue() throws StandardException {
        DataValueDescriptor restrictBoolean;
        if (this.restriction != null && ((restrictBoolean = (DataValueDescriptor)this.restriction.invoke(this.activation)).isNull() || !restrictBoolean.getBoolean())) {
            ++this.rowsFiltered;
            this.filteredRowLocationPostRead(this.localTXState);
            return false;
        }
        return true;
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "MERGEJOIN");
        if (this.leftResultSet != null) {
            this.leftResultSet.buildQueryPlan(builder, context.pushContext());
        }
        builder.append("<join/>");
        if (this.rightResultSet != null) {
            this.rightResultSet.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }
}

