/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

public abstract class JoinResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    public long restrictionTime;
    protected boolean isRightOpen;
    protected ExecRow leftRow;
    protected ExecRow rightRow;
    protected ExecRow mergedRow;
    public NoPutResultSet leftResultSet;
    protected int leftNumCols;
    public NoPutResultSet rightResultSet;
    protected int rightNumCols;
    protected GeneratedMethod restriction;
    public boolean oneRowRightSide;
    public boolean notExistsRightSide;
    String userSuppliedOptimizerOverrides;
    public String[] leftResultSetColumnNames;
    public String[] rightResultSetColumnNames;

    JoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, Activation activation, GeneratedMethod restriction, int resultSetNumber, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides, int leftResultColumnNames, int rightResultColumnNames) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.leftResultSet = leftResultSet;
        this.leftNumCols = leftNumCols;
        this.rightResultSet = rightResultSet;
        this.rightNumCols = rightNumCols;
        this.restriction = restriction;
        this.oneRowRightSide = oneRowRightSide;
        this.notExistsRightSide = notExistsRightSide;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        if (leftResultColumnNames != -1) {
            this.leftResultSetColumnNames = (String[])this.getActivation().getSavedObject(leftResultColumnNames);
        }
        if (rightResultColumnNames != -1) {
            this.rightResultSetColumnNames = (String[])this.getActivation().getSavedObject(rightResultColumnNames);
        }
        this.initLocalTXState();
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    void clearScanState() {
        this.leftRow = null;
        this.rightRow = null;
        this.mergedRow = null;
    }

    @Override
    public void openCore() throws StandardException {
        this.preOpen();
        this.ncjOpen();
        this.postOpen();
    }

    public void ncjOpen() throws StandardException {
    }

    protected void preOpen() throws StandardException {
        this.clearScanState();
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"JoinResultSet already open");
        this.isOpen = true;
    }

    protected void postOpen() throws StandardException {
        this.leftResultSet.openCore();
        this.leftRow = this.leftResultSet.getNextRowCore();
        if (this.leftRow != null) {
            this.openRight();
            ++this.rowsSeenLeft;
        }
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        if (this.statisticsTimingOn) {
            this.beginTime = XPLAINUtil.nanoTime();
        }
        this.leftResultSet.releasePreviousByteSource();
        this.rightResultSet.releasePreviousByteSource();
        this.clearScanState();
        this.ncjOpen();
        this.leftResultSet.reopenCore();
        this.leftRow = this.leftResultSet.getNextRowCore();
        if (this.leftRow != null) {
            this.openRight();
            ++this.rowsSeenLeft;
        } else if (this.isRightOpen) {
            this.closeRight();
        }
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        if (this.isOpen) {
            this.leftResultSet.close(cleanupOnError);
            if (this.isRightOpen) {
                this.closeRight();
            }
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of JoinResultSet repeated");
        }
        this.clearScanState();
    }

    @Override
    public void finish() throws StandardException {
        this.leftResultSet.finish();
        this.rightResultSet.finish();
        super.finish();
    }

    @Override
    public RowLocation getRowLocation() {
        SanityManager.THROWASSERT((String)"Join used in positioned update/delete");
        return null;
    }

    @Override
    public ExecRow getCurrentRow() {
        SanityManager.THROWASSERT((String)"Join used in positioned update/delete");
        return null;
    }

    protected void openRight() throws StandardException {
        if (this.isRightOpen) {
            this.rightResultSet.reopenCore();
        } else {
            this.isRightOpen = true;
            this.rightResultSet.openCore();
        }
    }

    protected void closeRight() throws StandardException {
        SanityManager.ASSERT((boolean)this.isRightOpen, (String)"isRightOpen is expected to be true");
        this.rightResultSet.close(false);
        this.isRightOpen = false;
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        SanityManager.THROWASSERT((String)"not expected to be invoked for joins");
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        if (this.isRightOpen) {
            this.rightResultSet.filteredRowLocationPostRead(localTXState);
        }
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        int noChildren = 0;
        if (this.leftResultSet != null) {
            ++noChildren;
        }
        if (this.rightResultSet != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.leftResultSet != null) {
            this.leftResultSet.accept(visitor);
        }
        if (this.rightResultSet != null) {
            this.rightResultSet.accept(visitor);
        }
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlAttribute(builder, "rows_seen_left", this.rowsSeenLeft);
        PlanUtils.xmlAttribute(builder, "rows_seen_right", this.rowsSeenRight);
        PlanUtils.xmlAttribute(builder, "restriction_time", this.restrictionTime);
        if (this.userSuppliedOptimizerOverrides != null) {
            PlanUtils.xmlAttribute(builder, "optimizer_overrides", this.userSuppliedOptimizerOverrides);
        }
        return builder;
    }

    @Override
    public void resetStatistics() {
        this.rowsSeenLeft = 0;
        this.rowsSeenRight = 0;
        this.rowsReturned = 0;
        this.restrictionTime = 0L;
        super.resetStatistics();
        this.leftResultSet.resetStatistics();
        this.rightResultSet.resetStatistics();
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with left-source = " + (this.leftResultSet != null ? this.leftResultSet.getClass().getSimpleName() : null) + " and left-source ResultSetNumber = " + (this.leftResultSet != null ? this.leftResultSet.resultSetNumber() : -1) + " with right-source = " + (this.rightResultSet != null ? this.rightResultSet.getClass().getSimpleName() : null) + " and right-source ResultSetNumber = " + (this.rightResultSet != null ? this.rightResultSet.resultSetNumber() : -1)));
        }
    }
}

