/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableArrayHolder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableIntHolder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.KeyHasher;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class HashScanResultSet
extends ScanResultSet
implements CursorResultSet {
    private boolean hashtableBuilt;
    private ExecIndexRow startPosition;
    private ExecIndexRow stopPosition;
    protected ExecRow compactRow;
    protected boolean firstNext = true;
    private int numFetchedOnNext;
    private int entryVectorSize;
    private List entryVector;
    private List rakVector;
    private long conglomId;
    protected StaticCompiledOpenConglomInfo scoci;
    private GeneratedMethod resultRowAllocator;
    private GeneratedMethod startKeyGetter;
    private int startSearchOperator;
    private GeneratedMethod stopKeyGetter;
    private int stopSearchOperator;
    public Qualifier[][] scanQualifiers;
    public Qualifier[][] nextQualifiers;
    private int initialCapacity;
    private float loadFactor;
    private int maxCapacity;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    public boolean forUpdate;
    private boolean runTimeStatisticsOn;
    public int[] keyColumns;
    private boolean sameStartStopPosition;
    private boolean skipNullKeyColumns;
    private boolean keepAfterCommit;
    protected BackingStoreHashtable hashtable;
    protected boolean eliminateDuplicates;
    public Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    public int hashtableSize;
    public boolean isConstraint;
    public static final int DEFAULT_INITIAL_CAPACITY = -1;
    public static final float DEFAULT_LOADFACTOR = -1.0f;
    public static final int DEFAULT_MAX_CAPACITY = -1;

    HashScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] scanQualifiers, Qualifier[][] nextQualifiers, int initialCapacity, float loadFactor, int maxCapacity, int hashKeyItem, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int lockMode, boolean tableLocked, int isolationLevel, boolean skipNullKeyColumns, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, resultRowAllocator, lockMode, tableLocked, isolationLevel, colRefItem, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.scoci = scoci;
        this.conglomId = conglomId;
        SanityManager.ASSERT((activation != null ? 1 : 0) != 0, (String)"hash scan must get activation context");
        SanityManager.ASSERT((resultRowAllocator != null ? 1 : 0) != 0, (String)"hash scan must get row allocator");
        if (sameStartStopPosition) {
            SanityManager.ASSERT((stopKeyGetter == null ? 1 : 0) != 0, (String)"stopKeyGetter expected to be null when sameStartStopPosition is true");
        }
        this.resultRowAllocator = resultRowAllocator;
        this.startKeyGetter = startKeyGetter;
        this.startSearchOperator = startSearchOperator;
        this.stopKeyGetter = stopKeyGetter;
        this.stopSearchOperator = stopSearchOperator;
        this.sameStartStopPosition = sameStartStopPosition;
        this.scanQualifiers = scanQualifiers;
        this.nextQualifiers = nextQualifiers;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.maxCapacity = maxCapacity;
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = indexName;
        this.isConstraint = isConstraint;
        this.forUpdate = forUpdate;
        this.skipNullKeyColumns = skipNullKeyColumns;
        this.keepAfterCommit = activation.getResultSetHoldability();
        FormatableArrayHolder fah = (FormatableArrayHolder)activation.getSavedObject(hashKeyItem);
        FormatableIntHolder[] fihArray = (FormatableIntHolder[])fah.getArray(FormatableIntHolder.class);
        this.keyColumns = new int[fihArray.length];
        for (int index = 0; index < fihArray.length; ++index) {
            this.keyColumns[index] = fihArray[index].getInt();
        }
        this.runTimeStatisticsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.compactRow = this.getCompactRow(this.candidate, this.accessedCols, false);
        this.initLocalTXState();
        this.recordConstructorTime();
    }

    @Override
    boolean canGetInstantaneousLocks() {
        return true;
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"HashScanResultSet already open");
        this.isOpen = true;
        TransactionController tc = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
        if (!this.skipScan(this.startPosition, this.stopPosition) && !this.hashtableBuilt) {
            DataValueDescriptor[] startPositionRow = this.startPosition == null ? null : this.startPosition.getRowArray();
            DataValueDescriptor[] stopPositionRow = this.stopPosition == null ? null : this.stopPosition.getRowArray();
            this.hashtable = tc.createBackingStoreHashtableFromScan(this.conglomId, this.forUpdate ? 4 : 0, this.lockMode, this.isolationLevel, this.accessedCols, startPositionRow, this.startSearchOperator, this.scanQualifiers, stopPositionRow, this.stopSearchOperator, -1L, this.keyColumns, this.eliminateDuplicates, -1L, this.maxCapacity, this.initialCapacity, this.loadFactor, this.runTimeStatisticsOn, this.skipNullKeyColumns, this.keepAfterCommit, this.activation);
            this.checkCancellationFlag();
            if (this.runTimeStatisticsOn) {
                this.hashtableSize = this.hashtable.size();
                if (this.scanProperties == null) {
                    this.scanProperties = new Properties();
                }
                try {
                    if (this.hashtable != null) {
                        this.hashtable.getAllRuntimeStats(this.scanProperties);
                    }
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
            }
            this.hashtableBuilt = true;
            this.activation.informOfRowCount(this, this.hashtableSize);
        }
        this.resetProbeVariables();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"HashScanResultSet already open");
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.resetProbeVariables();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    private void resetProbeVariables() throws StandardException {
        this.rowsSeen += this.numFetchedOnNext;
        this.firstNext = true;
        this.numFetchedOnNext = 0;
        this.entryVector = null;
        this.rakVector = null;
        this.entryVectorSize = 0;
        if (this.nextQualifiers != null) {
            this.clearOrderableCache(this.nextQualifiers);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        this.checkCancellationFlag();
        ExecRow result = null;
        DataValueDescriptor[] columns = null;
        Object rak = null;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen && this.hashtableBuilt) {
            do {
                if (this.firstNext) {
                    Object hashEntry;
                    this.firstNext = false;
                    if (this.keyColumns.length == 1) {
                        hashEntry = this.hashtable.get(this.nextQualifiers[0][0].getOrderable());
                        rak = this.hashtable.getFromRegionAndKeyHash(this.nextQualifiers[0][0].getOrderable());
                        if (GemFireXDUtils.TraceOuterJoin) {
                            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("HashScanResultSet::getNextRowCore_one hashEntry: " + hashEntry + (hashEntry != null && hashEntry instanceof DataValueDescriptor[] ? Arrays.toString((DataValueDescriptor[])hashEntry) : "null") + " and rak: " + rak));
                        }
                    } else {
                        KeyHasher mh = new KeyHasher(this.keyColumns.length);
                        SanityManager.ASSERT((this.nextQualifiers.length == 1 ? 1 : 0) != 0);
                        for (int index = 0; index < this.keyColumns.length; ++index) {
                            DataValueDescriptor dvd = this.nextQualifiers[0][index].getOrderable();
                            if (dvd == null) {
                                mh = null;
                                break;
                            }
                            mh.setObject(index, this.nextQualifiers[0][index].getOrderable());
                        }
                        if (mh == null) {
                            hashEntry = null;
                        } else {
                            hashEntry = this.hashtable.get(mh);
                            if (GemFireXDUtils.TraceOuterJoin) {
                                SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("HashScanResultSet::getNextRowCore_two hashEntry: " + hashEntry + (hashEntry != null && hashEntry instanceof DataValueDescriptor[] ? Arrays.toString((DataValueDescriptor[])hashEntry) : "null") + " and rak: " + rak));
                            }
                            rak = this.hashtable.getFromRegionAndKeyHash(mh);
                        }
                    }
                    if (hashEntry instanceof List) {
                        this.entryVector = (List)hashEntry;
                        this.entryVectorSize = this.entryVector.size();
                        columns = (DataValueDescriptor[])this.entryVector.get(0);
                        if (rak != null) {
                            assert (rak instanceof List);
                            this.rakVector = (List)rak;
                            rak = this.rakVector.get(0);
                        }
                    } else {
                        this.entryVector = null;
                        this.rakVector = null;
                        this.entryVectorSize = 0;
                        columns = (DataValueDescriptor[])hashEntry;
                    }
                } else if (this.numFetchedOnNext < this.entryVectorSize) {
                    columns = (DataValueDescriptor[])this.entryVector.get(this.numFetchedOnNext);
                    if (this.rakVector != null) {
                        rak = (RegionAndKey)this.rakVector.get(this.numFetchedOnNext);
                    }
                }
                if (columns != null) {
                    if (RowUtil.qualifyRow(columns, null, this.nextQualifiers, false)) {
                        if (this.compactRow != null) {
                            this.compactRow.clearAllRegionAndKeyInfo();
                        }
                        this.setCompactRow(this.compactRow, columns);
                        ++this.rowsSeen;
                        result = this.compactRow;
                    } else {
                        result = null;
                    }
                    ++this.numFetchedOnNext;
                    continue;
                }
                result = null;
            } while (result == null && this.numFetchedOnNext < this.entryVectorSize);
        }
        this.setCurrentRow(result);
        if (GemFireXDUtils.TraceOuterJoin) {
            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("HashScanResultSet::getNextRowCore_one current row set with row: " + result + " and rak: " + rak));
        }
        if (result != null) {
            if (rak != null) {
                assert (rak instanceof RegionAndKey);
                result.addRegionAndKey((RegionAndKey)rak);
            }
            if (this.localTXState != null && this.isTopResultSet && this.isForUpdate()) {
                this.updateRowLocationPostRead();
            }
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.hashtableBuilt) {
                this.scanProperties = this.getScanProperties();
                if (this.runTimeStatisticsOn) {
                    this.startPositionString = this.printStartPosition();
                    this.stopPositionString = this.printStopPosition();
                }
                this.hashtable.close();
                this.hashtable = null;
                this.hashtableBuilt = false;
            }
            this.startPosition = null;
            this.stopPosition = null;
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of HashScanResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time;
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public boolean requiresRelocking() {
        return this.isolationLevel == 2 || this.isolationLevel == 3 || this.isolationLevel == 1;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (!this.hashtableBuilt) {
            return null;
        }
        SanityManager.ASSERT((this.currentRow != null ? 1 : 0) != 0, (String)"There must be a current row when fetching the row location");
        DataValueDescriptor rlCandidate = this.currentRow.getLastColumn();
        if (!(rlCandidate instanceof RowLocation)) {
            SanityManager.THROWASSERT((String)("rlCandidate expected to be instanceof RowLocation, not " + rlCandidate.getClass().getName()));
        }
        return (RowLocation)this.currentRow.getLastColumn();
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.THROWASSERT((String)"getCurrentRow() not expected to be called for HSRS");
        return null;
    }

    public String printStartPosition() {
        return this.printPosition(this.startSearchOperator, this.startKeyGetter, this.startPosition);
    }

    public String printStopPosition() {
        if (this.sameStartStopPosition) {
            return this.printPosition(this.stopSearchOperator, this.startKeyGetter, this.startPosition);
        }
        return this.printPosition(this.stopSearchOperator, this.stopKeyGetter, this.stopPosition);
    }

    private String printPosition(int searchOperator, GeneratedMethod positionGetter, ExecIndexRow eiRow) {
        String idt = "";
        String output = "";
        if (positionGetter == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U") + "\n";
        }
        ExecIndexRow positioner = null;
        try {
            positioner = (ExecIndexRow)positionGetter.invoke(this.activation);
        }
        catch (StandardException e) {
            if (eiRow == null) {
                return "\t" + MessageService.getTextMessage("42Z38.U");
            }
            return "\t" + MessageService.getTextMessage("42Z39.U") + "\n";
        }
        if (positioner == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U") + "\n";
        }
        String searchOp = null;
        switch (searchOperator) {
            case 1: {
                searchOp = ">=";
                break;
            }
            case -1: {
                searchOp = ">";
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unknown search operator " + searchOperator));
                searchOp = "unknown value (" + searchOperator + ")";
            }
        }
        output = output + "\t" + MessageService.getTextMessage("42Z40.U", searchOp, String.valueOf(positioner.nColumns())) + "\n";
        output = output + "\t" + MessageService.getTextMessage("42Z41.U") + "\n";
        for (int position = 0; position < positioner.nColumns(); ++position) {
            if (!positioner.areNullsOrdered(position)) continue;
            output = output + position + " ";
        }
        return output + "\n";
    }

    public Properties getScanProperties() {
        return this.scanProperties;
    }

    @Override
    public boolean isForUpdate() {
        return this.forUpdate;
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.upgradeReadLockToWrite(this.getRowLocation(), null);
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        if (localTXState != null) {
            this.releaseRowLocationLock(this.getRowLocation(), null);
        }
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "HASHSCAN");
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }
}

