/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SPSDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.InternalTriggerExecutionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerEvent;

abstract class GenericTriggerExecutor {
    final InternalTriggerExecutionContext tec;
    final TriggerDescriptor triggerd;
    final Activation activation;
    final LanguageConnectionContext lcc;
    private ExecPreparedStatement ps;
    private Activation spsActivation;

    GenericTriggerExecutor(InternalTriggerExecutionContext tec, TriggerDescriptor triggerd, Activation activation, LanguageConnectionContext lcc) {
        this.tec = tec;
        this.triggerd = triggerd;
        this.activation = activation;
        this.lcc = lcc;
    }

    abstract void fireTrigger(TriggerEvent var1, CursorResultSet var2, CursorResultSet var3) throws StandardException;

    protected SPSDescriptor getWhenClause() throws StandardException {
        return this.triggerd.getWhenClauseSPS();
    }

    protected SPSDescriptor getAction() throws StandardException {
        return this.triggerd.getActionSPS(this.lcc);
    }

    protected void executeSPS(SPSDescriptor sps) throws StandardException {
        boolean recompile = false;
        while (true) {
            if (this.ps == null || recompile) {
                this.ps = sps.getPreparedStatement();
                this.ps = this.ps.getClone();
                this.ps.setValid();
                this.spsActivation = this.ps.getActivation(this.lcc, false, null);
                this.ps.setSource(sps.getText());
                this.ps.setSPSAction();
            }
            StatementContext active_sc = this.lcc.getStatementContext();
            try {
                ResultSet rs = this.ps.execute(this.spsActivation, false, 0L, true, true);
                if (rs.returnsRows()) {
                    while (rs.getNextRow() != null) {
                    }
                }
                rs.close(false);
            }
            catch (StandardException e) {
                StatementContext sc = this.lcc.getStatementContext();
                if (active_sc != sc) {
                    sc.cleanupOnError(e);
                }
                if (e.getMessageId().equals("XCL32.S")) {
                    recompile = true;
                    sps.revalidate(this.lcc);
                    continue;
                }
                this.spsActivation.close();
                throw e;
            }
            break;
        }
    }

    protected void clearSPS() throws StandardException {
        if (this.spsActivation != null) {
            this.spsActivation.close();
        }
        this.ps = null;
        this.spsActivation = null;
    }
}

