/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTableNumbersVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectAndEliminateColumnsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectNodesVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RemapCRsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnionNode;
import java.util.HashMap;
import java.util.Vector;

abstract class SetOperatorNode
extends TableOperatorNode {
    boolean all;
    OrderByList orderByList;
    private PredicateList leftOptPredicates;
    private PredicateList rightOptPredicates;
    private PredicateList pushedPredicates;
    private HashMap leftScopedPreds;
    private HashMap rightScopedPreds;

    SetOperatorNode() {
    }

    @Override
    public void init(Object leftResult, Object rightResult, Object all, Object tableProperties) throws StandardException {
        super.init(leftResult, rightResult, tableProperties);
        this.all = (Boolean)all;
        this.resultColumns = this.leftResultSet.getResultColumns().copyListAndObjects();
    }

    public Optimizable modifyAccessPath(JBitSet outerTables, PredicateList predList) throws StandardException {
        if (predList != null && !this.getTrulyTheBestAccessPath().getJoinStrategy().isHashJoin()) {
            for (int i = predList.size() - 1; i >= 0; --i) {
                if (!this.pushOptPredicate(predList.getOptPredicate(i))) continue;
                predList.removeOptPredicate(i);
            }
        }
        CostEstimate ce = this.getFinalCostEstimate();
        ResultSetNode topNode = (ResultSetNode)((Object)this.modifyAccessPath(outerTables));
        CollectNodesVisitor cnv = new CollectNodesVisitor(UnionNode.class);
        this.accept(cnv);
        Vector unions = cnv.getList();
        boolean genPRN = false;
        for (int i = unions.size() - 1; i >= 0; --i) {
            if (!((UnionNode)unions.get(i)).hasUnPushedPredicates()) continue;
            genPRN = true;
            break;
        }
        if (genPRN) {
            ResultSetNode prnRSN = (ResultSetNode)this.getNodeFactory().getNode(151, topNode, topNode.getResultColumns(), null, this.pushedPredicates, null, null, null, this.getContextManager());
            prnRSN.costEstimate = ce.cloneMe();
            prnRSN.setReferencedTableMap(topNode.getReferencedTableMap());
            topNode = prnRSN;
        }
        return (Optimizable)((Object)topNode);
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        if (!(this instanceof UnionNode)) {
            return false;
        }
        Predicate pred = (Predicate)optimizablePredicate;
        if (!pred.pushableToSubqueries()) {
            return false;
        }
        boolean canPush = false;
        JBitSet tableNums = new JBitSet(this.getReferencedTableMap().size());
        BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(tableNums);
        this.leftResultSet.accept(btnVis);
        boolean bl = canPush = tableNums.getFirstSetBit() != -1;
        if (!canPush) {
            return false;
        }
        tableNums.clearAll();
        this.rightResultSet.accept(btnVis);
        boolean bl2 = canPush = tableNums.getFirstSetBit() != -1;
        if (!canPush) {
            return false;
        }
        tableNums.clearAll();
        this.accept(btnVis);
        int[] whichRC = new int[]{-1};
        Predicate scopedPred = null;
        if (this.leftScopedPreds == null) {
            this.leftScopedPreds = new HashMap();
        } else {
            scopedPred = (Predicate)this.leftScopedPreds.get(pred);
        }
        if (scopedPred == null) {
            scopedPred = pred.getPredScopedForResultSet(tableNums, this.leftResultSet, whichRC);
            this.leftScopedPreds.put(pred, scopedPred);
        }
        this.getLeftOptPredicateList().addOptPredicate(scopedPred);
        scopedPred = null;
        if (this.rightScopedPreds == null) {
            this.rightScopedPreds = new HashMap();
        } else {
            scopedPred = (Predicate)this.rightScopedPreds.get(pred);
        }
        if (scopedPred == null) {
            scopedPred = pred.getPredScopedForResultSet(tableNums, this.rightResultSet, whichRC);
            this.rightScopedPreds.put(pred, scopedPred);
        }
        this.getRightOptPredicateList().addOptPredicate(scopedPred);
        if (this.pushedPredicates == null) {
            this.pushedPredicates = new PredicateList();
        }
        this.pushedPredicates.addOptPredicate(pred);
        return true;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates, JBitSet outerTables) throws StandardException {
        if (this.pushedPredicates == null) {
            return;
        }
        if (this.leftOptPredicates != null) {
            this.leftOptPredicates.removeAllElements();
        }
        if (this.rightOptPredicates != null) {
            this.rightOptPredicates.removeAllElements();
        }
        Predicate pred = null;
        RemapCRsVisitor rcrv = new RemapCRsVisitor(false);
        for (int i = 0; i < this.pushedPredicates.size(); ++i) {
            pred = (Predicate)this.pushedPredicates.getOptPredicate(i);
            if (pred.isScopedForPush()) {
                pred.getAndNode().accept(rcrv);
                continue;
            }
            optimizablePredicates.addOptPredicate(pred);
        }
        this.pushedPredicates.removeAllElements();
    }

    protected boolean hasUnPushedPredicates() {
        return this.leftOptPredicates != null && this.leftOptPredicates.size() > 0 || this.rightOptPredicates != null && this.rightOptPredicates.size() > 0;
    }

    @Override
    public String toString() {
        return "all: " + this.all + "\n" + "orderByList: " + (this.orderByList != null ? this.orderByList.toString() : "null") + "\n" + super.toString();
    }

    @Override
    public void bindResultColumns(FromList fromListParam) throws StandardException {
        super.bindResultColumns(fromListParam);
        this.buildRCL();
    }

    @Override
    public void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        super.bindResultColumns(targetTableDescriptor, targetVTI, targetColumnList, statement, fromListParam);
        this.buildRCL();
    }

    private void buildRCL() throws StandardException {
        if (this.leftResultSet.getResultColumns().visibleSize() != this.rightResultSet.getResultColumns().visibleSize()) {
            throw StandardException.newException("42X58", this.getOperatorName());
        }
        this.resultColumns = this.leftResultSet.getResultColumns().copyListAndObjects();
        this.resultColumns.removeGeneratedGroupingColumns();
        this.resultColumns.setUnionResultExpression(this.rightResultSet.getResultColumns(), this.tableNumber, this.level, this.getOperatorName());
    }

    @Override
    public void bindUntypedNullsToResultColumns(ResultColumnList rcl) throws StandardException {
        if (rcl == null) {
            ResultColumnList lrcl = this.rightResultSet.getResultColumns();
            ResultColumnList rrcl = this.leftResultSet.getResultColumns();
            this.leftResultSet.bindUntypedNullsToResultColumns(rrcl);
            this.rightResultSet.bindUntypedNullsToResultColumns(lrcl);
        } else {
            this.leftResultSet.bindUntypedNullsToResultColumns(rcl);
            this.rightResultSet.bindUntypedNullsToResultColumns(rcl);
        }
    }

    int getParamColumnTypes(DataTypeDescriptor[] types, RowResultSetNode rrsn) throws StandardException {
        int numTypes = 0;
        for (int i = 0; i < types.length; ++i) {
            ResultColumn rc;
            if (types[i] != null || (rc = (ResultColumn)rrsn.getResultColumns().elementAt(i)).getExpression().requiresTypeFromContext() && !rc.getExpression().isParameterizedConstantNode()) continue;
            types[i] = rc.getExpression().getTypeServices();
            ++numTypes;
        }
        return numTypes;
    }

    void setParamColumnTypes(DataTypeDescriptor[] types, RowResultSetNode rrsn) throws StandardException {
        ResultColumnList rrcl = rrsn.getResultColumns();
        int rrclSize = rrcl.size();
        for (int index = 0; index < rrclSize; ++index) {
            ResultColumn rc = (ResultColumn)rrcl.elementAt(index);
            if (!rc.getExpression().requiresTypeFromContext()) continue;
            rc.getExpression().setType(types[index]);
        }
    }

    @Override
    public void bindTargetExpressions(FromList fromListParam) throws StandardException {
        this.leftResultSet.bindTargetExpressions(fromListParam);
        this.rightResultSet.bindTargetExpressions(fromListParam);
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.orderByList = orderByList;
    }

    @Override
    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        SetOperatorNode newTop = this;
        this.leftResultSet = this.leftResultSet.preprocess(numTables, gbl, fromList);
        this.rightResultSet = this.rightResultSet.preprocess(numTables, gbl, fromList);
        this.referencedTableMap = (JBitSet)this.leftResultSet.getReferencedTableMap().clone();
        this.referencedTableMap.or(this.rightResultSet.getReferencedTableMap());
        if (!this.all && this.orderByList != null && this.orderByList.allAscending() && this.orderByList.isInOrderPrefix(this.resultColumns)) {
            this.orderByList = null;
        }
        return newTop;
    }

    @Override
    public ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this.genProjectRestrict(numTables);
    }

    @Override
    public void verifySelectStarSubquery(FromList outerFromList, int subqueryType) throws StandardException {
        this.leftResultSet.verifySelectStarSubquery(outerFromList, subqueryType);
        this.rightResultSet.verifySelectStarSubquery(outerFromList, subqueryType);
    }

    @Override
    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.leftResultSet.getFromTableByName(name, schemaName, exactMatch);
    }

    @Override
    public ResultSetNode setResultToBooleanTrueNode(boolean onlyConvertAlls) throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getContextManager());
        fromList.addFromTable(this);
        fromList.markAsTransparent();
        ResultColumnList rcl = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ResultColumn allResultColumn = (ResultColumn)this.getNodeFactory().getNode(16, null, this.getContextManager());
        rcl.addResultColumn(allResultColumn);
        ResultSetNode result = (ResultSetNode)this.getNodeFactory().getNode(129, rcl, null, fromList, null, null, null, false, this.getContextManager());
        return result.setResultToBooleanTrueNode(onlyConvertAlls);
    }

    @Override
    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    public boolean performMaterialization(JBitSet outerTables) throws StandardException {
        return false;
    }

    abstract String getOperatorName();

    PredicateList getLeftOptPredicateList() throws StandardException {
        if (this.leftOptPredicates == null) {
            this.leftOptPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        return this.leftOptPredicates;
    }

    PredicateList getRightOptPredicateList() throws StandardException {
        if (this.rightOptPredicates == null) {
            this.rightOptPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        return this.rightOptPredicates;
    }

    @Override
    public QueryInfo computeSubSelectQueryInfo(QueryInfoContext qic) throws StandardException {
        return ProjectRestrictNode.getSelectQueryInfo(qic, this);
    }

    @Override
    public void eliminateUnUsedColumns(ResultColumnList parentResultColumn, CollectAndEliminateColumnsVisitor finder) throws StandardException {
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        this.leftResultSet.optimizeForOffHeap(false);
        this.rightResultSet.optimizeForOffHeap(false);
    }
}

