/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.Constants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeap;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableArrayHolder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableIntHolder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.AccessPath;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.JoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RequiredRowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ViewDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.iapi.util.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryRelationalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectAndEliminateColumnsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CreateViewNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CurrentRowLocationNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.InListOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.IndexToBaseRowNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.LikeEscapeOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NestedLoopJoinStrategy;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OptimizerImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrListNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderedColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderedColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.ArrayDeque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class FromBaseTable
extends FromTable
implements Cloneable {
    static final int UNSET = -1;
    TableName tableName;
    TableDescriptor tableDescriptor;
    ConglomerateDescriptor baseConglomerateDescriptor;
    ConglomerateDescriptor[] conglomDescs;
    int updateOrDelete;
    int bulkFetch = -1;
    private double singleScanRowCount;
    private FormatableBitSet referencedCols;
    private ResultColumnList templateColumns;
    private String[] columnNames;
    private String raParentResultSetId;
    private long fkIndexConglomId;
    private int[] fkColArray;
    PredicateList baseTableRestrictionList;
    PredicateList nonBaseTableRestrictionList;
    PredicateList restrictionList;
    public PredicateList storeRestrictionList;
    public PredicateList nonStoreRestrictionList;
    private SelectQueryInfo qInfo;
    private GroupByList gbl;
    public static final int ONE_ROW_NONE = 0;
    public static final int ONE_ROW_UNIQUE = 1;
    public static final int ONE_ROW_NONUNIQUE = 2;
    private int flags = 0;
    private static final byte createGFEResultSet = 1;
    private static final byte specialRegionSize = 2;
    private static final byte skipIndexRowToBaseRow = 4;
    private static final byte specialMaxScan = 8;
    private static final byte distinctScan = 16;
    private static final byte raDependentScan = 32;
    private static final byte bulkFetchTurnedOff = 64;
    private static final short multiProbing = 128;
    private static final short existsBaseTable = 256;
    private static final short isNotExists = 512;
    private static final short getUpdateLocks = 1024;
    private static final short delayScanOpening = 2048;
    private static final short optimizeForOffHeap = 4096;
    private static final short indexAccesesBaseTable = 8192;
    PredicateList requalificationRestrictionList;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    private JBitSet dependencyMap;
    static final String validQueryHintProperites = (Object)((Object)Constants.QueryHints.index) + "," + (Object)((Object)Constants.QueryHints.constraint) + "," + (Object)((Object)Constants.QueryHints.joinStrategy) + "," + (Object)((Object)Constants.QueryHints.hashInitialCapacity) + "," + (Object)((Object)Constants.QueryHints.hashLoadFactor) + "," + (Object)((Object)Constants.QueryHints.hashMaxCapacity) + "," + (Object)((Object)Constants.QueryHints.bulkFetch) + "," + (Object)((Object)Constants.QueryHints.withSecondaries) + "," + (Object)((Object)Constants.QueryHints.queryHDFS);
    private boolean gotRowCount = false;
    private long rowCount = 0L;

    public FromBaseTable clone() {
        return new FromBaseTable(this);
    }

    public FromBaseTable() {
    }

    public FromBaseTable(FromBaseTable other) {
        super(other);
        try {
            this.tableName = other.tableName;
            this.setOrigTableName(this.tableName);
            this.tableDescriptor = other.tableDescriptor;
            this.baseConglomerateDescriptor = other.baseConglomerateDescriptor;
            this.updateOrDelete = other.updateOrDelete;
            this.templateColumns = this.resultColumns;
            if (this.resultColumns != null) {
                this.columnNames = this.resultColumns.getColumnNames();
            }
            if (other.referencedCols != null) {
                this.referencedCols = other.referencedCols.clone();
            }
            if (other.baseTableRestrictionList != null) {
                this.baseTableRestrictionList = new PredicateList();
                other.baseTableRestrictionList.copyPredicatesToOtherList(this.baseTableRestrictionList);
            }
            if (other.nonBaseTableRestrictionList != null) {
                this.nonBaseTableRestrictionList = new PredicateList();
                other.nonBaseTableRestrictionList.copyPredicatesToOtherList(this.nonBaseTableRestrictionList);
            }
            if (other.restrictionList != null) {
                this.restrictionList = new PredicateList();
                other.restrictionList.copyPredicatesToOtherList(this.restrictionList);
            }
            if (other.storeRestrictionList != null) {
                this.storeRestrictionList = new PredicateList();
                other.storeRestrictionList.copyPredicatesToOtherList(this.storeRestrictionList);
            }
            if (other.nonStoreRestrictionList != null) {
                this.nonStoreRestrictionList = new PredicateList();
                other.nonStoreRestrictionList.copyPredicatesToOtherList(this.nonStoreRestrictionList);
            }
            if (other.requalificationRestrictionList != null) {
                this.requalificationRestrictionList = new PredicateList();
                other.requalificationRestrictionList.copyPredicatesToOtherList(this.requalificationRestrictionList);
            }
            if (other.dependencyMap != null) {
                this.dependencyMap = (JBitSet)other.dependencyMap.clone();
            }
            this.bulkFetch = other.bulkFetch;
            this.gbl = other.gbl;
            this.flags = other.flags;
        }
        catch (StandardException e) {
            SanityManager.THROWASSERT((Throwable)e);
        }
    }

    void modifyResultColumns(PredicateList predList, int semiJoinColNum) throws StandardException {
        ColumnReference chosenCol = null;
        if (semiJoinColNum != -1) {
            for (QueryTreeNode pred : predList) {
                Predicate joinP = (Predicate)pred;
                ColumnReference cr = joinP.getRelop().getColumnOperand(this);
                if (cr.getColumnNumber() != semiJoinColNum) continue;
                chosenCol = cr;
            }
        } else {
            SanityManager.THROWASSERT((String)"NCJ: Join must have one PK column");
        }
        boolean modified = false;
        if (chosenCol != null) {
            int relSize = this.resultColumns.size();
            for (int i = relSize - 1; i >= 0; --i) {
                ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
                if (rc.getColumnPosition() == chosenCol.getColumnNumber()) continue;
                this.resultColumns.remove(i);
                modified = true;
            }
        } else {
            SanityManager.THROWASSERT((String)"NCJ: One column must be selected for semi join");
        }
        SanityManager.ASSERT((this.resultColumns.size() == 1 ? 1 : 0) != 0, (String)"NCJ: One and Only one column corresponding to join key should remain");
        if (this.templateColumns != null && modified) {
            this.templateColumns = this.resultColumns;
        }
    }

    public void setReferencedTableMap(int numTables) {
        this.referencedTableMap = new JBitSet(numTables);
        this.referencedTableMap.set(this.tableNumber);
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4) {
        if (arg3 instanceof Integer) {
            this.init(arg2, null);
            this.tableName = (TableName)arg1;
            this.updateOrDelete = (Integer)arg3;
            this.resultColumns = (ResultColumnList)arg4;
        } else {
            this.init(arg2, arg4);
            this.tableName = (TableName)arg1;
            this.resultColumns = (ResultColumnList)arg3;
        }
        this.setOrigTableName(this.tableName);
        this.templateColumns = this.resultColumns;
        this.optimizeForOffHeap(true);
    }

    @Override
    public boolean LOJ_reorderable(int numTables) throws StandardException {
        return false;
    }

    @Override
    public JBitSet LOJgetReferencedTables(int numTables) throws StandardException {
        JBitSet map = new JBitSet(numTables);
        this.fillInReferencedTableMap(map);
        return map;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "baseTableRestrictionList: \n");
        this.printPredicateList(this.baseTableRestrictionList, depth);
        this.printLabel(depth, "nonBaseTableRestrictionList: \n");
        this.printPredicateList(this.nonBaseTableRestrictionList, depth);
        this.printLabel(depth, "storeRestrictionList: \n");
        this.printPredicateList(this.storeRestrictionList, depth);
        this.printLabel(depth, "nonStoreRestrictionList: \n");
        this.printPredicateList(this.nonStoreRestrictionList, depth);
        this.printLabel(depth, "restrictionList: \n");
        this.printPredicateList(this.restrictionList, depth);
        this.printLabel(depth, "requalificationRestrictionList: \n");
        this.printPredicateList(this.requalificationRestrictionList, depth);
    }

    private void printPredicateList(PredicateList p, int depth) {
        if (p != null) {
            p.treePrint(depth);
        }
    }

    @Override
    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList predList, RowOrdering rowOrdering) throws StandardException {
        String userSpecifiedIndexName = this.getUserSpecifiedIndexName();
        AccessPath ap = this.getCurrentAccessPath();
        ConglomerateDescriptor currentConglomerateDescriptor = ap.getConglomerateDescriptor();
        optimizer.trace(42, predList == null ? 0 : predList.size(), 0, 0.0, this.getExposedName());
        rowOrdering.removeOptimizable(this.getTableNumber());
        if (userSpecifiedIndexName != null) {
            if (currentConglomerateDescriptor != null) {
                if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                    currentConglomerateDescriptor = null;
                }
            } else {
                optimizer.trace(39, this.tableNumber, 0, 0.0, userSpecifiedIndexName);
                if (StringUtil.SQLToUpperCase(userSpecifiedIndexName).equals("NULL")) {
                    currentConglomerateDescriptor = this.tableDescriptor.getConglomerateDescriptor(this.tableDescriptor.getHeapConglomerateId());
                } else {
                    String conglomerateName;
                    this.getConglomDescs();
                    for (int index = 0; !(index >= this.conglomDescs.length || (conglomerateName = (currentConglomerateDescriptor = this.conglomDescs[index]).getConglomerateName()) != null && conglomerateName.equals(userSpecifiedIndexName)); ++index) {
                    }
                    if (currentConglomerateDescriptor == null) {
                        SanityManager.THROWASSERT((String)("Expected to find match for forced index " + userSpecifiedIndexName));
                    }
                }
                if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                    SanityManager.THROWASSERT((String)"No join strategy found");
                }
            }
        } else if (currentConglomerateDescriptor != null) {
            if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                currentConglomerateDescriptor = this.getNextConglom(currentConglomerateDescriptor);
                this.resetJoinStrategies(optimizer);
                if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                    SanityManager.THROWASSERT((String)"No join strategy found");
                }
            }
        } else {
            currentConglomerateDescriptor = this.getFirstConglom();
            if (!super.nextAccessPath(optimizer, predList, rowOrdering)) {
                SanityManager.THROWASSERT((String)"No join strategy found");
            }
        }
        if (currentConglomerateDescriptor == null) {
            optimizer.trace(30, this.tableNumber, 0, 0.0, null);
        } else {
            currentConglomerateDescriptor.setColumnNames(this.columnNames);
            optimizer.trace(31, this.tableNumber, 0, 0.0, currentConglomerateDescriptor);
        }
        if (predList != null && predList.hasOrList()) {
            optimizer.trace(33, predList == null ? 0 : predList.size(), 0, 0.0, null);
            rowOrdering.addUnorderedOptimizable(this);
        } else if (currentConglomerateDescriptor != null) {
            IndexRowGenerator irg;
            if (!currentConglomerateDescriptor.isIndex() || "LOCALHASH1".equals((irg = currentConglomerateDescriptor.getIndexDescriptor()).indexType())) {
                if (!this.isOneRowResultSet(predList)) {
                    optimizer.trace(33, predList == null ? 0 : predList.size(), 0, 0.0, null);
                    rowOrdering.addUnorderedOptimizable(this);
                } else if (!currentConglomerateDescriptor.isIndex()) {
                    optimizer.trace(32, 0, 0, 0.0, null);
                } else {
                    optimizer.trace(63, 0, 0, 0.0, null);
                }
            } else {
                int[] baseColumnPositions = irg.baseColumnPositions();
                boolean[] isAscending = irg.isAscending();
                for (int i = 0; i < baseColumnPositions.length; ++i) {
                    if (rowOrdering.orderedOnColumn(isAscending[i] ? 1 : 2, this.getTableNumber(), baseColumnPositions[i])) continue;
                    rowOrdering.nextOrderPosition(isAscending[i] ? 1 : 2);
                    rowOrdering.addOrderedColumn(isAscending[i] ? 1 : 2, this.getTableNumber(), baseColumnPositions[i]);
                }
            }
        }
        ap.setConglomerateDescriptor(currentConglomerateDescriptor);
        return currentConglomerateDescriptor != null;
    }

    @Override
    protected boolean canBeOrdered() {
        return true;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        CompilerContext cc = this.getCompilerContext();
        boolean queryHDFS = false;
        if (lcc != null) {
            queryHDFS = lcc.getQueryHDFS();
        }
        if (cc != null && cc.getHasQueryHDFS()) {
            queryHDFS = cc.getQueryHDFS();
        }
        ConglomerateDescriptor cd = this.getCurrentAccessPath().getConglomerateDescriptor();
        String indexType = null;
        if (cd != null && cd.getIndexDescriptor() != null && cd.getIndexDescriptor().getIndexDescriptor() != null) {
            indexType = cd.getIndexDescriptor().indexType();
        }
        if (!queryHDFS || !"LOCALSORTEDMAP".equals(indexType)) {
            optimizer.costOptimizable(this, this.tableDescriptor, this.getCurrentAccessPath().getConglomerateDescriptor(), predList, outerCost);
        }
        return this.getCurrentAccessPath().getCostEstimate();
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    @Override
    public boolean isMaterializable() throws StandardException {
        return true;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        SanityManager.ASSERT((boolean)(optimizablePredicate instanceof Predicate), (String)"optimizablePredicate expected to be instanceof Predicate");
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        return true;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates, JBitSet outerTables) throws StandardException {
        for (int i = this.restrictionList.size() - 1; i >= 0; --i) {
            optimizablePredicates.addOptPredicate(this.restrictionList.getOptPredicate(i));
            this.restrictionList.removeOptPredicate(i);
        }
    }

    @Override
    public boolean isCoveringIndex(ConglomerateDescriptor cd) throws StandardException {
        boolean coveringIndex = true;
        if (!cd.isIndex()) {
            return false;
        }
        IndexRowGenerator irg = cd.getIndexDescriptor();
        int[] baseCols = irg.baseColumnPositions();
        int rclSize = this.resultColumns.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
            if (!rc.isReferenced() || rc.getExpression() instanceof ConstantNode) continue;
            coveringIndex = false;
            int colPos = rc.getColumnPosition();
            for (int i = 0; i < baseCols.length; ++i) {
                if (colPos != baseCols[i]) continue;
                coveringIndex = true;
                break;
            }
            if (!coveringIndex) break;
        }
        return coveringIndex;
    }

    @Override
    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.tableProperties == null) {
            return;
        }
        boolean indexSpecified = false;
        boolean constraintSpecified = false;
        ConstraintDescriptor consDesc = null;
        Enumeration<Object> e = this.tableProperties.keys();
        StringUtil.SQLEqualsIgnoreCase(this.tableDescriptor.getSchemaName(), "SYS");
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.tableProperties.get(key);
            if (key.equals(Constants.QueryHints.index.name())) {
                String conglomerateName;
                if (constraintSpecified) {
                    throw StandardException.newException("42Y50", this.getBaseTableName());
                }
                indexSpecified = true;
                if (StringUtil.SQLToUpperCase(value).equals("NULL")) continue;
                ConglomerateDescriptor cd = null;
                ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
                for (int index = 0; !(index >= cds.length || (conglomerateName = (cd = cds[index]).getConglomerateName()) != null && conglomerateName.equals(value)); ++index) {
                    cd = null;
                }
                if (cd == null) {
                    throw StandardException.newException("42Y46", (Object)value, (Object)this.getBaseTableName());
                }
                this.getCompilerContext().createDependency(cd);
                continue;
            }
            if (key.equals(Constants.QueryHints.constraint.name())) {
                if (indexSpecified) {
                    throw StandardException.newException("42Y50", this.getBaseTableName());
                }
                constraintSpecified = true;
                if (StringUtil.SQLToUpperCase(value).equals("NULL")) continue;
                consDesc = dDictionary.getConstraintDescriptorByName(this.tableDescriptor, null, value, false);
                if (consDesc == null || !consDesc.hasBackingIndex()) {
                    throw StandardException.newException("42Y48", (Object)value, (Object)this.getBaseTableName());
                }
                this.getCompilerContext().createDependency(consDesc);
                continue;
            }
            if (key.equals(Constants.QueryHints.joinStrategy.name())) {
                this.setUserSpecifiedJoinStrategy(value);
                continue;
            }
            if (key.equals(Constants.QueryHints.hashInitialCapacity.name())) {
                this.initialCapacity = this.getIntProperty(value, key);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException("42Y59", String.valueOf(this.initialCapacity));
            }
            if (key.equals(Constants.QueryHints.hashLoadFactor.name())) {
                try {
                    this.loadFactor = Float.valueOf(value).floatValue();
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("42Y58", (Object)value, (Object)key);
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException("42Y60", value);
            }
            if (key.equals(Constants.QueryHints.hashMaxCapacity.name())) {
                this.maxCapacity = this.getIntProperty(value, key);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException("42Y61", String.valueOf(this.maxCapacity));
            }
            if (key.equals(Constants.QueryHints.bulkFetch.name())) {
                this.bulkFetch = this.getIntProperty(value, key);
                if (this.bulkFetch <= 0) {
                    throw StandardException.newException("42Y64", String.valueOf(this.bulkFetch));
                }
                if (!this.forUpdate()) continue;
                throw StandardException.newException("42Y66");
            }
            if (key.equals(Constants.QueryHints.withSecondaries.name())) {
                this.explicitSecondaryBucketSet = true;
                this.includeSecondaryBuckets = value.length() == 1 ? Integer.parseInt(value) != 0 : Boolean.parseBoolean(value);
                CompilerContext cc = this.getCompilerContext();
                cc.setOptimizeForWrite(!this.includeSecondaryBuckets);
                cc.setWithSecondaries(this.includeSecondaryBuckets);
                if (!GemFireXDUtils.TraceAggreg) continue;
                SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)(this.tableName + " includeSecondaryBuckets=" + this.includeSecondaryBuckets + " explicitSecondaryBucketSet=" + this.explicitSecondaryBucketSet));
                continue;
            }
            if (key.equals(Constants.QueryHints.queryHDFS.name())) {
                this.queryHDFS = value.length() == 1 ? Integer.parseInt(value) != 0 : Boolean.parseBoolean(value);
                this.getCompilerContext().setQueryHDFS(this.queryHDFS);
                this.getCompilerContext().setHasQueryHDFS(true);
                continue;
            }
            throw StandardException.newException("42Y44", (Object)key, (Object)validQueryHintProperites);
        }
        if (constraintSpecified && consDesc != null) {
            ConglomerateDescriptor cd = dDictionary.getConglomerateDescriptor(consDesc.getConglomerateId());
            String indexName = cd.getConglomerateName();
            this.tableProperties.remove("constraint");
            this.tableProperties.put("index", indexName);
        }
    }

    @Override
    public String getBaseTableName() {
        return this.tableName.getTableName();
    }

    @Override
    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        AccessPath ap = this.getCurrentAccessPath();
        AccessPath bestAp = this.getBestAccessPath();
        AccessPath bestSortAp = this.getBestSortAvoidancePath();
        ap.setConglomerateDescriptor(null);
        bestAp.setConglomerateDescriptor(null);
        bestSortAp.setConglomerateDescriptor(null);
        ap.setCoveringIndexScan(false);
        bestAp.setCoveringIndexScan(false);
        bestSortAp.setCoveringIndexScan(false);
        ap.setLockMode(0);
        bestAp.setLockMode(0);
        bestSortAp.setLockMode(0);
        CostEstimate costEstimate = this.getCostEstimate(optimizer);
        ap.setCostEstimate(costEstimate);
        costEstimate.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        super.startOptimizing(optimizer, rowOrdering);
    }

    @Override
    public int convertAbsoluteToRelativeColumnPosition(int absolutePosition, ColumnReference ref) {
        return this.mapAbsoluteToRelativeColumnPosition(absolutePosition);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        Predicate pred;
        boolean statisticsForTable = false;
        boolean statisticsForConglomerate = false;
        PredicateList unknownPredicateList = null;
        if (optimizer.useStatistics() && predList != null) {
            statisticsForConglomerate = this.tableDescriptor.statisticsExist(cd);
            statisticsForTable = this.tableDescriptor.statisticsExist(null);
            unknownPredicateList = new PredicateList();
            predList.copyPredicatesToOtherList(unknownPredicateList);
        }
        AccessPath currentAccessPath = this.getCurrentAccessPath();
        JoinStrategy currentJoinStrategy = currentAccessPath.getJoinStrategy();
        optimizer.trace(38, this.tableNumber, 0, 0.0, cd);
        double tableUniquenessFactor = optimizer.uniqueJoinWithOuterTable(predList);
        boolean oneRowResultSetForSomeConglom = this.isOneRowResultSet(predList);
        CostEstimate costEstimate = this.getScratchCostEstimate(optimizer);
        int numPreds = predList != null ? predList.size() : 0;
        for (int i = 0; i < numPreds; ++i) {
            OrListNode orListNode;
            Predicate pred2 = (Predicate)predList.getOptPredicate(i);
            BooleanConstantNode constTrue = null;
            NestedLoopJoinStrategy nestedLoopStrategy = null;
            if (!(pred2.getAndNode() instanceof OrListNode)) continue;
            if (numPreds > 1) {
                int j = 0;
                while (i < numPreds) {
                    Predicate p;
                    if (!(j == i || (p = (Predicate)predList.getOptPredicate(j)).getAndNode().getLeftOperand().isBooleanTrue() && p.getAndNode().getRightOperand().isBooleanTrue())) {
                        throw StandardException.newException("0A000.S.23");
                    }
                    ++j;
                }
            }
            if ((orListNode = (OrListNode)pred2.getAndNode()).hasOptimizedList()) {
                for (OrListNode.ElementSpecification element : orListNode.getElements()) {
                    costEstimate.add(element.costEstimate, costEstimate);
                }
                continue;
            }
            ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
            JBitSet tableMap = pred2.getReferencedMap();
            if (nestedLoopStrategy == null) {
                nestedLoopStrategy = new NestedLoopJoinStrategy();
            }
            for (QueryTreeNode qtn : orListNode.getValueNodes()) {
                Predicate newPred;
                PredicateList newPredList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
                OrNode on = (OrNode)qtn;
                ValueNode valNode = on.getLeftOperand();
                ArrayDeque<ValueNode> stack = new ArrayDeque<ValueNode>();
                while (true) {
                    AndNode an;
                    if (valNode instanceof AndNode) {
                        an = (AndNode)valNode;
                        if (!((valNode = an.getLeftOperand()) instanceof AndNode)) {
                            newPred = (Predicate)this.getNodeFactory().getNode(78, an, tableMap, this.getContextManager());
                            newPredList.addOptPredicate(newPred);
                            valNode = an.getRightOperand();
                            continue;
                        }
                        stack.push(an.getRightOperand());
                        continue;
                    }
                    if (valNode instanceof BinaryRelationalOperatorNode) {
                        if (constTrue == null) {
                            constTrue = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
                        }
                        an = (AndNode)this.getNodeFactory().getNode(39, valNode, constTrue, this.getContextManager());
                        newPred = (Predicate)this.getNodeFactory().getNode(78, an, tableMap, this.getContextManager());
                        newPredList.addOptPredicate(newPred);
                    } else {
                        SanityManager.ASSERT((boolean)(valNode instanceof BooleanConstantNode));
                    }
                    if (stack.isEmpty()) break;
                    valNode = (ValueNode)stack.pop();
                }
                CostEstimate bestCost = null;
                ConglomerateDescriptor bestCostConglom = null;
                PredicateList bestPredList = null;
                currentAccessPath.setJoinStrategy(nestedLoopStrategy);
                for (ConglomerateDescriptor desc : cds) {
                    currentAccessPath.setConglomerateDescriptor(desc);
                    if (!this.feasibleJoinStrategy(newPredList, optimizer) || !newPredList.useful(this, desc)) continue;
                    CostEstimate elemCost = this.estimateCost(newPredList, desc, outerCost, optimizer, rowOrdering);
                    if (bestCost != null && !(elemCost.compare(bestCost) < 0.0)) continue;
                    bestCost = elemCost.cloneMe();
                    bestCostConglom = desc;
                    if (bestPredList == null) {
                        bestPredList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
                    } else {
                        bestPredList.clearAllPredicates();
                    }
                    for (QueryTreeNode p : newPredList) {
                        newPred = (Predicate)p;
                        Predicate bestPred = (Predicate)this.getNodeFactory().getNode(78, newPred.getAndNode(), tableMap, this.getContextManager());
                        bestPred.copyFields(newPred);
                        bestPredList.addPredicate(bestPred);
                    }
                }
                if (bestCostConglom == null || !bestCostConglom.isIndex()) {
                    throw StandardException.newException("0A000.S.23");
                }
                bestPredList.removeRedundantPredicates();
                boolean isOneRowRS = this.isOneRowResultSet(bestCostConglom, bestPredList);
                int bulkFetch = -1;
                boolean multiProbing = false;
                for (QueryTreeNode p : bestPredList) {
                    pred2 = (Predicate)p;
                    if (!pred2.isInListProbePredicate() || !pred2.isStartKey()) continue;
                    multiProbing = true;
                    break;
                }
                if (!(multiProbing || this.forUpdate() || isOneRowRS || this.getLevel() != 0)) {
                    bulkFetch = this.getDefaultBulkFetch();
                }
                costEstimate.add(bestCost, costEstimate);
                orListNode.addElement(bestCostConglom, bestPredList, bestCost, bulkFetch, multiProbing);
            }
            currentAccessPath.setConglomerateDescriptor(cd);
            currentAccessPath.setJoinStrategy(currentJoinStrategy);
        }
        if (predList != null && predList.size() == 1 && (pred = (Predicate)predList.getOptPredicate(0)).getAndNode() instanceof OrListNode) {
            OrListNode orln = (OrListNode)pred.andNode;
            long numRows = 0L;
            if (cd == orln.elements.get((int)0).conglom) {
                for (int i = 0; i < orln.elements.size(); ++i) {
                    numRows += orln.elements.get((int)i).costEstimate.getEstimatedRowCount();
                }
                costEstimate.setCost((double)outerCost.getEstimatedRowCount() * Double.MIN_VALUE, numRows * outerCost.getEstimatedRowCount(), numRows);
                return costEstimate;
            }
        }
        this.baseTableRestrictionList.removeAllElements();
        currentJoinStrategy.getBasePredicates(predList, this.baseTableRestrictionList, this);
        StoreCostController scc = this.getStoreCostController(cd);
        int oneRowResult = this.isOneRowResultSet(cd, this.baseTableRestrictionList, false);
        if (oneRowResult != 0) {
            OptimizablePredicate pred3;
            if (oneRowResult == 1) {
                rowOrdering.optimizableAlwaysOrdered(this);
            }
            this.singleScanRowCount = 1.0;
            int matchGroupByCols = this.matchGroupByColumns(cd);
            scc.getFetchFromFullKeyCost(null, currentJoinStrategy.scanCostType(), costEstimate);
            optimizer.trace(40, this.tableNumber, 0, costEstimate.getEstimatedCost(), null);
            double newCost = costEstimate.getEstimatedCost();
            if (currentJoinStrategy.multiplyBaseCostByOuterRows()) {
                newCost *= outerCost.rowCount();
            }
            if (currentJoinStrategy.isHashJoin()) {
                double depth = Math.log(this.baseRowCount()) / Math.log(2.0);
                newCost *= 2.0 + depth;
                newCost += 1000.0;
            }
            costEstimate.setCost(newCost, costEstimate.rowCount() * outerCost.rowCount(), costEstimate.singleScanRowCount());
            boolean constantStartStop = true;
            for (int i = 0; i < predList.size() && ((pred3 = predList.getOptPredicate(i)).isStartKey() || pred3.isStopKey()); ++i) {
                if (pred3.getReferencedMap().hasSingleBitSet()) continue;
                constantStartStop = false;
                break;
            }
            if (constantStartStop) {
                currentAccessPath.setLockMode(6);
                optimizer.trace(37, 0, 0, 0.0, null);
            } else {
                this.setLockingBasedOnThreshold(optimizer, costEstimate.rowCount());
            }
            optimizer.trace(23, this.tableNumber, 0, outerCost.rowCount(), costEstimate);
        } else {
            double maxRows;
            double maxRows2;
            double scanUniquenessFactor;
            int accessType;
            int stopOperator;
            int startOperator;
            OptimizablePredicate pred4;
            double extraFirstColumnSelectivity = 1.0;
            double extraStartStopSelectivity = 1.0;
            double extraQualifierSelectivity = 1.0;
            double extraNonQualifierSelectivity = 1.0;
            double statStartStopSelectivity = 1.0;
            double statCompositeSelectivity = 1.0;
            int numExtraFirstColumnPreds = 0;
            int numExtraStartStopPreds = 0;
            int numExtraQualifiers = 0;
            int numExtraNonQualifiers = 0;
            boolean startGap = false;
            boolean stopGap = false;
            boolean seenFirstColumn = false;
            boolean constantStartStop = true;
            boolean startStopFound = false;
            int startKeyNum = 0;
            int stopKeyNum = 0;
            int numStartKeyAllTypes = 0;
            int numStopKeyAllTypes = 0;
            int predListSize = predList != null ? this.baseTableRestrictionList.size() : 0;
            int startStopPredCount = 0;
            ColumnReference firstColumn = null;
            for (int i = 0; i < predListSize; ++i) {
                pred4 = this.baseTableRestrictionList.getOptPredicate(i);
                boolean startKey = pred4.isStartKey();
                boolean stopKey = pred4.isStopKey();
                if (startKey || stopKey) {
                    startStopFound = true;
                    if (!pred4.getReferencedMap().hasSingleBitSet()) {
                        constantStartStop = false;
                    }
                    boolean knownConstant = pred4.compareWithKnownConstant(this, true);
                    if (startKey) {
                        if (knownConstant && !startGap) {
                            ++startKeyNum;
                            if (unknownPredicateList != null) {
                                unknownPredicateList.removeOptPredicate(pred4);
                            }
                        } else {
                            if (pred4.compareWithParameterNode(this)) {
                                ++numStartKeyAllTypes;
                            }
                            startGap = true;
                        }
                    }
                    if (stopKey) {
                        if (knownConstant && !stopGap) {
                            ++stopKeyNum;
                            if (unknownPredicateList != null) {
                                unknownPredicateList.removeOptPredicate(pred4);
                            }
                        } else {
                            if (pred4.compareWithParameterNode(this)) {
                                ++numStopKeyAllTypes;
                            }
                            stopGap = true;
                        }
                    }
                    if (!startGap && !stopGap || this.baseTableRestrictionList.isRedundantPredicate(i)) continue;
                    if (startKey && stopKey) {
                        ++startStopPredCount;
                    }
                    if (pred4.getIndexPosition() == 0) {
                        extraFirstColumnSelectivity *= pred4.selectivity(this);
                        if (seenFirstColumn) continue;
                        ValueNode relNode = ((Predicate)pred4).getAndNode().getLeftOperand();
                        if (relNode instanceof BinaryRelationalOperatorNode) {
                            firstColumn = ((BinaryRelationalOperatorNode)relNode).getColumnOperand(this);
                        }
                        seenFirstColumn = true;
                        continue;
                    }
                    extraStartStopSelectivity *= pred4.selectivity(this);
                    ++numExtraStartStopPreds;
                    continue;
                }
                if (this.baseTableRestrictionList.isRedundantPredicate(i)) continue;
                if (pred4 instanceof Predicate) {
                    ColumnReference cr;
                    ValueNode receiver;
                    LikeEscapeOperatorNode likeNode;
                    ValueNode leftOpnd = ((Predicate)pred4).getAndNode().getLeftOperand();
                    if (firstColumn != null && leftOpnd instanceof LikeEscapeOperatorNode && (likeNode = (LikeEscapeOperatorNode)leftOpnd).getLeftOperand().requiresTypeFromContext() && !likeNode.getLeftOperand().isParameterizedConstantNode() && (receiver = likeNode.getReceiver()) instanceof ColumnReference && (cr = (ColumnReference)receiver).getTableNumber() == firstColumn.getTableNumber() && cr.getColumnNumber() == firstColumn.getColumnNumber()) {
                        extraFirstColumnSelectivity *= 0.2;
                    }
                }
                if (pred4.isQualifier()) {
                    extraQualifierSelectivity *= pred4.selectivity(this);
                    ++numExtraQualifiers;
                } else {
                    extraNonQualifierSelectivity *= pred4.selectivity(this);
                    ++numExtraNonQualifiers;
                }
                startGap = true;
                stopGap = true;
            }
            if (unknownPredicateList != null && (statCompositeSelectivity = unknownPredicateList.selectivity(this)) == -1.0) {
                statCompositeSelectivity = 1.0;
            }
            statisticsForConglomerate = true;
            statisticsForTable = true;
            if (seenFirstColumn && statisticsForConglomerate && startStopPredCount > 0) {
                statStartStopSelectivity = this.tableDescriptor.selectivityForConglomerate(cd, startStopPredCount);
            }
            extraNonQualifierSelectivity *= currentJoinStrategy.nonBasePredicateSelectivity(this, predList);
            DataValueDescriptor[] startKeys = startKeyNum > 0 ? new DataValueDescriptor[startKeyNum] : null;
            DataValueDescriptor[] stopKeys = stopKeyNum > 0 ? new DataValueDescriptor[stopKeyNum] : null;
            startKeyNum = 0;
            stopKeyNum = 0;
            startGap = false;
            stopGap = false;
            InListOperatorNode ssKeySourceInList = null;
            for (int i = 0; i < predListSize; ++i) {
                pred4 = this.baseTableRestrictionList.getOptPredicate(i);
                boolean startKey = pred4.isStartKey();
                boolean stopKey = pred4.isStopKey();
                if (startKey || stopKey) {
                    if (ssKeySourceInList != null && ((Predicate)pred4).isInListProbePredicate()) {
                        SanityManager.THROWASSERT((String)("Found multiple probe predicate start/stop keys for conglomerate '" + cd.getConglomerateName() + "' when at most one was expected."));
                    }
                    ssKeySourceInList = ((Predicate)pred4).getSourceInList(true);
                    boolean knownConstant = pred4.compareWithKnownConstant(this, true);
                    if (startKey) {
                        if (knownConstant && !startGap) {
                            startKeys[startKeyNum] = pred4.getCompareValue(this);
                            ++startKeyNum;
                        } else {
                            startGap = true;
                        }
                    }
                    if (!stopKey) continue;
                    if (knownConstant && !stopGap) {
                        stopKeys[stopKeyNum] = pred4.getCompareValue(this);
                        ++stopKeyNum;
                        continue;
                    }
                    stopGap = true;
                    continue;
                }
                startGap = true;
                stopGap = true;
            }
            if (this.baseTableRestrictionList != null) {
                startOperator = this.baseTableRestrictionList.startOperator(this);
                stopOperator = this.baseTableRestrictionList.stopOperator(this);
            } else {
                startOperator = 0;
                stopOperator = 0;
            }
            DataValueDescriptor[] rowTemplate = this.getRowTemplate(cd, this.getBaseCostController());
            int matchedGroupingColumns = this.matchGroupByColumns(cd);
            long baseRC = startKeys != null || stopKeys != null ? this.baseRowCount() : this.baseRowCount() + 5L;
            boolean isFullStartStopKeyForIndex = false;
            if (ssKeySourceInList != null && ssKeySourceInList.getLeftOperand() instanceof ColumnReference && ssKeySourceInList.getRightOperandList().containsOnlyConstantAndParamNodes()) {
                accessType = 1;
            } else if (startStopFound) {
                accessType = 2;
                int numIndexCols = 0;
                boolean bl = isFullStartStopKeyForIndex = cd.isIndex() && ((numIndexCols = cd.getIndexDescriptor().baseColumnPositions().length) == numStartKeyAllTypes || numIndexCols == numStopKeyAllTypes);
                if (isFullStartStopKeyForIndex) {
                    accessType = 3;
                }
            } else {
                accessType = 0;
            }
            scc.getScanCost(currentJoinStrategy.scanCostType(), baseRC, 1, this.forUpdate(), null, rowTemplate, startKeys, startOperator, stopKeys, stopOperator, false, accessType, costEstimate);
            boolean estimateIsMax = costEstimate.getEstimatedCost() == Double.MAX_VALUE;
            double initialPositionCost = 0.0;
            if (cd.isIndex() && !estimateIsMax) {
                initialPositionCost = scc.getFetchFromFullKeyCost(null, 0, null);
                if (oneRowResultSetForSomeConglom && costEstimate.rowCount() <= 1.0) {
                    costEstimate.setCost(costEstimate.getEstimatedCost() * 2.0, costEstimate.rowCount() + 2.0, costEstimate.singleScanRowCount() + 2.0);
                }
            }
            optimizer.trace(53, this.tableNumber, 0, 0.0, cd);
            optimizer.trace(54, this.tableNumber, 0, 0.0, costEstimate);
            optimizer.trace(55, numExtraFirstColumnPreds, 0, extraFirstColumnSelectivity, null);
            optimizer.trace(56, numExtraStartStopPreds, 0, extraStartStopSelectivity, null);
            optimizer.trace(59, startStopPredCount, 0, statStartStopSelectivity, null);
            optimizer.trace(57, numExtraQualifiers, 0, extraQualifierSelectivity, null);
            optimizer.trace(58, numExtraNonQualifiers, 0, extraNonQualifierSelectivity, null);
            if (estimateIsMax) {
                if (cd.isIndex()) {
                    optimizer.trace(48, this.tableNumber, 0, 0.0, costEstimate);
                }
                currentJoinStrategy.putBasePredicates(predList, this.baseTableRestrictionList);
                return costEstimate;
            }
            double initialRowCount = costEstimate.rowCount();
            if (statStartStopSelectivity != 1.0) {
                boolean forceSelectivity = false;
                if (cd.isIndex() && statStartStopSelectivity < 1.0 && statStartStopSelectivity > 0.0 && !this.indexCoverSort(cd, optimizer)) {
                    ConglomerateDescriptor[] cds;
                    for (ConglomerateDescriptor cdi : cds = this.tableDescriptor.getConglomerateDescriptors()) {
                        if (this.isOneRowResultSet(cdi, this.baseTableRestrictionList, false) == 0) continue;
                        forceSelectivity = true;
                        break;
                    }
                }
                costEstimate.setCost(this.scanCostAfterSelectivity(costEstimate.getEstimatedCost(), initialPositionCost, forceSelectivity ? 1.0 : statStartStopSelectivity, oneRowResultSetForSomeConglom), costEstimate.rowCount() * statStartStopSelectivity, costEstimate.singleScanRowCount() * statStartStopSelectivity);
                optimizer.trace(62, this.tableNumber, 0, 0.0, costEstimate);
            } else {
                if (extraFirstColumnSelectivity != 1.0) {
                    costEstimate.setCost(this.scanCostAfterSelectivity(costEstimate.getEstimatedCost(), initialPositionCost, extraFirstColumnSelectivity, oneRowResultSetForSomeConglom), costEstimate.rowCount() * extraFirstColumnSelectivity, costEstimate.singleScanRowCount() * extraFirstColumnSelectivity);
                    optimizer.trace(41, this.tableNumber, 0, 0.0, costEstimate);
                }
                if (extraStartStopSelectivity != 1.0) {
                    costEstimate.setCost(costEstimate.getEstimatedCost(), costEstimate.rowCount() * extraStartStopSelectivity, costEstimate.singleScanRowCount() * extraStartStopSelectivity);
                    optimizer.trace(45, this.tableNumber, 0, 0.0, costEstimate);
                }
            }
            if (ssKeySourceInList != null) {
                int listSize = ssKeySourceInList.getRightOperandList().size();
                double rc = costEstimate.rowCount() * (double)listSize;
                double ssrc = costEstimate.singleScanRowCount() * (double)listSize;
                costEstimate.setCost(costEstimate.getEstimatedCost() * (double)listSize, rc > initialRowCount ? initialRowCount : rc, ssrc > initialRowCount ? initialRowCount : ssrc);
            }
            if (!startStopFound) {
                currentAccessPath.setLockMode(7);
                optimizer.trace(35, 0, 0, 0.0, null);
            } else {
                double rowsTouched = costEstimate.rowCount();
                if (!constantStartStop && currentJoinStrategy.multiplyBaseCostByOuterRows()) {
                    double r = this.baseRowCount();
                    if (r > 0.0) {
                        double rowsTouchedAllScans;
                        double s = costEstimate.rowCount();
                        double o = outerCost.rowCount();
                        double pRowsNotTouchedPerScan = 1.0 - s / r;
                        double pRowsNotTouchedAllScans = Math.pow(pRowsNotTouchedPerScan, o);
                        double pRowsTouchedAllScans = 1.0 - pRowsNotTouchedAllScans;
                        rowsTouched = rowsTouchedAllScans = r * pRowsTouchedAllScans;
                    } else {
                        rowsTouched = optimizer.tableLockThreshold() + 1;
                    }
                }
                this.setLockingBasedOnThreshold(optimizer, rowsTouched);
            }
            if (extraQualifierSelectivity != 1.0) {
                costEstimate.setCost(costEstimate.getEstimatedCost(), costEstimate.rowCount() * extraQualifierSelectivity, costEstimate.singleScanRowCount() * extraQualifierSelectivity);
                optimizer.trace(46, this.tableNumber, 0, 0.0, costEstimate);
            }
            this.singleScanRowCount = costEstimate.singleScanRowCount();
            double newCost = costEstimate.getEstimatedCost();
            double rowCount = costEstimate.rowCount();
            if (currentJoinStrategy.multiplyBaseCostByOuterRows()) {
                newCost *= outerCost.rowCount();
            }
            if (currentJoinStrategy.isHashJoin()) {
                double depth = Math.log(baseRC) / Math.log(2.0);
                newCost *= 2.0 + depth;
                if (rowCount < 20.0) {
                    newCost += 1000.0;
                }
            }
            rowCount *= outerCost.rowCount();
            initialRowCount *= outerCost.rowCount();
            if (oneRowResultSetForSomeConglom && outerCost.rowCount() < rowCount) {
                rowCount = outerCost.rowCount();
            }
            if (cd.isIndex() && startStopFound && !constantStartStop && (scanUniquenessFactor = optimizer.uniqueJoinWithOuterTable(this.baseTableRestrictionList)) > 0.0 && rowCount > (maxRows2 = (double)this.baseRowCount() / scanUniquenessFactor)) {
                newCost *= maxRows2 / rowCount;
            }
            if (tableUniquenessFactor > 0.0 && rowCount > (maxRows = (double)this.baseRowCount() / tableUniquenessFactor)) {
                rowCount = maxRows;
            }
            costEstimate.setCost(newCost, rowCount, costEstimate.singleScanRowCount());
            optimizer.trace(23, this.tableNumber, 0, outerCost.rowCount(), costEstimate);
            double rc = -1.0;
            double src = -1.0;
            if (this.existsBaseTable()) {
                src = 1.0;
                rc = 1.0;
            } else if (extraNonQualifierSelectivity != 1.0) {
                rc = oneRowResultSetForSomeConglom ? costEstimate.rowCount() : costEstimate.rowCount() * extraNonQualifierSelectivity;
                src = costEstimate.singleScanRowCount() * extraNonQualifierSelectivity;
            }
            if (rc != -1.0) {
                costEstimate.setCost(costEstimate.getEstimatedCost(), rc, src);
                optimizer.trace(47, this.tableNumber, 0, 0.0, costEstimate);
            }
            if (statisticsForTable && !oneRowResultSetForSomeConglom && statCompositeSelectivity != 1.0) {
                double compositeStatRC = initialRowCount * statCompositeSelectivity;
                optimizer.trace(61, 0, 0, statCompositeSelectivity, null);
                if (!(tableUniquenessFactor > 0.0) || !(compositeStatRC > (double)this.baseRowCount() * tableUniquenessFactor)) {
                    costEstimate.setCost(costEstimate.getEstimatedCost(), compositeStatRC, this.existsBaseTable() ? 1.0 : compositeStatRC / outerCost.rowCount());
                    optimizer.trace(60, this.tableNumber, 0, 0.0, costEstimate);
                }
            }
        }
        currentJoinStrategy.putBasePredicates(predList, this.baseTableRestrictionList);
        return costEstimate;
    }

    private int matchGroupByColumns(ConglomerateDescriptor cd) throws StandardException {
        int gblSize;
        int matchedGroupingColumns = 0;
        if (this.gbl != null && (gblSize = this.gbl.size()) > 0 && cd.isIndex()) {
            boolean isInSortedOrder = true;
            ColumnReference[] crs = new ColumnReference[gblSize];
            for (int index = 0; index < gblSize; ++index) {
                GroupByColumn gc = (GroupByColumn)this.gbl.elementAt(index);
                if (!(gc.getColumnExpression() instanceof ColumnReference)) {
                    isInSortedOrder = false;
                    break;
                }
                crs[index] = (ColumnReference)gc.getColumnExpression();
            }
            if (isInSortedOrder && (isInSortedOrder = this.isOrdered(crs, cd))) {
                matchedGroupingColumns = gblSize;
            }
        }
        return matchedGroupingColumns;
    }

    private boolean indexCoverSort(ConglomerateDescriptor cd, Optimizer optimizer) throws StandardException {
        int orderByListSize;
        boolean indexCoverSort = true;
        RequiredRowOrdering requiredRowOrdering = ((OptimizerImpl)optimizer).requiredRowOrdering;
        OrderedColumnList orderedList = (OrderedColumnList)((Object)requiredRowOrdering);
        int n = orderByListSize = orderedList == null ? 0 : orderedList.size();
        if (orderByListSize > 0) {
            ColumnReference[] crs = new ColumnReference[orderByListSize];
            for (int index = 0; index < orderByListSize; ++index) {
                OrderedColumn orderedColumn = orderedList.getOrderedColumn(index);
                ResultColumn rc = orderedColumn.getResultColumn();
                if (rc == null || !(rc.getExpression() instanceof ColumnReference)) {
                    indexCoverSort = false;
                    break;
                }
                crs[index] = (ColumnReference)rc.getExpression();
            }
            if (indexCoverSort) {
                indexCoverSort = this.isOrdered(crs, cd);
            }
        } else {
            indexCoverSort = false;
        }
        return indexCoverSort;
    }

    private boolean existsBaseTable() {
        return GemFireXDUtils.isSet(this.flags, 256);
    }

    private boolean getUpdateLocks() {
        return GemFireXDUtils.isSet(this.flags, 1024);
    }

    private boolean bulkFetchTurnedOff() {
        return GemFireXDUtils.isSet(this.flags, 64);
    }

    private boolean skipIndexRowToBaseRow() {
        return GemFireXDUtils.isSet(this.flags, 4);
    }

    private boolean specialMaxScan() {
        return GemFireXDUtils.isSet(this.flags, 8);
    }

    private boolean specialRegionSize() {
        return GemFireXDUtils.isSet(this.flags, 2);
    }

    private boolean distinctScan() {
        return GemFireXDUtils.isSet(this.flags, 16);
    }

    private boolean raDependentScan() {
        return GemFireXDUtils.isSet(this.flags, 32);
    }

    private boolean createGFEResultSet() {
        return GemFireXDUtils.isSet(this.flags, 1);
    }

    private boolean multiProbing() {
        return GemFireXDUtils.isSet(this.flags, 128);
    }

    private boolean delayScanOpening() {
        return GemFireXDUtils.isSet(this.flags, 2048);
    }

    private void setFlagMask(int MASK, boolean on) {
        this.flags = GemFireXDUtils.set(this.flags, MASK, on);
    }

    private boolean isOptimizeForOffHeap() {
        return GemFireXDUtils.isSet(this.flags, 4096);
    }

    private boolean indexAccesesBaseTable() {
        return GemFireXDUtils.isSet(this.flags, 8192);
    }

    private double scanCostAfterSelectivity(double originalScanCost, double initialPositionCost, double selectivity, boolean anotherIndexUnique) throws StandardException {
        double afterInitialCost;
        double minSelectivity;
        double r;
        if (anotherIndexUnique && (r = (double)this.baseRowCount()) > 0.0 && (minSelectivity = 2.0 / r) > selectivity) {
            selectivity = minSelectivity;
        }
        if ((afterInitialCost = (originalScanCost - initialPositionCost) * selectivity) < 0.0) {
            afterInitialCost = 0.0;
        }
        return initialPositionCost + afterInitialCost;
    }

    private void setLockingBasedOnThreshold(Optimizer optimizer, double rowsTouched) {
        this.getCurrentAccessPath().setLockMode(6);
    }

    @Override
    public boolean isBaseTable() {
        return true;
    }

    @Override
    public boolean forUpdate() {
        return this.updateOrDelete != 0 || this.cursorTargetTable || this.getUpdateLocks();
    }

    @Override
    public int initialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public float loadFactor() {
        return this.loadFactor;
    }

    @Override
    public boolean memoryUsageOK(double rowCount, int maxMemoryPerTable) throws StandardException {
        return super.memoryUsageOK(this.singleScanRowCount, maxMemoryPerTable);
    }

    @Override
    public boolean isTargetTable() {
        return this.updateOrDelete != 0;
    }

    @Override
    public double uniqueJoin(OptimizablePredicateList predList) throws StandardException {
        double retval = -1.0;
        PredicateList pl = (PredicateList)predList;
        int numColumns = this.getTableDescriptor().getNumberOfColumns();
        int tableNumber = this.getTableNumber();
        int[] tableNumbers = new int[]{};
        JBitSet[] tableColMap = new JBitSet[]{new JBitSet(numColumns + 1)};
        pl.checkTopPredicatesForEqualsConditions(tableNumber, null, tableNumbers, tableColMap, false);
        if (this.supersetOfUniqueIndex(tableColMap)) {
            retval = this.getBestAccessPath().getCostEstimate().singleScanRowCount();
        }
        return retval;
    }

    @Override
    public boolean isOneRowScan() throws StandardException {
        if (this.existsBaseTable()) {
            return false;
        }
        return super.isOneRowScan();
    }

    @Override
    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        CompilerContext cc = this.getCompilerContext();
        if (cc.isNCJoinOnRemote() && assignedTableMap != null && this.dependencyMap != null || this.existsBaseTable()) {
            return assignedTableMap.contains(this.dependencyMap);
        }
        return true;
    }

    @Override
    public String toString() {
        return "tableName: " + (this.tableName != null ? this.tableName.toString() : "null") + "\n" + "tableDescriptor: " + this.tableDescriptor + "\n" + "correlationName: " + this.correlationName + "\n" + "updateOrDelete: " + this.updateOrDelete + "\n" + (this.tableProperties != null ? this.tableProperties.toString() : "null") + "\n" + "existsBaseTable: " + 256 + "\n" + "dependencyMap: " + (this.dependencyMap != null ? this.dependencyMap.toString() : "null") + "\n" + super.toString();
    }

    boolean getExistsBaseTable() {
        return this.existsBaseTable();
    }

    void setExistsBaseTable(boolean existsBaseTable, JBitSet dependencyMap, boolean isNotExists) {
        this.setFlagMask(256, existsBaseTable);
        this.setFlagMask(512, isNotExists);
        this.dependencyMap = existsBaseTable ? dependencyMap : null;
    }

    void clearDependency(Vector locations) {
        if (this.dependencyMap != null) {
            for (int i = 0; i < locations.size(); ++i) {
                this.dependencyMap.clear((Integer)locations.elementAt(i));
            }
        }
    }

    public void setDependency(int tableNum, int numTables) {
        if (this.dependencyMap == null || this.dependencyMap.size() != numTables) {
            this.dependencyMap = new JBitSet(numTables);
        }
        this.dependencyMap.set(tableNum);
    }

    public void setTableProperties(Properties tableProperties) {
        this.tableProperties = tableProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        TableDescriptor tableDescriptor = this.bindTableDescriptor();
        if (tableDescriptor.getTableType() == 5) {
            ResultSetNode vtiNode = this.getNodeFactory().mapTableAsVTI(tableDescriptor, this.getCorrelationName(), this.resultColumns, this.getProperties(), this.getContextManager());
            return vtiNode.bindNonVTITables(dataDictionary, fromListParam);
        }
        ResultColumnList derivedRCL = this.resultColumns;
        this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.baseTableRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        CompilerContext compilerContext = this.getCompilerContext();
        this.templateColumns = this.resultColumns = this.genResultColList();
        if (tableDescriptor.getTableType() == 2) {
            ViewDescriptor vd = dataDictionary.getViewDescriptor(tableDescriptor);
            SchemaDescriptor compSchema = dataDictionary.getSchemaDescriptor(vd.getCompSchemaId(), null);
            SchemaDescriptor prevCompSchema = compilerContext.setCompilationSchema(compSchema);
            try {
                compilerContext.createDependency(vd);
                SanityManager.ASSERT((vd != null ? 1 : 0) != 0, (String)("vd not expected to be null for " + this.tableName));
                CreateViewNode cvn = (CreateViewNode)this.parseStatement(vd.getViewText(), false);
                ResultSetNode rsn = cvn.getParsedQueryExpression();
                if (rsn.getResultColumns().containsAllResultColumn()) {
                    this.resultColumns.setCountMismatchAllowed(true);
                }
                for (int i = 0; i < this.resultColumns.size(); ++i) {
                    ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
                    if (!rc.isPrivilegeCollectionRequired()) continue;
                    compilerContext.addRequiredColumnPriv(rc.getTableColumnDescriptor());
                }
                FromTable fsq = (FromTable)this.getNodeFactory().getNode(136, rsn, this.correlationName != null ? this.correlationName : this.getOrigTableName().getTableName(), this.resultColumns, this.tableProperties, this.getContextManager());
                fsq.setLevel(this.level);
                fsq.disablePrivilegeCollection();
                fsq.setOrigTableName(this.getOrigTableName());
                ResultSetNode resultSetNode = fsq.bindNonVTITables(dataDictionary, fromListParam);
                return resultSetNode;
            }
            finally {
                compilerContext.setCompilationSchema(prevCompSchema);
            }
        }
        compilerContext.createDependency(tableDescriptor);
        this.baseConglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(tableDescriptor.getHeapConglomerateId());
        this.columnNames = this.resultColumns.getColumnNames();
        if (derivedRCL != null) {
            this.resultColumns.propagateDCLInfo(derivedRCL, this.origTableName.getFullTableName());
        }
        if (this.tableNumber == -1) {
            this.tableNumber = compilerContext.getNextTableNumber();
        }
        return this;
    }

    @Override
    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        String fullName;
        String ourSchemaName = this.getOrigTableName().getSchemaName();
        String string = fullName = schemaName != null ? schemaName + '.' + name : name;
        if (exactMatch) {
            if (schemaName != null && ourSchemaName == null || schemaName == null && ourSchemaName != null) {
                return null;
            }
            if (this.getExposedName().equals(fullName)) {
                return this;
            }
            return null;
        }
        if (this.getExposedName().equals(fullName)) {
            return this;
        }
        if (schemaName != null && ourSchemaName != null || schemaName == null && ourSchemaName == null) {
            return null;
        }
        if (schemaName != null && ourSchemaName == null) {
            if (this.tableName.equals(this.origTableName) && !schemaName.equals(this.tableDescriptor.getSchemaDescriptor().getSchemaName())) {
                return null;
            }
            if (!this.getExposedName().equals(name)) {
                return null;
            }
            if (!this.getExposedName().equals(this.getOrigTableName().getTableName())) {
                return null;
            }
            return this;
        }
        if (!this.getExposedName().equals(this.getOrigTableName().getSchemaName() + "." + name)) {
            return null;
        }
        return this;
    }

    private TableDescriptor bindTableDescriptor() throws StandardException {
        String schemaName = this.tableName.getSchemaName();
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName);
        this.tableDescriptor = this.getTableDescriptor(this.tableName.getTableName(), sd);
        if (this.tableDescriptor == null) {
            TableName synonymTab = this.resolveTableToSynonym(this.tableName);
            if (synonymTab == null) {
                throw StandardException.newException("42X05", this.tableName.getFullTableName());
            }
            this.tableName = synonymTab;
            sd = this.getSchemaDescriptor(this.tableName.getSchemaName());
            this.tableDescriptor = this.getTableDescriptor(synonymTab.getTableName(), sd);
            if (this.tableDescriptor == null) {
                throw StandardException.newException("42X05", this.tableName.getFullTableName());
            }
        }
        return this.tableDescriptor;
    }

    @Override
    public void bindExpressions(FromList fromListParam) throws StandardException {
    }

    @Override
    public void bindResultColumns(FromList fromListParam) throws StandardException {
    }

    @Override
    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        TableName exposedTableName;
        ResultColumn resultColumn = null;
        TableName columnsTableName = columnReference.getTableNameNode();
        if (columnsTableName != null && columnsTableName.getSchemaName() == null && this.correlationName == null) {
            columnsTableName.bind(this.getDataDictionary());
        }
        if ((exposedTableName = this.getExposedTableName()).getSchemaName() == null && this.correlationName == null) {
            exposedTableName.bind(this.getDataDictionary());
        }
        if ((columnsTableName == null || columnsTableName.equals(exposedTableName)) && (resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName())) != null) {
            columnReference.setTableNumber(this.tableNumber);
            if (this.tableDescriptor != null) {
                FormatableBitSet referencedColumnMap = this.tableDescriptor.getReferencedColumnMap();
                if (referencedColumnMap == null) {
                    referencedColumnMap = new FormatableBitSet(this.tableDescriptor.getNumberOfColumns() + 1);
                }
                referencedColumnMap.set(resultColumn.getColumnPosition());
                this.tableDescriptor.setReferencedColumnMap(referencedColumnMap);
            }
        }
        return resultColumn;
    }

    @Override
    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.referencedTableMap = new JBitSet(numTables);
        this.referencedTableMap.set(this.tableNumber);
        this.gbl = gbl;
        return this.genProjectRestrict(numTables);
    }

    @Override
    protected ResultSetNode genProjectRestrict(int numTables) throws StandardException {
        ResultColumnList prRCList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        prRCList.genVirtualColumnNodes(this, this.resultColumns, false);
        prRCList.doProjection();
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, prRCList, null, null, null, null, null, this.getContextManager());
    }

    @Override
    public ResultSetNode changeAccessPath() throws StandardException {
        ResultSetNode retval;
        boolean hasOrList;
        AccessPath ap = this.getTrulyTheBestAccessPath();
        ConglomerateDescriptor trulyTheBestConglomerateDescriptor = ap.getConglomerateDescriptor();
        JoinStrategy trulyTheBestJoinStrategy = ap.getJoinStrategy();
        Optimizer optimizer = ap.getOptimizer();
        optimizer.trace(34, this.tableNumber, 0, 0.0, null);
        SanityManager.ASSERT((trulyTheBestConglomerateDescriptor != null ? 1 : 0) != 0, (String)"Should only modify access path after conglomerate has been chosen.");
        if (this.bulkFetch != -1) {
            if (!trulyTheBestJoinStrategy.bulkFetchOK()) {
                throw StandardException.newException("42Y65", trulyTheBestJoinStrategy.getName());
            }
            if (trulyTheBestJoinStrategy.ignoreBulkFetch()) {
                this.disableBulkFetch();
            } else if (this.isOneRowResultSet()) {
                this.disableBulkFetch();
            }
        }
        if (this.bulkFetch == 1) {
            this.disableBulkFetch();
        }
        boolean hasRestrictionList = this.restrictionList != null;
        boolean bl = hasOrList = hasRestrictionList && this.restrictionList.hasOrList();
        if (hasRestrictionList) {
            this.restrictionList.removeRedundantPredicates();
        }
        this.storeRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.nonStoreRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.requalificationRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        if (hasRestrictionList) {
            trulyTheBestJoinStrategy.divideUpPredicateLists(this, this.restrictionList, this.storeRestrictionList, this.nonStoreRestrictionList, this.requalificationRestrictionList, this.getDataDictionary());
        }
        CompilerContext cc = this.getCompilerContext();
        if (hasRestrictionList) {
            for (int i = 0; i < this.restrictionList.size(); ++i) {
                Predicate pred = (Predicate)this.restrictionList.elementAt(i);
                if (!pred.isInListProbePredicate() || !pred.isStartKey()) continue;
                this.disableBulkFetch();
                this.setFlagMask(128, true);
                break;
            }
        }
        if (!(!trulyTheBestJoinStrategy.bulkFetchOK() || trulyTheBestJoinStrategy.ignoreBulkFetch() || this.bulkFetchTurnedOff() || this.bulkFetch != -1 || this.forUpdate() || this.isOneRowResultSet() || this.getLevel() != 0)) {
            this.bulkFetch = this.getDefaultBulkFetch();
        }
        cc.createDependency(trulyTheBestConglomerateDescriptor);
        if (!trulyTheBestConglomerateDescriptor.isIndex() || hasOrList) {
            boolean isSysstatements = this.tableName.equals("SYS", "SYSSTATEMENTS");
            this.templateColumns = this.resultColumns;
            this.referencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, isSysstatements, false);
            this.resultColumns = this.resultColumns.compactColumns(this.cursorTargetTable, isSysstatements);
            return this;
        }
        if (ap.getCoveringIndexScan() && !this.cursorTargetTable()) {
            this.resultColumns = this.newResultColumns(this.resultColumns, trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, false);
            this.templateColumns = this.newResultColumns(this.resultColumns, trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, false);
            this.templateColumns.addRCForRID();
            if (this.forUpdate()) {
                this.resultColumns.addRCForRID();
            }
            this.referencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, false);
            this.resultColumns = this.resultColumns.compactColumns(this.cursorTargetTable, true);
            this.resultColumns.setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
            return this;
        }
        if (hasRestrictionList) {
            cc.createDependency(this.baseConglomerateDescriptor);
        }
        if (this.bulkFetch != -1 && hasRestrictionList) {
            this.restrictionList.copyPredicatesToOtherListSkipPushedPredicates(this.requalificationRestrictionList);
        }
        ResultColumnList newResultColumns = this.newResultColumns(this.resultColumns, trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, true);
        if (!this.skipIndexRowToBaseRow()) {
            FormatableBitSet indexReferencedCols = null;
            FormatableBitSet heapReferencedCols = null;
            if (this.bulkFetch == -1 && (this.requalificationRestrictionList == null || this.requalificationRestrictionList.size() == 0)) {
                indexReferencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, false);
                heapReferencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, true);
                if (heapReferencedCols != null) {
                    indexReferencedCols.xor(heapReferencedCols);
                }
            } else {
                heapReferencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, false);
            }
            this.setFlagMask(8192, true);
            ResultColumnList heapRCL = this.resultColumns.compactColumns(this.cursorTargetTable, false);
            retval = (ResultSetNode)this.getNodeFactory().getNode(149, this, this.baseConglomerateDescriptor, heapRCL, this.cursorTargetTable, heapReferencedCols, indexReferencedCols, this.requalificationRestrictionList, this.forUpdate(), this.tableProperties, this.getContextManager());
            ((IndexToBaseRowNode)retval).delayScanOpening(this.delayScanOpening());
        } else {
            retval = this;
        }
        this.resultColumns = newResultColumns;
        this.templateColumns = this.newResultColumns(this.resultColumns, trulyTheBestConglomerateDescriptor, this.baseConglomerateDescriptor, false);
        if (this.bulkFetch != -1 && hasRestrictionList) {
            this.resultColumns.markAllUnreferenced();
            this.storeRestrictionList.markReferencedColumns();
            if (this.nonStoreRestrictionList != null) {
                this.nonStoreRestrictionList.markReferencedColumns();
            }
        }
        this.resultColumns.addRCForRID();
        this.templateColumns.addRCForRID();
        this.referencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, false, false);
        this.resultColumns = this.resultColumns.compactColumns(this.cursorTargetTable, false);
        this.resultColumns.setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
        this.setFlagMask(1024, this.cursorTargetTable);
        this.cursorTargetTable = false;
        return retval;
    }

    private ResultColumnList newResultColumns(ResultColumnList oldColumns, ConglomerateDescriptor idxCD, ConglomerateDescriptor heapCD, boolean cloneRCs) throws StandardException {
        IndexRowGenerator irg = idxCD.getIndexDescriptor();
        int[] baseCols = irg.baseColumnPositions();
        ResultColumnList newCols = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        for (int i = 0; i < baseCols.length; ++i) {
            ResultColumn newCol;
            boolean oldColNull;
            int basePosition = baseCols[i];
            ResultColumn oldCol = oldColumns.getResultColumn(basePosition);
            boolean bl = oldColNull = oldCol == null;
            if (oldColNull && this.skipIndexRowToBaseRow()) {
                for (Object colDesc : this.tableDescriptor.getColumnDescriptorList()) {
                    ColumnDescriptor cd = (ColumnDescriptor)colDesc;
                    if (basePosition != cd.getPosition()) continue;
                    cd.setTableDescriptor(this.tableDescriptor);
                    ValueNode vn = (ValueNode)this.getNodeFactory().getNode(94, cd.getColumnName(), this.getExposedTableName(), cd.getType(), this.getContextManager());
                    oldCol = (ResultColumn)this.getNodeFactory().getNode(80, cd, vn, this.getContextManager());
                    oldCol.setReferenced();
                    break;
                }
            }
            if (oldCol == null) {
                SanityManager.THROWASSERT((String)("Couldn't find base column " + basePosition + "\n.  RCL is\n" + oldColumns));
            }
            if (cloneRCs) {
                newCol = oldColNull ? oldCol : oldCol.cloneMe();
                oldCol.setExpression((ValueNode)this.getNodeFactory().getNode(107, this, newCol, ReuseFactory.getInteger(oldCol.getVirtualColumnId()), this.getContextManager()));
            } else {
                newCol = oldCol;
            }
            newCols.addResultColumn(newCol);
        }
        newCols.setIndexRow(heapCD.getConglomerateNumber(), this.forUpdate());
        return newCols;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateResultSet(acb, mb);
        if (this.cursorTargetTable) {
            acb.rememberCursorTarget(mb);
        }
    }

    @Override
    public void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        AccessPath trulyTheBestAccessPath = this.getTrulyTheBestAccessPath();
        boolean hasOrList = this.restrictionList.hasOrList();
        SanityManager.ASSERT((trulyTheBestAccessPath.getConglomerateDescriptor() != null ? 1 : 0) != 0);
        this.assignResultSetNumber();
        if (this.specialMaxScan()) {
            if (hasOrList) {
                throw StandardException.newException("0A000.S.23");
            }
            this.generateMaxSpecialResultSet(acb, mb);
            return;
        }
        if (this.specialRegionSize()) {
            this.generateRegionSizeSpecialResultSet(acb, mb);
            return;
        }
        if (this.distinctScan()) {
            if (hasOrList) {
                throw StandardException.newException("0A000.S.23");
            }
            this.generateDistinctScan(acb, mb);
            return;
        }
        if (this.raDependentScan()) {
            if (hasOrList) {
                throw StandardException.newException("0A000.S.23");
            }
            this.generateRefActionDependentTableScan(acb, mb);
            return;
        }
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)(" createGFEResultSet=" + this.createGFEResultSet() + " in FromBaseTable.generateResultSet for table=" + this.tableName + " and qInfo=" + this.qInfo));
        }
        if (this.createGFEResultSet()) {
            this.generateGFEResultSet(acb, mb);
            return;
        }
        JoinStrategy trulyTheBestJoinStrategy = trulyTheBestAccessPath.getJoinStrategy();
        acb.pushGetResultSetFactoryExpression(mb);
        if (hasOrList) {
            PredicateList nonStoreRL = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            boolean foundOrList = false;
            for (QueryTreeNode o : this.restrictionList) {
                MethodBuilder resultRowAllocator;
                Predicate pred = (Predicate)o;
                if (!(pred.getAndNode() instanceof OrListNode)) continue;
                SanityManager.ASSERT((!foundOrList ? 1 : 0) != 0, (String)"unexpected multiple OR lists required to be optimized");
                OrListNode orListNode = (OrListNode)pred.getAndNode();
                foundOrList = true;
                List<OrListNode.ElementSpecification> elems = orListNode.getElements();
                int numElems = elems.size();
                int lockMode = trulyTheBestAccessPath.getLockMode();
                boolean tableLocked = this.tableDescriptor.getLockGranularity() == 'T';
                int scanIsolationLevel = this.getCompilerContext().getScanIsolationLevel();
                CostEstimate bestCost = trulyTheBestAccessPath.getCostEstimate();
                mb.pushNewArray("com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet", numElems);
                for (int index = 0; index < numElems; ++index) {
                    ConglomerateDescriptor cd;
                    mb.dup();
                    acb.pushGetResultSetFactoryExpression(mb);
                    OrListNode.ElementSpecification elem = elems.get(index);
                    int indexColItem = -1;
                    if ((this.cursorTargetTable || this.getUpdateLocks()) && (cd = elem.conglom).isIndex()) {
                        IndexRowGenerator indexDesc = cd.getIndexDescriptor();
                        int[] baseColPos = indexDesc.baseColumnPositions();
                        boolean[] isAscending = indexDesc.isAscending();
                        int[] indexCols = new int[baseColPos.length];
                        for (int i = 0; i < indexCols.length; ++i) {
                            indexCols[i] = isAscending[i] ? baseColPos[i] : -baseColPos[i];
                        }
                        indexColItem = acb.addItem(indexCols);
                    }
                    FromBaseTable fbt = new FromBaseTable();
                    fbt.setContextManager(this.getContextManager());
                    fbt.setNodeType(135);
                    fbt.init(this.correlationName, this.tableProperties);
                    fbt.tableName = this.tableName;
                    fbt.updateOrDelete = this.updateOrDelete;
                    fbt.resultColumns = this.resultColumns;
                    fbt.origTableName = this.origTableName;
                    fbt.templateColumns = this.templateColumns;
                    fbt.baseConglomerateDescriptor = this.baseConglomerateDescriptor;
                    fbt.tableDescriptor = this.tableDescriptor;
                    fbt.assignResultSetNumber();
                    fbt.setReferencedTableMap(this.getReferencedTableMap());
                    fbt.setTableNumber(this.getTableNumber());
                    fbt.initAccessPaths(trulyTheBestAccessPath.getOptimizer());
                    AccessPath bestAccessPath = fbt.getTrulyTheBestAccessPath();
                    NestedLoopJoinStrategy joinStrategy = new NestedLoopJoinStrategy();
                    bestAccessPath.setConglomerateDescriptor(elem.conglom);
                    bestAccessPath.setCostEstimate(elem.costEstimate);
                    bestAccessPath.setCoveringIndexScan(this.isCoveringIndex(elem.conglom));
                    bestAccessPath.setJoinStrategy(joinStrategy);
                    bestAccessPath.setLockMode(lockMode);
                    fbt.getBestAccessPath().copy(bestAccessPath);
                    fbt.setFlagMask(8192, true);
                    fbt.setFlagMask(4096, this.isOptimizeForOffHeap());
                    fbt.setFlagMask(4, true);
                    this.setFlagMask(8192, true);
                    fbt.changeAccessPath();
                    resultRowAllocator = fbt.resultColumns.generateHolderMethod(acb, fbt.referencedCols, null);
                    int nargs = joinStrategy.getScanArgs(tc, mb, fbt, elem.predList, nonStoreRL, acb, elem.bulkFetch, resultRowAllocator, -1, indexColItem, lockMode, tableLocked, scanIsolationLevel, trulyTheBestAccessPath.getOptimizer().getMaxMemoryPerTable(), elem.multiProbing, this.delayScanOpening(), this.isOptimizeForOffHeap(), this.indexAccesesBaseTable());
                    mb.callMethod((short)185, null, joinStrategy.resultSetMethodName(elem.bulkFetch != -1, elem.multiProbing), "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", nargs);
                    mb.cast("com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet");
                    mb.setArrayElement(index);
                }
                StaticCompiledOpenConglomInfo scoci = tc.getStaticCompiledConglomInfo(trulyTheBestAccessPath.getConglomerateDescriptor().getConglomerateNumber());
                acb.pushThisAsActivation(mb);
                mb.push(acb.addItem(scoci));
                resultRowAllocator = this.resultColumns.generateHolderMethod(acb, this.referencedCols, null);
                acb.pushMethodReference(mb, resultRowAllocator);
                mb.push(this.getResultSetNumber());
                int colRefItem = -1;
                if (this.referencedCols != null) {
                    colRefItem = acb.addItem(this.referencedCols);
                }
                mb.push(colRefItem);
                mb.push(lockMode);
                mb.push(tableLocked);
                mb.push(scanIsolationLevel);
                mb.push(bestCost.rowCount());
                mb.push(bestCost.getEstimatedCost());
                int nargs = 11;
                mb.callMethod((short)185, null, "getMultiColumnTableScanResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 11);
            }
            SanityManager.ASSERT((boolean)foundOrList, (String)"unexpected hasOrList=true but found no OR list in restrictionList");
        } else {
            int nargs = this.getScanArguments(acb, mb);
            mb.callMethod((short)185, null, trulyTheBestJoinStrategy.resultSetMethodName(this.bulkFetch != -1, this.multiProbing()), "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", nargs);
        }
        if (this.updateOrDelete == 1 || this.updateOrDelete == 2) {
            mb.cast("com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet");
            mb.putField(acb.getRowLocationScanResultSetName(), "com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet");
            mb.cast("com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet");
        }
    }

    @Override
    public CostEstimate getFinalCostEstimate() {
        return this.getTrulyTheBestAccessPath().getCostEstimate();
    }

    private void pushIndexName(ConglomerateDescriptor cd, MethodBuilder mb) throws StandardException {
        if (cd.isConstraint()) {
            DataDictionary dd = this.getDataDictionary();
            ConstraintDescriptor constraintDesc = dd.getConstraintDescriptor(this.tableDescriptor, cd.getUUID());
            mb.push(constraintDesc.getConstraintName());
        } else if (cd.isIndex()) {
            mb.push(cd.getConglomerateName());
        } else {
            mb.pushNull("java.lang.String");
        }
    }

    private void generateMaxSpecialResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        ConglomerateDescriptor cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        CostEstimate costEstimate = this.getFinalCostEstimate();
        int colRefItem = this.referencedCols == null ? -1 : acb.addItem(this.referencedCols);
        boolean tableLockGranularity = this.tableDescriptor.getLockGranularity() == 'T';
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.getResultSetNumber());
        this.resultColumns.generateHolder(acb, mb, this.referencedCols, null);
        mb.push(cd.getConglomerateNumber());
        mb.push(this.tableDescriptor.getName());
        if (this.tableProperties != null) {
            mb.push(PropertyUtil.sortProperties(this.tableProperties));
        } else {
            mb.pushNull("java.lang.String");
        }
        this.pushIndexName(cd, mb);
        mb.push(colRefItem);
        mb.push(this.getTrulyTheBestAccessPath().getLockMode());
        mb.push(tableLockGranularity);
        mb.push(this.getCompilerContext().getScanIsolationLevel());
        mb.push(costEstimate.singleScanRowCount());
        mb.push(costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getLastIndexKeyResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 13);
    }

    private void generateDistinctScan(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int index;
        ConglomerateDescriptor cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        CostEstimate costEstimate = this.getFinalCostEstimate();
        int colRefItem = this.referencedCols == null ? -1 : acb.addItem(this.referencedCols);
        boolean tableLockGranularity = this.tableDescriptor.getLockGranularity() == 'T';
        int[] hashKeyColumns = new int[this.resultColumns.size()];
        if (this.referencedCols == null) {
            for (index = 0; index < hashKeyColumns.length; ++index) {
                hashKeyColumns[index] = index;
            }
        } else {
            index = 0;
            int colNum = this.referencedCols.anySetBit();
            while (colNum != -1) {
                hashKeyColumns[index++] = colNum;
                colNum = this.referencedCols.anySetBit(colNum);
            }
        }
        Object[] fihArray = FormatableIntHolder.getFormatableIntHolders(hashKeyColumns);
        FormatableArrayHolder hashKeyHolder = new FormatableArrayHolder(fihArray);
        int hashKeyItem = acb.addItem(hashKeyHolder);
        long conglomNumber = cd.getConglomerateNumber();
        StaticCompiledOpenConglomInfo scoci = this.getLanguageConnectionContext().getTransactionCompile().getStaticCompiledConglomInfo(conglomNumber);
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.push(conglomNumber);
        mb.push(acb.addItem(scoci));
        this.resultColumns.generateHolder(acb, mb, this.referencedCols, null);
        mb.push(this.getResultSetNumber());
        mb.push(hashKeyItem);
        mb.push(this.tableDescriptor.getName());
        if (this.tableProperties != null) {
            mb.push(PropertyUtil.sortProperties(this.tableProperties));
        } else {
            mb.pushNull("java.lang.String");
        }
        this.pushIndexName(cd, mb);
        mb.push(cd.isConstraint());
        mb.push(colRefItem);
        mb.push(this.getTrulyTheBestAccessPath().getLockMode());
        mb.push(tableLockGranularity);
        mb.push(this.getCompilerContext().getScanIsolationLevel());
        mb.push(costEstimate.singleScanRowCount());
        mb.push(costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getDistinctScanResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 16);
    }

    private void generateGFEResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        RowFormatter rf;
        GemFireContainer container;
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        MethodBuilder resultRowAllocator = this.resultColumns.generateHolderMethod(acb, this.referencedCols, null);
        acb.pushMethodReference(mb, resultRowAllocator);
        mb.push(this.resultSetNumber);
        int rowFormatterItem = -1;
        int fixedColsItem = -1;
        int varColsItem = -1;
        int lobColsItem = -1;
        int allColsItem = -1;
        int allColsWithLobsItem = -1;
        if (this.referencedCols != null && (container = Misc.getMemStore().getContainer(ContainerKey.valueOf(0L, this.baseConglomerateDescriptor.getConglomerateNumber()))) != null && (rf = container.getRowFormatter(this.referencedCols)) != null) {
            TIntArrayList fixedCols = new TIntArrayList();
            TIntArrayList varCols = new TIntArrayList();
            TIntArrayList lobCols = new TIntArrayList();
            TIntArrayList allCols = new TIntArrayList();
            TIntArrayList allColsWithLobs = new TIntArrayList();
            rf.getColumnPositions(fixedCols, varCols, lobCols, allCols, allColsWithLobs);
            rowFormatterItem = acb.addItem(rf);
            if (fixedCols.size() > 0) {
                fixedColsItem = acb.addItem(fixedCols.toNativeArray());
            }
            if (varCols.size() > 0) {
                varColsItem = acb.addItem(varCols.toNativeArray());
            }
            if (lobCols.size() > 0) {
                lobColsItem = acb.addItem(lobCols.toNativeArray());
            }
            if (allCols.size() > 0) {
                allColsItem = acb.addItem(allCols.toNativeArray());
            }
            assert (allColsWithLobs.size() > 0);
            allColsWithLobsItem = acb.addItem(allColsWithLobs.toNativeArray());
        }
        mb.push(rowFormatterItem);
        mb.push(fixedColsItem);
        mb.push(varColsItem);
        mb.push(lobColsItem);
        mb.push(allColsItem);
        mb.push(allColsWithLobsItem);
        mb.push(this.getCompilerContext().getScanIsolationLevel());
        mb.push(this.forUpdate());
        mb.push(acb.addItem(this.qInfo));
        mb.callMethod((short)185, null, "getGFEResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 12);
    }

    private void generateRefActionDependentTableScan(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.pushGetResultSetFactoryExpression(mb);
        int nargs = this.getScanArguments(acb, mb);
        mb.push(this.raParentResultSetId);
        mb.push(this.fkIndexConglomId);
        mb.push(acb.addItem(this.fkColArray));
        mb.push(acb.addItem(this.getDataDictionary().getRowLocationTemplate(this.getLanguageConnectionContext(), this.tableDescriptor)));
        int argCount = nargs + 4;
        mb.callMethod((short)185, null, "getRaDependentTableScanResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", argCount);
        if (this.updateOrDelete == 1 || this.updateOrDelete == 2) {
            mb.cast("com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet");
            mb.putField(acb.getRowLocationScanResultSetName(), "com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet");
            mb.cast("com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet");
        }
    }

    private int getScanArguments(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        AccessPath ap;
        JoinStrategy trulyTheBestJoinStrategy;
        ConglomerateDescriptor cd;
        MethodBuilder resultRowAllocator = this.resultColumns.generateHolderMethod(acb, this.referencedCols, null);
        int colRefItem = -1;
        if (this.referencedCols != null) {
            colRefItem = acb.addItem(this.referencedCols);
        }
        int indexColItem = -1;
        if ((this.cursorTargetTable || this.getUpdateLocks()) && (cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor()).isIndex()) {
            int[] baseColPos = cd.getIndexDescriptor().baseColumnPositions();
            boolean[] isAscending = cd.getIndexDescriptor().isAscending();
            int[] indexCols = new int[baseColPos.length];
            for (int i = 0; i < indexCols.length; ++i) {
                indexCols[i] = isAscending[i] ? baseColPos[i] : -baseColPos[i];
            }
            indexColItem = acb.addItem(indexCols);
        }
        if (!(trulyTheBestJoinStrategy = (ap = this.getTrulyTheBestAccessPath()).getJoinStrategy()).bulkFetchOK() && this.bulkFetch != -1) {
            SanityManager.THROWASSERT((String)("bulkFetch should not be set for the join strategy " + trulyTheBestJoinStrategy.getName()));
        }
        int nargs = trulyTheBestJoinStrategy.getScanArgs(this.getLanguageConnectionContext().getTransactionCompile(), mb, this, this.storeRestrictionList, this.nonStoreRestrictionList, acb, this.bulkFetch, resultRowAllocator, colRefItem, indexColItem, this.getTrulyTheBestAccessPath().getLockMode(), this.tableDescriptor.getLockGranularity() == 'T', this.getCompilerContext().getScanIsolationLevel(), ap.getOptimizer().getMaxMemoryPerTable(), this.multiProbing(), this.delayScanOpening(), this.isOptimizeForOffHeap(), this.indexAccesesBaseTable());
        return nargs;
    }

    public int mapAbsoluteToRelativeColumnPosition(int absolutePosition) {
        if (this.referencedCols == null) {
            return absolutePosition;
        }
        int setBitCtr = 0;
        for (int bitCtr = 0; bitCtr < this.referencedCols.getLength() && bitCtr < absolutePosition; ++bitCtr) {
            if (!this.referencedCols.get(bitCtr)) continue;
            ++setBitCtr;
        }
        return setBitCtr;
    }

    @Override
    public String getExposedName() {
        if (this.correlationName != null) {
            return this.correlationName;
        }
        return this.getOrigTableName().getFullTableName();
    }

    private TableName getExposedTableName() throws StandardException {
        if (this.correlationName != null) {
            return this.makeTableName(null, this.correlationName);
        }
        return this.getOrigTableName();
    }

    public TableName getTableNameField() {
        return this.tableName;
    }

    @Override
    public ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        return this.getResultColumnsForList(allTableName, this.resultColumns, this.getOrigTableName());
    }

    public ResultColumnList genResultColList() throws StandardException {
        ResultColumnList rcList = null;
        ColumnDescriptor colDesc = null;
        TableName exposedName = this.getExposedTableName();
        rcList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList cdl = this.tableDescriptor.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            colDesc = cdl.elementAt(index);
            colDesc.setTableDescriptor(this.tableDescriptor);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, colDesc.getColumnName(), exposedName, colDesc.getType(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, colDesc, valueNode, this.getContextManager());
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    public ResultColumnList addColsToList(ResultColumnList inputRcl, FormatableBitSet colsWeWant) throws StandardException {
        Object rcList = null;
        ColumnDescriptor cd = null;
        TableName exposedName = this.getExposedTableName();
        ResultColumnList newRcl = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList cdl = this.tableDescriptor.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            cd = cdl.elementAt(index);
            int position = cd.getPosition();
            if (!colsWeWant.get(position)) continue;
            ResultColumn resultColumn = inputRcl.getResultColumn(position);
            if (resultColumn == null) {
                ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, cd.getColumnName(), exposedName, this.getContextManager());
                resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, cd, valueNode, this.getContextManager());
            }
            newRcl.addResultColumn(resultColumn);
        }
        return newRcl;
    }

    @Override
    public TableName getTableName() throws StandardException {
        TableName tn = super.getTableName();
        if (tn != null && tn.getSchemaName() == null && this.correlationName == null) {
            tn.bind(this.getDataDictionary());
        }
        return tn != null ? tn : this.tableName;
    }

    public TableName getActualTableName() {
        return this.tableName;
    }

    @Override
    public boolean markAsCursorTargetTable() {
        this.cursorTargetTable = true;
        return true;
    }

    @Override
    protected boolean cursorTargetTable() {
        return this.cursorTargetTable;
    }

    void markUpdated(ResultColumnList updateColumns) {
        this.resultColumns.markUpdated(updateColumns);
    }

    @Override
    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return baseTable && name.equals(this.getBaseTableName());
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.tableDescriptor.getSchemaDescriptor());
    }

    @Override
    public boolean isOneRowResultSet() throws StandardException {
        if (this.existsBaseTable()) {
            return true;
        }
        AccessPath ap = this.getTrulyTheBestAccessPath();
        JoinStrategy trulyTheBestJoinStrategy = ap.getJoinStrategy();
        if (trulyTheBestJoinStrategy.isHashJoin()) {
            PredicateList pl = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
            if (this.storeRestrictionList != null) {
                pl.nondestructiveAppend(this.storeRestrictionList);
            }
            if (this.nonStoreRestrictionList != null) {
                pl.nondestructiveAppend(this.nonStoreRestrictionList);
            }
            return this.isOneRowResultSet(pl);
        }
        return this.isOneRowResultSet(this.getTrulyTheBestAccessPath().getConglomerateDescriptor(), this.restrictionList);
    }

    @Override
    public boolean isNotExists() {
        return GemFireXDUtils.isSet(this.flags, 512);
    }

    public boolean isOneRowResultSet(OptimizablePredicateList predList) throws StandardException {
        ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            if (!this.isOneRowResultSet(cds[index], predList)) continue;
            return true;
        }
        return false;
    }

    protected boolean supersetOfUniqueIndex(boolean[] eqCols) throws StandardException {
        ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            int inner;
            IndexRowGenerator id;
            ConglomerateDescriptor cd = cds[index];
            if (!cd.isIndex() || !(id = cd.getIndexDescriptor()).isUnique()) continue;
            int[] keyColumns = id.baseColumnPositions();
            for (inner = 0; inner < keyColumns.length && eqCols[keyColumns[inner]]; ++inner) {
            }
            if (inner != keyColumns.length) continue;
            return true;
        }
        return false;
    }

    protected boolean supersetOfUniqueIndex(JBitSet[] tableColMap) throws StandardException {
        ConglomerateDescriptor[] cds = this.tableDescriptor.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            IndexRowGenerator id;
            ConglomerateDescriptor cd = cds[index];
            if (!cd.isIndex() || !(id = cd.getIndexDescriptor()).isUnique()) continue;
            int[] keyColumns = id.baseColumnPositions();
            int numBits = tableColMap[0].size();
            JBitSet keyMap = new JBitSet(numBits);
            JBitSet resMap = new JBitSet(numBits);
            for (int inner = 0; inner < keyColumns.length; ++inner) {
                keyMap.set(keyColumns[inner]);
            }
            for (int table = 0; table < tableColMap.length; ++table) {
                resMap.setTo(tableColMap[table]);
                resMap.and(keyMap);
                if (!keyMap.equals(resMap)) continue;
                tableColMap[table].set(0);
                return true;
            }
        }
        return false;
    }

    @Override
    public int updateTargetLockMode() {
        if (this.getTrulyTheBestAccessPath().getConglomerateDescriptor().isIndex()) {
            return 6;
        }
        int isolationLevel = this.getLanguageConnectionContext().getCurrentIsolationLevel();
        if (isolationLevel != 4 && this.tableDescriptor.getLockGranularity() != 'T') {
            int lockMode = this.getTrulyTheBestAccessPath().getLockMode();
            lockMode = lockMode != 6 ? (lockMode & 0xFF) << 16 : 0;
            return lockMode += 6;
        }
        return this.getTrulyTheBestAccessPath().getLockMode();
    }

    @Override
    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, Vector fbtVector) throws StandardException {
        for (int index = 0; index < crs.length; ++index) {
            String crsTableName = crs[index].getSource().findSourceTableName();
            if (ArrayUtils.objectEquals((Object)this.tableDescriptor.getSchemaName(), (Object)Misc.getSchemaName(crs[index].getSourceSchemaName(), this.getLanguageConnectionContext())) && this.getBaseTableName().equals(crsTableName)) continue;
            return false;
        }
        ConglomerateDescriptor cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (!cd.isIndex()) {
            return false;
        }
        boolean isOrdered = permuteOrdering ? this.isOrdered(crs, cd) : this.isStrictlyOrdered(crs, cd);
        this.getTrulyTheBestAccessPath().setSupportsMoveToNextKey(isOrdered && cd.getIndexDescriptor().baseColumnPositions().length == crs.length);
        if (fbtVector != null) {
            fbtVector.addElement(this);
        }
        return isOrdered;
    }

    void disableBulkFetch() {
        this.setFlagMask(64, true);
        this.bulkFetch = -1;
    }

    void doSpecialMaxScan() {
        if (this.restrictionList.size() != 0 || this.storeRestrictionList.size() != 0 || this.nonStoreRestrictionList.size() != 0) {
            SanityManager.THROWASSERT((String)"shouldn't be setting max special scan because there is a restriction");
        }
        this.setFlagMask(8, true);
    }

    @Override
    boolean isPossibleDistinctScan(Set distinctColumns) {
        if (this.restrictionList != null && this.restrictionList.size() != 0) {
            return false;
        }
        HashSet<ValueNode> columns = new HashSet<ValueNode>();
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
            columns.add(rc.getExpression());
        }
        return columns.equals(distinctColumns);
    }

    @Override
    void markForDistinctScan() {
        this.setFlagMask(16, true);
    }

    @Override
    void adjustForSortElimination() {
    }

    @Override
    void adjustForSortElimination(RequiredRowOrdering rowOrdering) throws StandardException {
        if (this.restrictionList != null) {
            this.restrictionList.adjustForSortElimination(rowOrdering);
        }
    }

    private boolean isOrdered(ColumnReference[] crs, ConglomerateDescriptor cd) throws StandardException {
        int nextCR;
        int nextKeyColumn;
        boolean[] matchedCRs = new boolean[crs.length];
        int[] keyColumns = cd.getIndexDescriptor().baseColumnPositions();
        String[] baseTableColumnNames = cd.getColumnNames();
        for (nextKeyColumn = 0; nextKeyColumn < keyColumns.length; ++nextKeyColumn) {
            boolean currMatch = false;
            for (nextCR = 0; nextCR < crs.length; ++nextCR) {
                String crsTableName = crs[nextCR].getSource().findSourceTableName();
                if (!ArrayUtils.objectEquals((Object)this.tableDescriptor.getSchemaName(), (Object)Misc.getSchemaName(crs[nextCR].getSourceSchemaName(), this.getLanguageConnectionContext())) || !this.getBaseTableName().equals(crsTableName) || !crs[nextCR].getColumnName().equals(baseTableColumnNames[keyColumns[nextKeyColumn] - 1])) continue;
                matchedCRs[nextCR] = true;
                currMatch = true;
                break;
            }
            if (!currMatch && this.storeRestrictionList != null && !this.storeRestrictionList.hasOptimizableEqualityPredicate(this, keyColumns[nextKeyColumn], true)) break;
        }
        int numCRsMatched = 0;
        for (nextCR = 0; nextCR < matchedCRs.length; ++nextCR) {
            if (!matchedCRs[nextCR]) continue;
            ++numCRsMatched;
        }
        if (numCRsMatched == matchedCRs.length) {
            return true;
        }
        if (nextKeyColumn == keyColumns.length) {
            return cd.getIndexDescriptor().isUnique();
        }
        return false;
    }

    private boolean isStrictlyOrdered(ColumnReference[] crs, ConglomerateDescriptor cd) throws StandardException {
        int nextKeyColumn = 0;
        int[] keyColumns = cd.getIndexDescriptor().baseColumnPositions();
        block0: for (int nextCR = 0; nextCR < crs.length; ++nextCR) {
            if (nextKeyColumn == keyColumns.length) {
                if (cd.getIndexDescriptor().isUnique()) break;
                return false;
            }
            if (crs[nextCR].getColumnNumber() == keyColumns[nextKeyColumn]) {
                ++nextKeyColumn;
                continue;
            }
            while (crs[nextCR].getColumnNumber() != keyColumns[nextKeyColumn]) {
                if (!this.storeRestrictionList.hasOptimizableEqualityPredicate(this, keyColumns[nextKeyColumn], true)) {
                    return false;
                }
                if (++nextKeyColumn != keyColumns.length) continue;
                if (cd.getIndexDescriptor().isUnique()) continue block0;
                return false;
            }
        }
        return true;
    }

    private boolean isOneRowResultSet(ConglomerateDescriptor cd, OptimizablePredicateList predList) throws StandardException {
        return this.isOneRowResultSet(cd, predList, true) == 1;
    }

    private int isOneRowResultSet(ConglomerateDescriptor cd, OptimizablePredicateList predList, boolean skipNonUnique) throws StandardException {
        int uniq;
        if (predList == null) {
            return 0;
        }
        if (!(predList instanceof PredicateList)) {
            SanityManager.THROWASSERT((String)("predList should be a PredicateList, but is a " + predList.getClass().getName()));
        }
        PredicateList restrictionList = (PredicateList)predList;
        if (!cd.isIndex()) {
            return 0;
        }
        IndexRowGenerator irg = cd.getIndexDescriptor();
        int n = uniq = irg.isUnique() ? 1 : 2;
        if (skipNonUnique && uniq == 2) {
            return 0;
        }
        int[] baseColumnPositions = irg.baseColumnPositions();
        DataDictionary dd = this.getDataDictionary();
        for (int index = 0; index < baseColumnPositions.length; ++index) {
            int curCol = baseColumnPositions[index];
            if (restrictionList.hasOptimizableEqualityPredicate(this, curCol, true)) continue;
            return 0;
        }
        return uniq;
    }

    private int getDefaultBulkFetch() throws StandardException {
        int valInt = GemFireXDUtils.DML_BULK_FETCH_SIZE;
        if (valInt <= 0) {
            throw StandardException.newException("42Y64", String.valueOf(valInt));
        }
        return valInt <= 1 ? -1 : valInt;
    }

    private String getUserSpecifiedIndexName() {
        String retval = null;
        if (this.tableProperties != null) {
            retval = this.tableProperties.getProperty("index");
        }
        return retval;
    }

    private StoreCostController getStoreCostController(ConglomerateDescriptor cd) throws StandardException {
        return this.getCompilerContext().getStoreCostController(cd.getConglomerateNumber());
    }

    private StoreCostController getBaseCostController() throws StandardException {
        return this.getStoreCostController(this.baseConglomerateDescriptor);
    }

    private long baseRowCount() throws StandardException {
        if (!this.gotRowCount) {
            StoreCostController scc = this.getBaseCostController();
            this.rowCount = scc.getEstimatedRowCount();
            this.gotRowCount = true;
        }
        return this.rowCount;
    }

    private DataValueDescriptor[] getRowTemplate(ConglomerateDescriptor cd, StoreCostController scc) throws StandardException {
        if (!cd.isIndex()) {
            return this.templateColumns.buildEmptyRow().getRowArray();
        }
        ExecRow emptyIndexRow = this.templateColumns.buildEmptyIndexRow(this.tableDescriptor, cd, scc, this.getDataDictionary());
        return emptyIndexRow.getRowArray();
    }

    private ConglomerateDescriptor getFirstConglom() throws StandardException {
        int index;
        this.getConglomDescs();
        for (index = 0; index < this.conglomDescs.length && this.conglomDescs[index].isIndex() && this.conglomDescs[index].getIndexDescriptor().indexType().equals("GLOBALHASH"); ++index) {
        }
        if (index < this.conglomDescs.length) {
            return this.conglomDescs[index];
        }
        return null;
    }

    private ConglomerateDescriptor getNextConglom(ConglomerateDescriptor currCD) throws StandardException {
        int index;
        for (index = 0; index < this.conglomDescs.length && currCD != this.conglomDescs[index]; ++index) {
        }
        while (index < this.conglomDescs.length - 1 && this.conglomDescs[index + 1].isIndex() && this.conglomDescs[index + 1].getIndexDescriptor().indexType().equals("GLOBALHASH")) {
            ++index;
        }
        if (index < this.conglomDescs.length - 1) {
            return this.conglomDescs[index + 1];
        }
        return null;
    }

    private void getConglomDescs() throws StandardException {
        if (this.conglomDescs == null) {
            this.conglomDescs = this.tableDescriptor.getConglomerateDescriptors();
        }
    }

    @Override
    public void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.fkIndexConglomId = fkIndexConglomId;
        this.fkColArray = fkColArray;
        this.raParentResultSetId = parentResultSetId;
        this.setFlagMask(32, dependentScan);
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = super.accept(v);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.nonStoreRestrictionList != null && !v.stopTraversal()) {
            this.nonStoreRestrictionList.accept(v);
        }
        if (this.restrictionList != null && !v.stopTraversal()) {
            this.restrictionList.accept(v);
        }
        if (this.nonBaseTableRestrictionList != null && !v.stopTraversal()) {
            this.nonBaseTableRestrictionList.accept(v);
        }
        if (this.requalificationRestrictionList != null && !v.stopTraversal()) {
            this.requalificationRestrictionList.accept(v);
        }
        return returnNode;
    }

    @Override
    public final QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        return new TableQueryInfo(this, qic);
    }

    public final void setCreateGFEResultSetTrue(SelectQueryInfo qinfo) {
        this.setFlagMask(1, true);
        this.qInfo = qinfo;
    }

    public final boolean isGFEResultSet() {
        return this.createGFEResultSet();
    }

    public final SelectQueryInfo getQueryInfo() {
        return this.qInfo;
    }

    public final ConglomerateDescriptor getConglomerateDescriptor() {
        return this.baseConglomerateDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExecIndexRow getExecIndexRow() throws StandardException {
        ResultColumnList rslst = this.getResultColumns();
        ExecIndexRow eir = this.getExecutionFactory().getIndexableRow(rslst.size());
        for (int idx = 1; idx <= rslst.size(); ++idx) {
            ResultColumn rcl = rslst.getResultColumn(idx);
            if (rcl.getExpression() instanceof CurrentRowLocationNode) {
                ConglomerateController cc = null;
                cc = this.getLanguageConnectionContext().getTransactionCompile().openConglomerate(this.baseConglomerateDescriptor.getConglomerateNumber(), false, 0, 6, 2);
                try {
                    RowLocation rl = cc.newRowLocationTemplate();
                    eir.setColumn(idx, rl);
                    continue;
                }
                finally {
                    if (cc != null) {
                        cc.close();
                    }
                }
            }
            eir.setColumn(idx, rcl.getExpression().getTypeServices().getNull());
        }
        return eir;
    }

    public final boolean isDistinctScan() {
        return this.distinctScan();
    }

    final void doSpecialRegionSize(ResultColumn parentRC) throws StandardException {
        if (this.restrictionList.size() != 0 || this.storeRestrictionList != null && this.storeRestrictionList.size() != 0 || this.nonStoreRestrictionList != null && this.nonStoreRestrictionList.size() != 0) {
            SanityManager.THROWASSERT((String)"shouldn't be setting special region size scan because there is a restriction");
        }
        ValueNode aggNode = parentRC.getExpression();
        assert (aggNode instanceof AggregateNode);
        this.resultColumns.addColumn(this.tableName, parentRC.getColumnName(), aggNode.getTypeServices());
        ResultColumn newRC = (ResultColumn)this.resultColumns.elementAt(0);
        ColumnReference newColumnRef = (ColumnReference)this.getNodeFactory().getNode(62, newRC.getName(), null, this.getContextManager());
        newColumnRef.setSource(newRC);
        newColumnRef.setNestingLevel(this.getLevel());
        newColumnRef.setSourceLevel(this.getLevel());
        parentRC.setExpression(newColumnRef);
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("Marking special region size optimization for " + this.getBaseTableName()));
        }
        this.setFlagMask(2, true);
    }

    private void generateRegionSizeSpecialResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        ConglomerateDescriptor cd = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.getResultSetNumber());
        this.resultColumns.generateHolder(acb, mb, this.referencedCols, null);
        mb.push(cd.getConglomerateNumber());
        mb.push(this.tableDescriptor.getName());
        String withSecondaries = "";
        if (this.explicitSecondaryBucketSet) {
            withSecondaries = Boolean.valueOf(this.includeSecondaryBuckets).toString();
        }
        if (GemFireXDUtils.TraceAggreg) {
            SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("explicitSecondaryBucket is" + (this.explicitSecondaryBucketSet ? " set " : " not set") + " includeSecondaryBuckets=" + this.includeSecondaryBuckets + " withSecondaries=" + withSecondaries));
        }
        mb.push(withSecondaries);
        mb.callMethod((short)185, null, "getRegionSizeResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 6);
    }

    public final boolean isSpecialRegionSize() {
        return this.specialRegionSize();
    }

    @Override
    public void eliminateUnUsedColumns(ResultColumnList parentResultColumn, CollectAndEliminateColumnsVisitor finder) throws StandardException {
        if (this.getTableDescriptor().getTableType() == 1) {
            return;
        }
    }

    @Override
    public void delayScanOpening(boolean delay) {
        this.setFlagMask(2048, delay);
    }

    @Override
    public LocalRegion getRegion(boolean returnUnInitialized) throws StandardException {
        LanguageConnectionContext lcc;
        ConglomerateDescriptor conglomDes = this.getConglomerateDescriptor();
        TableDescriptor td = this.getTableDescriptor();
        LocalRegion rgn = (LocalRegion)Misc.getRegion(td, lcc = this.getLanguageConnectionContext(), false, returnUnInitialized);
        if (rgn == null) {
            GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
            MemConglomerate conglom = tran.findExistingConglomerate(conglomDes.getConglomerateNumber());
            MemHeap mh = (MemHeap)conglom;
            rgn = mh.getRegion();
        }
        return rgn;
    }

    boolean isPartitionedRegion() throws StandardException {
        return this.getRegion(true).getDataPolicy().withPartitioning();
    }

    @Override
    public void getTablesReferencedByRestrictionLists(JBitSet referencedTables) {
        Predicate pred;
        int i;
        if (this.restrictionList != null) {
            for (i = 0; i < this.restrictionList.size(); ++i) {
                pred = (Predicate)this.restrictionList.elementAt(i);
                referencedTables.or(pred.referencedSet);
            }
        }
        if (this.nonStoreRestrictionList != null) {
            for (i = 0; i < this.nonStoreRestrictionList.size(); ++i) {
                pred = (Predicate)this.nonStoreRestrictionList.elementAt(i);
                referencedTables.or(pred.referencedSet);
            }
        }
        if (this.storeRestrictionList != null) {
            for (i = 0; i < this.storeRestrictionList.size(); ++i) {
                pred = (Predicate)this.storeRestrictionList.elementAt(i);
                referencedTables.or(pred.referencedSet);
            }
        }
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        shouldOptimize = shouldOptimize || this.resultColumns != null && this.resultColumns.size() < this.tableDescriptor.getNumberOfColumns() && !this.indexAccesesBaseTable();
        this.setFlagMask(4096, shouldOptimize);
    }

    @Override
    public Optimizable getBaseTable() throws StandardException {
        return this;
    }

    @Override
    protected FromBaseTable ncjGetOnlyOneFBTNode() throws StandardException {
        return this;
    }
}

