/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;

public class DropTriggerNode
extends DDLStatementNode {
    private TableDescriptor td;
    private boolean onlyIfExists;

    @Override
    public void init(Object indexName, Object onlyIfExists) throws StandardException {
        super.init(indexName);
        this.onlyIfExists = (Boolean)onlyIfExists;
    }

    @Override
    public String statementToString() {
        return "DROP TRIGGER";
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        SchemaDescriptor sd = null;
        try {
            sd = this.getSchemaDescriptor();
        }
        catch (StandardException e) {
            if (e.getSQLState().equals("42Y07") && this.onlyIfExists) {
                return;
            }
            throw e;
        }
        TriggerDescriptor triggerDescriptor = null;
        if (sd.getUUID() != null) {
            triggerDescriptor = dd.getTriggerDescriptor(this.getRelativeName(), sd);
        }
        if (triggerDescriptor == null) {
            if (this.onlyIfExists) {
                return;
            }
            throw StandardException.newException("42X94", (Object)"TRIGGER", (Object)this.getFullName());
        }
        this.td = triggerDescriptor.getTableDescriptor();
        cc.createDependency(this.td);
        cc.createDependency(triggerDescriptor);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        SchemaDescriptor sd;
        block2: {
            sd = null;
            try {
                sd = this.getSchemaDescriptor();
            }
            catch (StandardException e) {
                if (e.getSQLState().equals("42Y07") && this.onlyIfExists) break block2;
                throw e;
            }
        }
        return this.getGenericConstantActionFactory().getDropTriggerConstantAction(sd, this.getRelativeName(), this.td == null ? null : this.td.getUUID(), this.onlyIfExists);
    }
}

