/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;

public class DropRoleNode
extends DDLStatementNode {
    private String roleName;

    @Override
    public void init(Object roleName) throws StandardException {
        this.initAndCheck(null);
        this.roleName = (String)roleName;
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if (this.isPrivilegeCollectionRequired()) {
            cc.addRequiredRolePriv(this.roleName, 20);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "roleName: " + this.roleName + "\n";
    }

    @Override
    public String statementToString() {
        return "DROP ROLE";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropRoleConstantAction(this.roleName);
    }
}

