/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTypeCompiler;

public final class CharTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.getBaseTypeId().isAnsiUDT()) {
            return false;
        }
        if (this.getTypeId().isLongVarcharTypeId()) {
            return otherType.isStringTypeId();
        }
        if (forDataTypeFunction && otherType.isDoubleTypeId()) {
            return this.getTypeId().isStringTypeId();
        }
        return !otherType.isFloatingPointTypeId() && !otherType.isBitTypeId() && !otherType.isBlobTypeId() && !otherType.isXMLTypeId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return otherType.isStringTypeId() || otherType.isDateTimeTimeStampTypeId() && !this.getTypeId().isLongVarcharTypeId();
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        if (this.convertible(otherType, false) && !otherType.isBlobTypeId() && !otherType.isNumericTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), otherType, cf);
    }

    @Override
    public String interfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.StringDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.lang.String";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }

    @Override
    String nullMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 5: {
                return "getNullChar";
            }
            case 230: {
                return "getNullLongvarchar";
            }
            case 13: {
                return "getNullVarchar";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in nullMethodName() - " + formatId));
        return null;
    }

    @Override
    boolean pushCollationForDataValue(int collationType) {
        return collationType != 0;
    }

    @Override
    String dataValueMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 5: {
                return "getCharDataValue";
            }
            case 230: {
                return "getLongvarcharDataValue";
            }
            case 13: {
                return "getVarcharDataValue";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in dataValueMethodName() - " + formatId));
        return null;
    }
}

