/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.bytecode;

import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassHolder;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCJava;

final class Type {
    static final Type LONG = new Type("long", "J");
    static final Type INT = new Type("int", "I");
    static final Type SHORT = new Type("short", "S");
    static final Type BYTE = new Type("byte", "B");
    static final Type BOOLEAN = new Type("boolean", "Z");
    static final Type FLOAT = new Type("float", "F");
    static final Type DOUBLE = new Type("double", "D");
    static final Type STRING = new Type("java.lang.String", "Ljava/lang/String;");
    private final String javaName;
    private final short vmType;
    private final String vmName;
    final String vmNameSimple;

    Type(String javaName, String vmName) {
        this.vmName = vmName;
        this.javaName = javaName;
        this.vmType = BCJava.vmTypeId(vmName);
        this.vmNameSimple = ClassHolder.convertToInternalClassName(javaName);
    }

    String javaName() {
        return this.javaName;
    }

    String vmName() {
        return this.vmName;
    }

    short vmType() {
        return this.vmType;
    }

    int width() {
        return Type.width(this.vmType);
    }

    static int width(short type) {
        switch (type) {
            case -1: {
                return 0;
            }
            case 3: 
            case 5: {
                return 2;
            }
        }
        return 1;
    }
}

