/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.ConnectionChild;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import java.sql.SQLException;
import java.sql.Savepoint;

final class EmbedSavepoint30
extends ConnectionChild
implements Savepoint {
    private final String savepointName;
    private final int savepointID;

    EmbedSavepoint30(EmbedConnection conn, String name) throws StandardException {
        super(conn);
        if (name == null) {
            this.savepointName = "i." + conn.getLanguageConnection().getUniqueSavepointName();
            this.savepointID = conn.getLanguageConnection().getUniqueSavepointID();
        } else {
            this.savepointName = "e." + name;
            this.savepointID = -1;
        }
        conn.getLanguageConnection().languageSetSavePoint(this.savepointName, this);
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.savepointID == -1) {
            throw this.newSQLException("XJ013.S");
        }
        return this.savepointID;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.savepointID != -1) {
            throw this.newSQLException("XJ014.S");
        }
        return this.savepointName.substring(2);
    }

    String getInternalName() {
        return this.savepointName;
    }

    boolean sameConnection(EmbedConnection con) {
        return this.getEmbedConnection().getLanguageConnection() == con.getLanguageConnection();
    }
}

