/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import java.util.ArrayList;

public class ColumnDescriptorList
extends ArrayList {
    public void add(UUID tableID, ColumnDescriptor column) {
        this.add(column);
    }

    public ColumnDescriptor getColumnDescriptor(UUID tableID, String columnName) {
        ColumnDescriptor returnValue = null;
        for (ColumnDescriptor columnDescriptor : this) {
            if (!columnName.equals(columnDescriptor.getColumnName()) || !tableID.equals(columnDescriptor.getReferencingUUID())) continue;
            returnValue = columnDescriptor;
            break;
        }
        return returnValue;
    }

    public ColumnDescriptor getColumnDescriptor(UUID tableID, int columnID) {
        ColumnDescriptor returnValue = null;
        for (ColumnDescriptor columnDescriptor : this) {
            if (columnID != columnDescriptor.getPosition() || !tableID.equals(columnDescriptor.getReferencingUUID())) continue;
            returnValue = columnDescriptor;
            break;
        }
        return returnValue;
    }

    public ColumnDescriptor elementAt(int n) {
        return (ColumnDescriptor)this.get(n);
    }

    public String[] getColumnNames() {
        String[] strings = new String[this.size()];
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ColumnDescriptor columnDescriptor = this.elementAt(index);
            strings[index] = columnDescriptor.getColumnName();
        }
        return strings;
    }

    public boolean hasAutoIncrementAlways() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ColumnDescriptor columnDescriptor = this.elementAt(index);
            if (!columnDescriptor.isAutoincAlways()) continue;
            return true;
        }
        return false;
    }
}

