/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.property;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertySetCallback;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PropertyValidation
implements PropertyFactory {
    private Vector notifyOnSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable doValidateApplyAndMap(TransactionController tc, String key, Serializable value, Dictionary d, boolean dbOnlyProperty) throws StandardException {
        Serializable mappedValue = null;
        if (this.notifyOnSet != null) {
            PropertyValidation propertyValidation = this;
            synchronized (propertyValidation) {
                for (int i = 0; i < this.notifyOnSet.size(); ++i) {
                    PropertySetCallback psc = (PropertySetCallback)this.notifyOnSet.elementAt(i);
                    if (!psc.validate(key, value, d) || !dbOnlyProperty && key.startsWith("gemfirexd.") && PropertyUtil.whereSet(key, d) == 0) continue;
                    Serviceable s = psc.apply(key, value, d);
                    if (s != null) {
                        ((TransactionManager)tc).addPostCommitWork(s);
                    }
                    if (mappedValue != null) continue;
                    mappedValue = psc.map(key, value, d);
                }
            }
        }
        return mappedValue;
    }

    @Override
    public Serializable doMap(String key, Serializable value, Dictionary set) throws StandardException {
        Serializable mappedValue = null;
        if (this.notifyOnSet != null) {
            for (int i = 0; i < this.notifyOnSet.size() && mappedValue == null; ++i) {
                PropertySetCallback psc = (PropertySetCallback)this.notifyOnSet.elementAt(i);
                mappedValue = psc.map(key, value, set);
            }
        }
        if (mappedValue == null) {
            return value;
        }
        return mappedValue;
    }

    @Override
    public void validateSingleProperty(String key, Serializable value, Dictionary set) throws StandardException {
        if (key.equals("logDevice")) {
            throw StandardException.newException("XSRS8.S");
        }
        if (this.notifyOnSet != null) {
            for (int i = 0; i < this.notifyOnSet.size(); ++i) {
                PropertySetCallback psc = (PropertySetCallback)this.notifyOnSet.elementAt(i);
                psc.validate(key, value, set);
            }
        }
    }

    @Override
    public synchronized void addPropertySetNotification(PropertySetCallback who) {
        if (this.notifyOnSet == null) {
            this.notifyOnSet = new Vector(1, 1);
        }
        for (int i = this.notifyOnSet.size() - 1; i > 0; --i) {
            if (this.notifyOnSet.get(i) != who) continue;
            return;
        }
        this.notifyOnSet.addElement(who);
    }

    @Override
    public synchronized void verifyPropertySet(Properties p, Properties ignore) throws StandardException {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String pn = (String)e.nextElement();
            if (ignore.getProperty(pn) != null) continue;
            String pv = p.getProperty(pn);
            this.validateSingleProperty(pn, (Serializable)((Object)pv), p);
        }
    }
}

