/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.compile.types;

import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

public final class DVDSetHashingStrategy
implements TObjectHashingStrategy {
    private static final long serialVersionUID = 2173762090709422691L;
    private static final DVDSetHashingStrategy instance = new DVDSetHashingStrategy();

    public final int computeHashCode(Object object) {
        DataValueDescriptor ele = (DataValueDescriptor)object;
        return ele.computeHashCode(-1, 7);
    }

    public final boolean equals(Object o1, Object o2) {
        DataValueDescriptor leftEle = (DataValueDescriptor)o1;
        DataValueDescriptor rightEle = (DataValueDescriptor)o2;
        DataValueDescriptor comparator = leftEle.typePrecedence() < rightEle.typePrecedence() ? rightEle : leftEle;
        try {
            BooleanDataValue bdv = comparator.equals(leftEle, rightEle);
            return bdv.getBoolean();
        }
        catch (StandardException e) {
            SanityManager.THROWASSERT((String)"Failure in DVDSetHashingStrategy#equals", (Throwable)e);
            return false;
        }
    }

    public static DVDSetHashingStrategy getInstance() {
        return instance;
    }
}

