/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.coordinate;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import java.sql.ResultSetMetaData;
import java.util.concurrent.CountDownLatch;

public class ProxyResultDescription
implements ResultDescription {
    private volatile ResultDescription rd;
    private CountDownLatch latch;
    private volatile boolean ready = false;

    public ProxyResultDescription(boolean isCoordinator) {
        this.latch = isCoordinator ? new CountDownLatch(1) : null;
    }

    @Override
    public int findColumnInsensitive(String name) {
        this.checkReady();
        if (this.rd == null) {
            return 0;
        }
        return this.rd.findColumnInsensitive(name);
    }

    @Override
    public int getColumnCount() {
        this.checkReady();
        if (this.rd == null) {
            return 0;
        }
        return this.rd.getColumnCount();
    }

    @Override
    public ResultColumnDescriptor getColumnDescriptor(int position) {
        this.checkReady();
        if (this.rd == null) {
            return null;
        }
        return this.rd.getColumnDescriptor(position);
    }

    @Override
    public ResultColumnDescriptor[] getColumnInfo() {
        this.checkReady();
        if (this.rd == null) {
            return null;
        }
        return this.rd.getColumnInfo();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        this.checkReady();
        if (this.rd == null) {
            return null;
        }
        return this.rd.getMetaData();
    }

    @Override
    public String getStatementType() {
        this.checkReady();
        if (this.rd == null) {
            return null;
        }
        return this.rd.getStatementType();
    }

    @Override
    public void setMetaData(ResultSetMetaData rsmd) {
        this.checkReady();
        if (this.rd != null) {
            this.rd.setMetaData(rsmd);
        }
    }

    public boolean isSet() {
        return this.ready;
    }

    public synchronized void setResultDescription(ResultDescription rd) {
        if (rd == null || this.ready) {
            return;
        }
        this.rd = rd;
        this.ready = true;
        if (this.latch != null) {
            this.latch.countDown();
        }
    }

    public void setReady() {
        this.ready = true;
        this.latch.countDown();
    }

    private void checkReady() {
        if (this.latch == null || this.ready) {
            return;
        }
        while (true) {
            try {
                this.latch.await();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)ie);
                continue;
            }
            break;
        }
    }
}

