/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.coordinate;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.DistributedProcedureCallNode;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureResultCollector;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.procedure.IncomingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureProcessorContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;

public class ProcedureProcessorContextImpl
implements ProcedureProcessorContext {
    private final ProcedureResultCollector prc;
    private final ConnectionContext cc;
    private final LanguageConnectionContext lcc;
    private final Region region;
    private final String whereClause;
    private final String tableName;
    private final DistributedProcedureCallNode dpnode;

    public ProcedureProcessorContextImpl(LanguageConnectionContext lcc, ProcedureResultCollector prc, Region r, String whereClause, DistributedProcedureCallNode dnode, String tableName) {
        this.lcc = lcc;
        ContextManager cm = lcc.getContextManager();
        this.cc = (ConnectionContext)((Object)cm.getContext("JDBC_ConnectionContext"));
        this.prc = prc;
        this.region = r;
        this.whereClause = whereClause;
        this.dpnode = dnode;
        this.tableName = tableName;
    }

    @Override
    public IncomingResultSet[] getIncomingOutParameters() {
        return this.prc.getOutParameters();
    }

    @Override
    public IncomingResultSet[] getIncomingResultSets(int resultSetNumber) {
        return this.prc.getIncomingResultSets(resultSetNumber);
    }

    @Override
    public String[] getColocatedTableNames() {
        Map map;
        if (this.region != null && this.region.getAttributes().getDataPolicy().withPartitioning() && (map = ColocationHelper.getAllColocationRegions((PartitionedRegion)((PartitionedRegion)this.region))) != null) {
            String[] ret = new String[map.size()];
            Iterator itr = map.keySet().iterator();
            int i = -1;
            while (itr.hasNext()) {
                String fpath = (String)itr.next();
                String[] parts = fpath.split("/");
                assert (parts.length == 2);
                ret[i++] = parts[0] + "." + parts[1];
            }
            if (ret.length > 0) {
                return ret;
            }
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        if (this.cc != null) {
            try {
                return this.cc.getNestedConnection(true);
            }
            catch (SQLException e) {
                Misc.getCacheLogWriter().warning("could not get nested connection", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getFilter() {
        return this.whereClause;
    }

    @Override
    public String getProcedureName() {
        return this.dpnode.getMethodName();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean isPartitioned(String tableName) {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("ProcedureExecutionContextImpl::isPartitioned tableName passed is either null or empty");
        }
        Region reg = Misc.getRegionForTableByPath(tableName, true);
        if (reg == null) {
            throw new IllegalArgumentException("ProcedureExecutionContextImpl::isPartitioned no region found corresponding to the tableName: " + tableName);
        }
        return reg.getAttributes().getDataPolicy().withPartitioning();
    }

    ResultSet getResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet rs) throws SQLException {
        return this.cc.getResultSet(rs);
    }

    public int getCurrentResultSetNumber() {
        return 0;
    }

    @Override
    public boolean isPossibleDuplicate() {
        return this.prc.getIfReExecute();
    }
}

