/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.locks.impl;

import com.gemstone.gemfire.distributed.internal.deadlock.Dependency;
import com.gemstone.gemfire.distributed.internal.deadlock.DependencyMonitor;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLocalLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockable;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdReadWriteLock;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class GfxdRWLockDependencyMonitor
implements DependencyMonitor {
    public static final DependencyMonitor INSTANCE = new GfxdRWLockDependencyMonitor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Dependency<Thread, Serializable>> getBlockedThreads(Thread[] allThreads) {
        GfxdLocalLockService localService;
        HashSet<Dependency<Thread, Serializable>> results = new HashSet<Dependency<Thread, Serializable>>();
        GemFireStore memStore = GemFireStore.getBootedInstance();
        if (memStore == null) {
            return results;
        }
        GfxdDRWLockService ddlService = memStore.getDDLLockService();
        if (ddlService == null) {
            return results;
        }
        GfxdLocalLockService gfxdLocalLockService = localService = ddlService.getLocalLockService();
        synchronized (gfxdLocalLockService) {
            for (GfxdReadWriteLock lock : localService.values()) {
                Collection<Thread> blockedThreads = lock.getBlockedThreadsForDebugging();
                for (Thread blocked : blockedThreads) {
                    if (!(lock.getLockName() instanceof Serializable)) continue;
                    results.add((Dependency<Thread, Serializable>)new Dependency((Object)blocked, (Object)new LockId((Serializable)lock.getLockName())));
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Dependency<Serializable, Thread>> getHeldResources(Thread[] allThreads) {
        GfxdLocalLockService localService;
        HashSet<Dependency<Serializable, Thread>> results = new HashSet<Dependency<Serializable, Thread>>();
        GemFireStore memStore = GemFireStore.getBootedInstance();
        if (memStore == null) {
            return results;
        }
        GfxdDRWLockService ddlService = memStore.getDDLLockService();
        if (ddlService == null) {
            return results;
        }
        GfxdLocalLockService gfxdLocalLockService = localService = ddlService.getLocalLockService();
        synchronized (gfxdLocalLockService) {
            block6: for (GfxdReadWriteLock lock : localService.values()) {
                GfxdLocalLockService.DistributedLockOwner dOwner;
                Object owner = lock.getWriteLockOwner();
                Object name = lock.getLockName();
                if (!(name instanceof Serializable)) continue;
                if (owner instanceof Thread) {
                    results.add((Dependency<Serializable, Thread>)new Dependency((Object)new LockId((Serializable)name), (Object)((Thread)owner)));
                }
                if (!(owner instanceof GfxdLocalLockService.DistributedLockOwner) || !(dOwner = (GfxdLocalLockService.DistributedLockOwner)owner).getOwnerMember().equals(GemFireStore.getMyId())) continue;
                for (Thread thread : allThreads) {
                    if (thread.getId() != dOwner.getOwnerThreadId()) continue;
                    results.add((Dependency<Serializable, Thread>)new Dependency((Object)new LockId((Serializable)lock.getLockName()), (Object)thread));
                    continue block6;
                }
            }
        }
        ContextService service = ContextService.getFactory();
        if (service == null) {
            return results;
        }
        ContextService contextService = service;
        synchronized (contextService) {
            for (ContextManager cm : service.getAllContexts()) {
                Thread thread;
                GfxdLockSet lockSet;
                TransactionController tc;
                LanguageConnectionContext lcc = (LanguageConnectionContext)cm.getContext("LanguageConnectionContext");
                if (lcc == null || (tc = lcc.getTransactionExecute()) == null || (lockSet = ((GemFireTransaction)tc).getLockSpace()) == null || (thread = cm.getActiveThread()) == null) continue;
                Collection<GfxdLockable> readLocks = lockSet.getReadLocksForDebugging();
                for (GfxdLockable lock : readLocks) {
                    if (!(lock.getName() instanceof Serializable)) continue;
                    results.add((Dependency<Serializable, Thread>)new Dependency((Object)((Serializable)lock.getName()), (Object)thread));
                }
            }
        }
        return results;
    }

    private GfxdRWLockDependencyMonitor() {
    }

    private static class LockId
    implements Serializable {
        private final Serializable tokenName;

        public LockId(Serializable tokenName) {
            this.tokenName = tokenName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tokenName == null ? 0 : this.tokenName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LockId other = (LockId)obj;
            return !(this.tokenName == null ? other.tokenName != null : !this.tokenName.equals(other.tokenName));
        }

        public String toString() {
            return "GFXDRWLock(" + this.tokenName + ")";
        }
    }
}

