/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.locks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.LeaseExpiredException;
import com.gemstone.gemfire.distributed.LockNotHeldException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.locks.DLockLogWriter;
import com.gemstone.gemfire.distributed.internal.locks.DLockRequestProcessor;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.locks.LockGrantorId;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessageProcessor;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResponseCode;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdWaitingReplyProcessor;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockReleaseProcessor;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLocalLockService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public final class GfxdDRWLockRequestProcessor
extends DLockRequestProcessor {
    protected GfxdDRWLockRequestProcessor(LockGrantorId lockGrantorId, DLockService svc, Object objectName, int threadId, long startTime, long leaseMillis, long waitMillis, boolean reentrant, boolean tryLock, DM dm) {
        super(lockGrantorId, svc, objectName, threadId, startTime, leaseMillis, waitMillis, reentrant, tryLock, dm, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GfxdWaitingReplyProcessor requestDRWLock(GfxdDRWLockService rwsvc, Object objectName, Object lockOwner, DM dm, long waitMillis, boolean interruptible, LogWriterI18n log) throws InterruptedException {
        long currentTime;
        GfxdReplyMessageProcessor response = null;
        GfxdResponseCode responseCode = null;
        if (waitMillis < 0L) {
            waitMillis = Long.MAX_VALUE;
        }
        long endTime = Long.MAX_VALUE - waitMillis < (currentTime = System.currentTimeMillis()) ? Long.MAX_VALUE : currentTime + waitMillis;
        InternalDistributedMember myId = dm.getDistributionManagerId();
        Set<DistributedMember> grantedMembers = Collections.emptySet();
        try {
            Set<DistributedMember> members;
            boolean toSelf;
            while (waitMillis > 0L && ((toSelf = (members = GfxdMessage.getAllGfxdMembers()).remove(myId)) || members.size() > 0)) {
                response = new GfxdWaitingReplyProcessor(dm, members, true, true);
                try {
                    long vmWaitMillis = rwsvc.getMaxVMWriteLockWait();
                    if (vmWaitMillis > waitMillis) {
                        vmWaitMillis = waitMillis;
                    }
                    boolean localGrant = GfxdDRWLockRequestMessage.send(dm, (GfxdWaitingReplyProcessor)response, members, toSelf, rwsvc, objectName, lockOwner, vmWaitMillis, interruptible, log);
                    responseCode = response.getResponseCode();
                    grantedMembers = ((GfxdWaitingReplyProcessor)response).getGrantedMembers();
                    if (localGrant && (responseCode.isGrant() || responseCode.isException())) break;
                    if (grantedMembers.size() > 0) {
                        try {
                            toSelf = grantedMembers.remove(myId);
                            GfxdDRWLockReleaseProcessor.GfxdDRWLockReleaseMessage.send(dm, grantedMembers, toSelf, rwsvc.getName(), objectName, lockOwner, true, log);
                        }
                        catch (ReplyException ex) {
                            ex.handleAsUnexpected();
                        }
                        grantedMembers.clear();
                    }
                    if (log.infoEnabled()) {
                        log.info(LocalizedStrings.LockRequest_RETRYING_FOR_LOCK, new Object[]{response.toString(), objectName, vmWaitMillis});
                    }
                }
                finally {
                    response.endWait();
                }
                if (waitMillis == Long.MAX_VALUE) continue;
                waitMillis = endTime - System.currentTimeMillis();
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Throwable t) {
            Error err;
            if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                SystemFailure.initiateFailure((Error)err);
                throw err;
            }
            SystemFailure.checkFailure();
            if (t.getCause() instanceof InterruptedException) {
                throw (InterruptedException)t.getCause();
            }
            if (log.fineEnabled()) {
                log.fine("GfxdDRWLockRequestProcessor caught Exception", t);
            }
        }
        finally {
            if (response != null && !response.getResponseCode().isGrant()) {
                block34: {
                    if (grantedMembers.size() > 0) {
                        boolean toSelf = grantedMembers.remove(myId);
                        GfxdDRWLockReleaseProcessor.GfxdDRWLockReleaseMessage.send(dm, grantedMembers, toSelf, rwsvc.getName(), objectName, lockOwner, true, log);
                    }
                    try {
                        rwsvc.unlock(objectName);
                    }
                    catch (LockNotHeldException ex) {
                        if (log.fineEnabled()) {
                            log.fine("GfxdDRWLockRequestProcessor unexpected exception in unlock after failed distributed write lock", (Throwable)ex);
                        }
                    }
                    catch (LeaseExpiredException ex) {
                        if (!log.fineEnabled()) break block34;
                        log.fine("GfxdDRWLockRequestProcessor unexpected exception in unlock after failed distributed write lock", (Throwable)ex);
                    }
                }
                dm.getCancelCriterion().checkCancelInProgress(null);
            }
        }
        return response;
    }

    public static final class GfxdDRWLockDumpMessage
    extends GfxdMessage
    implements MessageWithReply {
        private String serviceName;
        private String logPrefix;
        private boolean stdout;
        private static final short ISSTDOUT = 64;

        public static void send(InternalDistributedSystem sys, String serviceName, String logPrefix, boolean stdout, LogWriterI18n log) {
            block3: {
                GfxdDRWLockDumpMessage msg = new GfxdDRWLockDumpMessage();
                msg.serviceName = serviceName;
                msg.logPrefix = logPrefix;
                msg.stdout = stdout;
                DM dm = sys.getDistributionManager();
                Set<DistributedMember> otherMembers = GfxdDRWLockDumpMessage.getOtherMembers();
                ReplyProcessor21 processor = new ReplyProcessor21(sys, otherMembers);
                msg.setRecipients(otherMembers);
                msg.setProcessorId(processor.getProcessorId());
                dm.putOutgoing((DistributionMessage)msg);
                try {
                    processor.waitForReplies();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    Misc.checkIfCacheClosing(ie);
                }
                catch (ReplyException ex) {
                    if (!log.severeEnabled()) break block3;
                    log.severe(LocalizedStrings.DEBUG, (Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }

        @Override
        protected void processMessage(DistributionManager dm) {
            DistributedLockService svc = DistributedLockService.getServiceNamed((String)this.serviceName);
            if (svc != null && svc instanceof GfxdDRWLockService) {
                GfxdDRWLockService rwsvc = (GfxdDRWLockService)svc;
                rwsvc.dumpAllRWLocks(this.logPrefix, false, this.stdout, false);
            }
        }

        @Override
        protected void sendReply(ReplyException ex, DistributionManager dm) {
            ReplyMessage.send((InternalDistributedMember)this.getSender(), (int)this.processorId, (ReplyException)ex, (ReplySender)dm, null);
        }

        @Override
        protected boolean waitForNodeInitialization() {
            return false;
        }

        @Override
        public byte getGfxdID() {
            return 8;
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString((String)this.serviceName, (DataOutput)out);
            DataSerializer.writeString((String)this.logPrefix, (DataOutput)out);
        }

        @Override
        protected short computeCompressedShort(short flags) {
            flags = super.computeCompressedShort(flags);
            if (this.stdout) {
                flags = (short)(flags | 0x40);
            }
            return flags;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.serviceName = DataSerializer.readString((DataInput)in);
            this.logPrefix = DataSerializer.readString((DataInput)in);
            this.stdout = (this.flags & 0x40) != 0;
        }

        @Override
        protected void appendFields(StringBuilder sb) {
            super.appendFields(sb);
            sb.append("; serviceName=").append(this.serviceName);
            sb.append("; logPrefix=").append(this.logPrefix);
            sb.append("; isStdout=").append(this.stdout);
            sb.append("; sender=").append(this.getSender());
        }
    }

    public static final class GfxdDRWLockResponseMessage
    extends GfxdReplyMessage {
        protected String serviceName;
        protected Object objectName;
        protected GfxdResponseCode responseCode = GfxdResponseCode.EXCEPTION;

        @Override
        public byte getGfxdID() {
            return 5;
        }

        @Override
        public GfxdResponseCode getResponseCode() {
            return this.responseCode;
        }

        public void setException(ReplyException ex) {
            super.setException(ex);
            this.responseCode = GfxdResponseCode.EXCEPTION;
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            this.responseCode.toData(out);
            out.writeUTF(this.serviceName);
            DataSerializer.writeObject((Object)this.objectName, (DataOutput)out);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.responseCode = GfxdResponseCode.fromData(in);
            this.serviceName = in.readUTF();
            this.objectName = DataSerializer.readObject((DataInput)in);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{GfxdDRWLockResponseMessage id=" + this.processorId);
            sb.append(" responseCode=" + this.responseCode);
            sb.append(" serviceName=" + this.serviceName);
            sb.append(" name=" + this.objectName);
            sb.append(" sender=" + this.getSender());
            sb.append(" processorId=" + this.processorId);
            sb.append("}");
            return sb.toString();
        }
    }

    public static final class GfxdDRWLockRequestMessage
    extends GfxdMessage
    implements MessageWithReply {
        protected String serviceName;
        protected Object objectName;
        protected Object lockOwner;
        protected long waitMillis;
        private transient boolean grant;
        private transient int sequenceId;
        private transient GfxdDRWLockService rwsvc;

        public static boolean send(DM dm, GfxdWaitingReplyProcessor processor, Set<DistributedMember> members, boolean toSelf, GfxdDRWLockService svc, Object objectName, Object lockOwner, long waitMillis, boolean interruptible, LogWriterI18n log) throws InterruptedException {
            GfxdDRWLockRequestMessage msg = new GfxdDRWLockRequestMessage();
            msg.processorId = processor.getProcessorId();
            msg.serviceName = svc.getName();
            msg.objectName = objectName;
            msg.lockOwner = lockOwner;
            msg.waitMillis = waitMillis < 0L ? Long.MAX_VALUE : waitMillis;
            msg.setRecipients(members);
            if (log.fineEnabled()) {
                log.fine("GfxdDRWLockRequestMessage#send: acquiring writeLock for object [" + objectName + "]");
            }
            boolean grant = true;
            if (toSelf) {
                grant = svc.getLocalLockService().writeLock(objectName, lockOwner, waitMillis, -1L);
                if (log.fineEnabled()) {
                    log.fine("GfxdDRWLockRequestMessage#send: writeLock for object [" + objectName + "] " + (grant ? "successful" : "unsuccessful"));
                }
                if (grant) {
                    processor.addGrantedMember((DistributedMember)dm.getDistributionManagerId(), 1);
                } else {
                    processor.setResponseCode(GfxdResponseCode.TIMEOUT);
                }
            }
            if (grant) {
                if (DistributionManager.VERBOSE || log.fineEnabled()) {
                    log.fine(msg.toString() + "#send: sending writeLock message for " + "object [" + objectName + "] to members: " + members + ", myId: " + dm.getDistributionManagerId());
                }
                dm.putOutgoing((DistributionMessage)msg);
                GfxdDRWLockRequestMessage.waitForReplies(processor, interruptible, true);
            }
            return grant;
        }

        static void waitForReplies(GfxdWaitingReplyProcessor processor, boolean interruptible, boolean checkWaiters) throws InterruptedException {
            ReplyException replyEx = null;
            try {
                if (interruptible) {
                    if (checkWaiters) {
                        processor.waitForReplies(0L, processor.getWaitersLatch(), false);
                    } else {
                        processor.waitForReplies();
                    }
                } else if (checkWaiters) {
                    processor.waitForRepliesUninterruptibly(0L, processor.getWaitersLatch(), false);
                } else {
                    processor.waitForRepliesUninterruptibly();
                }
            }
            catch (ReplyException ex) {
                replyEx = ex;
            }
            if (replyEx == null) {
                replyEx = processor.getReplyException();
            }
            if (replyEx != null) {
                Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)replyEx);
            }
        }

        @Override
        protected void processMessage(DistributionManager dm) {
            this.grant = false;
            LogWriterI18n log = dm.getLoggerI18n();
            this.sequenceId = 1;
            DistributedLockService svc = DistributedLockService.getServiceNamed((String)this.serviceName);
            this.grant = true;
            if (svc != null && svc instanceof GfxdDRWLockService) {
                this.rwsvc = (GfxdDRWLockService)svc;
                GfxdLocalLockService lsvc = this.rwsvc.getLocalLockService();
                InternalDistributedMember sender = this.getSender();
                if (log.fineEnabled()) {
                    log.fine("GfxdDRWLockRequestMessage#process: getting writeLock for object [" + this.objectName + "] with waitMillis=" + this.waitMillis + " owner=" + this.lockOwner);
                }
                this.grant = lsvc.writeLock(this.objectName, this.lockOwner, this.waitMillis, -1L);
                if (log.fineEnabled()) {
                    log.fine("GfxdDRWLockRequestMessage#process: writeLock for object [" + this.objectName + "] was " + (this.grant ? "successful" : "unsuccessful") + " with waitMillis=" + this.waitMillis + " owner=" + this.lockOwner + ", sender=" + sender);
                }
                if (this.grant && !dm.isCurrentMember(sender)) {
                    this.releaseAfterMemberDeparted(log, sender);
                    this.grant = false;
                }
            }
        }

        @Override
        protected void sendReply(ReplyException ex, DistributionManager dm) {
            DLockLogWriter log = new DLockLogWriter(dm.getLoggerI18n());
            GfxdDRWLockResponseMessage response = ex != null ? this.createResponse(GfxdResponseCode.EXCEPTION, ex, (LogWriterI18n)log) : (this.grant ? this.createResponse(GfxdResponseCode.GRANT(this.sequenceId), null, (LogWriterI18n)log) : this.createResponse(GfxdResponseCode.TIMEOUT, null, (LogWriterI18n)log));
            Set noRecipients = dm.putOutgoing((DistributionMessage)response);
            if (noRecipients != null && this.rwsvc != null && response.getResponseCode().isGrant() && noRecipients.contains(this.getSender())) {
                this.releaseAfterMemberDeparted((LogWriterI18n)log, this.sender);
            }
        }

        private final void releaseAfterMemberDeparted(LogWriterI18n log, InternalDistributedMember sender) {
            boolean released = false;
            try {
                this.rwsvc.getLocalLockService().writeUnlock(this.objectName, this.lockOwner);
                released = true;
            }
            catch (LockNotHeldException lockNotHeldException) {
                // empty catch block
            }
            if (log.fineEnabled()) {
                log.fine("GfxdDRWLockRequestMessage#process: writeLock for object [" + this.objectName + "] with owner " + this.lockOwner + (released ? " released since" : " tried to be released but already unlocked after") + " the requester [" + sender + "] has departed");
            }
        }

        @Override
        protected boolean waitForNodeInitialization() {
            return false;
        }

        private GfxdDRWLockResponseMessage createResponse(GfxdResponseCode code, Throwable replyException, LogWriterI18n log) {
            GfxdDRWLockResponseMessage response = new GfxdDRWLockResponseMessage();
            response.setProcessorId(this.getProcessorId());
            response.setRecipient(this.getSender());
            response.serviceName = this.serviceName;
            response.objectName = this.objectName;
            if (replyException != null) {
                response.setException(new ReplyException(replyException));
                if (log.fineEnabled()) {
                    log.fine("While processing <" + this + ">, got exception, returning to sender", (Throwable)response.getException());
                }
            } else {
                response.responseCode = code;
            }
            return response;
        }

        @Override
        public byte getGfxdID() {
            return 4;
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString((String)this.serviceName, (DataOutput)out);
            DataSerializer.writeObject((Object)this.objectName, (DataOutput)out);
            DataSerializer.writeObject((Object)this.lockOwner, (DataOutput)out);
            out.writeLong(this.waitMillis);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.serviceName = DataSerializer.readString((DataInput)in);
            this.objectName = DataSerializer.readObject((DataInput)in);
            this.lockOwner = DataSerializer.readObject((DataInput)in);
            this.waitMillis = in.readLong();
        }

        @Override
        protected void appendFields(StringBuilder sb) {
            super.appendFields(sb);
            sb.append("; serviceName=").append(this.serviceName);
            sb.append("; name=").append(this.objectName);
            sb.append("; owner=").append(this.lockOwner);
            sb.append("; sender=").append(this.getSender());
            sb.append("; waitMillis=").append(this.waitMillis);
        }
    }
}

