/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.expression;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GfxdExprNodeVisitor
extends VisitorAdaptor {
    private final Map<String, Integer> columnToIndexMap;
    private final ArrayList<String> usedCols;
    private int idx;

    public GfxdExprNodeVisitor(Map<String, Integer> columnToIndexMap) {
        this.columnToIndexMap = columnToIndexMap;
        this.usedCols = new ArrayList();
        this.idx = 0;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ColumnReference) {
            String columnName = ((ColumnReference)node).getColumnName();
            this.usedCols.add(columnName);
            this.columnToIndexMap.put(columnName, this.idx);
            ++this.idx;
        } else if (node instanceof BaseColumnNode) {
            String columnName = ((BaseColumnNode)node).getColumnName();
            this.usedCols.add(columnName);
            this.columnToIndexMap.put(columnName, this.idx);
            ++this.idx;
        }
        return node;
    }

    public List<String> getUsedColumns() {
        return this.usedCols;
    }
}

