/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.execute.EmptyRegionFunctionException;
import com.gemstone.gemfire.cache.execute.NoMemberFoundException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DirectReplyMessage;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.ProxyBucketRegion;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdSingleResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public abstract class RegionSingleKeyExecutorMessage
extends GfxdFunctionMessage<Object>
implements DirectReplyMessage {
    protected String regionPath;
    protected int prId = -1;
    protected Object key;
    protected Object callbackArg;
    protected int bucketId = -1;
    protected boolean isSecondaryCopy;
    protected transient LocalRegion region;
    protected transient DistributedRegion dr;
    protected transient PartitionedRegion pr;
    protected transient Object routingObject;
    protected transient ProxyBucketRegion pbr;
    protected transient DistributedMember target;
    protected boolean allCopies;
    protected final transient boolean txBatching;
    protected static final Object DUMMY_RESULT = Token.INVALID;
    protected static final short IS_PARTITIONED_TABLE = 64;
    protected static final short HAS_BUCKET_ID = 128;
    protected static final short SECONDARY_COPY = 256;
    protected static final short ALL_COPIES = 512;
    protected static final short HAS_CALLBACK_ARG = 1024;
    protected static final short UNRESERVED_FLAGS_START = 2048;

    protected RegionSingleKeyExecutorMessage(boolean ignored) {
        super(true);
        this.txBatching = false;
    }

    protected RegionSingleKeyExecutorMessage(LocalRegion region, Object key, Object callbackArg, Object routingObject, boolean allCopies, TXStateInterface tx, boolean timeStatsEnabled) {
        super(new GfxdSingleResultCollector(allCopies ? DUMMY_RESULT : null), tx, timeStatsEnabled);
        this.region = region;
        this.regionPath = region.getFullPath();
        if (region.getPartitionAttributes() != null) {
            this.pr = (PartitionedRegion)region;
            this.prId = this.pr.getPRId();
            this.bucketId = routingObject == null ? PartitionedRegionHelper.getHashKey((PartitionedRegion)this.pr, (Operation)Operation.GET, (Object)key, null, (Object)callbackArg) : PartitionedRegionHelper.getHashKey((PartitionedRegion)this.pr, (Object)routingObject);
            this.pbr = this.pr.getRegionAdvisor().getProxyBucketArray()[this.bucketId];
        } else {
            this.dr = (DistributedRegion)region;
        }
        this.key = key;
        this.callbackArg = callbackArg;
        this.routingObject = routingObject;
        this.allCopies = allCopies;
        this.txBatching = this.txProxy != null && this.txProxy.batchingEnabled();
    }

    protected RegionSingleKeyExecutorMessage(RegionSingleKeyExecutorMessage other) {
        super(other);
        this.region = other.region;
        this.regionPath = other.regionPath;
        this.dr = other.dr;
        this.pr = other.pr;
        this.prId = other.prId;
        this.bucketId = other.bucketId;
        this.pbr = other.pbr;
        this.key = other.key;
        this.callbackArg = other.callbackArg;
        this.routingObject = other.routingObject;
        this.allCopies = other.allCopies;
        this.txBatching = other.txBatching;
        assert (this.getTXState() == null || this.getTXState() == TXManagerImpl.getCurrentTXState()) : "unexpected mismatch of current TX " + TXManagerImpl.getCurrentTXState() + ", and TX passed to message " + this.getTXState();
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.pbr != null ? this.pbr.getDistributionAdvisor() : this.dr.getDistributionAdvisor();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void executeFunction(boolean enableStreaming) throws StandardException, SQLException {
        boolean preferredIsSelf;
        Set members;
        InternalDistributedMember member;
        GemFireCacheImpl cache = this.region.getCache();
        InternalDistributedSystem sys = cache.getSystem();
        DM dm = sys.getDistributionManager();
        InternalDistributedMember myId = cache.getMyId();
        String logName = this.getID();
        this.target = null;
        this.isSecondaryCopy = false;
        if (this.pr == null) {
            InternalDistributedMember member2;
            long beginMapTime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(-1L) : 0L;
            DataPolicy policy = this.dr.getDataPolicy();
            CacheDistributionAdvisor advisor = this.dr.getCacheDistributionAdvisor();
            Set replicates = null;
            if (policy.withReplication() || policy.withPreloaded()) {
                member2 = myId;
            } else {
                if (policy.withStorage()) throw new GemFireXDRuntimeException(logName + "#execute: unknown policy " + policy + " for region: " + this.region);
                if (this.failedNodes == null) {
                    member2 = this.dr.getRandomReplicate();
                } else {
                    replicates = advisor.adviseInitializedReplicates();
                    member2 = null;
                    replicates.removeAll(this.failedNodes);
                    if (replicates.size() > 0) {
                        int pos = PartitionedRegion.rand.nextInt(replicates.size());
                        Iterator iter = replicates.iterator();
                        while (pos-- >= 0 && iter.hasNext()) {
                            member2 = (InternalDistributedMember)iter.next();
                        }
                    }
                }
            }
            if (member2 == null) {
                throw new NoMemberFoundException(LocalizedStrings.DistributedRegion_NO_REPLICATED_REGION_FOUND_FOR_EXECUTING_FUNCTION_0.toLocalizedString(new Object[]{logName}));
            }
            if (!(!this.allCopies || this.txBatching && member2 == myId || advisor.hasUninitializedReplicate())) {
                if (replicates == null) {
                    replicates = advisor.adviseInitializedReplicates();
                }
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(logName + ": executing region message " + this.toString() + " on nodes " + replicates + " with \"preferred node\" " + member2));
                }
            } else {
                this.allCopies = false;
                replicates = null;
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(logName + ": executing region message " + this.toString() + " on node " + member2));
                }
            }
            long beginTime = 0L;
            ArrayList<RegionSingleKeyExecutorMessage> msgsSent = null;
            if (beginMapTime != 0L) {
                this.member_mapping_time = XPLAINUtil.recordTiming(beginMapTime);
                msgsSent = this.membersMsgsSent;
                if (msgsSent == null) {
                    this.membersMsgsSent = msgsSent = new ArrayList<RegionSingleKeyExecutorMessage>(1);
                }
                this.begin_scatter_time = XPLAINUtil.currentTimeStamp();
                beginTime = XPLAINUtil.recordTiming(-1L);
            }
            if (replicates != null && replicates.size() > 0) {
                Set targets = replicates;
                targets.add(member2);
                GfxdFunctionMessage.GfxdFunctionReplyMessageProcessor processor = this.createReplyProcessor(dm, targets);
                this.setProcessor(processor);
                targets.remove(member2);
                if (targets.size() > 0) {
                    RegionSingleKeyExecutorMessage msg = this.clone();
                    msg.isSecondaryCopy = true;
                    msg.executeOnMembers(sys, dm, targets, false);
                    if (beginTime != 0L) {
                        msgsSent.add(msg);
                    }
                }
                this.executeOnMember(sys, dm, member2, member2 == myId, enableStreaming);
            } else {
                GfxdFunctionMessage.GfxdFunctionReplyMessageProcessor processor = this.createReplyProcessor(dm, member2);
                this.setProcessor(processor);
                this.target = member2;
                this.executeOnMember(sys, dm, member2, member2 == myId, enableStreaming);
            }
            if (beginTime == 0L) return;
            this.root_msg_send_time += XPLAINUtil.recordTiming(beginTime);
            msgsSent.add(this);
            return;
        }
        long beginMapTime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(-1L) : 0L;
        PartitionedRegion.RetryTimeKeeper retryTime = null;
        boolean optimizeForWrite = this.optimizeForWrite() || this.region.isHDFSReadWriteRegion();
        while (true) {
            member = null;
            members = null;
            preferredIsSelf = false;
            member = optimizeForWrite ? this.pr.getOrCreateNodeForBucketWrite(this.bucketId, retryTime) : this.pr.getOrCreateNodeForInitializedBucketRead(this.bucketId, this.possibleDuplicate);
            preferredIsSelf = myId.equals(member);
            if (!(!this.allCopies || this.txBatching && preferredIsSelf)) {
                ProxyBucketRegion pbr = this.pr.getRegionAdvisor().getProxyBucketArray()[this.bucketId];
                if (!pbr.getBucketAdvisor().hasUninitialized()) {
                    members = pbr.getBucketOwners();
                    if (!members.contains(member)) {
                        continue;
                    }
                } else {
                    this.allCopies = false;
                }
            } else {
                this.allCopies = false;
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(logName + ": execute on bucket [" + this.bucketId + "] with routing object [" + this.routingObject + "] for key: " + this.key + (members != null ? " on members " + members : " on member " + member)));
            }
            if (this.failedNodes == null) break;
            boolean hasFailedNode = false;
            for (DistributedMember m : this.failedNodes) {
                if ((members == null || !members.contains(m)) && !m.equals(member)) continue;
                if (retryTime == null) {
                    retryTime = new PartitionedRegion.RetryTimeKeeper(this.pr.getRetryTimeout());
                }
                if (retryTime.overMaximum()) {
                    throw new InternalFunctionInvocationTargetException(LocalizedStrings.PRHARedundancyProvider_TIMED_OUT_ATTEMPTING_TO_0_IN_THE_PARTITIONED_REGION__1_WAITED_FOR_2_MS.toLocalizedString(new Object[]{"doing GemFireXD function execution", PRHARedundancyProvider.regionStatus((PartitionedRegion)this.pr, null, null, (boolean)true), (long)this.pr.getRetryTimeout()}) + PRHARedundancyProvider.TIMEOUT_MSG);
                }
                retryTime.waitToRetryNode();
                hasFailedNode = true;
                break;
            }
            if (!hasFailedNode) {
                this.failedNodes = null;
                break;
            }
            this.mapping_retry_count = (short)(this.mapping_retry_count + 1);
        }
        ArrayList<RegionSingleKeyExecutorMessage> msgsSent = null;
        if (beginMapTime != 0L) {
            this.member_mapping_time = XPLAINUtil.recordTiming(beginMapTime);
            this.begin_scatter_time = XPLAINUtil.currentTimeStamp();
            msgsSent = this.membersMsgsSent;
            if (msgsSent == null) {
                this.membersMsgsSent = msgsSent = new ArrayList<RegionSingleKeyExecutorMessage>(1);
            }
        }
        if (member != null && members == null) {
            long beginTime;
            GfxdFunctionMessage.GfxdFunctionReplyMessageProcessor processor = this.createReplyProcessor(dm, member);
            this.setProcessor(processor);
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(logName + ": executing region message " + this.toString() + " on node " + member));
            }
            long l = beginTime = beginMapTime != 0L ? XPLAINUtil.recordTiming(-1L) : 0L;
            if (preferredIsSelf) {
                this.target = myId;
                this.executeOnMember(sys, dm, myId, true, enableStreaming);
            } else {
                this.target = member;
                this.executeOnMember(sys, dm, member, false, enableStreaming);
            }
            if (beginTime == 0L) return;
            this.root_msg_send_time += XPLAINUtil.recordTiming(beginTime);
            msgsSent.add(this);
            return;
        }
        if (members != null && members.size() > 0) {
            RegionSingleKeyExecutorMessage msg;
            long beginTime;
            Set targets = members;
            GfxdFunctionMessage.GfxdFunctionReplyMessageProcessor processor = this.createReplyProcessor(dm, targets);
            this.setProcessor(processor);
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(logName + ": executing region message " + this.toString() + " on nodes " + members));
            }
            long l = beginTime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(-1L) : 0L;
            if (!targets.remove(member)) {
                Assert.fail((Object)("unexpected missing \"preferred node\" " + member + " in allCopies list " + targets));
            }
            boolean toSelf = false;
            if (!preferredIsSelf) {
                toSelf = targets.remove(myId);
            }
            if (targets.size() > 0) {
                msg = this.clone();
                msg.isSecondaryCopy = true;
                msg.executeOnMembers(sys, dm, targets, enableStreaming);
                if (beginTime != 0L) {
                    msgsSent.add(msg);
                }
            }
            this.executeOnMember(sys, dm, member, preferredIsSelf, enableStreaming);
            if (toSelf) {
                msg = this.clone();
                msg.isSecondaryCopy = true;
                msg.executeOnMember(sys, dm, myId, true, enableStreaming);
                if (beginTime != 0L) {
                    msgsSent.add(msg);
                }
            }
            if (beginTime == 0L) return;
            this.root_msg_send_time += XPLAINUtil.recordTiming(beginTime);
            msgsSent.add(this);
            return;
        }
        this.userCollector.endResults();
        throw new EmptyRegionFunctionException(LocalizedStrings.PartitionedRegion_FUNCTION_NOT_EXECUTED_AS_REGION_IS_EMPTY.toLocalizedString());
    }

    @Override
    protected final GemFireCacheImpl getGemFireCache() {
        return this.region.getGemFireCache();
    }

    @Override
    protected abstract RegionSingleKeyExecutorMessage clone();

    @Override
    public boolean useTransactionProxy() {
        return this.allCopies ? false : this.canStartRemoteTransaction();
    }

    public boolean containsRegionContentChange() {
        return this.isTransactional() && this.processorId != 0 && this.canStartRemoteTransaction();
    }

    @Override
    protected boolean requiresTXFlushAfterExecution() {
        return this.allCopies ? false : this.canStartRemoteTransaction();
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return this.getLockingPolicy().readCanStartTX();
    }

    public final DistributedMember getTarget() {
        return this.target;
    }

    @Override
    protected final void processMessage(DistributionManager dm) throws GemFireCheckedException {
        if (this.region == null) {
            if (this.prId >= 0) {
                this.pr = PartitionedRegion.getPRFromId((int)this.prId);
                this.region = this.pr;
                if (this.pr == null) {
                    throw new ForceReattemptException(LocalizedStrings.PartitionMessage_0_COULD_NOT_FIND_PARTITIONED_REGION_WITH_ID_1.toLocalizedString(new Object[]{Misc.getGemFireCache().getMyId(), this.prId}));
                }
            } else {
                this.region = Misc.getGemFireCache().getRegionByPathForProcessing(this.regionPath);
                if (this.region == null) {
                    throw new ForceReattemptException(LocalizedStrings.Region_CLOSED_OR_DESTROYED.toLocalizedString(new Object[]{this.regionPath}));
                }
                this.dr = (DistributedRegion)this.region;
            }
        }
        if (this.key instanceof KeyWithRegionContext) {
            ((KeyWithRegionContext)this.key).setRegionContext(this.region);
        }
        if (this.pr != null) {
            if (this.bucketId < 0) {
                this.bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)this.pr, (Operation)Operation.GET, (Object)this.key, null, (Object)this.callbackArg);
            }
            if (this.pbr == null) {
                this.pbr = this.pr.getRegionAdvisor().getProxyBucketArray()[this.bucketId];
            }
        }
        super.processMessage(dm);
    }

    @Override
    public final void checkAllBucketsHosted() throws BucketMovedException {
        if (this.pr != null) {
            BucketAdvisor bucAdvisor = this.pr.getRegionAdvisor().getBucketAdvisor(this.bucketId);
            if (this.optimizeForWrite()) {
                if (!bucAdvisor.isPrimary()) {
                    this.pr.checkReadiness();
                    InternalDistributedMember primaryHolder = bucAdvisor.basicGetPrimaryMember();
                    throw new PrimaryBucketException("Bucket " + this.pr.getBucketName(this.bucketId) + " is not primary. Current primary holder is " + primaryHolder);
                }
            } else if (!bucAdvisor.isHosting()) {
                throw new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString(), this.bucketId, this.pr.getFullPath());
            }
        }
    }

    @Override
    public final boolean isSecondaryCopy() {
        return this.isSecondaryCopy;
    }

    public DirectReplyProcessor getDirectReplyProcessor() {
        return this.processor;
    }

    public boolean supportsDirectAck() {
        return true;
    }

    public void registerProcessor() {
        this.processorId = this.processor.register();
    }

    @Override
    protected short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.prId >= 0) {
            flags = (short)(flags | 0x40);
            if (this.bucketId != -1) {
                flags = (short)(flags | 0x80);
            }
        }
        if (this.callbackArg != null) {
            flags = (short)(flags | 0x400);
        }
        if (this.isSecondaryCopy) {
            flags = (short)(flags | 0x100);
        }
        if (this.allCopies) {
            flags = (short)(flags | 0x200);
        }
        return flags;
    }

    public void toData(DataOutput out) throws IOException {
        long begintime;
        super.toData(out);
        long l = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : (begintime = 0L);
        if (this.prId >= 0) {
            InternalDataSerializer.writeUnsignedVL((long)this.prId, (DataOutput)out);
            if (this.bucketId != -1) {
                InternalDataSerializer.writeUnsignedVL((long)this.bucketId, (DataOutput)out);
            }
        } else {
            DataSerializer.writeString((String)this.regionPath, (DataOutput)out);
        }
        DataSerializer.writeObject((Object)this.key, (DataOutput)out);
        if (this.callbackArg != null) {
            DataSerializer.writeObject((Object)this.callbackArg, (DataOutput)out);
        }
        if (begintime != 0L) {
            this.ser_deser_time = XPLAINUtil.recordTiming(begintime);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.ser_deser_time = this.timeStatsEnabled ? (long)(this.ser_deser_time == 0L ? -1 : -2) : 0L;
        this.bucketId = -1;
        if ((this.flags & 0x40) != 0) {
            this.prId = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
            if ((this.flags & 0x80) != 0) {
                this.bucketId = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
            }
        } else {
            this.regionPath = DataSerializer.readString((DataInput)in);
        }
        this.key = DataSerializer.readObject((DataInput)in);
        if ((this.flags & 0x400) != 0) {
            this.callbackArg = DataSerializer.readObject((DataInput)in);
        }
        this.isSecondaryCopy = (this.flags & 0x100) != 0;
        boolean bl = this.allCopies = (this.flags & 0x200) != 0;
        if (this.timeStatsEnabled && this.ser_deser_time == -1L) {
            this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
        }
    }

    protected String getID() {
        return this.getShortClassName();
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(";region=").append(this.regionPath);
        if (this.pr != null) {
            sb.append(";prId=").append(this.prId);
            sb.append(";bucketId=").append(this.bucketId);
        }
        sb.append(";key=");
        ArrayUtils.objectString((Object)this.key, (StringBuilder)sb);
        if (this.callbackArg != null) {
            sb.append(";callbackArg=");
            ArrayUtils.objectString((Object)this.callbackArg, (StringBuilder)sb);
        }
        sb.append(";isSecondaryCopy=").append(this.isSecondaryCopy);
        if (this.routingObject != null) {
            sb.append(";routingObject=").append(this.routingObject);
        }
    }
}

