/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.distributed.DVDIOUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.StatementQueryExecutor;
import com.pivotal.gemfirexd.internal.engine.distributed.message.BitSetSet;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.NcjHashMapWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;

public final class PrepStatementExecutorMessage<T>
extends StatementExecutorMessage<T> {
    private final String origSource;
    private transient byte[] pvsData;
    private transient GfxdConnectionWrapper wrapper;
    private transient EmbedPreparedStatement pstmt;

    public PrepStatementExecutorMessage() {
        this.origSource = null;
    }

    public PrepStatementExecutorMessage(ResultCollector<Object, T> collector, String userName, long connectionId, long statementId, int executionId, long rootID, int statementLevel, String source, boolean isSelect, boolean optimizeForWrite, boolean withSecondaries, boolean isSpecialCaseOuterJoin, boolean needGfxdSubActivation, boolean flattenSubquery, boolean needKeysForSelectForUpdate, ParameterValueSet pvs, LocalRegion region, Set<Object> routingObjects, boolean insertAsSubselect, LanguageConnectionContext lcc, long timeOutMillis) {
        super(collector, userName, connectionId, statementId, executionId, rootID, statementLevel, source, isSelect, optimizeForWrite, withSecondaries, isSpecialCaseOuterJoin, needGfxdSubActivation, flattenSubquery, needKeysForSelectForUpdate, pvs, region, routingObjects, insertAsSubselect, lcc, timeOutMillis);
        this.origSource = source;
    }

    private PrepStatementExecutorMessage(PrepStatementExecutorMessage<T> other) {
        super(other);
        this.origSource = other.origSource;
    }

    @Override
    protected void execute() throws Exception {
        String argsStr = null;
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            StringBuilder sb = new StringBuilder();
            this.appendFields(sb);
            argsStr = sb.toString();
        }
        this.wrapperForMarkUnused = null;
        StatementQueryExecutor.executePrepStatement(this.defaultSchema, this.connectionId, this.statementId, this.source, this.getActivationFlags(), this.statsEnabled(), this.timeStatsEnabled(), (FunctionContext)this, argsStr, this.getTXState(), this);
    }

    public GfxdConnectionWrapper getAndClearWrapper(String userName, long connId) throws Exception {
        if (this.pvsData != null) {
            ByteArrayDataInput dis = new ByteArrayDataInput();
            dis.initialize(this.pvsData, null);
            this.readStatementPVS(dis);
        }
        if (this.pstmt == null) {
            this.pstmt = this.getStatement();
            ParameterValueSet pvs = this.pvs;
            if (pvs != null && pvs.getParameterCount() > 0) {
                pvs.transferDataValues(this.pstmt.getParms());
            }
        }
        GfxdConnectionWrapper wrapper = this.wrapper;
        this.wrapper = null;
        return wrapper;
    }

    public EmbedPreparedStatement getAndClearPreparedStatement() {
        EmbedPreparedStatement eps = this.pstmt;
        this.pstmt = null;
        return eps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setArgsForMember(DistributedMember member, Set<DistributedMember> messageAwareMembers) {
        Set<DistributedMember> set;
        if (messageAwareMembers != null) {
            set = messageAwareMembers;
            synchronized (set) {
                if (messageAwareMembers.contains(member)) {
                    if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("PrepStatementExecutorMessage: setting query string to null for member " + member + "; aware members: " + messageAwareMembers));
                    }
                    this.source = null;
                    return;
                }
            }
        }
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ && messageAwareMembers != null) {
            set = messageAwareMembers;
            synchronized (set) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("PrepStatementExecutorMessage: setting query string to value '" + this.origSource + "' for member " + member + "; aware members: " + messageAwareMembers));
            }
        }
        this.source = this.origSource;
    }

    @Override
    protected final PrepStatementExecutorMessage<T> clone() {
        return new PrepStatementExecutorMessage<T>(this);
    }

    @Override
    public byte getGfxdID() {
        return 29;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        long begintime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : 0L;
        super.toData(out);
        int paramCount = this.pvs != null ? this.pvs.getParameterCount() : 0;
        int numEightColGroups = BitSetSet.udiv8(paramCount);
        int numPartialCols = BitSetSet.umod8(paramCount);
        try {
            if (this.source != null) {
                if (paramCount > 0) {
                    HeapDataOutputStream hdos = new HeapDataOutputStream();
                    DVDIOUtil.writeParameterValueSet(this.pvs, numEightColGroups, numPartialCols, (DataOutput)hdos);
                    InternalDataSerializer.writeArrayLength((int)hdos.size(), (DataOutput)out);
                    hdos.sendTo(out);
                } else {
                    InternalDataSerializer.writeArrayLength((int)-1, (DataOutput)out);
                }
            } else if (numEightColGroups > 0 || numPartialCols > 0) {
                HeapDataOutputStream hdos = new HeapDataOutputStream();
                DVDIOUtil.writeParameterValueSet(this.pvs, numEightColGroups, numPartialCols, (DataOutput)hdos);
                InternalDataSerializer.writeArrayLength((int)hdos.size(), (DataOutput)out);
                hdos.sendTo(out);
            } else {
                InternalDataSerializer.writeArrayLength((int)-1, (DataOutput)out);
            }
        }
        catch (StandardException ex) {
            throw GemFireXDRuntimeException.newRuntimeException("unexpected exception in writing parameters", ex);
        }
        finally {
            if (begintime != 0L) {
                this.ser_deser_time = XPLAINUtil.recordTiming(begintime);
            }
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.ser_deser_time = this.timeStatsEnabled ? (long)(this.ser_deser_time == 0L ? -1 : -2) : 0L;
        super.fromData(in);
        try {
            this.pvsData = DataSerializer.readByteArray((DataInput)in);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (this.timeStatsEnabled && this.ser_deser_time == -1L) {
                this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
            }
        }
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(";pvs=").append(this.pvs).append(";pvsData=").append(Arrays.toString(this.pvsData)).append(";origSource=").append(this.origSource);
    }

    @Override
    public void reset() {
        super.reset();
        this.pvsData = null;
        this.wrapper = null;
        EmbedPreparedStatement eps = this.pstmt;
        if (eps != null) {
            try {
                if (!eps.isClosed()) {
                    eps.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.pstmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmbedPreparedStatement getStatement() throws SQLException {
        Properties props = new Properties();
        props.setProperty("query-HDFS", Boolean.toString(this.getQueryHDFS()));
        this.wrapper = GfxdConnectionHolder.getOrCreateWrapper(this.defaultSchema, this.connectionId, false, props);
        EmbedConnection conn = this.wrapper.getConnectionForSynchronization();
        Object object = conn.getConnectionSynchronization();
        synchronized (object) {
            conn.setDefaultSchema(this.defaultSchema);
            this.wrapper.convertToHardReference(conn);
            conn.getLanguageConnection().setStatsEnabled(this.statsEnabled(), this.timeStatsEnabled(), this.explainConnectionEnabled());
            conn.getLanguageConnection().setQueryHDFS(this.getQueryHDFS());
            if (this.getNCJMetaDataOnRemote() != null) {
                conn.getLanguageConnection().setNcjBatchSize(NcjHashMapWrapper.getBatchSize(this.getNCJMetaDataOnRemote()));
                conn.getLanguageConnection().setNcjCacheSize(NcjHashMapWrapper.getCacheSize(this.getNCJMetaDataOnRemote()));
            }
            this.wrapperForMarkUnused = this.wrapper;
            return (EmbedPreparedStatement)this.wrapper.getStatement(this.source, this.statementId, true, this.needGfxdSubActivation(), this.allowSubqueryFlattening(), this.allTablesAreReplicatedOnRemote(), this.getNCJMetaDataOnRemote(), false, this.rootId, this.statementLevel);
        }
    }

    private void readStatementPVS(ByteArrayDataInput in) throws IOException, SQLException, ClassNotFoundException, StandardException {
        this.pstmt = this.getStatement();
        this.pvs = this.pstmt.getParms();
        int paramCount = this.pvs.getParameterCount();
        int numEightColGroups = BitSetSet.udiv8(paramCount);
        int numPartialCols = BitSetSet.umod8(paramCount);
        DVDIOUtil.readParameterValueSet(this.pvs, in, numEightColGroups, numPartialCols);
    }
}

