/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdConfigMessage;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class QueryStatisticsVTI
extends GfxdVTITemplate {
    private Iterator<HashMap<String, Object>> memberResults;
    private HashMap<String, Object> currentStats;
    public static final String QUERYSTRING = "QUERY";
    public static final String MEMBERID = "MEMBERID";
    public static final String PARAMSSIZE = "PARAMSSIZE";
    public static final String QUERYPLAN = "PLAN";
    public static final String NUMINVOCATIONS = "NUMINVOCATIONS";
    public static final String TOTALNANOS = "TOTALTIME";
    public static final String DISTRIBNANOS = "DISTRIBUTIONTIME";
    public static final String SERNANOS = "SERIALIZATIONTIME";
    public static final String EXECNANOS = "EXECUTIONTIME";
    public static final String ORMNANOS = "ORMTIME";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("QUERY", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("MEMBERID", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("PARAMSSIZE", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("PLAN", 12, false, 2048), EmbedResultSetMetaData.getResultColumnDescriptor("NUMINVOCATIONS", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("TOTALTIME", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("DISTRIBUTIONTIME", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("SERIALIZATIONTIME", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("EXECUTIONTIME", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("ORMTIME", -5, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public boolean next() throws SQLException {
        if (this.memberResults == null) {
            try {
                MemberSingleResultCollector rc = new MemberSingleResultCollector();
                InternalDistributedMember myId = Misc.getDistributedSystem().getDistributionManager().getDistributionManagerId();
                GfxdConfigMessage<TreeMap<String, HashMap<String, Object>>> msg = new GfxdConfigMessage<TreeMap<String, HashMap<String, Object>>>(rc, Collections.singleton(myId), GfxdConfigMessage.Operation.GET_QUERYSTATS, null, false);
                this.memberResults = ((TreeMap)msg.executeFunction()).values().iterator();
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw Util.javaException(t);
            }
        }
        if (this.memberResults.hasNext()) {
            this.currentStats = this.memberResults.next();
            this.wasNull = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean getBoolean(int columnNumber) {
        String columnName;
        Object stats;
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        if (desc.getType().getJDBCTypeId() != 16) {
            this.dataTypeConversion("boolean", desc);
        }
        if ((stats = this.currentStats.get(columnName = desc.getName())) != null) {
            this.wasNull = false;
            return (Boolean)stats;
        }
        throw new GemFireXDRuntimeException("unexpected columnName " + columnName + " for query: " + this.currentStats.get(QUERYSTRING));
    }

    @Override
    public int getInt(int columnNumber) {
        String columnName;
        Object stats;
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        if (desc.getType().getJDBCTypeId() != 4) {
            this.dataTypeConversion("integer", desc);
        }
        if ((stats = this.currentStats.get(columnName = desc.getName())) != null) {
            this.wasNull = false;
            return (Integer)stats;
        }
        throw new GemFireXDRuntimeException("unexpected columnName " + columnName + " for query: " + this.currentStats.get(QUERYSTRING));
    }

    @Override
    public long getLong(int columnNumber) {
        String columnName;
        Object stats;
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        if (desc.getType().getJDBCTypeId() != -5) {
            this.dataTypeConversion("long", desc);
        }
        if ((stats = this.currentStats.get(columnName = desc.getName())) != null) {
            this.wasNull = false;
            return (Long)stats;
        }
        throw new GemFireXDRuntimeException("unexpected columnName " + columnName + " for query: " + this.currentStats.get(QUERYSTRING));
    }

    @Override
    public Object getObjectForColumn(int columnNumber) {
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        String columnName = desc.getName();
        return this.currentStats.get(columnName);
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.currentStats = null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    private class MemberSingleResultCollector
    extends TreeMap<String, HashMap<String, Object>>
    implements ResultCollector<Object, TreeMap<String, HashMap<String, Object>>> {
        private static final long serialVersionUID = 1996707111592217057L;

        private MemberSingleResultCollector() {
        }

        public void addResult(DistributedMember memberId, Object resultOfSingleExecution) {
            ArrayList result = (ArrayList)resultOfSingleExecution;
            if (result != null) {
                for (HashMap statsMap : result) {
                    statsMap.put(QueryStatisticsVTI.MEMBERID, memberId.getId());
                    this.put((String)statsMap.get(QueryStatisticsVTI.QUERYSTRING) + ':' + memberId.getId(), statsMap);
                }
            }
        }

        public TreeMap<String, HashMap<String, Object>> getResult() throws FunctionException {
            return this;
        }

        public TreeMap<String, HashMap<String, Object>> getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
            throw new AssertionError((Object)"getResult with timeout not expected to be invoked for GemFireXD");
        }

        public void clearResults() {
            this.clear();
        }

        public void endResults() {
        }
    }
}

