/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.callbacks;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.callbacks.DBSynchronizer;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.EventErrorLogger;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Formatter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncEventHelper {
    public static final String LOGGER_NAME = "snappystore";
    public static final String INTEGRITY_VIOLATION_PREFIX = "23";
    public static final String CONNECTIVITY_PREFIX = "08";
    public static final String LSE_COMPILATION_PREFIX = "42";
    static final int MAX_MEM_BLOB_SIZE = 0x8000000;
    static final int MAX_MEM_CLOB_SIZE = 0x4000000;
    private final ConcurrentHashMap<Event, long[]> failureLogInterval = new ConcurrentHashMap(16, 0.75f, 2);
    protected static final int FAILURE_MAP_MAXSIZE = Integer.getInteger("gemfirexd.asyncevent.FAILURE_MAP_MAXSIZE", 1000000);
    protected static final int FAILURE_LOG_MAX_INTERVAL = Integer.getInteger("gemfirexd.asyncevent.FAILURE_LOG_MAX_INTERVAL", 300000);
    public static final boolean POSTGRESQL_SYNTAX = Boolean.getBoolean("gemfirexd.asyncevent.POSTGRESQL_SYNTAX");
    public static final String EVENT_ERROR_LOG_FILE = "dbsync_failed_dmls.xml";
    public static final String EVENT_ERROR_LOG_ENTRIES_FILE = "dbsync_failed_dmls_entries.xml";
    private EventErrorLogger evErrorLogger;

    public static AsyncEventHelper newInstance() {
        return new AsyncEventHelper();
    }

    public final void getStackTrace(Throwable t, StringBuilder sb) {
        ClientSharedUtils.getStackTrace((Throwable)t, (StringBuilder)sb, null);
    }

    public final boolean logFineEnabled() {
        return SanityManager.isFineEnabled;
    }

    public final boolean traceExecute() {
        return GemFireXDUtils.TraceExecute;
    }

    public final boolean traceDBSynchronizer() {
        return GemFireXDUtils.TraceDBSynchronizer;
    }

    public final boolean traceDBSynchronizerHA() {
        return GemFireXDUtils.TraceDBSynchronizerHA;
    }

    public final void log(Logger logger, Level level, Throwable t, String message) {
        if (t != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(message).append(": ");
            this.getStackTrace(t, sb);
            logger.log(level, sb.toString());
        } else {
            logger.log(level, message);
        }
    }

    public final void logFormat(Logger logger, Level level, Throwable t, String format, Object ... params) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format(format, params);
        if (t != null) {
            sb.append(": ");
            this.getStackTrace(t, sb);
        }
        logger.log(level, sb.toString());
        fmt.close();
    }

    public static final String getInsertString(String tableName, TableMetaData tableMetaData, boolean hasAutoIncrementColumns) throws SQLException {
        int pos;
        StringBuilder sbuff = new StringBuilder().append("insert into ");
        if (POSTGRESQL_SYNTAX) {
            String unQuotedTableName = tableName.replace("\"", "");
            sbuff.append(unQuotedTableName);
        } else {
            sbuff.append(tableName);
        }
        int numColumns = tableMetaData.getColumnCount();
        sbuff.append('(');
        for (pos = 1; pos <= numColumns; ++pos) {
            if (hasAutoIncrementColumns && tableMetaData.isAutoIncrement(pos)) continue;
            sbuff.append(tableMetaData.getColumnName(pos)).append(',');
        }
        sbuff.setCharAt(sbuff.length() - 1, ')');
        sbuff.append(" values (");
        for (pos = 1; pos <= numColumns; ++pos) {
            if (hasAutoIncrementColumns && tableMetaData.isAutoIncrement(pos)) continue;
            sbuff.append("?,");
        }
        sbuff.setCharAt(sbuff.length() - 1, ')');
        return sbuff.toString();
    }

    public static final String getDeleteString(String tableName, ResultSetMetaData pkMetaData) throws SQLException {
        StringBuilder sbuff = new StringBuilder().append("delete from ");
        if (POSTGRESQL_SYNTAX) {
            String unQuotedTableName = tableName.replace("\"", "");
            sbuff.append(unQuotedTableName);
        } else {
            sbuff.append(tableName);
        }
        sbuff.append(" where ");
        int numCols = pkMetaData.getColumnCount();
        for (int col = 1; col < numCols; ++col) {
            sbuff.append(pkMetaData.getColumnName(col));
            sbuff.append("=? and ");
        }
        sbuff.append(pkMetaData.getColumnName(numCols));
        sbuff.append("=?");
        return sbuff.toString();
    }

    public static final String getUpdateString(String tableName, ResultSetMetaData pkMetaData, ResultSetMetaData updateMetaData) throws SQLException {
        int col;
        StringBuilder sbuff = new StringBuilder().append("update ");
        if (POSTGRESQL_SYNTAX) {
            String unQuotedTableName = tableName.replace("\"", "");
            sbuff.append(unQuotedTableName);
        } else {
            sbuff.append(tableName);
        }
        sbuff.append(" set ");
        int numPkCols = pkMetaData.getColumnCount();
        for (col = 1; col <= updateMetaData.getColumnCount(); ++col) {
            sbuff.append(updateMetaData.getColumnName(col));
            sbuff.append("=?,");
        }
        sbuff.setCharAt(sbuff.length() - 1, ' ');
        sbuff.append("where ");
        for (col = 1; col < numPkCols; ++col) {
            sbuff.append(pkMetaData.getColumnName(col));
            sbuff.append("=? and ");
        }
        sbuff.append(pkMetaData.getColumnName(numPkCols));
        sbuff.append("=?");
        return sbuff.toString();
    }

    public final boolean setParamsInBulkPreparedStatement(Event event, Event.Type evType, PreparedStatement ps, PreparedStatement prevPS, DBSynchronizer sync) throws SQLException {
        ResultSetMetaData rsmd;
        int columnCount;
        ResultSet params;
        if (evType.isBulkInsert()) {
            boolean skipAutoGenCols;
            TableMetaData rsmd2 = event.getResultSetMetaData();
            int numColumns = rsmd2.getColumnCount();
            ResultSet rows = event.getNewRowsAsResultSet();
            boolean bl = skipAutoGenCols = event.tableHasAutogeneratedColumns() && (sync == null || sync.skipIdentityColumns());
            while (rows.next()) {
                int paramIndex = 1;
                for (int rowPos = 1; rowPos <= numColumns; ++rowPos) {
                    if (skipAutoGenCols && rsmd2.isAutoIncrement(rowPos)) continue;
                    this.setColumnInPrepStatement(rsmd2.getColumnType(rowPos), ps, rows, rowPos, paramIndex, sync);
                    ++paramIndex;
                }
                ps.addBatch();
            }
            return true;
        }
        if (prevPS == ps) {
            ps.addBatch();
        }
        if ((params = event.getNewRowsAsResultSet()) != null && (columnCount = (rsmd = params.getMetaData()).getColumnCount()) > 0) {
            for (int paramIndex = 1; paramIndex <= columnCount; ++paramIndex) {
                this.setColumnInPrepStatement(rsmd.getColumnType(paramIndex), ps, params, paramIndex, paramIndex, sync);
            }
        }
        return false;
    }

    public final void setColumnInPrepStatement(int javaSqlType, PreparedStatement ps, ResultSet row, int rowPosition, int paramIndex, DBSynchronizer sync) throws SQLException {
        if (this.traceDBSynchronizer()) {
            Logger logger = sync != null ? sync.logger : Logger.getLogger(LOGGER_NAME);
            logger.info("AsyncEventHelper::setColumnInPrepStatement: setting column type=" + javaSqlType + " index=" + paramIndex + " value=" + row.getObject(rowPosition) + ", for " + ps);
        }
        switch (javaSqlType) {
            case -15: 
            case -9: 
            case -8: 
            case 0: 
            case 70: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2011: {
                throw new UnsupportedOperationException("java.sql.Type = " + javaSqlType + " not supported");
            }
            case -5: {
                long longVal = row.getLong(rowPosition);
                if (!row.wasNull()) {
                    ps.setLong(paramIndex, longVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case -7: 
            case 16: {
                boolean boolVal = row.getBoolean(rowPosition);
                if (!row.wasNull()) {
                    ps.setBoolean(paramIndex, boolVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case 2004: {
                Blob blob = row.getBlob(rowPosition);
                if (blob != null) {
                    if (sync == null) {
                        ps.setBlob(paramIndex, blob);
                        break;
                    }
                    long blen = blob.length();
                    if (blen > 0x8000000L) {
                        byte isJDBC4Driver = sync.isJDBC4Driver();
                        if (isJDBC4Driver == 1) {
                            ps.setBinaryStream(paramIndex, blob.getBinaryStream());
                            break;
                        }
                        if (isJDBC4Driver == -1) {
                            try {
                                ps.setBinaryStream(paramIndex, blob.getBinaryStream(), blen);
                                sync.setJDBC4Driver((byte)1);
                                break;
                            }
                            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                            }
                            catch (AbstractMethodError abstractMethodError) {
                                // empty catch block
                            }
                            sync.setJDBC4Driver((byte)0);
                        }
                    }
                    byte[] bytes = blob.getBytes(1L, (int)blen);
                    ps.setBytes(paramIndex, bytes);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case 2005: {
                Object clobVal = row.getObject(rowPosition);
                if (clobVal != null) {
                    if (clobVal instanceof String) {
                        ps.setString(paramIndex, (String)clobVal);
                        break;
                    }
                    Clob clob = (Clob)clobVal;
                    if (sync == null) {
                        ps.setClob(paramIndex, clob);
                        break;
                    }
                    long len = clob.length();
                    if (len > 0x4000000L) {
                        byte isJDBC4Driver = sync.isJDBC4Driver();
                        if (isJDBC4Driver == 1) {
                            ps.setCharacterStream(paramIndex, clob.getCharacterStream());
                            break;
                        }
                        if (isJDBC4Driver == -1) {
                            try {
                                ps.setCharacterStream(paramIndex, clob.getCharacterStream(), len);
                                sync.setJDBC4Driver((byte)1);
                                break;
                            }
                            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                            }
                            catch (AbstractMethodError abstractMethodError) {
                                // empty catch block
                            }
                            sync.setJDBC4Driver((byte)0);
                        }
                    }
                    String str = clob.getSubString(1L, (int)len);
                    ps.setString(paramIndex, str);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case 91: {
                Date dateVal = row.getDate(rowPosition);
                if (dateVal != null) {
                    ps.setDate(paramIndex, dateVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal decimalVal = row.getBigDecimal(rowPosition);
                if (decimalVal != null) {
                    ps.setBigDecimal(paramIndex, decimalVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case 8: {
                double doubleVal = row.getDouble(rowPosition);
                if (!row.wasNull()) {
                    ps.setDouble(paramIndex, doubleVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case 6: 
            case 7: {
                float floatVal = row.getFloat(rowPosition);
                if (!row.wasNull()) {
                    ps.setFloat(paramIndex, floatVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int intVal = row.getInt(rowPosition);
                if (!row.wasNull()) {
                    ps.setInt(paramIndex, intVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case -16: 
            case -1: 
            case 1: 
            case 12: 
            case 2009: {
                String strVal = row.getString(rowPosition);
                if (strVal != null) {
                    ps.setString(paramIndex, strVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case 4001: {
                String strVal2 = row.getString(rowPosition);
                ps.setString(paramIndex, strVal2);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] bytesVal = row.getBytes(rowPosition);
                if (bytesVal != null) {
                    ps.setBytes(paramIndex, bytesVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case 92: {
                Time timeVal = row.getTime(rowPosition);
                if (timeVal != null) {
                    ps.setTime(paramIndex, timeVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case 93: {
                Timestamp timestampVal = row.getTimestamp(rowPosition);
                if (timestampVal != null) {
                    ps.setTimestamp(paramIndex, timestampVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            case 2000: {
                Object objVal = row.getObject(rowPosition);
                if (objVal != null) {
                    ps.setObject(paramIndex, objVal);
                    break;
                }
                ps.setNull(paramIndex, javaSqlType);
                break;
            }
            default: {
                throw new UnsupportedOperationException("java.sql.Type = " + javaSqlType + " not supported");
            }
        }
    }

    public final boolean skipFailureLogging(Event event) {
        boolean skipLogging = false;
        if (this.failureLogInterval.size() < FAILURE_MAP_MAXSIZE) {
            long[] logInterval = this.failureLogInterval.get(event);
            if (logInterval == null) {
                logInterval = this.failureLogInterval.putIfAbsent(event, new long[]{System.currentTimeMillis(), 1000L});
            }
            if (logInterval != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - logInterval[0] < logInterval[1]) {
                    skipLogging = true;
                } else {
                    logInterval[0] = currentTime;
                    if (logInterval[1] <= (long)(FAILURE_LOG_MAX_INTERVAL / 4)) {
                        logInterval[1] = logInterval[1] * 4L;
                    }
                }
            }
        }
        return skipLogging;
    }

    public final boolean removeEventFromFailureMap(Event event) {
        return this.failureLogInterval.remove(event) != null;
    }

    public final boolean hasFailures() {
        return this.failureLogInterval.size() > 0;
    }

    public static final String encryptPassword(String user, String password, String transformation, int keySize) throws Exception {
        return GemFireXDUtils.encrypt(password, transformation, GemFireXDUtils.getUserPasswordCipherKeyBytes(user, transformation, keySize));
    }

    public static final String decryptPassword(String user, String encPassword, String transformation, int keySize) throws Exception {
        return GemFireXDUtils.decrypt(encPassword, transformation, GemFireXDUtils.getUserPasswordCipherKeyBytes(user, transformation, keySize));
    }

    public void close() {
        this.failureLogInterval.clear();
    }

    public RuntimeException newRuntimeException(String message, Throwable t) {
        return GemFireXDRuntimeException.newRuntimeException(message, t);
    }

    public void createEventErrorLogger(String errorFileName) {
        if (errorFileName == null) {
            errorFileName = EVENT_ERROR_LOG_FILE;
        }
        this.evErrorLogger = new EventErrorLogger(errorFileName);
    }

    public void logEventError(Event ev, Exception e) throws Exception {
        if (this.evErrorLogger == null) {
            throw new Exception("Event Error Logger not created");
        }
        this.evErrorLogger.logError(ev, e);
    }
}

