/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.jdbc;

import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ResourceAdapter;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.jdbc.EmbedPooledConnection;
import com.pivotal.gemfirexd.internal.jdbc.EmbedXAResource;
import com.pivotal.gemfirexd.internal.jdbc.EmbeddedDataSource;
import com.pivotal.gemfirexd.internal.jdbc.XAStatementControl;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

class EmbedXAConnection
extends EmbedPooledConnection
implements XAConnection {
    private EmbedXAResource xaRes;

    EmbedXAConnection(EmbeddedDataSource ds, ResourceAdapter ra, String u, String p, boolean requestPassword) throws SQLException {
        super(ds, u, p, requestPassword);
        this.xaRes = new EmbedXAResource(this, ra);
    }

    private boolean isGlobal() {
        return this.xaRes.getCurrentXid() != null;
    }

    @Override
    public final synchronized XAResource getXAResource() throws SQLException {
        this.checkActive();
        return this.xaRes;
    }

    @Override
    public void checkAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit && this.isGlobal()) {
            throw Util.generateCsSQLException("XJ056.S");
        }
        super.checkAutoCommit(autoCommit);
    }

    @Override
    public int checkHoldCursors(int holdability, boolean downgrade) throws SQLException {
        if (holdability == 1 && this.isGlobal()) {
            if (!downgrade) {
                throw Util.generateCsSQLException("XJ05C.S");
            }
            holdability = 2;
        }
        return super.checkHoldCursors(holdability, downgrade);
    }

    @Override
    public void checkSavepoint() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ058.S");
        }
        super.checkSavepoint();
    }

    @Override
    public void checkRollback() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ058.S");
        }
        super.checkRollback();
    }

    @Override
    public void checkCommit() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ057.S");
        }
        super.checkCommit();
    }

    @Override
    public void checkClose() throws SQLException {
        if (!this.isGlobal()) {
            super.checkClose();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection handle;
        if (!this.isGlobal()) {
            handle = super.getConnection();
        } else {
            if (this.currentConnectionHandle != null) {
                throw Util.generateCsSQLException("25001");
            }
            handle = this.getNewCurrentConnectionHandle();
        }
        this.currentConnectionHandle.syncState();
        handle.setTransactionIsolation(2);
        return handle;
    }

    @Override
    public Statement wrapStatement(Statement s) throws SQLException {
        XAStatementControl sc = new XAStatementControl(this, s);
        return sc.applicationStatement;
    }

    @Override
    public PreparedStatement wrapStatement(PreparedStatement ps, String sql, Object generatedKeys) throws SQLException {
        ps = super.wrapStatement(ps, sql, generatedKeys);
        XAStatementControl sc = new XAStatementControl(this, ps, sql, generatedKeys);
        return (PreparedStatement)((Object)sc.applicationStatement);
    }

    @Override
    public CallableStatement wrapStatement(CallableStatement cs, String sql) throws SQLException {
        cs = super.wrapStatement(cs, sql);
        XAStatementControl sc = new XAStatementControl(this, cs, sql);
        return (CallableStatement)((Object)sc.applicationStatement);
    }

    @Override
    public EngineConnection getRealConnection() throws SQLException {
        EngineConnection rc = super.getRealConnection();
        if (rc != null) {
            return rc;
        }
        this.openRealConnection();
        this.currentConnectionHandle.setState(true);
        return this.realConnection;
    }
}

