/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseContainerHandle;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.ContainerHandleActionOnCommit;
import java.util.Observable;

public class TruncateOnCommit
extends ContainerHandleActionOnCommit {
    private boolean commitAsWell;

    public TruncateOnCommit(ContainerKey identity, boolean commitAsWell) {
        super(identity);
        this.commitAsWell = commitAsWell;
        if (identity.getSegmentId() != -1L) {
            SanityManager.THROWASSERT((String)("segment id is not temp segment " + identity.getSegmentId()));
        }
    }

    @Override
    public void update(Observable obj, Object arg) {
        if (arg == null) {
            SanityManager.THROWASSERT((String)("still on observer list " + this));
        }
        if (arg.equals(RawTransaction.ABORT) || arg.equals(RawTransaction.SAVEPOINT_ROLLBACK) || this.commitAsWell && arg.equals(RawTransaction.COMMIT)) {
            this.openContainerAndDoIt((RawTransaction)obj);
        }
        if (arg.equals(RawTransaction.COMMIT) || arg.equals(RawTransaction.ABORT) || arg.equals(this.identity)) {
            obj.deleteObserver(this);
        }
    }

    @Override
    protected void doIt(BaseContainerHandle handle) throws StandardException {
        handle.container.truncate(handle);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TruncateOnCommit) {
            if (((TruncateOnCommit)other).commitAsWell != this.commitAsWell) {
                return false;
            }
            return super.equals(other);
        }
        return false;
    }
}

