/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.RawContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseDataFileFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.EncryptContainerOperation;
import com.pivotal.gemfirexd.internal.io.StorageFactory;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class EncryptData
implements PrivilegedAction {
    private BaseDataFileFactory dataFactory;
    private StorageFactory storageFactory;
    private StorageFile[] oldFiles;
    private int noOldFiles = 0;
    private static final int STORAGE_FILE_EXISTS_ACTION = 1;
    private static final int STORAGE_FILE_DELETE_ACTION = 2;
    private static final int STORAGE_FILE_RENAME_ACTION = 3;
    private int actionCode;
    private StorageFile actionStorageFile;
    private StorageFile actionDestStorageFile;

    public EncryptData(BaseDataFileFactory dataFactory) {
        this.dataFactory = dataFactory;
        this.storageFactory = dataFactory.getStorageFactory();
    }

    public void encryptAllContainers(RawTransaction t) throws StandardException {
        String[] files = this.dataFactory.getContainerNames();
        if (files != null) {
            this.oldFiles = new StorageFile[files.length];
            this.noOldFiles = 0;
            long segmentId = 0L;
            for (int f = files.length - 1; f >= 0; --f) {
                long containerId;
                try {
                    containerId = Long.parseLong(files[f].substring(1, files[f].length() - 4), 16);
                }
                catch (Throwable th) {
                    continue;
                }
                ContainerKey ckey = new ContainerKey(segmentId, containerId);
                this.oldFiles[this.noOldFiles++] = this.encryptContainer(t, ckey);
            }
        } else {
            SanityManager.THROWASSERT((String)"encryption process is unable toread container names in seg0");
        }
    }

    private StorageFile encryptContainer(RawTransaction t, ContainerKey ckey) throws StandardException {
        StorageFile oldFile;
        StorageFile currentFile;
        LockingPolicy cl = t.newLockingPolicy(2, 5, true);
        SanityManager.ASSERT((cl != null ? 1 : 0) != 0);
        RawContainerHandle containerHdl = (RawContainerHandle)t.openContainer(ckey, cl, 4);
        SanityManager.ASSERT((containerHdl != null ? 1 : 0) != 0);
        EncryptContainerOperation lop = new EncryptContainerOperation(containerHdl);
        t.logAndDo(lop);
        this.dataFactory.flush(t.getLastLogInstant());
        String newFilePath = this.getFilePath(ckey, false);
        StorageFile newFile = this.storageFactory.newStorageFile(newFilePath);
        containerHdl.encryptContainer(newFilePath);
        containerHdl.close();
        if (!this.dataFactory.getPageCache().discard(ckey)) {
            SanityManager.THROWASSERT((String)("unable to discard pages releated to container " + ckey + " from the page cache"));
        }
        if (!this.dataFactory.getContainerCache().discard(ckey)) {
            SanityManager.THROWASSERT((String)("unable to discard a container " + ckey + " from the container cache"));
        }
        if (!this.privRename(currentFile = this.dataFactory.getContainerPath(ckey, false), oldFile = this.getFile(ckey, true))) {
            throw StandardException.newException("XSRS4.S", (Object)currentFile, (Object)oldFile);
        }
        if (!this.privRename(newFile, currentFile)) {
            throw StandardException.newException("XSRS4.S", (Object)newFile, (Object)currentFile);
        }
        return oldFile;
    }

    private StorageFile getFile(ContainerKey containerId, boolean old) {
        String path = this.getFilePath(containerId, old);
        return this.storageFactory.newStorageFile(this.getFilePath(containerId, old));
    }

    private String getFilePath(ContainerKey containerId, boolean old) {
        StringBuilder sb = new StringBuilder("seg");
        sb.append(containerId.getSegmentId());
        sb.append(this.storageFactory.getSeparator());
        sb.append(old ? (char)'o' : 'n');
        sb.append(Long.toHexString(containerId.getContainerId()));
        sb.append(".dat");
        return sb.toString();
    }

    private boolean isOldContainerFile(String fileName) {
        return fileName.startsWith("o") && fileName.endsWith(".dat");
    }

    private StorageFile getFile(String ctrFileName) {
        long segmentId = 0L;
        StringBuilder sb = new StringBuilder("seg");
        sb.append(segmentId);
        sb.append(this.storageFactory.getSeparator());
        sb.append(ctrFileName);
        return this.storageFactory.newStorageFile(sb.toString());
    }

    void restoreContainer(ContainerKey containerId) throws StandardException {
        if (!this.dataFactory.getContainerCache().discard(containerId)) {
            SanityManager.THROWASSERT((String)("unable to discard  container from cache:" + containerId));
        }
        StorageFile currentFile = this.dataFactory.getContainerPath(containerId, false);
        StorageFile oldFile = this.getFile(containerId, true);
        StorageFile newFile = this.getFile(containerId, false);
        if (this.privExists(oldFile)) {
            if (this.privExists(currentFile) && !this.privRename(currentFile, newFile)) {
                throw StandardException.newException("XSRS4.S", (Object)currentFile, (Object)newFile);
            }
            if (!this.privRename(oldFile, currentFile)) {
                throw StandardException.newException("XSRS4.S", (Object)oldFile, (Object)currentFile);
            }
        }
        if (this.privExists(newFile) && !this.privDelete(newFile)) {
            throw StandardException.newException("XBM0R.D", newFile);
        }
    }

    public void removeOldVersionOfContainers(boolean inRecovery) throws StandardException {
        block3: {
            block2: {
                if (!inRecovery) break block2;
                String[] files = this.dataFactory.getContainerNames();
                if (files == null) break block3;
                for (int i = files.length - 1; i >= 0; --i) {
                    StorageFile oldFile;
                    if (!this.isOldContainerFile(files[i]) || this.privDelete(oldFile = this.getFile(files[i]))) continue;
                    throw StandardException.newException("XSDF4.S", oldFile);
                }
                break block3;
            }
            for (int i = 0; i < this.noOldFiles; ++i) {
                if (this.privDelete(this.oldFiles[i])) continue;
                throw StandardException.newException("XSDF4.S", this.oldFiles[i]);
            }
        }
    }

    private synchronized boolean privExists(StorageFile file) {
        this.actionCode = 1;
        this.actionStorageFile = file;
        Object ret = AccessController.doPrivileged(this);
        this.actionStorageFile = null;
        return (Boolean)ret;
    }

    private synchronized boolean privDelete(StorageFile file) {
        this.actionCode = 2;
        this.actionStorageFile = file;
        Object ret = AccessController.doPrivileged(this);
        this.actionStorageFile = null;
        return (Boolean)ret;
    }

    private synchronized boolean privRename(StorageFile fromFile, StorageFile destFile) {
        this.actionCode = 3;
        this.actionStorageFile = fromFile;
        this.actionDestStorageFile = destFile;
        Object ret = AccessController.doPrivileged(this);
        this.actionStorageFile = null;
        this.actionDestStorageFile = null;
        return (Boolean)ret;
    }

    public Object run() {
        switch (this.actionCode) {
            case 1: {
                return ReuseFactory.getBoolean(this.actionStorageFile.exists());
            }
            case 2: {
                return ReuseFactory.getBoolean(this.actionStorageFile.delete());
            }
            case 3: {
                return ReuseFactory.getBoolean(this.actionStorageFile.renameTo(this.actionDestStorageFile));
            }
        }
        return null;
    }
}

