/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.sort;

import com.gemstone.gnu.trove.TLongArrayList;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortObserver;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.StreamContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.MergeSort;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.SortBuffer;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.SortScan;

public class MergeScan
extends SortScan {
    protected SortBuffer sortBuffer;
    protected TLongArrayList mergeRuns;
    protected StreamContainerHandle[] openScans;
    private final SortObserver sortObserver;

    MergeScan(MergeSort sort, TransactionManager tran, SortBuffer sortBuffer, TLongArrayList mergeRuns, SortObserver sortObserver, boolean hold) {
        super(sort, tran, hold);
        this.sortBuffer = sortBuffer;
        this.mergeRuns = mergeRuns;
        this.tran = tran;
        this.sortObserver = sortObserver;
    }

    @Override
    public boolean next() throws StandardException {
        this.current = this.sortBuffer.removeFirst();
        if (this.current != null) {
            this.mergeARow(this.sortBuffer.getLastAux());
        }
        return this.current != null;
    }

    @Override
    public void close() {
        if (this.openScans != null) {
            for (int i = 0; i < this.openScans.length; ++i) {
                if (this.openScans[i] != null) {
                    this.openScans[i].close();
                }
                this.openScans[i] = null;
            }
            this.openScans = null;
        }
        if (this.sort != null) {
            this.sort.doneScanning(this, this.sortBuffer, this.mergeRuns);
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        super.close();
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) {
        if (!this.hold || closeHeldScan) {
            this.close();
            return true;
        }
        return false;
    }

    public boolean init(TransactionManager tran) throws StandardException {
        SanityManager.ASSERT((this.mergeRuns != null ? 1 : 0) != 0);
        SanityManager.ASSERT((this.mergeRuns.size() > 0 ? 1 : 0) != 0);
        SanityManager.ASSERT((this.sortBuffer.capacity() >= this.mergeRuns.size() ? 1 : 0) != 0);
        this.sortBuffer.reset();
        this.openScans = new StreamContainerHandle[this.mergeRuns.size()];
        if (this.openScans == null) {
            return false;
        }
        int scanindex = 0;
        for (int i = 0; i < this.mergeRuns.size(); ++i) {
            ExecRow templateRow;
            long id = this.mergeRuns.getQuick(i);
            Transaction rawTran = tran.getRawStoreXact();
            int segmentId = -1;
            this.openScans[scanindex++] = rawTran.openStreamContainer(-1L, id, this.hold);
            if (scanindex != 1 || (templateRow = this.openScans[0].getTemplateRow()) == null) continue;
            this.sortObserver.setTemplateRow(templateRow);
        }
        for (scanindex = 0; scanindex < this.openScans.length; ++scanindex) {
            this.mergeARow(scanindex);
        }
        return true;
    }

    void mergeARow(int scanindex) throws StandardException {
        ExecRow row;
        SanityManager.ASSERT((this.openScans[scanindex] != null ? 1 : 0) != 0);
        do {
            if (!this.openScans[scanindex].fetchNext(row = this.sortObserver.getRowArray())) {
                this.openScans[scanindex].close();
                this.openScans[scanindex] = null;
                return;
            }
            this.sortBuffer.setNextAux(scanindex);
        } while (this.sortBuffer.insert(row) == 1);
    }
}

