/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.Storable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.NcjBackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashTableResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.Iterator;
import java.util.List;

public class NcjHashTableResultSet
extends HashTableResultSet {
    private Iterator hashIter;

    NcjHashTableResultSet(NoPutResultSet s, Activation a, GeneratedMethod str, Qualifier[][] nextQualifiers, GeneratedMethod p, int resultSetNumber, int mapRefItem, boolean reuseResult, int keyColItem, boolean removeDuplicates, long maxInMemoryRowCount, int initialCapacity, float loadFactor, boolean skipNullKeyColumns, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(s, a, str, nextQualifiers, p, resultSetNumber, mapRefItem, reuseResult, keyColItem, removeDuplicates, maxInMemoryRowCount, initialCapacity, loadFactor, skipNullKeyColumns, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    @Override
    protected BackingStoreHashtable getBackingStoreHashtable() throws StandardException {
        TransactionController tc = this.activation.getTransactionController();
        return new NcjBackingStoreHashtable(tc, (RowSource)this, this.keyColumns, this.removeDuplicates, (long)((int)this.optimizerEstimatedRowCount), this.maxInMemoryRowCount, this.initialCapacity, this.loadFactor, this.skipNullKeyColumns, false, this.getLanguageConnectionContext().getNcjBatchSize());
    }

    @Override
    public boolean moreRowsExpected() {
        if (this.ht != null) {
            return this.ht.moreRowsExpected();
        }
        return false;
    }

    @Override
    public boolean fillUpHashTable() throws StandardException {
        if (this.ht != null) {
            return this.ht.fillUpHashTable();
        }
        return false;
    }

    @Override
    public void purgeHashTable() {
        if (this.ht != null) {
            this.ht.purgeHashTable();
        }
    }

    @Override
    protected void resetProbeVariables() throws StandardException {
        super.resetProbeVariables();
        this.hashIter = null;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.nextQualifiers != null) {
            return super.getNextRowCore();
        }
        this.checkCancellationFlag();
        ExecRow result = null;
        DataValueDescriptor[] columns = null;
        Object rak = null;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            do {
                if (this.firstNext) {
                    this.firstNext = false;
                    this.hashIter = this.hashTableIterator();
                }
                SanityManager.ASSERT((this.hashIter != null ? 1 : 0) != 0, (String)"NcjHashTableResultSet is not open");
                if (this.numFetchedOnNext < this.entryVectorSize) {
                    columns = (DataValueDescriptor[])this.entryVector.get(this.numFetchedOnNext);
                } else if (this.hashIter.hasNext()) {
                    Object hashEntry = this.hashIter.next();
                    SanityManager.ASSERT((hashEntry != null ? 1 : 0) != 0, (String)"Null row from hash table");
                    if (hashEntry instanceof List) {
                        this.entryVector = (List)hashEntry;
                        this.entryVectorSize = this.entryVector.size();
                        columns = (DataValueDescriptor[])this.entryVector.get(0);
                    } else {
                        this.entryVector = null;
                        this.entryVectorSize = 0;
                        columns = (DataValueDescriptor[])hashEntry;
                    }
                }
                if (columns != null) {
                    for (int i = 0; i < columns.length; ++i) {
                        if (columns[0] instanceof Storable) continue;
                        SanityManager.THROWASSERT((String)("columns[" + i + "] expected to be Storable, not " + columns[i].getClass().getName()));
                    }
                    for (int index = 0; index < columns.length; ++index) {
                        this.nextCandidate.setColumn(index + 1, columns[index]);
                    }
                    if (this.nextCandidate != null) {
                        this.nextCandidate.clearAllRegionAndKeyInfo();
                    }
                    result = this.doProjection(this.nextCandidate);
                    ++this.numFetchedOnNext;
                    continue;
                }
                result = null;
            } while (result == null && this.numFetchedOnNext < this.entryVectorSize);
        }
        this.setCurrentRow(result);
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                StatementContext sc = this.activation.getLanguageConnectionContext().getStatementContext();
                this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
            }
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
        }
        if (result != null && this.localTXState != null && this.isTopResultSet && this.isForUpdate()) {
            this.updateRowLocationPostRead();
        }
        return result;
    }
}

