/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import java.util.Arrays;
import java.util.Collections;

class MultiProbeTableScanResultSet
extends TableScanResultSet
implements CursorResultSet {
    protected DataValueDescriptor[] probeValues;
    protected DataValueDescriptor[] origProbeValues;
    protected int probeValIndex;
    private int sortRequired;

    MultiProbeTableScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, DataValueDescriptor[] probingVals, int sortRequired, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean delayScanOpening, boolean optimizeOffHeap, boolean indexAccesesBaseTable, boolean supportsMovetoNextKey, String nonQualPreds) throws StandardException {
        this(conglomId, scoci, activation, (ExecRow)resultRowAllocator.invoke(activation), resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, probingVals, sortRequired, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, colRefItem != -1 ? (FormatableBitSet)activation.getSavedObject(colRefItem) : null, indexColItem, lockMode, tableLocked, isolationLevel, oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost, delayScanOpening, optimizeOffHeap, indexAccesesBaseTable, supportsMovetoNextKey);
    }

    MultiProbeTableScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, ExecRow candidate, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, DataValueDescriptor[] probingVals, int sortRequired, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, FormatableBitSet accessedCols, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean delayScanOpening, boolean optimizeOffHeap, boolean indexAccesesBaseTable, boolean supportsMoveToNextKey) throws StandardException {
        super(conglomId, scoci, activation, candidate, resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, accessedCols, indexColItem, lockMode, tableLocked, isolationLevel, 1, oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost, delayScanOpening, optimizeOffHeap, indexAccesesBaseTable, supportsMoveToNextKey, null);
        SanityManager.ASSERT((probingVals != null && probingVals.length > 0 ? 1 : 0) != 0, (String)"No probe values found for multi-probe scan.");
        this.origProbeValues = probingVals;
        this.sortRequired = sortRequired;
    }

    @Override
    public void openCore() throws StandardException {
        if (this.sortRequired == 3) {
            this.probeValues = this.origProbeValues;
        } else {
            Object[] pVals = new DataValueDescriptor[this.origProbeValues.length];
            for (int i = 0; i < pVals.length; ++i) {
                pVals[i] = this.origProbeValues[i].getClone();
            }
            if (this.sortRequired == 1) {
                Arrays.sort(pVals);
            } else {
                Arrays.sort(pVals, Collections.reverseOrder());
            }
            this.probeValues = pVals;
        }
        this.probeValIndex = 0;
        super.openCore();
    }

    @Override
    protected void openScanController(TransactionController tc) throws StandardException {
        this.openScanController(tc, this.probeValues[0]);
        this.probeValIndex = 1;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.reopenCore(false);
    }

    private void reopenCore(boolean forNextProbe) throws StandardException {
        if (!forNextProbe) {
            this.probeValIndex = 0;
        }
        super.reopenCore();
    }

    @Override
    protected void reopenScanController() throws StandardException {
        if (this.probeValIndex == 0) {
            this.rowsThisScan = 0L;
        }
        DataValueDescriptor pv = null;
        if (this.moreInListVals() && (pv = this.getNextProbeValue()) == null) {
            return;
        }
        this.reopenScanController(pv);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        this.checkCancellationFlag();
        ExecRow result = super.getNextRowCore();
        while (result == null && this.moreInListVals()) {
            this.reopenCore(true);
            result = super.getNextRowCore();
        }
        return result;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        super.close(cleanupOnError);
    }

    private boolean moreInListVals() {
        return this.probeValIndex < this.probeValues.length;
    }

    private DataValueDescriptor getNextProbeValue() throws StandardException {
        int ctr;
        for (ctr = this.probeValIndex; ctr > 0 && ctr < this.probeValues.length && this.probeValues[this.probeValIndex - 1].equals(this.probeValues[ctr]); ++ctr) {
        }
        this.probeValIndex = ctr;
        if (this.probeValIndex < this.probeValues.length) {
            return this.probeValues[this.probeValIndex++];
        }
        return null;
    }
}

