/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.RoleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

class CreateRoleConstantAction
extends DDLConstantAction {
    private String roleName;

    public CreateRoleConstantAction(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        String currentAuthId = lcc.getAuthorizationId();
        dd.startWriting(lcc);
        RoleDescriptor rd = dd.getRoleDefinitionDescriptor(this.roleName);
        if (rd != null) {
            throw StandardException.newException("X0Y68.S", (Object)"Role", (Object)this.roleName);
        }
        rd = ddg.newRoleDescriptor(dd.getUUIDFactory().createUUID(), this.roleName, currentAuthId, "_SYSTEM", true, true);
        dd.addDescriptor(rd, null, 19, false, tc);
    }

    public String toString() {
        return "CREATE ROLE " + this.roleName;
    }

    @Override
    public String getSchemaName() {
        return null;
    }
}

