/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.types.RowMultiSetImpl;
import com.pivotal.gemfirexd.internal.catalog.types.SynonymAliasInfo;
import com.pivotal.gemfirexd.internal.catalog.types.UserDefinedTypeIdImpl;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericConstantActionFactory;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericExecutionFactory;
import java.util.List;

public abstract class QueryTreeNode
implements Visitable {
    public static final int AUTOINCREMENT_START_INDEX = 0;
    public static final int AUTOINCREMENT_INC_INDEX = 1;
    public static final int AUTOINCREMENT_IS_AUTOINCREMENT_INDEX = 2;
    public static final int AUTOINCREMENT_CREATE_MODIFY = 3;
    public static final int HAS_AUTOINCREMENT_INC = 4;
    public static final int SET_AUTOINCREMENT = 5;
    public static final int AUTOINCREMENT_IS_GENERATED_BY_DEFAULT = 6;
    private int beginOffset = -1;
    private int endOffset = -1;
    private int nodeType;
    private ContextManager cm;
    protected LanguageConnectionContext lcc;
    private GenericConstantActionFactory constantActionFactory;
    boolean isPrivilegeCollectionRequired = true;

    public QueryTreeNode() {
    }

    public QueryTreeNode(QueryTreeNode other) {
        this.nodeType = other.nodeType;
        this.cm = other.cm;
        this.lcc = other.lcc;
    }

    public void setContextManager(ContextManager cm) {
        this.cm = cm;
        SanityManager.ASSERT((cm != null ? 1 : 0) != 0, (String)"cm not expected to be null");
    }

    public final ContextManager getContextManager() {
        if (this.cm == null) {
            SanityManager.THROWASSERT((String)("Null context manager in QueryTreeNode of type :" + this.getClass()));
        }
        return this.cm;
    }

    public final NodeFactory getNodeFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getNodeFactory();
    }

    public final GenericConstantActionFactory getGenericConstantActionFactory() {
        if (this.constantActionFactory == null) {
            GenericExecutionFactory execFactory = (GenericExecutionFactory)this.getExecutionFactory();
            this.constantActionFactory = execFactory.getConstantActionFactory();
        }
        return this.constantActionFactory;
    }

    public final ExecutionFactory getExecutionFactory() {
        ExecutionFactory ef = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
        return ef;
    }

    protected final ClassFactory getClassFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getClassFactory();
    }

    public final LanguageConnectionContext getLanguageConnectionContext() {
        if (this.lcc == null) {
            this.lcc = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        }
        return this.lcc;
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    protected String nodeHeader() {
        return "\n" + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "\n";
    }

    public static String formatNodeString(String nodeString, int depth) {
        StringBuilder nodeStringBuilder = new StringBuilder(nodeString);
        char[] indent = new char[depth];
        while (depth > 0) {
            indent[depth - 1] = 9;
            --depth;
        }
        nodeStringBuilder.insert(0, indent);
        for (int pos = 0; pos < nodeStringBuilder.length() - 1; ++pos) {
            char c = nodeStringBuilder.charAt(pos);
            if (c != '\n') continue;
            nodeStringBuilder.insert(pos + 1, indent);
        }
        return nodeStringBuilder.toString();
    }

    public void treePrint() {
        QueryTreeNode.debugPrint(this.nodeHeader());
        QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(this.toString(), 0));
        this.printSubNodes(0);
        QueryTreeNode.debugFlush();
    }

    public void treePrint(int depth) {
        QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(this.nodeHeader(), depth));
        QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(this.toString(), depth));
        this.printSubNodes(depth);
    }

    public static void debugPrint(String outputString) {
        SanityManager.GET_DEBUG_STREAM().print(outputString);
    }

    protected static void debugFlush() {
        SanityManager.GET_DEBUG_STREAM().flush();
    }

    public void printSubNodes(int depth) {
    }

    public String toString() {
        return "";
    }

    public void printLabel(int depth, String label) {
        QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString("<" + depth + "> " + label, depth));
    }

    public boolean referencesSessionSchema() throws StandardException {
        return false;
    }

    final boolean isSessionSchema(SchemaDescriptor sd) {
        return sd != null ? this.isSessionSchema(sd.getSchemaName()) : false;
    }

    final boolean isSessionSchema(String schemaName) {
        return "SESSION".equals(schemaName);
    }

    public void disablePrivilegeCollection() {
        this.isPrivilegeCollectionRequired = false;
    }

    public boolean isPrivilegeCollectionRequired() {
        return this.isPrivilegeCollectionRequired;
    }

    public long getRowEstimate() {
        return 0L;
    }

    protected void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    public DataTypeDescriptor[] getParameterTypes() throws StandardException {
        return this.getCompilerContext().getParameterTypes();
    }

    public List<TypeCompiler> getOriginalParameterTypeCompilers() throws StandardException {
        return this.getCompilerContext().getOriginalParameterTypeCompilers();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return null;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    protected boolean isInstanceOf(int nodeType) {
        return this.nodeType == nodeType;
    }

    public final DataDictionary getDataDictionary() {
        return this.getLanguageConnectionContext().getDataDictionary();
    }

    public final DependencyManager getDependencyManager() {
        return this.getDataDictionary().getDependencyManager();
    }

    public final CompilerContext getCompilerContext() {
        return (CompilerContext)this.getContextManager().getContext("CompilerContext");
    }

    protected final TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.getCompilerContext().getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        return v.visit(this);
    }

    void acceptChildren(Visitor v) throws StandardException {
    }

    protected int getIntProperty(String value, String key) throws StandardException {
        int intVal = -1;
        try {
            intVal = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("42Y58", (Object)value, (Object)key);
        }
        return intVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementNode parseStatement(String sql, boolean internalSQL) throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        CompilerContext newCC = lcc.pushCompilerContext();
        if (internalSQL) {
            newCC.setReliability(0);
        }
        newCC.allowOptimizeLiteral(false);
        try {
            Parser p = newCC.getParser();
            StatementNode statementNode = p.parseStatement(sql);
            return statementNode;
        }
        finally {
            lcc.popCompilerContext(newCC);
        }
    }

    public int getStatementType() {
        return 0;
    }

    public boolean foundString(String[] list, String search) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(search)) continue;
            return true;
        }
        return false;
    }

    public ConstantNode getNullNode(DataTypeDescriptor type) throws StandardException {
        int constantNodeType;
        switch (type.getTypeId().getJDBCTypeId()) {
            case 12: {
                constantNodeType = 77;
                break;
            }
            case 1: {
                constantNodeType = 61;
                break;
            }
            case -6: {
                constantNodeType = 75;
                break;
            }
            case 5: {
                constantNodeType = 74;
                break;
            }
            case 4: {
                constantNodeType = 70;
                break;
            }
            case -5: {
                constantNodeType = 71;
                break;
            }
            case 7: {
                constantNodeType = 69;
                break;
            }
            case 8: {
                constantNodeType = 68;
                break;
            }
            case 2: 
            case 3: {
                constantNodeType = 67;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                constantNodeType = 76;
                break;
            }
            case -2: {
                constantNodeType = 58;
                break;
            }
            case -3: {
                constantNodeType = 59;
                break;
            }
            case -1: {
                constantNodeType = 73;
                break;
            }
            case 2005: {
                constantNodeType = 196;
                break;
            }
            case -4: {
                constantNodeType = 72;
                break;
            }
            case 2004: {
                constantNodeType = 195;
                break;
            }
            case 2009: {
                constantNodeType = 199;
                break;
            }
            case 4001: {
                constantNodeType = 204;
                break;
            }
            case 16: {
                constantNodeType = 38;
                break;
            }
            default: {
                if (type.getTypeId().userType()) {
                    constantNodeType = 76;
                    break;
                }
                SanityManager.THROWASSERT((String)("Unknown type " + type.getTypeId().getSQLTypeName() + " in getNullNode"));
                return null;
            }
        }
        ConstantNode constantNode = (ConstantNode)this.getNodeFactory().getNode(constantNodeType, type.getTypeId(), this.cm);
        constantNode.setType(type.getNullabilityType(true));
        return constantNode;
    }

    public DataValueDescriptor convertDefaultNode(DataTypeDescriptor typeDescriptor) throws StandardException {
        return null;
    }

    public void init(Object arg1) throws StandardException {
        SanityManager.THROWASSERT((String)("Single-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2) throws StandardException {
        SanityManager.THROWASSERT((String)("Two-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3) throws StandardException {
        SanityManager.THROWASSERT((String)("Three-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4) throws StandardException {
        SanityManager.THROWASSERT((String)("Four-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws StandardException {
        SanityManager.THROWASSERT((String)("Five-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) throws StandardException {
        SanityManager.THROWASSERT((String)("Six-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) throws StandardException {
        SanityManager.THROWASSERT((String)("Seven-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) throws StandardException {
        SanityManager.THROWASSERT((String)("Eight-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) throws StandardException {
        SanityManager.THROWASSERT((String)("Nine-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) throws StandardException {
        SanityManager.THROWASSERT((String)("Ten-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) throws StandardException {
        SanityManager.THROWASSERT((String)("Eleven-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) throws StandardException {
        SanityManager.THROWASSERT((String)("Twelve-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) throws StandardException {
        SanityManager.THROWASSERT((String)("Thirteen-argument init() not implemented for " + this.getClass().getName()));
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) throws StandardException {
        SanityManager.THROWASSERT((String)("Fourteen-argument init() not implemented for " + this.getClass().getName()));
    }

    public TableName makeTableName(String schemaName, String flatName) throws StandardException {
        return (TableName)this.getNodeFactory().getNode(34, schemaName, flatName, this.getContextManager());
    }

    public boolean isAtomic() throws StandardException {
        SanityManager.THROWASSERT((String)("isAtomic should not be called for this  class: " + this.getClass().getName()));
        return false;
    }

    public Object getCursorInfo() throws StandardException {
        return null;
    }

    protected final TableDescriptor getTableDescriptor(String tableName, SchemaDescriptor schema) throws StandardException {
        TableDescriptor retval;
        if (this.isSessionSchema(schema) && (retval = this.getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable(tableName)) != null) {
            return retval;
        }
        if (schema.getUUID() == null) {
            return null;
        }
        TableDescriptor td = this.getDataDictionary().getTableDescriptor(tableName, schema, this.getLanguageConnectionContext().getTransactionCompile());
        if (td == null || td.isSynonymDescriptor()) {
            return null;
        }
        return td;
    }

    protected final SchemaDescriptor getSchemaDescriptor(String schemaName) throws StandardException {
        return this.getSchemaDescriptor(schemaName, true);
    }

    protected final SchemaDescriptor getSchemaDescriptor(String schemaName, boolean raiseError) throws StandardException {
        SchemaDescriptor sd = null;
        boolean isCurrent = false;
        boolean isCompilation = false;
        if (schemaName == null) {
            CompilerContext cc = this.getCompilerContext();
            sd = cc.getCompilationSchema();
            if (sd == null) {
                sd = this.getLanguageConnectionContext().getDefaultSchema();
                isCurrent = true;
                cc.setCompilationSchema(sd);
            } else {
                isCompilation = true;
            }
            schemaName = sd.getSchemaName();
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor sdCatalog = dataDictionary.getSchemaDescriptor(schemaName, this.getLanguageConnectionContext().getTransactionCompile(), raiseError);
        if (isCurrent || isCompilation) {
            if (sdCatalog != null && sdCatalog.getUUID() != null) {
                if (!sdCatalog.getUUID().equals(sd.getUUID())) {
                    if (isCurrent) {
                        this.getLanguageConnectionContext().setDefaultSchema(sdCatalog);
                    }
                    this.getCompilerContext().setCompilationSchema(sdCatalog);
                }
            } else {
                sd.setUUID(null);
                sdCatalog = sd;
            }
        }
        return sdCatalog;
    }

    public TableName resolveTableToSynonym(TableName tabName) throws StandardException {
        AliasDescriptor nextAD;
        SchemaDescriptor nextSD;
        DataDictionary dd = this.getDataDictionary();
        String nextSynonymTable = tabName.getTableName();
        String nextSynonymSchema = tabName.getSchemaName();
        boolean found = false;
        CompilerContext cc = this.getCompilerContext();
        while ((nextSD = this.getSchemaDescriptor(nextSynonymSchema, false)) != null && nextSD.getUUID() != null && (nextAD = dd.getAliasDescriptor(nextSD.getUUID().toString(), nextSynonymTable, 'S')) != null) {
            cc.createDependency(nextAD);
            found = true;
            SynonymAliasInfo info = (SynonymAliasInfo)nextAD.getAliasInfo();
            nextSynonymTable = info.getSynonymTable();
            nextSynonymSchema = info.getSynonymSchema();
        }
        if (!found) {
            return null;
        }
        TableName tableName = new TableName();
        tableName.init(nextSynonymSchema, nextSynonymTable);
        return tableName;
    }

    void verifyClassExist(String javaClassName) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        ClassNotFoundException reason = null;
        boolean foundMatch = false;
        try {
            foundMatch = classInspector.accessible(javaClassName);
        }
        catch (ClassNotFoundException cnfe) {
            reason = cnfe;
        }
        if (!foundMatch) {
            throw StandardException.newException("42X51", (Throwable)reason, (Object)javaClassName);
        }
        if (ClassInspector.primitiveType(javaClassName)) {
            throw StandardException.newException("42Y37", javaClassName);
        }
    }

    public void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        SanityManager.THROWASSERT((String)("setRefActionInfo() not expected to be called for " + this.getClass().getName()));
    }

    protected void generateAuthorizeCheck(ExpressionClassBuilder acb, MethodBuilder mb, int sqlOperation) {
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getLanguageConnectionContext", "com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext", 0);
        mb.callMethod((short)185, null, "getAuthorizer", "com.pivotal.gemfirexd.internal.iapi.sql.conn.Authorizer", 0);
        acb.pushThisAsActivation(mb);
        mb.push(sqlOperation);
        mb.callMethod((short)185, null, "authorize", "void", 2);
    }

    public DataTypeDescriptor bindUserType(DataTypeDescriptor originalDTD) throws StandardException {
        if (originalDTD.getCatalogType().isRowMultiSet()) {
            return this.bindRowMultiSet(originalDTD);
        }
        if (!originalDTD.getTypeId().userType()) {
            return originalDTD;
        }
        UserDefinedTypeIdImpl userTypeID = (UserDefinedTypeIdImpl)originalDTD.getTypeId().getBaseTypeId();
        if (userTypeID.isBound()) {
            return originalDTD;
        }
        DataDictionary dd = this.getDataDictionary();
        SchemaDescriptor typeSchema = this.getSchemaDescriptor(userTypeID.getSchemaName());
        char udtNameSpace = 'A';
        String unqualifiedTypeName = userTypeID.getUnqualifiedName();
        AliasDescriptor ad = dd.getAliasDescriptor(typeSchema.getUUID().toString(), unqualifiedTypeName, udtNameSpace);
        if (ad == null) {
            throw StandardException.newException("42X94", (Object)AliasDescriptor.getAliasType(udtNameSpace), (Object)unqualifiedTypeName);
        }
        DataTypeDescriptor result = new DataTypeDescriptor(TypeId.getUserDefinedTypeId(typeSchema.getSchemaName(), unqualifiedTypeName, ad.getJavaClassName()), originalDTD.isNullable());
        return result;
    }

    public DataTypeDescriptor bindRowMultiSet(DataTypeDescriptor originalDTD) throws StandardException {
        if (!originalDTD.getCatalogType().isRowMultiSet()) {
            return originalDTD;
        }
        RowMultiSetImpl originalMultiSet = (RowMultiSetImpl)originalDTD.getTypeId().getBaseTypeId();
        String[] columnNames = originalMultiSet.getColumnNames();
        for (TypeDescriptor columnType : originalMultiSet.getTypes()) {
            TypeDescriptor newColumnType;
            if (!columnType.isUserDefinedType()) continue;
            DataTypeDescriptor newColumnDTD = DataTypeDescriptor.getType(columnType);
            newColumnDTD = this.bindUserType(newColumnDTD);
            columnTypes[i] = newColumnType = newColumnDTD.getCatalogType();
        }
        return originalDTD;
    }

    public void createTypeDependency(DataTypeDescriptor dtd) throws StandardException {
        AliasDescriptor ad = this.getDataDictionary().getAliasDescriptorForUDT(null, dtd);
        if (ad != null) {
            this.createTypeDependency(ad);
        }
    }

    private void createTypeDependency(AliasDescriptor ad) throws StandardException {
        if (ad != null) {
            this.getCompilerContext().createDependency(ad);
        }
    }

    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        return QueryInfoConstants.DUMMY;
    }

    public QueryInfo computeSubSelectQueryInfo(QueryInfoContext qic) throws StandardException {
        return this.computeQueryInfo(qic);
    }

    protected void optimizeForOffHeap(boolean shouldOptimize) {
    }
}

