/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.InQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryComparisonOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryListOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;

public final class InListOperatorNode
extends BinaryListOperatorNode {
    private boolean isOrdered;
    private boolean sortDescending;
    private boolean rightOperandIsArray;

    @Override
    public void init(Object leftOperand, Object rightOperandList) {
        this.init(leftOperand, rightOperandList, "IN", "in");
    }

    @Override
    public String toString() {
        return "isOrdered: " + this.isOrdered + " ,rightOperandIsArray: " + this.rightOperandIsArray + "\n" + super.toString();
    }

    protected InListOperatorNode shallowCopy() throws StandardException {
        InListOperatorNode ilon = (InListOperatorNode)this.getNodeFactory().getNode(55, this.leftOperand, this.rightOperandList, this.getContextManager());
        ilon.copyFields(this);
        if (this.isOrdered) {
            ilon.markAsOrdered();
        }
        if (this.sortDescending) {
            ilon.markSortDescending();
        }
        if (this.rightOperandIsArray) {
            ilon.setRightOperandArray();
        }
        return ilon;
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        super.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.rightOperandList.size() == 1 && !this.rightOperandIsArray) {
            BinaryComparisonOperatorNode equal = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(0), this.getContextManager());
            equal.bindComparisonOperator();
            return equal;
        }
        if (this.leftOperand instanceof ColumnReference && this.rightOperandList.containsOnlyConstantAndParamNodes()) {
            boolean allConstants = this.rightOperandList.containsAllConstantNodes();
            if (allConstants) {
                DataTypeDescriptor targetType = this.leftOperand.getTypeServices();
                TypeId judgeTypeId = targetType.getTypeId();
                if (!this.rightOperandList.allSamePrecendence(judgeTypeId.typePrecedence())) {
                    ClassFactory cf = this.getClassFactory();
                    int sz = this.rightOperandList.size();
                    for (int i = 0; i < sz; ++i) {
                        ValueNode vn = (ValueNode)this.rightOperandList.elementAt(i);
                        targetType = targetType.getDominantType(vn.getTypeServices(), cf);
                    }
                }
                DataValueDescriptor judgeODV = targetType.getNull();
                this.rightOperandList.sortInAscendingOrder(judgeODV);
                this.isOrdered = true;
                ValueNode minValue = (ValueNode)this.rightOperandList.elementAt(0);
                ValueNode maxValue = (ValueNode)this.rightOperandList.elementAt(this.rightOperandList.size() - 1);
                DataValueDescriptor minODV = ((ConstantNode)minValue).getValue();
                DataValueDescriptor maxODV = ((ConstantNode)maxValue).getValue();
                if (judgeODV.equals(minODV, maxODV).equals(true)) {
                    BinaryComparisonOperatorNode equal = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, this.leftOperand, minValue, this.getContextManager());
                    equal.bindComparisonOperator();
                    return equal;
                }
            }
            ValueNode srcVal = (ValueNode)this.rightOperandList.elementAt(0);
            ParameterNode pNode = (ParameterNode)this.getNodeFactory().getNode(88, 0, null, this.getContextManager());
            DataTypeDescriptor pType = srcVal.getTypeServices();
            pNode.setType(pType);
            pNode.setValueToGenerate(srcVal);
            BinaryComparisonOperatorNode equal = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, this.leftOperand, pNode, this, this.getContextManager());
            equal.bindComparisonOperator();
            return equal;
        }
        return this;
    }

    @Override
    public ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        AndNode newAnd = null;
        int listSize = this.rightOperandList.size();
        SanityManager.ASSERT((listSize > 0 ? 1 : 0) != 0, (String)"rightOperandList.size() is expected to be > 0");
        if (!underNotNode) {
            return this;
        }
        SanityManager.ASSERT((!this.rightOperandIsArray ? 1 : 0) != 0, (String)"Scenario of In-list as var param array under NOT is not supported yet");
        ValueNode leftClone = this.leftOperand instanceof ColumnReference ? this.leftOperand.getClone() : this.leftOperand;
        BinaryComparisonOperatorNode leftBCO = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(47, leftClone, (ValueNode)this.rightOperandList.elementAt(0), this.getContextManager());
        leftBCO.bindComparisonOperator();
        BinaryOperatorNode leftSide = leftBCO;
        for (int elemsDone = 1; elemsDone < listSize; ++elemsDone) {
            leftClone = this.leftOperand instanceof ColumnReference ? this.leftOperand.getClone() : this.leftOperand;
            BinaryComparisonOperatorNode rightBCO = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(47, leftClone, (ValueNode)this.rightOperandList.elementAt(elemsDone), this.getContextManager());
            rightBCO.bindComparisonOperator();
            newAnd = (AndNode)this.getNodeFactory().getNode(39, leftSide, rightBCO, this.getContextManager());
            newAnd.postBindFixup();
            leftSide = newAnd;
        }
        return leftSide;
    }

    public boolean selfReference(ColumnReference cr) throws StandardException {
        int size = this.rightOperandList.size();
        for (int i = 0; i < size; ++i) {
            ValueNode vn = (ValueNode)this.rightOperandList.elementAt(i);
            if (!vn.getTablesReferenced().get(cr.getTableNumber())) continue;
            return true;
        }
        return false;
    }

    @Override
    public double selectivity(Optimizable optTable) {
        return 0.3;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int listSize = this.rightOperandList.size();
        String receiverType = "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor";
        String leftInterfaceType = "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor";
        String rightInterfaceType = "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor[]";
        SanityManager.ASSERT((listSize > 0 ? 1 : 0) != 0, (String)"listSize is expected to be > 0");
        this.receiver = this.leftOperand;
        String resultTypeName = this.getTypeCompiler().interfaceName();
        if (this.rightOperandIsArray) {
            this.ncjGenerateExpression(acb, mb, resultTypeName);
            return;
        }
        LocalField arrayField = this.generateListAsArray(acb, mb);
        this.leftOperand.generateExpression(acb, mb);
        mb.dup();
        mb.upCast(leftInterfaceType);
        mb.getField(arrayField);
        mb.push(this.isOrdered);
        mb.callMethod((short)185, receiverType, this.methodName, resultTypeName, 3);
    }

    protected LocalField generateListAsArray(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((!this.rightOperandIsArray ? 1 : 0) != 0, (String)"Method ncjGenerateListAsArray should be called.");
        int listSize = this.rightOperandList.size();
        LocalField arrayField = acb.newFieldDeclaration(2, "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor[]");
        MethodBuilder cb = acb.getConstructor();
        cb.pushNewArray("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", listSize);
        cb.setField(arrayField);
        int numConstants = 0;
        MethodBuilder nonConstantMethod = null;
        MethodBuilder currentConstMethod = cb;
        for (int index = 0; index < listSize; ++index) {
            MethodBuilder setArrayMethod;
            if (this.rightOperandList.elementAt(index) instanceof ConstantNode) {
                ++numConstants;
                if (currentConstMethod.statementNumHitLimit(1)) {
                    MethodBuilder genConstantMethod = acb.newGeneratedFun("void", 2);
                    currentConstMethod.pushThis();
                    currentConstMethod.callMethod((short)182, null, genConstantMethod.getName(), "void", 0);
                    if (currentConstMethod != cb) {
                        currentConstMethod.methodReturn();
                        currentConstMethod.complete();
                    }
                    currentConstMethod = genConstantMethod;
                }
                setArrayMethod = currentConstMethod;
            } else {
                if (nonConstantMethod == null) {
                    nonConstantMethod = acb.newGeneratedFun("void", 4);
                }
                setArrayMethod = nonConstantMethod;
            }
            setArrayMethod.getField(arrayField);
            ((ValueNode)this.rightOperandList.elementAt(index)).generateExpression(acb, setArrayMethod);
            setArrayMethod.upCast("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
            setArrayMethod.setArrayElement(index);
        }
        if (currentConstMethod != cb) {
            currentConstMethod.methodReturn();
            currentConstMethod.complete();
        }
        if (nonConstantMethod != null) {
            nonConstantMethod.methodReturn();
            nonConstantMethod.complete();
            mb.pushThis();
            mb.callMethod((short)182, null, nonConstantMethod.getName(), "void", 0);
        }
        return arrayField;
    }

    public void generateStartStopKey(boolean isAsc, boolean isStartKey, ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int numValInLastLoop;
        int numLoops;
        SanityManager.ASSERT((!this.rightOperandIsArray ? 1 : 0) != 0, (String)"Scenario of In-list as var param array with start/stop key is not supported yet");
        int leftTypeFormatId = this.leftOperand.getTypeId().getTypeFormatId();
        int leftJDBCTypeId = this.leftOperand.getTypeId().isUserDefinedTypeId() ? this.leftOperand.getTypeId().getJDBCTypeId() : -1;
        int listSize = this.rightOperandList.size();
        int currentOpnd = 0;
        if (listSize < 5) {
            numLoops = 1;
            numValInLastLoop = (listSize - 1) % 4 + 1;
        } else {
            numLoops = (listSize - 5) / 3 + 2;
            numValInLastLoop = (listSize - 5) % 3 + 1;
        }
        for (int i = 0; i < numLoops; ++i) {
            int numVals = i == numLoops - 1 ? numValInLastLoop : (i == 0 ? 4 : 3);
            for (int j = 0; j < numVals; ++j) {
                ValueNode vn = (ValueNode)this.rightOperandList.elementAt(currentOpnd++);
                vn.generateExpression(acb, mb);
                mb.upCast("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
            }
            int numNulls = i < numLoops - 1 ? 0 : (i == 0 ? 4 - numValInLastLoop : 3 - numValInLastLoop);
            for (int j = 0; j < numNulls; ++j) {
                mb.pushNull("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
            }
            mb.push(leftTypeFormatId);
            mb.push(leftJDBCTypeId);
            String methodName = isAsc && isStartKey || !isAsc && !isStartKey ? "minValue" : "maxValue";
            mb.callMethod((short)184, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseExpressionActivation", methodName, "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", 6);
        }
    }

    protected void markAsOrdered() {
        this.isOrdered = true;
    }

    protected void markSortDescending() {
        this.sortDescending = true;
    }

    protected boolean isOrdered() {
        if (this.rightOperandIsArray) {
            return false;
        }
        return this.isOrdered;
    }

    protected boolean sortDescending() {
        return this.sortDescending;
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        ValueQueryInfo[] qiArr = new ValueQueryInfo[this.rightOperandList.size()];
        Boolean isDynamic = this.rightOperandList.populateQueryInfoArray(qic, qiArr);
        if (isDynamic != null) {
            InQueryInfo inQI = new InQueryInfo(this.leftOperand.computeQueryInfo(qic), isDynamic, qiArr);
            if (this.rightOperandIsArray) {
                inQI.setRightOperandArray();
            }
            return inQI;
        }
        return null;
    }

    @Override
    public String ncjGenerateSql() {
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append(this.leftOperand.ncjGenerateSql());
        sqlStr.append(" ");
        sqlStr.append(this.operator);
        sqlStr.append(" (");
        for (int index = 0; index < this.rightOperandList.size(); ++index) {
            ValueNode vNode = (ValueNode)this.rightOperandList.elementAt(index);
            if (index != 0) {
                sqlStr.append(", ");
            }
            sqlStr.append(vNode.ncjGenerateSql());
        }
        sqlStr.append(" ) ");
        return sqlStr.toString();
    }

    public boolean getIsRightOperandArray() {
        return this.rightOperandIsArray;
    }

    public void setRightOperandArray() {
        this.rightOperandIsArray = true;
        SanityManager.ASSERT((this.rightOperandList.size() == 1 ? 1 : 0) != 0, (String)"Right Child of IN Operator must have one and only one Parameter");
        SanityManager.ASSERT((boolean)(this.rightOperandList.elementAt(0) instanceof ParameterNode), (String)("Right Child of IN Operator must be of type ParameterNode, and not " + this.rightOperandList.elementAt(0).getClass().getSimpleName()));
        ParameterNode rightNode = (ParameterNode)this.rightOperandList.elementAt(0);
        rightNode.setDefaultValueIsArray();
    }

    @Override
    protected void handleUserDefinedTypes() throws StandardException {
        if (this.rightOperandIsArray) {
            return;
        }
        super.handleUserDefinedTypes();
    }

    private void ncjGenerateExpression(ExpressionClassBuilder acb, MethodBuilder mb, String resultTypeName) throws StandardException {
        LocalField arrayField = acb.newFieldDeclaration(2, "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor[]");
        ParameterNode rightNode = (ParameterNode)this.rightOperandList.elementAt(0);
        rightNode.generateExpression(acb, mb);
        this.leftOperand.generateExpression(acb, mb);
        mb.upCast("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
        mb.getField(arrayField);
        mb.push(false);
        mb.callMethod((short)182, "com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet", this.methodName, resultTypeName, 3);
    }

    protected void ncjGenerateListAsArray(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        ParameterNode rightNode = (ParameterNode)this.rightOperandList.elementAt(0);
        rightNode.generateExpression(acb, mb);
        mb.callMethod((short)182, "com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet", "getValues", "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor[]", 0);
    }
}

