/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class ConcatenationOperatorNode
extends BinaryOperatorNode {
    @Override
    public void init(Object leftOperand, Object rightOperand) {
        super.init(leftOperand, rightOperand, "||", "concatenate", "com.pivotal.gemfirexd.internal.iapi.types.ConcatableDataValue", "com.pivotal.gemfirexd.internal.iapi.types.ConcatableDataValue");
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        DataTypeDescriptor dtd;
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregateVector);
        this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.leftOperand.requiresTypeFromContext() && !this.leftOperand.isParameterizedConstantNode()) {
            if (this.rightOperand.requiresTypeFromContext() && !this.rightOperand.isParameterizedConstantNode()) {
                throw StandardException.newException("42X35", this.operator);
            }
            TypeId leftType = this.rightOperand.getTypeId().isBitTypeId() ? (this.rightOperand.getTypeId().isBlobTypeId() ? TypeId.getBuiltInTypeId(2004) : TypeId.getBuiltInTypeId(-3)) : (this.rightOperand.getTypeId().isClobTypeId() ? TypeId.getBuiltInTypeId(2005) : TypeId.getBuiltInTypeId(12));
            this.leftOperand.setType(new DataTypeDescriptor(leftType, true));
            if (this.rightOperand.getTypeId().isStringTypeId()) {
                this.leftOperand.setCollationInfo(this.rightOperand.getTypeServices());
            }
        }
        if (this.rightOperand.requiresTypeFromContext() && !this.rightOperand.isParameterizedConstantNode()) {
            TypeId rightType = this.leftOperand.getTypeId().isBitTypeId() ? (this.leftOperand.getTypeId().isBlobTypeId() ? TypeId.getBuiltInTypeId(2004) : TypeId.getBuiltInTypeId(-3)) : (this.leftOperand.getTypeId().isClobTypeId() ? TypeId.getBuiltInTypeId(2005) : TypeId.getBuiltInTypeId(12));
            this.rightOperand.setType(new DataTypeDescriptor(rightType, true));
            if (this.leftOperand.getTypeId().isStringTypeId()) {
                this.rightOperand.setCollationInfo(this.leftOperand.getTypeServices());
            }
        }
        if (this.leftOperand.getTypeId().userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if (this.rightOperand.getTypeId().userType()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        TypeCompiler tc = this.leftOperand.getTypeCompiler();
        if (!this.leftOperand.getTypeId().isStringTypeId() && !this.leftOperand.getTypeId().isBitTypeId()) {
            dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, tc.getCastToCharWidth(this.leftOperand.getTypeServices()));
            this.leftOperand = (ValueNode)this.getNodeFactory().getNode(60, this.leftOperand, dtd, this.getContextManager());
            this.leftOperand.setCollationUsingCompilationSchema();
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        }
        tc = this.rightOperand.getTypeCompiler();
        if (!this.rightOperand.getTypeId().isStringTypeId() && !this.rightOperand.getTypeId().isBitTypeId()) {
            dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, tc.getCastToCharWidth(this.rightOperand.getTypeServices()));
            this.rightOperand = (ValueNode)this.getNodeFactory().getNode(60, this.rightOperand, dtd, this.getContextManager());
            this.rightOperand.setCollationUsingCompilationSchema();
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        }
        tc = this.leftOperand.getTypeCompiler();
        this.setType(this.resolveConcatOperation(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices()));
        if (this.getTypeServices().getMaximumWidth() > this.getTypeId().getMaximumMaximumWidth()) {
            SanityManager.THROWASSERT((String)("The maximum length " + this.getTypeServices().getMaximumWidth() + " for the result type " + this.getTypeId().getSQLTypeName() + " can't be greater than it's maximum width of result's typeid" + this.getTypeId().getMaximumMaximumWidth()));
        }
        this.setLeftRightInterfaceType(tc.interfaceName());
        return this;
    }

    private DataTypeDescriptor resolveConcatOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType) throws StandardException {
        TypeId leftTypeId = leftType.getTypeId();
        TypeId rightTypeId = rightType.getTypeId();
        if (!leftTypeId.isConcatableTypeId() || !rightTypeId.isConcatableTypeId() || rightTypeId.isBitTypeId() && leftTypeId.isStringTypeId() || leftTypeId.isBitTypeId() && rightTypeId.isStringTypeId()) {
            throw StandardException.newException("42884", (Object)"||", (Object)"FUNCTION");
        }
        String higherType = leftTypeId.typePrecedence() >= rightTypeId.typePrecedence() ? leftType.getTypeName() : rightType.getTypeName();
        int resultLength = leftType.getMaximumWidth() + rightType.getMaximumWidth();
        if (leftTypeId.getJDBCTypeId() == 1 || leftTypeId.getJDBCTypeId() == -2) {
            switch (rightTypeId.getJDBCTypeId()) {
                case -2: 
                case 1: {
                    if (resultLength <= 254) break;
                    if (rightTypeId.getJDBCTypeId() == 1) {
                        higherType = "VARCHAR";
                        break;
                    }
                    higherType = "VARCHAR () FOR BIT DATA";
                    break;
                }
                case -3: 
                case 12: {
                    if (resultLength <= 4000) break;
                    if (rightTypeId.getJDBCTypeId() == 12) {
                        higherType = "LONG VARCHAR";
                        break;
                    }
                    higherType = "LONG VARCHAR FOR BIT DATA";
                    break;
                }
                case 2004: 
                case 2005: {
                    resultLength = ConcatenationOperatorNode.clobBlobHandling(rightType, leftType);
                }
            }
        } else if (leftTypeId.getJDBCTypeId() == 12) {
            switch (rightTypeId.getJDBCTypeId()) {
                case 1: 
                case 12: {
                    if (resultLength <= 4000) break;
                    higherType = "LONG VARCHAR";
                    break;
                }
                case 2005: {
                    resultLength = ConcatenationOperatorNode.clobBlobHandling(rightType, leftType);
                }
            }
        } else if (leftTypeId.getJDBCTypeId() == -3) {
            switch (rightTypeId.getJDBCTypeId()) {
                case -3: 
                case -2: {
                    if (resultLength <= 4000) break;
                    higherType = "LONG VARCHAR FOR BIT DATA";
                    break;
                }
                case 2004: {
                    resultLength = ConcatenationOperatorNode.clobBlobHandling(rightType, leftType);
                }
            }
        } else if (leftTypeId.getJDBCTypeId() == 2005 || leftTypeId.getJDBCTypeId() == 2004) {
            resultLength = ConcatenationOperatorNode.clobBlobHandling(leftType, rightType);
        } else if (rightTypeId.getJDBCTypeId() == 2005 || rightTypeId.getJDBCTypeId() == 2004) {
            resultLength = ConcatenationOperatorNode.clobBlobHandling(rightType, leftType);
        }
        if (higherType.equals("LONG VARCHAR")) {
            resultLength = 32700;
        } else if (higherType.equals("LONG VARCHAR FOR BIT DATA")) {
            resultLength = 32700;
        }
        if (resultLength < 0) {
            SanityManager.THROWASSERT((String)"There should not be an overflow of maximum length for any result type at this point. Overflow for BLOB/CLOB has already been handled earlier");
        }
        boolean nullable = leftType.isNullable() || rightType.isNullable();
        DataTypeDescriptor returnDTD = new DataTypeDescriptor(TypeId.getBuiltInTypeId(higherType), nullable, resultLength);
        returnDTD = leftType.getCollationDerivation() != rightType.getCollationDerivation() || leftType.getCollationType() != rightType.getCollationType() ? returnDTD.getCollatedType(returnDTD.getCollationDerivation(), 0) : returnDTD.getCollatedType(leftType.getCollationType(), leftType.getCollationDerivation());
        return returnDTD;
    }

    @Override
    protected void initializeResultField(ExpressionClassBuilder acb, MethodBuilder mb, LocalField resultField) throws StandardException {
        mb.conditionalIfNull();
        acb.generateNull(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        mb.startElseCode();
        mb.getField(resultField);
        mb.completeConditional();
    }

    private static int clobBlobHandling(DataTypeDescriptor clobBlobType, DataTypeDescriptor otherType) throws StandardException {
        int resultLength = otherType.getTypeId().getJDBCTypeId() == -1 || otherType.getTypeId().getJDBCTypeId() == -4 ? clobBlobType.getMaximumWidth() + 32768 : clobBlobType.getMaximumWidth() + otherType.getMaximumWidth();
        if (resultLength < 1) {
            return Integer.MAX_VALUE;
        }
        return resultLength;
    }
}

