/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql;

import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;

public final class GenericParameter {
    private static int DECIMAL_PARAMETER_DEFAULT_PRECISION = 38;
    private static int DECIMAL_PARAMETER_DEFAULT_SCALE = 15;
    private final GenericParameterValueSet pvs;
    private DataValueDescriptor value;
    int jdbcTypeId;
    String declaredClassName;
    short parameterMode;
    boolean isSet;
    private final boolean isReturnOutputParameter;
    int registerOutType = 0;
    int registerOutScale = -1;
    int registerOutPrecision = -1;

    GenericParameter(GenericParameterValueSet pvs, boolean isReturnOutputParameter) {
        this.pvs = pvs;
        this.isReturnOutputParameter = isReturnOutputParameter;
        this.parameterMode = (short)(this.isReturnOutputParameter ? 4 : 1);
    }

    public GenericParameter getClone(GenericParameterValueSet pvs) {
        GenericParameter gpClone = new GenericParameter(pvs, this.isReturnOutputParameter);
        gpClone.initialize(this.getValue().getClone(), this.jdbcTypeId, this.declaredClassName);
        gpClone.isSet = true;
        return gpClone;
    }

    public void initialize(DataValueDescriptor value, int jdbcTypeId, String className) {
        this.value = value;
        this.jdbcTypeId = jdbcTypeId;
        this.declaredClassName = className;
    }

    public void clear() {
        this.isSet = false;
        DataValueDescriptor value = this.value;
        if (value != null) {
            value.setToNull();
        }
    }

    public DataValueDescriptor getValue() {
        return this.value;
    }

    void setOutParameter(int sqlType, int scale) throws StandardException {
        if (this.registerOutType == sqlType && scale == this.registerOutScale) {
            return;
        }
        switch (this.parameterMode) {
            default: {
                throw StandardException.newException("XCL22.S", this.getJDBCParameterNumberStr());
            }
            case 2: 
            case 4: 
        }
        if (!DataTypeDescriptor.isJDBCTypeEquivalent(this.jdbcTypeId, sqlType)) {
            throw this.throwInvalidOutParamMap(sqlType);
        }
        this.registerOutType = sqlType;
    }

    private StandardException throwInvalidOutParamMap(int sqlType) {
        String jdbcTypesName = Util.typeName(sqlType);
        TypeId typeId = TypeId.getBuiltInTypeId(this.jdbcTypeId);
        String thisTypeName = typeId == null ? this.declaredClassName : typeId.getSQLTypeName();
        StandardException e = StandardException.newException("XCL25.S", (Object)this.getJDBCParameterNumberStr(), (Object)jdbcTypesName, (Object)thisTypeName);
        return e;
    }

    void validate() throws StandardException {
        switch (this.parameterMode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                if (this.registerOutType != 0) break;
                throw StandardException.newException("07004", (Object)this.getJDBCParameterNumberStr(), (Object)RoutineAliasInfo.parameterMode(this.parameterMode));
            }
        }
    }

    public int getScale() {
        return this.registerOutScale == -1 ? 0 : this.registerOutScale;
    }

    public int getPrecision() {
        return this.registerOutPrecision;
    }

    public int getSQLType() {
        return this.registerOutType;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public short getParameterMode() {
        return this.parameterMode;
    }

    public void setParameterMode(short mode) {
        this.parameterMode = mode;
    }

    public int getRegisterOutputType() {
        return this.registerOutType;
    }

    public int getRegisterOutScale() {
        return this.registerOutScale;
    }

    public boolean getIsSet() {
        return this.isSet;
    }

    String getJDBCParameterNumberStr() {
        return Integer.toString(this.pvs.getParameterNumber(this));
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        try {
            return this.value.getTraceString();
        }
        catch (StandardException se) {
            return "unexpected exception from getTraceString() - " + se;
        }
    }

    public void initialize(DataValueDescriptor value) {
        this.value = value;
    }

    public int getJDBCTypeId() {
        return this.jdbcTypeId;
    }
}

