/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.stream;

import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.services.stream.PrintWriterGetHeader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

class BasicHeaderPrintWriter
extends PrintWriter
implements HeaderPrintWriter {
    private final PrintWriterGetHeader headerGetter;
    private final boolean canClose;
    private final String name;

    BasicHeaderPrintWriter(OutputStream writeTo, PrintWriterGetHeader headerGetter, boolean canClose, String streamName) {
        super(writeTo, true);
        this.headerGetter = headerGetter;
        this.canClose = canClose;
        this.name = streamName;
    }

    BasicHeaderPrintWriter(Writer writeTo, PrintWriterGetHeader headerGetter, boolean canClose, String writerName) {
        super(writeTo, true);
        this.headerGetter = headerGetter;
        this.canClose = canClose;
        this.name = writerName;
    }

    @Override
    public synchronized void printlnWithHeader(String message) {
        this.print(this.headerGetter.getHeader());
        this.println(message);
    }

    @Override
    public PrintWriterGetHeader getHeader() {
        return this.headerGetter;
    }

    @Override
    public PrintWriter getPrintWriter() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void complete() {
        this.flush();
        if (this.canClose) {
            this.close();
        }
    }

    @Override
    public int getLogSeverityLevel() {
        return 0;
    }

    @Override
    public boolean printStackTrace(Throwable error, int logSeverityLevel) {
        return true;
    }
}

