/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.pivotal.gemfirexd.internal.impl.load.ControlInfo;
import com.pivotal.gemfirexd.internal.impl.load.ExportWriteDataAbstract;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;

final class ExportWriteData
extends ExportWriteDataAbstract
implements PrivilegedExceptionAction {
    private String outputFileName;
    private String lobsFileName;
    private boolean lobsInExtFile = false;
    private long lobFileOffset = 0L;
    private OutputStreamWriter aStream;
    private OutputStreamWriter lobCharStream;
    private BufferedOutputStream lobOutBinaryStream;
    private ByteArrayOutputStream lobByteArrayStream;
    private byte[] byteBuf;
    private char[] charBuf;

    ExportWriteData(String outputFileName, ControlInfo controlFileReader) throws Exception {
        this.outputFileName = outputFileName;
        this.controlFileReader = controlFileReader;
        this.init();
    }

    ExportWriteData(String outputFileName, String lobsFileName, ControlInfo controlFileReader) throws Exception {
        this.outputFileName = outputFileName;
        this.lobsFileName = lobsFileName;
        this.controlFileReader = controlFileReader;
        this.lobsInExtFile = true;
        this.byteBuf = new byte[8192];
        this.charBuf = new char[8192];
        this.init();
    }

    private void init() throws Exception {
        this.loadPropertiesInfo();
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public final Object run() throws Exception {
        this.openFiles();
        return null;
    }

    private void openFiles() throws Exception {
        try {
            URL url = new URL(this.outputFileName);
            this.outputFileName = url.getFile();
            if (this.lobsInExtFile) {
                url = new URL(this.lobsFileName);
                this.lobsFileName = url.getFile();
            }
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        FileOutputStream anOutputStream = null;
        FilterOutputStream buffered = null;
        FileOutputStream lobOutputStream = null;
        try {
            anOutputStream = new FileOutputStream(this.outputFileName);
            buffered = new BufferedOutputStream(anOutputStream);
            OutputStreamWriter outputStreamWriter = this.aStream = this.dataCodeset == null ? new OutputStreamWriter(buffered) : new OutputStreamWriter((OutputStream)buffered, this.dataCodeset);
            if (this.lobsInExtFile) {
                File lobsFile = new File(this.lobsFileName);
                if (lobsFile.getParentFile() == null) {
                    lobsFile = new File(new File(this.outputFileName).getParentFile(), this.lobsFileName);
                }
                lobOutputStream = new FileOutputStream(lobsFile);
                this.lobOutBinaryStream = new BufferedOutputStream(lobOutputStream);
                this.lobByteArrayStream = new ByteArrayOutputStream();
                this.lobCharStream = this.dataCodeset == null ? new OutputStreamWriter(this.lobByteArrayStream) : new OutputStreamWriter((OutputStream)this.lobByteArrayStream, this.dataCodeset);
            }
        }
        catch (Exception e) {
            if (this.aStream == null) {
                if (buffered != null) {
                    buffered.close();
                } else if (anOutputStream != null) {
                    anOutputStream.close();
                }
            } else {
                this.aStream.close();
                if (this.lobOutBinaryStream != null) {
                    this.lobOutBinaryStream.close();
                } else if (lobOutputStream != null) {
                    lobOutputStream.close();
                }
            }
            throw e;
        }
    }

    @Override
    void writeColumnDefinitionOptionally(String[] columnNames, String[] columnTypes) throws Exception {
        boolean ignoreColumnTypes = true;
        if (this.columnDefinition.toUpperCase(Locale.ENGLISH).equals("True".toUpperCase(Locale.ENGLISH))) {
            String tempStr = new String();
            for (int i = 0; i < columnNames.length; ++i) {
                tempStr = i > 0 ? this.fieldSeparator : "";
                tempStr = tempStr + this.fieldStartDelimiter + columnNames[i] + this.fieldStopDelimiter;
                if (!ignoreColumnTypes) {
                    tempStr = tempStr + this.fieldSeparator + this.fieldStartDelimiter + columnTypes[i] + this.fieldStopDelimiter;
                }
                this.aStream.write(tempStr, 0, tempStr.length());
            }
            this.aStream.write(this.recordSeparator, 0, this.recordSeparator.length());
        }
    }

    private void writeNextColumn(String oneColumn, boolean isNumeric) throws Exception {
        if (oneColumn != null) {
            if (!isNumeric) {
                this.aStream.write(this.fieldStartDelimiter, 0, this.fieldStartDelimiter.length());
            }
            if (this.doubleDelimiter) {
                oneColumn = this.makeDoubleDelimiterString(oneColumn, this.fieldStartDelimiter);
            }
            this.aStream.write(oneColumn, 0, oneColumn.length());
            if (!isNumeric) {
                this.aStream.write(this.fieldStopDelimiter, 0, this.fieldStopDelimiter.length());
            }
        }
    }

    @Override
    String writeBinaryColumnToExternalFile(InputStream istream) throws Exception {
        long blobSize = 0L;
        int noBytes = 0;
        if (istream != null) {
            noBytes = istream.read(this.byteBuf);
            while (noBytes != -1) {
                this.lobOutBinaryStream.write(this.byteBuf, 0, noBytes);
                blobSize += (long)noBytes;
                noBytes = istream.read(this.byteBuf);
            }
            istream.close();
            this.lobOutBinaryStream.flush();
        } else {
            blobSize = -1L;
        }
        String lobLocation = this.lobsFileName + "." + this.lobFileOffset + "." + blobSize + "/";
        if (blobSize != -1L) {
            this.lobFileOffset += blobSize;
        }
        return lobLocation;
    }

    @Override
    String writeCharColumnToExternalFile(Reader ir) throws Exception {
        long clobSize = 0L;
        int noChars = 0;
        if (ir != null) {
            noChars = ir.read(this.charBuf);
            while (noChars != -1) {
                this.lobByteArrayStream.reset();
                this.lobCharStream.write(this.charBuf, 0, noChars);
                this.lobCharStream.flush();
                clobSize += (long)this.lobByteArrayStream.size();
                this.lobByteArrayStream.writeTo(this.lobOutBinaryStream);
                noChars = ir.read(this.charBuf);
            }
            ir.close();
            this.lobOutBinaryStream.flush();
        } else {
            clobSize = -1L;
        }
        String lobLocation = this.lobsFileName + "." + this.lobFileOffset + "." + clobSize + "/";
        if (clobSize != -1L) {
            this.lobFileOffset += clobSize;
        }
        return lobLocation;
    }

    @Override
    public void writeData(String[] oneRow, boolean[] isNumeric) throws Exception {
        if (this.format.equals("ASCII_DELIMITED")) {
            this.writeNextColumn(oneRow[0], isNumeric[0]);
            for (int i = 1; i < oneRow.length; ++i) {
                this.aStream.write(this.fieldSeparator, 0, this.fieldSeparator.length());
                this.writeNextColumn(oneRow[i], isNumeric[i]);
            }
            if (this.hasDelimiterAtEnd) {
                this.aStream.write(this.fieldSeparator, 0, this.fieldSeparator.length());
            }
        }
        this.aStream.write(this.recordSeparator, 0, this.recordSeparator.length());
    }

    @Override
    public void noMoreRows() throws IOException {
        this.aStream.flush();
        this.aStream.close();
        if (this.lobsInExtFile) {
            if (this.lobOutBinaryStream != null) {
                this.lobOutBinaryStream.flush();
                this.lobOutBinaryStream.close();
            }
            if (this.lobCharStream != null) {
                this.lobCharStream.close();
            }
            if (this.lobByteArrayStream != null) {
                this.lobByteArrayStream.close();
            }
        }
    }

    private String makeDoubleDelimiterString(String inputString, String charDelimiter) {
        int start = inputString.indexOf(charDelimiter);
        if (start != -1) {
            StringBuilder result = new StringBuilder(inputString);
            int delLength = charDelimiter.length();
            while (start != -1) {
                result = result.insert(start, charDelimiter);
                int current = start + delLength + 1;
                start = result.toString().indexOf(charDelimiter, current);
            }
            return result.toString();
        }
        return inputString;
    }
}

