/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayDataOutput;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.BinarySQLHybridType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DateTimeDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBinary;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLReal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLSmallint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTinyint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.types.XML;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class DataTypeUtilities {
    static final byte[] INT_MIN_BYTES = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
    static final byte[] LONG_MIN_BYTES = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    public static final int NULL_MAX = 0x3FFFFFFF;
    public static final int NULL_MIN = -1073741823;

    public static int getPrecision(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        switch (typeId) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: 
            case 2009: 
            case 4001: {
                return dtd.getMaximumWidth();
            }
            case 5: {
                return 5;
            }
            case 16: {
                return 1;
            }
        }
        return dtd.getPrecision();
    }

    public static int getDigitPrecision(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        switch (typeId) {
            case 6: 
            case 8: {
                return 15;
            }
            case 7: {
                return 7;
            }
        }
        return DataTypeUtilities.getPrecision(dtd);
    }

    public static boolean isCurrency(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        return typeId == 3 || typeId == 2;
    }

    public static boolean isCaseSensitive(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        return typeId == 1 || typeId == 12 || typeId == 2005 || typeId == -1 || typeId == 2009 || typeId == 4001;
    }

    public static int isNullable(DataTypeDescriptor dtd) {
        return dtd.isNullable() ? 1 : 0;
    }

    public static boolean isSigned(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        return typeId == 4 || typeId == 6 || typeId == 3 || typeId == 5 || typeId == -5 || typeId == -6 || typeId == 2 || typeId == 7 || typeId == 8;
    }

    public static int getColumnDisplaySize(DataTypeDescriptor dtd) {
        int typeId = dtd.getTypeId().getJDBCTypeId();
        int storageLength = dtd.getMaximumWidth();
        return DataTypeUtilities.getColumnDisplaySize(typeId, storageLength);
    }

    public static int getColumnDisplaySize(int typeId, int storageLength) {
        int size;
        switch (typeId) {
            case 93: {
                size = 26;
                break;
            }
            case 91: {
                size = 10;
                break;
            }
            case 92: {
                size = 8;
                break;
            }
            case 4: {
                size = 11;
                break;
            }
            case 5: {
                size = 6;
                break;
            }
            case 6: 
            case 7: {
                size = 13;
                break;
            }
            case 8: {
                size = 22;
                break;
            }
            case -6: {
                size = 15;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                size = 2 * storageLength;
                if (size >= 0) break;
                size = Integer.MAX_VALUE;
                break;
            }
            case -5: {
                size = 20;
                break;
            }
            case -7: 
            case 16: {
                size = 5;
                break;
            }
            default: {
                int w = storageLength;
                size = w > 0 ? w : 15;
            }
        }
        return size;
    }

    public static int computeMaxWidth(int precision, int scale) {
        return scale == 0 ? precision + 1 : (scale == precision ? precision + 3 : precision + 2);
    }

    public static final String getAsString(byte[] inBytes, int offset, int columnWidth, DataTypeDescriptor dtd, ResultWasNull wasNull) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 5: {
                return SQLChar.getAsString(inBytes, offset, columnWidth, dtd);
            }
            case 13: 
            case 230: 
            case 444: {
                return SQLVarchar.getAsString(inBytes, offset, columnWidth);
            }
            case 7: {
                return Integer.toString(SQLInteger.getAsInteger(inBytes, offset));
            }
            case 197: {
                return SQLDecimal.getAsString(inBytes, offset, columnWidth);
            }
            case 11: {
                return Long.toString(SQLLongint.getAsLong(inBytes, offset));
            }
            case 6: {
                return Double.toString(SQLDouble.getAsDouble(inBytes, offset));
            }
            case 8: {
                return Float.toString(SQLReal.getAsFloat(inBytes, offset));
            }
            case 10: {
                return Integer.toString(SQLSmallint.getAsShort(inBytes, offset));
            }
            case 40: {
                return SQLDate.getAsString(inBytes, offset);
            }
            case 35: {
                return SQLTime.getAsString(inBytes, offset);
            }
            case 36: {
                return SQLTimestamp.getAsString(inBytes, offset);
            }
            case 4: {
                return Boolean.toString(SQLBoolean.getAsBoolean(inBytes, offset));
            }
            case 195: {
                return Byte.toString(SQLTinyint.getAsByte(inBytes, offset));
            }
            case 456: {
                return XML.getAsString(inBytes, offset, columnWidth);
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        String result = dvd.getString();
        if (result != null) {
            return result;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    public static final String getAsString(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, DataTypeDescriptor dtd, ResultWasNull wasNull) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 5: {
                return SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd);
            }
            case 13: 
            case 230: 
            case 444: {
                return SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs);
            }
            case 7: {
                return Integer.toString(SQLInteger.getAsInteger(unsafe, memOffset));
            }
            case 197: {
                return SQLDecimal.getAsString(unsafe, memOffset, columnWidth);
            }
            case 11: {
                return Long.toString(SQLLongint.getAsLong(unsafe, memOffset));
            }
            case 6: {
                return Double.toString(SQLDouble.getAsDouble(unsafe, memOffset));
            }
            case 8: {
                return Float.toString(SQLReal.getAsFloat(unsafe, memOffset));
            }
            case 10: {
                return Integer.toString(SQLSmallint.getAsShort(unsafe, memOffset));
            }
            case 40: {
                return SQLDate.getAsString(unsafe, memOffset);
            }
            case 35: {
                return SQLTime.getAsString(unsafe, memOffset);
            }
            case 36: {
                return SQLTimestamp.getAsString(unsafe, memOffset);
            }
            case 4: {
                return Boolean.toString(SQLBoolean.getAsBoolean(unsafe, memOffset));
            }
            case 195: {
                return Byte.toString(SQLTinyint.getAsByte(unsafe, memOffset));
            }
            case 456: {
                return XML.getAsString(unsafe, memOffset, columnWidth, bs);
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        String result = dvd.getString();
        if (result != null) {
            return result;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    public static final Object getAsObject(byte[] inBytes, int offset, int columnWidth, DataTypeDescriptor dtd, ResultWasNull wasNull) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 5: {
                return SQLChar.getAsString(inBytes, offset, columnWidth, dtd);
            }
            case 13: 
            case 230: 
            case 444: {
                return SQLVarchar.getAsString(inBytes, offset, columnWidth);
            }
            case 7: {
                return SQLInteger.getAsInteger(inBytes, offset);
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(inBytes, offset, columnWidth);
                if (bd != null) {
                    return bd;
                }
                if (wasNull != null) {
                    wasNull.setWasNull();
                }
                return null;
            }
            case 11: {
                return SQLLongint.getAsLong(inBytes, offset);
            }
            case 6: {
                return SQLDouble.getAsDouble(inBytes, offset);
            }
            case 8: {
                return Float.valueOf(SQLReal.getAsFloat(inBytes, offset));
            }
            case 10: {
                return (int)SQLSmallint.getAsShort(inBytes, offset);
            }
            case 40: {
                return SQLDate.getAsDate(inBytes, offset, (Calendar)ClientSharedData.getDefaultCalendar());
            }
            case 35: {
                return SQLTime.getAsTime(inBytes, offset, (Calendar)ClientSharedData.getDefaultCalendar());
            }
            case 36: {
                return SQLTimestamp.getAsTimeStamp(inBytes, offset, (Calendar)ClientSharedData.getDefaultCalendar());
            }
            case 4: {
                return SQLBoolean.getAsBoolean(inBytes, offset);
            }
            case 195: {
                return SQLTinyint.getAsByte(inBytes, offset);
            }
            case 27: 
            case 29: 
            case 232: 
            case 440: {
                return SQLBinary.getAsBytes(inBytes, offset, columnWidth);
            }
            case 456: {
                return XML.getAsString(inBytes, offset, columnWidth);
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        Object result = dvd.getObject();
        if (result != null) {
            return result;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    public static final Object getAsObject(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, DataTypeDescriptor dtd, ResultWasNull wasNull) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 5: {
                return SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd);
            }
            case 13: 
            case 230: 
            case 444: {
                return SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs);
            }
            case 7: {
                return SQLInteger.getAsInteger(unsafe, memOffset);
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(unsafe, memOffset, columnWidth);
                if (bd != null) {
                    return bd;
                }
                if (wasNull != null) {
                    wasNull.setWasNull();
                }
                return null;
            }
            case 11: {
                return SQLLongint.getAsLong(unsafe, memOffset);
            }
            case 6: {
                return SQLDouble.getAsDouble(unsafe, memOffset);
            }
            case 8: {
                return Float.valueOf(SQLReal.getAsFloat(unsafe, memOffset));
            }
            case 10: {
                return (int)SQLSmallint.getAsShort(unsafe, memOffset);
            }
            case 40: {
                return SQLDate.getAsDate(unsafe, memOffset, (Calendar)ClientSharedData.getDefaultCalendar());
            }
            case 35: {
                return SQLTime.getAsTime(unsafe, memOffset, (Calendar)ClientSharedData.getDefaultCalendar());
            }
            case 36: {
                return SQLTimestamp.getAsTimeStamp(unsafe, memOffset, (Calendar)ClientSharedData.getDefaultCalendar());
            }
            case 4: {
                return SQLBoolean.getAsBoolean(unsafe, memOffset);
            }
            case 195: {
                return SQLTinyint.getAsByte(unsafe, memOffset);
            }
            case 27: 
            case 29: 
            case 232: 
            case 440: {
                return SQLBinary.getAsBytes(unsafe, memOffset, columnWidth);
            }
            case 456: {
                return XML.getAsString(unsafe, memOffset, columnWidth, bs);
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        Object result = dvd.getObject();
        if (result != null) {
            return result;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    static int numDecimalDigits(int v) {
        int digits = 1;
        for (int pow10 = 10; v >= pow10; pow10 *= 10) {
            if (++digits != 10) {
                continue;
            }
            return 10;
        }
        return digits;
    }

    static int numDecimalDigits(long v) {
        int digits = 1;
        for (long pow10 = 10L; v >= pow10; pow10 *= 10L) {
            if (++digits != 19) {
                continue;
            }
            return 19;
        }
        return digits;
    }

    public static void toString(int v, ByteArrayDataOutput buffer) {
        if (v < 0) {
            if (v != Integer.MIN_VALUE) {
                v = -v;
                buffer.write(45);
            } else {
                buffer.write(INT_MIN_BYTES);
                return;
            }
        }
        int size = DataTypeUtilities.numDecimalDigits(v);
        int pos = buffer.ensureCapacity(size, buffer.position());
        pos += size;
        byte[] data = buffer.getData();
        do {
            data[--pos] = (byte)(v % 10 + 48);
        } while ((v /= 10) > 0);
        buffer.advance(size);
    }

    public static void toString(long v, ByteArrayDataOutput buffer) {
        if (v < 0L) {
            if (v != Long.MIN_VALUE) {
                v = -v;
                buffer.write(45);
            } else {
                buffer.write(LONG_MIN_BYTES);
                return;
            }
        }
        int size = DataTypeUtilities.numDecimalDigits(v);
        int pos = buffer.ensureCapacity(size, buffer.position());
        pos += size;
        byte[] data = buffer.getData();
        do {
            data[--pos] = (byte)(v % 10L + 48L);
        } while ((v /= 10L) > 0L);
        buffer.advance(size);
    }

    public static int toStringUnsigned(int v, char[] buffer, int endOffset) {
        assert (v >= 0) : Integer.toString(v);
        do {
            buffer[--endOffset] = (char)(v % 10 + 48);
        } while ((v /= 10) > 0);
        return endOffset;
    }

    public static int toStringUnsigned(long v, char[] buffer, int endOffset) {
        assert (v >= 0L) : Long.toString(v);
        do {
            buffer[--endOffset] = (char)(v % 10L + 48L);
        } while ((v /= 10L) > 0L);
        return endOffset;
    }

    public static int toStringUnsignedWithDecimalPoint(int v, char[] buffer, int endOffset, int decimalPos) {
        assert (v >= 0) : Integer.toString(v);
        do {
            if (--endOffset == decimalPos) {
                buffer[endOffset--] = 46;
            }
            buffer[endOffset] = (char)(v % 10 + 48);
        } while ((v /= 10) > 0);
        return endOffset;
    }

    public static int toStringUnsignedWithDecimalPoint(long v, char[] buffer, int endOffset, int decimalPos) {
        assert (v >= 0L) : Long.toString(v);
        do {
            if (--endOffset == decimalPos) {
                buffer[endOffset--] = 46;
            }
            buffer[endOffset] = (char)(v % 10L + 48L);
        } while ((v /= 10L) > 0L);
        return endOffset;
    }

    public static void toHexString(byte[] data, int offset, int length, ByteArrayDataOutput buffer) {
        int end = offset + length;
        while (offset < end) {
            byte b = data[offset];
            buffer.write(ClientSharedUtils.HEX_DIGITS[(b & 0xF0) >>> 4]);
            buffer.write(ClientSharedUtils.HEX_DIGITS[b & 0xF]);
            ++offset;
        }
    }

    public static void toHexString(UnsafeWrapper unsafe, long memOffset, int length, ByteArrayDataOutput buffer) {
        long memEnd = memOffset + (long)length;
        while (memOffset < memEnd) {
            byte b = unsafe.getByte(memOffset);
            buffer.write(ClientSharedUtils.HEX_DIGITS[(b & 0xF0) >>> 4]);
            buffer.write(ClientSharedUtils.HEX_DIGITS[b & 0xF]);
            ++memOffset;
        }
    }

    public static final void writeAsUTF8BytesForPXF(byte[] inBytes, int offset, int columnWidth, DataTypeDescriptor dtd, ByteArrayDataOutput buffer) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 5: {
                SQLChar.writeAsUTF8String(inBytes, offset, columnWidth, dtd, buffer);
                return;
            }
            case 13: 
            case 230: 
            case 444: 
            case 456: {
                SQLChar.writeAsUTF8String(inBytes, offset, columnWidth, columnWidth, buffer);
                return;
            }
            case 7: {
                DataTypeUtilities.toString(SQLInteger.getAsInteger(inBytes, offset), buffer);
                return;
            }
            case 11: {
                DataTypeUtilities.toString(SQLLongint.getAsLong(inBytes, offset), buffer);
                return;
            }
            case 197: {
                SQLDecimal.writeAsString(inBytes, offset, columnWidth, buffer);
                return;
            }
            case 6: {
                buffer.writeBytes(Double.toString(SQLDouble.getAsDouble(inBytes, offset)));
                return;
            }
            case 8: {
                buffer.writeBytes(Float.toString(SQLReal.getAsFloat(inBytes, offset)));
                return;
            }
            case 10: {
                DataTypeUtilities.toString(SQLSmallint.getAsShort(inBytes, offset), buffer);
                return;
            }
            case 40: {
                SQLDate.writeAsString(inBytes, offset, buffer);
                return;
            }
            case 35: {
                SQLTime.writeAsString(inBytes, offset, buffer);
                return;
            }
            case 36: {
                SQLTimestamp.writeAsString(inBytes, offset, buffer);
                return;
            }
            case 4: {
                buffer.writeBytes(Boolean.toString(SQLBoolean.getAsBoolean(inBytes, offset)));
                return;
            }
            case 195: {
                DataTypeUtilities.toString(SQLTinyint.getAsByte(inBytes, offset), buffer);
                return;
            }
            case 27: 
            case 29: 
            case 232: 
            case 440: {
                buffer.write(92);
                buffer.write(120);
                DataTypeUtilities.toHexString(inBytes, offset, columnWidth, buffer);
                return;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        String result = dvd.getString();
        if (result != null) {
            buffer.writeBytes(result);
        }
    }

    public static final void writeAsUTF8BytesForPXF(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, DataTypeDescriptor dtd, ByteArrayDataOutput buffer) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 5: {
                SQLChar.writeAsUTF8String(unsafe, memOffset, columnWidth, bs, dtd, buffer);
                return;
            }
            case 13: 
            case 230: 
            case 444: 
            case 456: {
                SQLChar.writeAsUTF8String(unsafe, memOffset, columnWidth, columnWidth, bs, buffer);
                return;
            }
            case 7: {
                DataTypeUtilities.toString(SQLInteger.getAsInteger(unsafe, memOffset), buffer);
                return;
            }
            case 11: {
                DataTypeUtilities.toString(SQLLongint.getAsLong(unsafe, memOffset), buffer);
                return;
            }
            case 197: {
                SQLDecimal.writeAsString(unsafe, memOffset, columnWidth, buffer);
                return;
            }
            case 6: {
                buffer.writeBytes(Double.toString(SQLDouble.getAsDouble(unsafe, memOffset)));
                return;
            }
            case 8: {
                buffer.writeBytes(Float.toString(SQLReal.getAsFloat(unsafe, memOffset)));
                return;
            }
            case 10: {
                DataTypeUtilities.toString(SQLSmallint.getAsShort(unsafe, memOffset), buffer);
                return;
            }
            case 40: {
                SQLDate.writeAsString(unsafe, memOffset, buffer);
                return;
            }
            case 35: {
                SQLTime.writeAsString(unsafe, memOffset, buffer);
                return;
            }
            case 36: {
                SQLTimestamp.writeAsString(unsafe, memOffset, buffer);
                return;
            }
            case 4: {
                buffer.writeBytes(Boolean.toString(SQLBoolean.getAsBoolean(unsafe, memOffset)));
                return;
            }
            case 195: {
                DataTypeUtilities.toString(SQLTinyint.getAsByte(unsafe, memOffset), buffer);
                return;
            }
            case 27: 
            case 29: 
            case 232: 
            case 440: {
                buffer.write(92);
                buffer.write(120);
                DataTypeUtilities.toHexString(unsafe, memOffset, columnWidth, buffer);
                return;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        String result = dvd.getString();
        if (result != null) {
            buffer.writeBytes(result);
        }
    }

    public static final void setInDVD(DataValueDescriptor dvd, byte[] inBytes, int offset, int columnWidth, DataTypeDescriptor dtd) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 5: {
                dvd.setValue(SQLChar.getAsString(inBytes, offset, columnWidth, dtd));
                break;
            }
            case 13: 
            case 230: 
            case 444: {
                dvd.setValue(SQLVarchar.getAsString(inBytes, offset, columnWidth));
                break;
            }
            case 7: {
                dvd.setValue(SQLInteger.getAsInteger(inBytes, offset));
                break;
            }
            case 197: {
                dvd.setBigDecimal(SQLDecimal.getAsBigDecimal(inBytes, offset, columnWidth));
                break;
            }
            case 11: {
                dvd.setValue(SQLLongint.getAsLong(inBytes, offset));
                break;
            }
            case 6: {
                dvd.setValue(SQLDouble.getAsDouble(inBytes, offset));
                break;
            }
            case 8: {
                dvd.setValue(SQLReal.getAsFloat(inBytes, offset));
                break;
            }
            case 10: {
                dvd.setValue(SQLSmallint.getAsShort(inBytes, offset));
                break;
            }
            case 40: {
                dvd.setValue(SQLDate.getAsDate(inBytes, offset, (Calendar)ClientSharedData.getDefaultCalendar()));
                break;
            }
            case 35: {
                dvd.setValue(SQLTime.getAsTime(inBytes, offset, (Calendar)ClientSharedData.getDefaultCalendar()));
                break;
            }
            case 36: {
                dvd.setValue(SQLTimestamp.getAsTimeStamp(inBytes, offset, (Calendar)ClientSharedData.getDefaultCalendar()));
                break;
            }
            case 4: {
                dvd.setValue(SQLBoolean.getAsBoolean(inBytes, offset));
                break;
            }
            case 195: {
                dvd.setValue(SQLTinyint.getAsByte(inBytes, offset));
                break;
            }
            case 27: 
            case 29: 
            case 232: 
            case 440: {
                dvd.setValue(SQLBinary.getAsBytes(inBytes, offset, columnWidth));
                break;
            }
            case 456: {
                dvd.setValue(XML.getAsString(inBytes, offset, columnWidth));
                break;
            }
            default: {
                DataValueDescriptor dvd2 = dtd.getNull();
                dvd2.readBytes(inBytes, offset, columnWidth);
                Object result = dvd2.getObject();
                if (result != null) {
                    dvd.setValue(result);
                    break;
                }
                dvd.restoreToNull();
            }
        }
    }

    public static final void setInDVD(DataValueDescriptor dvd, UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, DataTypeDescriptor dtd) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 5: {
                dvd.setValue(SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd));
                break;
            }
            case 13: 
            case 230: 
            case 444: {
                dvd.setValue(SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs));
                break;
            }
            case 7: {
                dvd.setValue(SQLInteger.getAsInteger(unsafe, memOffset));
                break;
            }
            case 197: {
                dvd.setBigDecimal(SQLDecimal.getAsBigDecimal(unsafe, memOffset, columnWidth));
                break;
            }
            case 11: {
                dvd.setValue(SQLLongint.getAsLong(unsafe, memOffset));
                break;
            }
            case 6: {
                dvd.setValue(SQLDouble.getAsDouble(unsafe, memOffset));
                break;
            }
            case 8: {
                dvd.setValue(SQLReal.getAsFloat(unsafe, memOffset));
                break;
            }
            case 10: {
                dvd.setValue(SQLSmallint.getAsShort(unsafe, memOffset));
                break;
            }
            case 40: {
                dvd.setValue(SQLDate.getAsDate(unsafe, memOffset, (Calendar)ClientSharedData.getDefaultCalendar()));
                break;
            }
            case 35: {
                dvd.setValue(SQLTime.getAsTime(unsafe, memOffset, (Calendar)ClientSharedData.getDefaultCalendar()));
                break;
            }
            case 36: {
                dvd.setValue(SQLTimestamp.getAsTimeStamp(unsafe, memOffset, (Calendar)ClientSharedData.getDefaultCalendar()));
                break;
            }
            case 4: {
                dvd.setValue(SQLBoolean.getAsBoolean(unsafe, memOffset));
                break;
            }
            case 195: {
                dvd.setValue(SQLTinyint.getAsByte(unsafe, memOffset));
                break;
            }
            case 27: 
            case 29: 
            case 232: 
            case 440: {
                dvd.setValue(SQLBinary.getAsBytes(unsafe, memOffset, columnWidth));
                break;
            }
            case 456: {
                dvd.setValue(XML.getAsString(unsafe, memOffset, columnWidth, bs));
                break;
            }
            default: {
                DataValueDescriptor dvd2 = dtd.getNull();
                dvd2.readBytes(unsafe, memOffset, columnWidth, bs);
                Object result = dvd2.getObject();
                if (result != null) {
                    dvd.setValue(result);
                    break;
                }
                dvd.restoreToNull();
            }
        }
    }

    public static final boolean getAsBoolean(byte[] inBytes, int offset, int columnWidth, DataTypeDescriptor dtd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 4: {
                return SQLBoolean.getAsBoolean(inBytes, offset);
            }
            case 6: {
                double value = SQLDouble.getAsDouble(inBytes, offset);
                return value != 0.0;
            }
            case 7: {
                int value = SQLInteger.getAsInteger(inBytes, offset);
                return value != 0;
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(inBytes, offset, columnWidth);
                if (bd != null) {
                    return SQLDecimal.getBoolean(bd);
                }
                wasNull.setWasNull();
                return false;
            }
            case 11: {
                long lv = SQLLongint.getAsLong(inBytes, offset);
                return lv != 0L;
            }
            case 8: {
                float flt = SQLReal.getAsFloat(inBytes, offset);
                return flt != 0.0f;
            }
            case 10: {
                short shrt = SQLSmallint.getAsShort(inBytes, offset);
                return shrt != 0;
            }
            case 5: {
                String str = SQLChar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    return !str.equals("0") && !str.equals("false");
                }
                wasNull.setWasNull();
                return false;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    return !str.equals("0") && !str.equals("false");
                }
                wasNull.setWasNull();
                return false;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (!dvd.isNull()) {
            return dvd.getBoolean();
        }
        wasNull.setWasNull();
        return false;
    }

    public static final boolean getAsBoolean(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, DataTypeDescriptor dtd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 4: {
                return SQLBoolean.getAsBoolean(unsafe, memOffset);
            }
            case 6: {
                double value = SQLDouble.getAsDouble(unsafe, memOffset);
                return value != 0.0;
            }
            case 7: {
                int value = SQLInteger.getAsInteger(unsafe, memOffset);
                return value != 0;
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(unsafe, memOffset, columnWidth);
                if (bd != null) {
                    return SQLDecimal.getBoolean(bd);
                }
                wasNull.setWasNull();
                return false;
            }
            case 11: {
                long lv = SQLLongint.getAsLong(unsafe, memOffset);
                return lv != 0L;
            }
            case 8: {
                float flt = SQLReal.getAsFloat(unsafe, memOffset);
                return flt != 0.0f;
            }
            case 10: {
                short shrt = SQLSmallint.getAsShort(unsafe, memOffset);
                return shrt != 0;
            }
            case 5: {
                String str = SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    return !str.equals("0") && !str.equals("false");
                }
                wasNull.setWasNull();
                return false;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    return !str.equals("0") && !str.equals("false");
                }
                wasNull.setWasNull();
                return false;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        if (!dvd.isNull()) {
            return dvd.getBoolean();
        }
        wasNull.setWasNull();
        return false;
    }

    public static final byte getAsByte(byte[] inBytes, int offset, int columnWidth, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                double value = SQLDouble.getAsDouble(inBytes, offset);
                if (value > 128.0 || value < -129.0) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                return (byte)value;
            }
            case 7: {
                int value = SQLInteger.getAsInteger(inBytes, offset);
                if (value > 127 || value < -128) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                return (byte)value;
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(inBytes, offset, columnWidth);
                if (bd != null) {
                    long lv = SQLDecimal.getLong(bd);
                    if (lv >= -128L && lv <= 127L) {
                        return (byte)lv;
                    }
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                wasNull.setWasNull();
                return 0;
            }
            case 11: {
                long lv = SQLLongint.getAsLong(inBytes, offset);
                if (lv > 127L || lv < -128L) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                return (byte)lv;
            }
            case 8: {
                float flt = SQLReal.getAsFloat(inBytes, offset);
                if ((double)flt > 128.0 || (double)flt < -129.0) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                return (byte)flt;
            }
            case 10: {
                short shrt = SQLSmallint.getAsShort(inBytes, offset);
                if (shrt > 127 || shrt < -128) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                return (byte)shrt;
            }
            case 5: {
                String str = SQLChar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Byte.parseByte(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"TINYINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Byte.parseByte(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"TINYINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (!dvd.isNull()) {
            return dvd.getByte();
        }
        wasNull.setWasNull();
        return 0;
    }

    public static final byte getAsByte(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                double value = SQLDouble.getAsDouble(unsafe, memOffset);
                if (value > 128.0 || value < -129.0) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                return (byte)value;
            }
            case 7: {
                int value = SQLInteger.getAsInteger(unsafe, memOffset);
                if (value > 127 || value < -128) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                return (byte)value;
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(unsafe, memOffset, columnWidth);
                if (bd != null) {
                    long lv = SQLDecimal.getLong(bd);
                    if (lv >= -128L && lv <= 127L) {
                        return (byte)lv;
                    }
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                wasNull.setWasNull();
                return 0;
            }
            case 11: {
                long lv = SQLLongint.getAsLong(unsafe, memOffset);
                if (lv > 127L || lv < -128L) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                return (byte)lv;
            }
            case 8: {
                float flt = SQLReal.getAsFloat(unsafe, memOffset);
                if ((double)flt > 128.0 || (double)flt < -129.0) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                return (byte)flt;
            }
            case 10: {
                short shrt = SQLSmallint.getAsShort(unsafe, memOffset);
                if (shrt > 127 || shrt < -128) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)cd.getColumnName());
                }
                return (byte)shrt;
            }
            case 5: {
                String str = SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Byte.parseByte(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"TINYINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Byte.parseByte(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"TINYINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        if (!dvd.isNull()) {
            return dvd.getByte();
        }
        wasNull.setWasNull();
        return 0;
    }

    public static final short getAsShort(byte[] inBytes, int offset, int columnWidth, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                double value = SQLDouble.getAsDouble(inBytes, offset);
                if (value > 32768.0 || value < -32769.0) {
                    throw StandardException.newException("22003", (Object)"SMALLINT", (Object)cd.getColumnName());
                }
                return (short)value;
            }
            case 7: {
                int value = SQLInteger.getAsInteger(inBytes, offset);
                if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
                    throw StandardException.newException("22003", (Object)"SMALLINT", (Object)cd.getColumnName());
                }
                return (short)value;
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(inBytes, offset, columnWidth);
                if (bd != null) {
                    long lv = SQLDecimal.getLong(bd);
                    if (lv >= -32768L && lv <= 32767L) {
                        return (short)lv;
                    }
                    throw StandardException.newException("22003", (Object)"SMALLINT", (Object)cd.getColumnName());
                }
                wasNull.setWasNull();
                return 0;
            }
            case 11: {
                long lv = SQLLongint.getAsLong(inBytes, offset);
                if (lv > 32767L || lv < -32768L) {
                    throw StandardException.newException("22003", (Object)"SMALLINT", (Object)cd.getColumnName());
                }
                return (short)lv;
            }
            case 8: {
                float flt = SQLReal.getAsFloat(inBytes, offset);
                if ((double)flt > 32768.0 || (double)flt < -32769.0) {
                    throw StandardException.newException("22003", (Object)"SMALLINT", (Object)cd.getColumnName());
                }
                return (short)flt;
            }
            case 10: {
                return SQLSmallint.getAsShort(inBytes, offset);
            }
            case 5: {
                String str = SQLChar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Short.parseShort(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"SMALLINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Short.parseShort(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"SMALLINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (!dvd.isNull()) {
            return dvd.getShort();
        }
        wasNull.setWasNull();
        return 0;
    }

    public static final short getAsShort(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                double value = SQLDouble.getAsDouble(unsafe, memOffset);
                if (value > 32768.0 || value < -32769.0) {
                    throw StandardException.newException("22003", (Object)"SMALLINT", (Object)cd.getColumnName());
                }
                return (short)value;
            }
            case 7: {
                int value = SQLInteger.getAsInteger(unsafe, memOffset);
                if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
                    throw StandardException.newException("22003", (Object)"SMALLINT", (Object)cd.getColumnName());
                }
                return (short)value;
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(unsafe, memOffset, columnWidth);
                if (bd != null) {
                    long lv = SQLDecimal.getLong(bd);
                    if (lv >= -32768L && lv <= 32767L) {
                        return (short)lv;
                    }
                    throw StandardException.newException("22003", (Object)"SMALLINT", (Object)cd.getColumnName());
                }
                wasNull.setWasNull();
                return 0;
            }
            case 11: {
                long lv = SQLLongint.getAsLong(unsafe, memOffset);
                if (lv > 32767L || lv < -32768L) {
                    throw StandardException.newException("22003", (Object)"SMALLINT", (Object)cd.getColumnName());
                }
                return (short)lv;
            }
            case 8: {
                float flt = SQLReal.getAsFloat(unsafe, memOffset);
                if ((double)flt > 32768.0 || (double)flt < -32769.0) {
                    throw StandardException.newException("22003", (Object)"SMALLINT", (Object)cd.getColumnName());
                }
                return (short)flt;
            }
            case 10: {
                return SQLSmallint.getAsShort(unsafe, memOffset);
            }
            case 5: {
                String str = SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Short.parseShort(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"SMALLINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Short.parseShort(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"SMALLINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        if (!dvd.isNull()) {
            return dvd.getShort();
        }
        wasNull.setWasNull();
        return 0;
    }

    public static final int getAsInt(byte[] inBytes, int offset, int columnWidth, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                double value = SQLDouble.getAsDouble(inBytes, offset);
                if (value > 2.147483648E9 || value < -2.147483649E9) {
                    throw StandardException.newException("22003", (Object)"INTEGER", (Object)cd.getColumnName());
                }
                return (int)value;
            }
            case 7: {
                return SQLInteger.getAsInteger(inBytes, offset);
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(inBytes, offset, columnWidth);
                if (bd != null) {
                    long lv = SQLDecimal.getLong(bd);
                    if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                        return (int)lv;
                    }
                    throw StandardException.newException("22003", (Object)"INTEGER", (Object)cd.getColumnName());
                }
                wasNull.setWasNull();
                return 0;
            }
            case 11: {
                long lv = SQLLongint.getAsLong(inBytes, offset);
                if (lv > Integer.MAX_VALUE || lv < Integer.MIN_VALUE) {
                    throw StandardException.newException("22003", (Object)"INTEGER", (Object)cd.getColumnName());
                }
                return (int)lv;
            }
            case 8: {
                float flt = SQLReal.getAsFloat(inBytes, offset);
                if ((double)flt > 2.147483648E9 || (double)flt < -2.147483649E9) {
                    throw StandardException.newException("22003", (Object)"INTEGER", (Object)cd.getColumnName());
                }
                return (int)flt;
            }
            case 10: {
                return SQLSmallint.getAsShort(inBytes, offset);
            }
            case 5: {
                String str = SQLChar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Integer.parseInt(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"INTEGER", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Integer.parseInt(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"INTEGER", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (!dvd.isNull()) {
            return dvd.getInt();
        }
        wasNull.setWasNull();
        return 0;
    }

    public static final int getAsInt(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                double value = SQLDouble.getAsDouble(unsafe, memOffset);
                if (value > 2.147483648E9 || value < -2.147483649E9) {
                    throw StandardException.newException("22003", (Object)"INTEGER", (Object)cd.getColumnName());
                }
                return (int)value;
            }
            case 7: {
                return SQLInteger.getAsInteger(unsafe, memOffset);
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(unsafe, memOffset, columnWidth);
                if (bd != null) {
                    long lv = SQLDecimal.getLong(bd);
                    if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                        return (int)lv;
                    }
                    throw StandardException.newException("22003", (Object)"INTEGER", (Object)cd.getColumnName());
                }
                wasNull.setWasNull();
                return 0;
            }
            case 11: {
                long lv = SQLLongint.getAsLong(unsafe, memOffset);
                if (lv > Integer.MAX_VALUE || lv < Integer.MIN_VALUE) {
                    throw StandardException.newException("22003", (Object)"INTEGER", (Object)cd.getColumnName());
                }
                return (int)lv;
            }
            case 8: {
                float flt = SQLReal.getAsFloat(unsafe, memOffset);
                if ((double)flt > 2.147483648E9 || (double)flt < -2.147483649E9) {
                    throw StandardException.newException("22003", (Object)"INTEGER", (Object)cd.getColumnName());
                }
                return (int)flt;
            }
            case 10: {
                return SQLSmallint.getAsShort(unsafe, memOffset);
            }
            case 5: {
                String str = SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Integer.parseInt(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"INTEGER", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Integer.parseInt(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"INTEGER", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        if (!dvd.isNull()) {
            return dvd.getInt();
        }
        wasNull.setWasNull();
        return 0;
    }

    public static final long getAsLong(byte[] inBytes, int offset, int columnWidth, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                double value = SQLDouble.getAsDouble(inBytes, offset);
                if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
                    throw StandardException.newException("22003", (Object)"BIGINT", (Object)cd.getColumnName());
                }
                return (long)value;
            }
            case 7: {
                return SQLInteger.getAsInteger(inBytes, offset);
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(inBytes, offset, columnWidth);
                if (bd != null) {
                    return SQLDecimal.getLong(bd);
                }
                wasNull.setWasNull();
                return 0L;
            }
            case 11: {
                return SQLLongint.getAsLong(inBytes, offset);
            }
            case 8: {
                float flt = SQLReal.getAsFloat(inBytes, offset);
                if ((double)flt > 9.223372036854776E18 || (double)flt < -9.223372036854776E18) {
                    throw StandardException.newException("22003", (Object)"BIGINT", (Object)cd.getColumnName());
                }
                return (long)flt;
            }
            case 10: {
                return SQLSmallint.getAsShort(inBytes, offset);
            }
            case 5: {
                String str = SQLChar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Long.parseLong(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"BIGINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0L;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Long.parseLong(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"BIGINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0L;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (!dvd.isNull()) {
            return dvd.getLong();
        }
        wasNull.setWasNull();
        return 0L;
    }

    public static final long getAsLong(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                double value = SQLDouble.getAsDouble(unsafe, memOffset);
                if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
                    throw StandardException.newException("22003", (Object)"BIGINT", (Object)cd.getColumnName());
                }
                return (long)value;
            }
            case 7: {
                return SQLInteger.getAsInteger(unsafe, memOffset);
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(unsafe, memOffset, columnWidth);
                if (bd != null) {
                    return SQLDecimal.getLong(bd);
                }
                wasNull.setWasNull();
                return 0L;
            }
            case 11: {
                return SQLLongint.getAsLong(unsafe, memOffset);
            }
            case 8: {
                float flt = SQLReal.getAsFloat(unsafe, memOffset);
                if ((double)flt > 9.223372036854776E18 || (double)flt < -9.223372036854776E18) {
                    throw StandardException.newException("22003", (Object)"BIGINT", (Object)cd.getColumnName());
                }
                return (long)flt;
            }
            case 10: {
                return SQLSmallint.getAsShort(unsafe, memOffset);
            }
            case 5: {
                String str = SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Long.parseLong(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"BIGINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0L;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Long.parseLong(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"BIGINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0L;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        if (!dvd.isNull()) {
            return dvd.getLong();
        }
        wasNull.setWasNull();
        return 0L;
    }

    public static final float getAsFloat(byte[] inBytes, int offset, int columnWidth, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                double value = SQLDouble.getAsDouble(inBytes, offset);
                if (Float.isInfinite((float)value)) {
                    throw StandardException.newException("22003", (Object)"REAL", (Object)cd.getColumnName());
                }
                return (float)value;
            }
            case 7: {
                return SQLInteger.getAsInteger(inBytes, offset);
            }
            case 197: {
                BigDecimal localValue = SQLDecimal.getAsBigDecimal(inBytes, offset, columnWidth);
                if (localValue != null) {
                    return NumberDataType.normalizeREAL(localValue.floatValue());
                }
                wasNull.setWasNull();
                return 0.0f;
            }
            case 11: {
                return SQLLongint.getAsLong(inBytes, offset);
            }
            case 8: {
                return SQLReal.getAsFloat(inBytes, offset);
            }
            case 10: {
                return SQLSmallint.getAsShort(inBytes, offset);
            }
            case 5: {
                String str = SQLChar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Float.parseFloat(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"BIGINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0.0f;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Float.parseFloat(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"BIGINT", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0.0f;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (!dvd.isNull()) {
            return dvd.getFloat();
        }
        wasNull.setWasNull();
        return 0.0f;
    }

    public static final float getAsFloat(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                double value = SQLDouble.getAsDouble(unsafe, memOffset);
                if (Float.isInfinite((float)value)) {
                    throw StandardException.newException("22003", (Object)"REAL", (Object)cd.getColumnName());
                }
                return (float)value;
            }
            case 7: {
                return SQLInteger.getAsInteger(unsafe, memOffset);
            }
            case 197: {
                BigDecimal localValue = SQLDecimal.getAsBigDecimal(unsafe, memOffset, columnWidth);
                if (localValue != null) {
                    return NumberDataType.normalizeREAL(localValue.floatValue());
                }
                wasNull.setWasNull();
                return 0.0f;
            }
            case 11: {
                return SQLLongint.getAsLong(unsafe, memOffset);
            }
            case 8: {
                return SQLReal.getAsFloat(unsafe, memOffset);
            }
            case 10: {
                return SQLSmallint.getAsShort(unsafe, memOffset);
            }
            case 5: {
                String str = SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Float.parseFloat(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"REAL", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0.0f;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Float.parseFloat(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"REAL", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0.0f;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        if (!dvd.isNull()) {
            return dvd.getFloat();
        }
        wasNull.setWasNull();
        return 0.0f;
    }

    public static final double getAsDouble(byte[] inBytes, int offset, int columnWidth, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                return SQLDouble.getAsDouble(inBytes, offset);
            }
            case 7: {
                return SQLInteger.getAsInteger(inBytes, offset);
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(inBytes, offset, columnWidth);
                if (bd != null) {
                    return SQLDecimal.getDouble(bd);
                }
                wasNull.setWasNull();
                return 0.0;
            }
            case 11: {
                return SQLLongint.getAsLong(inBytes, offset);
            }
            case 8: {
                return SQLReal.getAsFloat(inBytes, offset);
            }
            case 10: {
                return SQLSmallint.getAsShort(inBytes, offset);
            }
            case 5: {
                String str = SQLChar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Double.parseDouble(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"DOUBLE", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0.0;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(inBytes, offset, columnWidth, dtd).trim();
                if (str != null) {
                    try {
                        return Double.parseDouble(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"DOUBLE", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0.0;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (!dvd.isNull()) {
            return dvd.getDouble();
        }
        wasNull.setWasNull();
        return 0.0;
    }

    public static final double getAsDouble(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 6: {
                return SQLDouble.getAsDouble(unsafe, memOffset);
            }
            case 7: {
                return SQLInteger.getAsInteger(unsafe, memOffset);
            }
            case 197: {
                BigDecimal bd = SQLDecimal.getAsBigDecimal(unsafe, memOffset, columnWidth);
                if (bd != null) {
                    return SQLDecimal.getDouble(bd);
                }
                wasNull.setWasNull();
                return 0.0;
            }
            case 11: {
                return SQLLongint.getAsLong(unsafe, memOffset);
            }
            case 8: {
                return SQLReal.getAsFloat(unsafe, memOffset);
            }
            case 10: {
                return SQLSmallint.getAsShort(unsafe, memOffset);
            }
            case 5: {
                String str = SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Double.parseDouble(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"DOUBLE", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0.0;
            }
            case 13: 
            case 230: 
            case 444: {
                String str = SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs, dtd).trim();
                if (str != null) {
                    try {
                        return Double.parseDouble(str);
                    }
                    catch (NumberFormatException nfe) {
                        throw StandardException.newException("22018", (Object)"DOUBLE", (Object)cd.getColumnName());
                    }
                }
                wasNull.setWasNull();
                return 0.0;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        if (!dvd.isNull()) {
            return dvd.getDouble();
        }
        wasNull.setWasNull();
        return 0.0;
    }

    public static final BigDecimal getAsBigDecimal(byte[] inBytes, int offset, int columnWidth, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        try {
            switch (formatID) {
                case 197: {
                    BigDecimal bd = SQLDecimal.getAsBigDecimal(inBytes, offset, columnWidth);
                    if (bd != null) {
                        return bd;
                    }
                    wasNull.setWasNull();
                    return null;
                }
                case 6: {
                    double value = SQLDouble.getAsDouble(inBytes, offset);
                    return BigDecimal.valueOf(value);
                }
                case 8: {
                    float flt = SQLReal.getAsFloat(inBytes, offset);
                    return new BigDecimal(Float.toString(flt));
                }
                case 7: {
                    int v = SQLInteger.getAsInteger(inBytes, offset);
                    return BigDecimal.valueOf(v);
                }
                case 11: {
                    long v = SQLLongint.getAsLong(inBytes, offset);
                    return BigDecimal.valueOf(v);
                }
                case 10: {
                    short v = SQLSmallint.getAsShort(inBytes, offset);
                    return BigDecimal.valueOf(v);
                }
                case 5: {
                    String str = SQLChar.getAsString(inBytes, offset, columnWidth, dtd);
                    if (str != null) {
                        return new BigDecimal(str);
                    }
                    wasNull.setWasNull();
                    return BigDecimal.ZERO;
                }
                case 13: 
                case 230: {
                    String str = SQLVarchar.getAsString(inBytes, offset, columnWidth);
                    if (str != null) {
                        return new BigDecimal(str);
                    }
                    wasNull.setWasNull();
                    return BigDecimal.ZERO;
                }
            }
            DataValueDescriptor dvd = dtd.getNull();
            dvd.readBytes(inBytes, offset, columnWidth);
            if (!dvd.isNull()) {
                return SQLDecimal.getBigDecimal(dvd);
            }
            wasNull.setWasNull();
            return null;
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", (Object)"java.math.BigDecimal", (Object)cd.getColumnName());
        }
    }

    public static final BigDecimal getAsBigDecimal(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, ColumnDescriptor cd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        DataTypeDescriptor dtd = cd.getType();
        int formatID = dtd.getTypeId().getTypeFormatId();
        try {
            switch (formatID) {
                case 197: {
                    BigDecimal bd = SQLDecimal.getAsBigDecimal(unsafe, memOffset, columnWidth);
                    if (bd != null) {
                        return bd;
                    }
                    wasNull.setWasNull();
                    return null;
                }
                case 6: {
                    double value = SQLDouble.getAsDouble(unsafe, memOffset);
                    return BigDecimal.valueOf(value);
                }
                case 8: {
                    float flt = SQLReal.getAsFloat(unsafe, memOffset);
                    return new BigDecimal(Float.toString(flt));
                }
                case 7: {
                    int v = SQLInteger.getAsInteger(unsafe, memOffset);
                    return BigDecimal.valueOf(v);
                }
                case 11: {
                    long v = SQLLongint.getAsLong(unsafe, memOffset);
                    return BigDecimal.valueOf(v);
                }
                case 10: {
                    short v = SQLSmallint.getAsShort(unsafe, memOffset);
                    return BigDecimal.valueOf(v);
                }
                case 5: {
                    String str = SQLChar.getAsString(unsafe, memOffset, columnWidth, bs, dtd);
                    if (str != null) {
                        return new BigDecimal(str);
                    }
                    wasNull.setWasNull();
                    return BigDecimal.ZERO;
                }
                case 13: 
                case 230: {
                    String str = SQLVarchar.getAsString(unsafe, memOffset, columnWidth, bs);
                    if (str != null) {
                        return new BigDecimal(str);
                    }
                    wasNull.setWasNull();
                    return BigDecimal.ZERO;
                }
            }
            DataValueDescriptor dvd = dtd.getNull();
            dvd.readBytes(unsafe, memOffset, columnWidth, bs);
            if (!dvd.isNull()) {
                return SQLDecimal.getBigDecimal(dvd);
            }
            wasNull.setWasNull();
            return null;
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", (Object)"java.math.BigDecimal", (Object)cd.getColumnName());
        }
    }

    public static final byte[] getAsBytes(byte[] inBytes, int offset, int columnWidth, DataTypeDescriptor dtd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 27: 
            case 29: 
            case 232: 
            case 440: {
                if (offset == 0 && columnWidth == inBytes.length) {
                    return inBytes;
                }
                byte[] bytes = new byte[columnWidth];
                System.arraycopy(inBytes, offset, bytes, 0, columnWidth);
                return bytes;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (!dvd.isNull()) {
            return dvd.getBytes();
        }
        wasNull.setWasNull();
        return null;
    }

    public static final byte[] getAsBytes(UnsafeWrapper unsafe, long memAddr, int addrOffset, int columnWidth, OffHeapByteSource bs, DataTypeDescriptor dtd, ResultWasNull wasNull) throws StandardException {
        assert (wasNull != null);
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 27: 
            case 29: 
            case 232: 
            case 440: {
                byte[] bytes = new byte[columnWidth];
                UnsafeMemoryChunk.readAbsoluteBytes((long)memAddr, (int)addrOffset, (byte[])bytes, (int)0, (int)columnWidth);
                return bytes;
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memAddr + (long)addrOffset, columnWidth, bs);
        if (!dvd.isNull()) {
            return dvd.getBytes();
        }
        wasNull.setWasNull();
        return null;
    }

    public static final Date getAsDate(byte[] inBytes, int offset, int columnWidth, Calendar cal, DataTypeDescriptor dtd) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 40: {
                return SQLDate.getAsDate(inBytes, offset, cal);
            }
            case 36: {
                return SQLTimestamp.getAsDate(inBytes, offset, cal);
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (dvd.isNull()) {
            return null;
        }
        return dvd.getDate(cal);
    }

    public static final Date getAsDate(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, Calendar cal, DataTypeDescriptor dtd) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 40: {
                return SQLDate.getAsDate(unsafe, memOffset, cal);
            }
            case 36: {
                return SQLTimestamp.getAsDate(unsafe, memOffset, cal);
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        if (dvd.isNull()) {
            return null;
        }
        return dvd.getDate(cal);
    }

    public static final Timestamp getAsTimestamp(byte[] inBytes, int offset, int columnWidth, Calendar cal, DataTypeDescriptor dtd) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 40: {
                return SQLDate.getAsTimeStamp(inBytes, offset, cal);
            }
            case 35: {
                return SQLTime.getAsTimestamp(inBytes, offset, cal);
            }
            case 36: {
                return SQLTimestamp.getAsTimeStamp(inBytes, offset, cal);
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (dvd.isNull()) {
            return null;
        }
        return dvd.getTimestamp(cal);
    }

    public static final Timestamp getAsTimestamp(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, Calendar cal, DataTypeDescriptor dtd) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 40: {
                return SQLDate.getAsTimeStamp(unsafe, memOffset, cal);
            }
            case 35: {
                return SQLTime.getAsTimestamp(unsafe, memOffset, cal);
            }
            case 36: {
                return SQLTimestamp.getAsTimeStamp(unsafe, memOffset, cal);
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        if (dvd.isNull()) {
            return null;
        }
        return dvd.getTimestamp(cal);
    }

    public static final Time getAsTime(byte[] inBytes, int offset, int columnWidth, Calendar cal, DataTypeDescriptor dtd) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 35: {
                return SQLTime.getAsTime(inBytes, offset, cal);
            }
            case 36: {
                return SQLTimestamp.getAsTime(inBytes, offset, cal);
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(inBytes, offset, columnWidth);
        if (dvd.isNull()) {
            return null;
        }
        return dvd.getTime(cal);
    }

    public static final Time getAsTime(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, Calendar cal, DataTypeDescriptor dtd) throws StandardException {
        int formatID = dtd.getTypeId().getTypeFormatId();
        switch (formatID) {
            case 35: {
                return SQLTime.getAsTime(unsafe, memOffset, cal);
            }
            case 36: {
                return SQLTimestamp.getAsTime(unsafe, memOffset, cal);
            }
        }
        DataValueDescriptor dvd = dtd.getNull();
        dvd.readBytes(unsafe, memOffset, columnWidth, bs);
        if (dvd.isNull()) {
            return null;
        }
        return dvd.getTime(cal);
    }

    public static final int compare(UnsafeWrapper unsafe, byte[] lhsBytes, long lhsMemAddr, OffHeapByteSource lhsBS, byte[] rhsBytes, long rhsMemAddr, OffHeapByteSource rhsBS, long lhsOffsetWidth, long rhsOffsetWidth, boolean nullsOrderedLow, boolean caseSensitive, ColumnDescriptor cd) throws StandardException {
        int rhsColumnWidth;
        int rhsOffset;
        if (lhsBS == null && rhsBS == null) {
            return DataTypeUtilities.compare(lhsBytes, rhsBytes, lhsOffsetWidth, rhsOffsetWidth, nullsOrderedLow, caseSensitive, cd);
        }
        if (lhsOffsetWidth == -6L && cd.columnDefault == null) {
            lhsOffsetWidth = -7L;
        }
        if (rhsOffsetWidth == -6L && cd.columnDefault == null) {
            rhsOffsetWidth = -7L;
        }
        if (lhsOffsetWidth == -7L) {
            if (rhsOffsetWidth == -7L) {
                return 0;
            }
            return nullsOrderedLow ? -1073741823 : 0x3FFFFFFF;
        }
        if (rhsOffsetWidth == -7L) {
            return nullsOrderedLow ? 0x3FFFFFFF : -1073741823;
        }
        DataTypeDescriptor dtd = cd.getType();
        TypeId typeId = dtd.getTypeId();
        int formatID = typeId.getTypeFormatId();
        int lhsColumnWidth = (int)(lhsOffsetWidth & 0xFFFFFFFFFFFFFFFFL);
        int lhsOffset = (int)(lhsOffsetWidth >>> 32);
        if (rhsOffsetWidth == -6L) {
            if (lhsOffsetWidth == -6L) {
                return 0;
            }
            rhsBytes = cd.columnDefaultBytes;
            rhsMemAddr = 0L;
            rhsBS = null;
            rhsOffset = 0;
            rhsColumnWidth = rhsBytes != null ? rhsBytes.length : 0;
        } else {
            if (lhsOffsetWidth == -6L) {
                lhsBytes = cd.columnDefaultBytes;
                lhsMemAddr = 0L;
                lhsBS = null;
                lhsOffset = 0;
                lhsColumnWidth = lhsBytes != null ? lhsBytes.length : 0;
            }
            rhsColumnWidth = (int)(rhsOffsetWidth & 0xFFFFFFFFFFFFFFFFL);
            rhsOffset = (int)(rhsOffsetWidth >>> 32);
        }
        switch (formatID) {
            case 10: {
                short lhsV = lhsMemAddr != 0L ? SQLSmallint.getAsShort(unsafe, lhsMemAddr + (long)lhsOffset) : SQLSmallint.getAsShort(lhsBytes, lhsOffset);
                short rhsV = rhsMemAddr != 0L ? SQLSmallint.getAsShort(unsafe, rhsMemAddr + (long)rhsOffset) : SQLSmallint.getAsShort(rhsBytes, rhsOffset);
                return lhsV - rhsV;
            }
            case 7: {
                long lhsV = lhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, lhsMemAddr + (long)lhsOffset) : (long)SQLInteger.getAsInteger(lhsBytes, lhsOffset);
                long rhsV = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset);
                return (int)(lhsV - rhsV);
            }
            case 11: {
                long rhsV;
                long lhsV = lhsMemAddr != 0L ? SQLLongint.getAsLong(unsafe, lhsMemAddr + (long)lhsOffset) : SQLLongint.getAsLong(lhsBytes, lhsOffset);
                long l = rhsV = rhsMemAddr != 0L ? SQLLongint.getAsLong(unsafe, rhsMemAddr + (long)rhsOffset) : SQLLongint.getAsLong(rhsBytes, rhsOffset);
                return lhsV < rhsV ? -1 : (lhsV == rhsV ? 0 : 1);
            }
            case 6: {
                double lhsV = lhsMemAddr != 0L ? SQLDouble.getAsDouble(unsafe, lhsMemAddr + (long)lhsOffset) : SQLDouble.getAsDouble(lhsBytes, lhsOffset);
                double rhsV = rhsMemAddr != 0L ? SQLDouble.getAsDouble(unsafe, rhsMemAddr + (long)rhsOffset) : SQLDouble.getAsDouble(rhsBytes, rhsOffset);
                return Double.compare(lhsV, rhsV);
            }
            case 8: {
                float lhsV = lhsMemAddr != 0L ? SQLReal.getAsFloat(unsafe, lhsMemAddr + (long)lhsOffset) : SQLReal.getAsFloat(lhsBytes, lhsOffset);
                float rhsV = rhsMemAddr != 0L ? SQLReal.getAsFloat(unsafe, rhsMemAddr + (long)rhsOffset) : SQLReal.getAsFloat(rhsBytes, rhsOffset);
                return Float.compare(lhsV, rhsV);
            }
            case 5: 
            case 13: 
            case 230: 
            case 444: 
            case 456: {
                if (caseSensitive) {
                    if (lhsBS != null) {
                        if (rhsBS != null) {
                            return SQLChar.compareString(unsafe, lhsMemAddr + (long)lhsOffset, lhsColumnWidth, lhsBS, rhsMemAddr + (long)rhsOffset, rhsColumnWidth, rhsBS);
                        }
                        return -Integer.signum(SQLChar.compareString(unsafe, rhsBytes, rhsOffset, rhsColumnWidth, lhsMemAddr + (long)lhsOffset, lhsColumnWidth, lhsBS));
                    }
                    if (rhsBS != null) {
                        return SQLChar.compareString(unsafe, lhsBytes, lhsOffset, lhsColumnWidth, rhsMemAddr + (long)rhsOffset, rhsColumnWidth, rhsBS);
                    }
                    return SQLChar.compareString(lhsBytes, lhsOffset, lhsColumnWidth, rhsBytes, rhsOffset, rhsColumnWidth);
                }
                if (lhsBS != null) {
                    if (rhsBS != null) {
                        return SQLChar.compareStringIgnoreCase(unsafe, lhsMemAddr + (long)lhsOffset, lhsColumnWidth, lhsBS, rhsMemAddr + (long)rhsOffset, rhsColumnWidth, rhsBS);
                    }
                    return -Integer.signum(SQLChar.compareStringIgnoreCase(unsafe, rhsBytes, rhsOffset, rhsColumnWidth, lhsMemAddr + (long)lhsOffset, lhsColumnWidth, lhsBS));
                }
                if (rhsBS != null) {
                    return SQLChar.compareStringIgnoreCase(unsafe, lhsBytes, lhsOffset, lhsColumnWidth, rhsMemAddr + (long)rhsOffset, rhsColumnWidth, rhsBS);
                }
                return SQLChar.compareStringIgnoreCase(lhsBytes, lhsOffset, lhsColumnWidth, rhsBytes, rhsOffset, rhsColumnWidth);
            }
            case 197: {
                BigDecimal rhsV;
                BigDecimal lhsV = lhsMemAddr != 0L ? SQLDecimal.getAsBigDecimal(unsafe, lhsMemAddr + (long)lhsOffset, lhsColumnWidth) : SQLDecimal.getAsBigDecimal(lhsBytes, lhsOffset, lhsColumnWidth);
                BigDecimal bigDecimal = rhsV = rhsMemAddr != 0L ? SQLDecimal.getAsBigDecimal(unsafe, rhsMemAddr + (long)rhsOffset, rhsColumnWidth) : SQLDecimal.getAsBigDecimal(rhsBytes, rhsOffset, rhsColumnWidth);
                if (lhsV != null) {
                    if (rhsV != null) {
                        return lhsV.compareTo(rhsV);
                    }
                    return 1;
                }
                return rhsV == null ? 0 : -1;
            }
            case 40: {
                long lhsEncodedDate = lhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, lhsMemAddr + (long)lhsOffset) : (long)SQLInteger.getAsInteger(lhsBytes, lhsOffset);
                long rhsEncodedDate = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset);
                return (int)(lhsEncodedDate - rhsEncodedDate);
            }
            case 35: {
                long lhsEncodedTime = lhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, lhsMemAddr + (long)lhsOffset) : (long)SQLInteger.getAsInteger(lhsBytes, lhsOffset);
                long rhsEncodedTime = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset);
                return (int)(lhsEncodedTime - rhsEncodedTime);
            }
            case 36: {
                long rhsEncodedTime;
                long rhsEncodedDate;
                long lhsEncodedDate = lhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, lhsMemAddr + (long)lhsOffset) : (long)SQLInteger.getAsInteger(lhsBytes, lhsOffset);
                long l = rhsEncodedDate = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset);
                if (lhsEncodedDate < rhsEncodedDate) {
                    return -1;
                }
                if (lhsEncodedDate > rhsEncodedDate) {
                    return 1;
                }
                long lhsEncodedTime = lhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, lhsMemAddr + (long)lhsOffset) : (long)SQLInteger.getAsInteger(lhsBytes, lhsOffset += 4);
                long l2 = rhsEncodedTime = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset += 4);
                if (lhsEncodedTime < rhsEncodedTime) {
                    return -1;
                }
                if (lhsEncodedTime > rhsEncodedTime) {
                    return 1;
                }
                long lhsNanos = lhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, lhsMemAddr + (long)lhsOffset) : (long)SQLInteger.getAsInteger(lhsBytes, lhsOffset += 4);
                long rhsNanos = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset += 4);
                return (int)(lhsNanos - rhsNanos);
            }
            case 4: 
            case 195: {
                byte lhsV = lhsMemAddr != 0L ? SQLTinyint.getAsByte(unsafe, lhsMemAddr + (long)lhsOffset) : SQLTinyint.getAsByte(lhsBytes, lhsOffset);
                byte rhsV = rhsMemAddr != 0L ? SQLTinyint.getAsByte(unsafe, rhsMemAddr + (long)rhsOffset) : SQLTinyint.getAsByte(rhsBytes, rhsOffset);
                return lhsV - rhsV;
            }
        }
        DataValueDescriptor lhsDVD = dtd.getNull();
        if (lhsBS != null) {
            lhsDVD.readBytes(unsafe, lhsMemAddr + (long)lhsOffset, lhsColumnWidth, lhsBS);
        } else {
            lhsDVD.readBytes(lhsBytes, lhsOffset, lhsColumnWidth);
        }
        DataValueDescriptor rhsDVD = dtd.getNull();
        if (rhsBS != null) {
            rhsDVD.readBytes(unsafe, rhsMemAddr + (long)rhsOffset, rhsColumnWidth, rhsBS);
        } else {
            rhsDVD.readBytes(rhsBytes, rhsOffset, rhsColumnWidth);
        }
        return lhsDVD.compare(rhsDVD);
    }

    public static final int compare(UnsafeWrapper unsafe, DataValueDescriptor lhsDVD, byte[] rhsBytes, long rhsMemAddr, OffHeapByteSource rhsBS, long rhsOffsetWidth, boolean nullsOrderedLow, boolean caseSensitive, ColumnDescriptor cd) throws StandardException {
        int rhsColumnWidth;
        int rhsOffset;
        boolean lhsIsNull = false;
        if (lhsDVD.getClass() == BinarySQLHybridType.class) {
            BinarySQLHybridType bt = (BinarySQLHybridType)lhsDVD;
            lhsDVD = bt.sqlValue;
            if (lhsDVD == null) {
                byte[] lhsBytes = bt.byteValue;
                long lhsOffsetWidth = lhsBytes != null ? (long)lhsBytes.length : -7L;
                return DataTypeUtilities.compare(unsafe, lhsBytes, 0L, null, rhsBytes, rhsMemAddr, rhsBS, lhsOffsetWidth, rhsOffsetWidth, nullsOrderedLow, caseSensitive, cd);
            }
            if (lhsDVD.isNull()) {
                lhsIsNull = true;
            }
        } else if (lhsDVD.isNull()) {
            lhsIsNull = true;
        }
        if (rhsOffsetWidth == -6L && cd.columnDefault == null) {
            rhsOffsetWidth = -7L;
        }
        if (lhsIsNull) {
            if (rhsOffsetWidth == -7L) {
                return 0;
            }
            return nullsOrderedLow ? -1073741823 : 0x3FFFFFFF;
        }
        if (rhsOffsetWidth == -7L) {
            return nullsOrderedLow ? 0x3FFFFFFF : -1073741823;
        }
        DataTypeDescriptor dtd = cd.getType();
        TypeId typeId = dtd.getTypeId();
        int formatID = typeId.getTypeFormatId();
        if (rhsOffsetWidth == -6L) {
            rhsBytes = cd.columnDefaultBytes;
            rhsMemAddr = 0L;
            rhsBS = null;
            rhsOffset = 0;
            rhsColumnWidth = rhsBytes != null ? rhsBytes.length : 0;
        } else {
            rhsColumnWidth = (int)(rhsOffsetWidth & 0xFFFFFFFFFFFFFFFFL);
            rhsOffset = (int)(rhsOffsetWidth >>> 32);
        }
        switch (formatID) {
            case 10: {
                short lhsV = lhsDVD.getShort();
                short rhsV = rhsMemAddr != 0L ? SQLSmallint.getAsShort(unsafe, rhsMemAddr + (long)rhsOffset) : SQLSmallint.getAsShort(rhsBytes, rhsOffset);
                return lhsV - rhsV;
            }
            case 7: {
                long lhsV = lhsDVD.getInt();
                long rhsV = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset);
                return (int)(lhsV - rhsV);
            }
            case 11: {
                long rhsV;
                long lhsV = lhsDVD.getLong();
                long l = rhsV = rhsMemAddr != 0L ? SQLLongint.getAsLong(unsafe, rhsMemAddr + (long)rhsOffset) : SQLLongint.getAsLong(rhsBytes, rhsOffset);
                return lhsV < rhsV ? -1 : (lhsV == rhsV ? 0 : 1);
            }
            case 6: {
                double lhsV = lhsDVD.getDouble();
                double rhsV = rhsMemAddr != 0L ? SQLDouble.getAsDouble(unsafe, rhsMemAddr + (long)rhsOffset) : SQLDouble.getAsDouble(rhsBytes, rhsOffset);
                return Double.compare(lhsV, rhsV);
            }
            case 8: {
                float lhsV = lhsDVD.getFloat();
                float rhsV = rhsMemAddr != 0L ? SQLReal.getAsFloat(unsafe, rhsMemAddr + (long)rhsOffset) : SQLReal.getAsFloat(rhsBytes, rhsOffset);
                return Float.compare(lhsV, rhsV);
            }
            case 5: 
            case 13: 
            case 230: 
            case 444: 
            case 456: {
                String lhsStr = lhsDVD.getString();
                if (caseSensitive) {
                    if (rhsBS != null) {
                        return SQLChar.compareString(unsafe, lhsStr, rhsMemAddr + (long)rhsOffset, rhsColumnWidth, rhsBS);
                    }
                    return SQLChar.compareString(lhsStr, rhsBytes, rhsOffset, rhsColumnWidth);
                }
                if (rhsBS != null) {
                    return SQLChar.compareStringIgnoreCase(unsafe, lhsStr, rhsMemAddr + (long)rhsOffset, rhsColumnWidth, rhsBS);
                }
                return SQLChar.compareStringIgnoreCase(lhsStr, rhsBytes, rhsOffset, rhsColumnWidth);
            }
            case 197: {
                BigDecimal rhsV;
                BigDecimal lhsV = (BigDecimal)lhsDVD.getObject();
                BigDecimal bigDecimal = rhsV = rhsMemAddr != 0L ? SQLDecimal.getAsBigDecimal(unsafe, rhsMemAddr + (long)rhsOffset, rhsColumnWidth) : SQLDecimal.getAsBigDecimal(rhsBytes, rhsOffset, rhsColumnWidth);
                if (lhsV != null) {
                    if (rhsV != null) {
                        return lhsV.compareTo(rhsV);
                    }
                    return 1;
                }
                return rhsV == null ? 0 : -1;
            }
            case 40: {
                long lhsEncodedDate = ((DateTimeDataValue)lhsDVD).getEncodedDate();
                long rhsEncodedDate = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset);
                return (int)(lhsEncodedDate - rhsEncodedDate);
            }
            case 35: {
                long lhsEncodedTime = ((DateTimeDataValue)lhsDVD).getEncodedTime();
                long rhsEncodedTime = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset);
                return (int)(lhsEncodedTime - rhsEncodedTime);
            }
            case 36: {
                long rhsEncodedTime;
                long rhsEncodedDate;
                DateTimeDataValue ts = (DateTimeDataValue)lhsDVD;
                int lhsEncodedDate = ts.getEncodedDate();
                long l = rhsEncodedDate = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset);
                if ((long)lhsEncodedDate < rhsEncodedDate) {
                    return -1;
                }
                if ((long)lhsEncodedDate > rhsEncodedDate) {
                    return 1;
                }
                int lhsEncodedTime = ts.getEncodedTime();
                long l2 = rhsEncodedTime = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset += 4);
                if ((long)lhsEncodedTime < rhsEncodedTime) {
                    return -1;
                }
                if ((long)lhsEncodedTime > rhsEncodedTime) {
                    return 1;
                }
                long lhsNanos = ts.getNanos();
                long rhsNanos = rhsMemAddr != 0L ? (long)SQLInteger.getAsInteger(unsafe, rhsMemAddr + (long)rhsOffset) : (long)SQLInteger.getAsInteger(rhsBytes, rhsOffset += 4);
                return (int)(lhsNanos - rhsNanos);
            }
            case 4: 
            case 195: {
                byte lhsV = lhsDVD.getByte();
                byte rhsV = rhsMemAddr != 0L ? SQLTinyint.getAsByte(unsafe, rhsMemAddr + (long)rhsOffset) : SQLTinyint.getAsByte(rhsBytes, rhsOffset);
                return lhsV - rhsV;
            }
        }
        DataValueDescriptor rhsDVD = dtd.getNull();
        if (rhsBS != null) {
            rhsDVD.readBytes(unsafe, rhsMemAddr + (long)rhsOffset, rhsColumnWidth, rhsBS);
        } else {
            rhsDVD.readBytes(rhsBytes, rhsOffset, rhsColumnWidth);
        }
        return lhsDVD.compare(rhsDVD);
    }

    public static final int compare(byte[] lhs, byte[] rhs, long lhsOffsetWidth, long rhsOffsetWidth, boolean nullsOrderedLow, boolean caseSensitive, ColumnDescriptor cd) throws StandardException {
        int rhsColumnWidth;
        int rhsOffset;
        if (lhsOffsetWidth == -6L && cd.columnDefault == null) {
            lhsOffsetWidth = -7L;
        }
        if (rhsOffsetWidth == -6L && cd.columnDefault == null) {
            rhsOffsetWidth = -7L;
        }
        if (lhsOffsetWidth == -7L) {
            if (rhsOffsetWidth == -7L) {
                return 0;
            }
            return nullsOrderedLow ? -1073741823 : 0x3FFFFFFF;
        }
        if (rhsOffsetWidth == -7L) {
            return nullsOrderedLow ? 0x3FFFFFFF : -1073741823;
        }
        DataTypeDescriptor dtd = cd.getType();
        TypeId typeId = dtd.getTypeId();
        int formatID = typeId.getTypeFormatId();
        int lhsColumnWidth = (int)(lhsOffsetWidth & 0xFFFFFFFFFFFFFFFFL);
        int lhsOffset = (int)(lhsOffsetWidth >>> 32);
        if (rhsOffsetWidth == -6L) {
            if (lhsOffsetWidth == -6L) {
                return 0;
            }
            rhs = cd.columnDefaultBytes;
            rhsOffset = 0;
            rhsColumnWidth = rhs.length;
        } else {
            if (lhsOffsetWidth == -6L) {
                lhs = cd.columnDefaultBytes;
                lhsOffset = 0;
                lhsColumnWidth = lhs.length;
            }
            rhsColumnWidth = (int)(rhsOffsetWidth & 0xFFFFFFFFFFFFFFFFL);
            rhsOffset = (int)(rhsOffsetWidth >>> 32);
        }
        switch (formatID) {
            case 10: {
                short lhsV = SQLSmallint.getAsShort(lhs, lhsOffset);
                short rhsV = SQLSmallint.getAsShort(rhs, rhsOffset);
                return lhsV - rhsV;
            }
            case 7: {
                long lhsV = SQLInteger.getAsInteger(lhs, lhsOffset);
                long rhsV = SQLInteger.getAsInteger(rhs, rhsOffset);
                return (int)(lhsV - rhsV);
            }
            case 11: {
                long lhsV = SQLLongint.getAsLong(lhs, lhsOffset);
                long rhsV = SQLLongint.getAsLong(rhs, rhsOffset);
                return lhsV < rhsV ? -1 : (lhsV == rhsV ? 0 : 1);
            }
            case 6: {
                double lhsV = SQLDouble.getAsDouble(lhs, lhsOffset);
                double rhsV = SQLDouble.getAsDouble(rhs, rhsOffset);
                return Double.compare(lhsV, rhsV);
            }
            case 8: {
                float lhsV = SQLReal.getAsFloat(lhs, lhsOffset);
                float rhsV = SQLReal.getAsFloat(rhs, rhsOffset);
                return Float.compare(lhsV, rhsV);
            }
            case 5: 
            case 13: 
            case 230: 
            case 444: 
            case 456: {
                return caseSensitive ? SQLChar.compareString(lhs, lhsOffset, lhsColumnWidth, rhs, rhsOffset, rhsColumnWidth) : SQLChar.compareStringIgnoreCase(lhs, lhsOffset, lhsColumnWidth, rhs, rhsOffset, rhsColumnWidth);
            }
            case 197: {
                BigDecimal lhsV = SQLDecimal.getAsBigDecimal(lhs, lhsOffset, lhsColumnWidth);
                BigDecimal rhsV = SQLDecimal.getAsBigDecimal(rhs, rhsOffset, rhsColumnWidth);
                if (lhsV != null) {
                    if (rhsV != null) {
                        return lhsV.compareTo(rhsV);
                    }
                    return 1;
                }
                return rhsV == null ? 0 : -1;
            }
            case 40: {
                long lhsEncodedDate = RowFormatter.readInt(lhs, lhsOffset);
                long rhsEncodedDate = RowFormatter.readInt(rhs, rhsOffset);
                return (int)(lhsEncodedDate - rhsEncodedDate);
            }
            case 35: {
                long lhsEncodedTime = RowFormatter.readInt(lhs, lhsOffset);
                long rhsEncodedTime = RowFormatter.readInt(rhs, rhsOffset);
                return (int)(lhsEncodedTime - rhsEncodedTime);
            }
            case 36: {
                int rhsEncodedTime;
                int lhsEncodedDate = RowFormatter.readInt(lhs, lhsOffset);
                int rhsEncodedDate = RowFormatter.readInt(rhs, rhsOffset);
                if (lhsEncodedDate < rhsEncodedDate) {
                    return -1;
                }
                if (lhsEncodedDate > rhsEncodedDate) {
                    return 1;
                }
                int lhsEncodedTime = RowFormatter.readInt(lhs, lhsOffset += 4);
                if (lhsEncodedTime < (rhsEncodedTime = RowFormatter.readInt(rhs, rhsOffset += 4))) {
                    return -1;
                }
                if (lhsEncodedTime > rhsEncodedTime) {
                    return 1;
                }
                long lhsNanos = RowFormatter.readInt(lhs, lhsOffset += 4);
                long rhsNanos = RowFormatter.readInt(rhs, rhsOffset += 4);
                return (int)(lhsNanos - rhsNanos);
            }
            case 4: 
            case 195: {
                return lhs[0] - rhs[0];
            }
        }
        DataValueDescriptor lhsDVD = dtd.getNull();
        lhsDVD.readBytes(lhs, lhsOffset, lhsColumnWidth);
        DataValueDescriptor rhsDVD = dtd.getNull();
        rhsDVD.readBytes(rhs, rhsOffset, rhsColumnWidth);
        return lhsDVD.compare(rhsDVD);
    }

    public static final int compare(DataValueDescriptor lhsDVD, byte[] rhs, long rhsOffsetWidth, boolean nullsOrderedLow, boolean caseSensitive, ColumnDescriptor cd) throws StandardException {
        int rhsColumnWidth;
        int rhsOffset;
        boolean lhsIsNull = false;
        if (lhsDVD.getClass() == BinarySQLHybridType.class) {
            BinarySQLHybridType bt = (BinarySQLHybridType)lhsDVD;
            lhsDVD = bt.sqlValue;
            if (lhsDVD == null) {
                byte[] lhs = bt.byteValue;
                long lhsOffsetWidth = lhs != null ? (long)lhs.length : -7L;
                return DataTypeUtilities.compare(lhs, rhs, lhsOffsetWidth, rhsOffsetWidth, nullsOrderedLow, caseSensitive, cd);
            }
            if (lhsDVD.isNull()) {
                lhsIsNull = true;
            }
        } else if (lhsDVD.isNull()) {
            lhsIsNull = true;
        }
        if (rhsOffsetWidth == -6L && cd.columnDefault == null) {
            rhsOffsetWidth = -7L;
        }
        if (lhsIsNull) {
            if (rhsOffsetWidth == -7L) {
                return 0;
            }
            return nullsOrderedLow ? -1073741823 : 0x3FFFFFFF;
        }
        if (rhsOffsetWidth == -7L) {
            return nullsOrderedLow ? 0x3FFFFFFF : -1073741823;
        }
        DataTypeDescriptor dtd = cd.getType();
        TypeId typeId = dtd.getTypeId();
        int formatID = typeId.getTypeFormatId();
        if (rhsOffsetWidth == -6L) {
            rhs = cd.columnDefaultBytes;
            rhsOffset = 0;
            rhsColumnWidth = rhs.length;
        } else {
            rhsColumnWidth = (int)(rhsOffsetWidth & 0xFFFFFFFFFFFFFFFFL);
            rhsOffset = (int)(rhsOffsetWidth >>> 32);
        }
        switch (formatID) {
            case 10: {
                short lhsV = lhsDVD.getShort();
                short rhsV = SQLSmallint.getAsShort(rhs, rhsOffset);
                return lhsV - rhsV;
            }
            case 7: {
                long lhsV = lhsDVD.getInt();
                long rhsV = SQLInteger.getAsInteger(rhs, rhsOffset);
                return (int)(lhsV - rhsV);
            }
            case 11: {
                long lhsV = lhsDVD.getLong();
                long rhsV = SQLLongint.getAsLong(rhs, rhsOffset);
                return lhsV < rhsV ? -1 : (lhsV == rhsV ? 0 : 1);
            }
            case 6: {
                double lhsV = lhsDVD.getDouble();
                double rhsV = SQLDouble.getAsDouble(rhs, rhsOffset);
                return Double.compare(lhsV, rhsV);
            }
            case 8: {
                float lhsV = lhsDVD.getFloat();
                float rhsV = SQLReal.getAsFloat(rhs, rhsOffset);
                return Float.compare(lhsV, rhsV);
            }
            case 5: 
            case 13: 
            case 230: 
            case 444: 
            case 456: {
                String lhsStr = lhsDVD.getString();
                return caseSensitive ? SQLChar.compareString(lhsStr, rhs, rhsOffset, rhsColumnWidth) : SQLChar.compareStringIgnoreCase(lhsStr, rhs, rhsOffset, rhsColumnWidth);
            }
            case 197: {
                BigDecimal lhsV = (BigDecimal)lhsDVD.getObject();
                BigDecimal rhsV = SQLDecimal.getAsBigDecimal(rhs, rhsOffset, rhsColumnWidth);
                if (lhsV != null) {
                    if (rhsV != null) {
                        return lhsV.compareTo(rhsV);
                    }
                    return 1;
                }
                return rhsV == null ? 0 : -1;
            }
            case 40: {
                long lhsEncodedDate = ((DateTimeDataValue)lhsDVD).getEncodedDate();
                long rhsEncodedDate = RowFormatter.readInt(rhs, rhsOffset);
                return (int)(lhsEncodedDate - rhsEncodedDate);
            }
            case 35: {
                long lhsEncodedTime = ((DateTimeDataValue)lhsDVD).getEncodedTime();
                long rhsEncodedTime = RowFormatter.readInt(rhs, rhsOffset);
                return (int)(lhsEncodedTime - rhsEncodedTime);
            }
            case 36: {
                int rhsEncodedTime;
                DateTimeDataValue ts = (DateTimeDataValue)lhsDVD;
                int lhsEncodedDate = ts.getEncodedDate();
                int rhsEncodedDate = RowFormatter.readInt(rhs, rhsOffset);
                if (lhsEncodedDate < rhsEncodedDate) {
                    return -1;
                }
                if (lhsEncodedDate > rhsEncodedDate) {
                    return 1;
                }
                int lhsEncodedTime = ts.getEncodedTime();
                if (lhsEncodedTime < (rhsEncodedTime = RowFormatter.readInt(rhs, rhsOffset += 4))) {
                    return -1;
                }
                if (lhsEncodedTime > rhsEncodedTime) {
                    return 1;
                }
                long lhsNanos = ts.getNanos();
                long rhsNanos = RowFormatter.readInt(rhs, rhsOffset += 4);
                return (int)(lhsNanos - rhsNanos);
            }
            case 4: 
            case 195: {
                byte lhsV = lhsDVD.getByte();
                byte rhsV = rhs[0];
                return lhsV - rhsV;
            }
        }
        DataValueDescriptor rhsDVD = dtd.getNull();
        rhsDVD.readBytes(rhs, rhsOffset, rhsColumnWidth);
        return lhsDVD.compare(rhsDVD);
    }

    public static TypeId getNumericTypeIdForNumber(String num) {
        try {
            Byte byet = Byte.valueOf(num);
            return TypeId.getBuiltInTypeId(-6);
        }
        catch (NumberFormatException byet) {
            try {
                Short shorrt = Short.valueOf(num);
                return TypeId.getBuiltInTypeId(5);
            }
            catch (NumberFormatException shorrt) {
                try {
                    Integer integer = Integer.valueOf(num);
                    return TypeId.getBuiltInTypeId(4);
                }
                catch (NumberFormatException integer) {
                    try {
                        Long loong = Long.valueOf(num);
                        return TypeId.getBuiltInTypeId(-5);
                    }
                    catch (NumberFormatException loong) {
                        try {
                            Float floaat = Float.valueOf(num);
                            return TypeId.getBuiltInTypeId(7);
                        }
                        catch (NumberFormatException floaat) {
                            try {
                                Double doouble = Double.valueOf(num);
                                return TypeId.getBuiltInTypeId(8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                return null;
                            }
                        }
                    }
                }
            }
        }
    }
}

