/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.io;

import java.io.IOException;
import java.io.InputStream;

public final class NewByteArrayInputStream
extends InputStream {
    private byte[] data;
    private int offset;
    private int length;

    public NewByteArrayInputStream(byte[] data) {
        this(data, 0, data.length);
    }

    public NewByteArrayInputStream(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int read() throws IOException {
        if (this.data == null) {
            throw new IOException();
        }
        if (this.length == 0) {
            return -1;
        }
        --this.length;
        return this.data[this.offset++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.data == null) {
            throw new IOException();
        }
        if (this.length == 0) {
            return -1;
        }
        if (len > this.length) {
            len = this.length;
        }
        System.arraycopy(this.data, this.offset, b, off, len);
        this.offset += len;
        this.length -= len;
        return len;
    }

    @Override
    public long skip(long count) throws IOException {
        if (this.data == null) {
            throw new IOException();
        }
        if (this.length == 0 || count <= 0L) {
            return 0L;
        }
        if (count > (long)this.length) {
            count = this.length;
        }
        this.offset += (int)count;
        this.length -= (int)count;
        return count;
    }

    @Override
    public int available() throws IOException {
        if (this.data == null) {
            throw new IOException();
        }
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void close() {
        this.data = null;
    }
}

