/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractConditionQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ParameterizedConditionsWrapperQueryInfo
extends AbstractConditionQueryInfo {
    private AbstractConditionQueryInfo constantCondition = null;
    private final List<AbstractConditionQueryInfo> parameterizedConditions = new ArrayList<AbstractConditionQueryInfo>(4);

    ParameterizedConditionsWrapperQueryInfo(AbstractConditionQueryInfo condition1, AbstractConditionQueryInfo condition2) {
        if (condition1.isWhereClauseDynamic()) {
            this.parameterizedConditions.add(condition1);
            if (condition2.isWhereClauseDynamic()) {
                this.parameterizedConditions.add(condition2);
            } else {
                this.constantCondition = condition2;
            }
        } else {
            this.constantCondition = condition1;
            assert (condition2.isWhereClauseDynamic());
            this.parameterizedConditions.add(condition2);
        }
    }

    @Override
    AbstractConditionQueryInfo createOrAddToGroup(AbstractConditionQueryInfo operand, boolean ignore, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
        assert (ignore);
        assert (activation == null);
        if (operand.isWhereClauseDynamic()) {
            this.parameterizedConditions.add(operand);
        } else {
            this.constantCondition = this.constantCondition != null ? this.constantCondition.createOrAddToGroup(operand, true, activation, false) : operand;
        }
        return this;
    }

    List getParameterizedOperands() {
        return Collections.unmodifiableList(this.parameterizedConditions);
    }

    AbstractConditionQueryInfo getConstantOperand() {
        return this.constantCondition;
    }

    @Override
    public void computeNodes(Set<Object> routingKeys, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
        assert (routingKeys.size() == 1);
        assert (routingKeys.contains(ResolverUtils.TOK_ALL_NODES));
        HashSet<Object> nodesCollector = new HashSet<Object>();
        nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
        if (this.constantCondition != null) {
            this.constantCondition.computeNodes(nodesCollector, activation, forSingleHopPreparePhase);
            if (!nodesCollector.contains(ResolverUtils.TOK_ALL_NODES)) {
                routingKeys.remove(ResolverUtils.TOK_ALL_NODES);
                routingKeys.addAll(nodesCollector);
                nodesCollector.clear();
                nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
            } else assert (nodesCollector.size() == 1);
        }
        AbstractConditionQueryInfo tempAcqi = this.groupParameterizedConditions(activation, forSingleHopPreparePhase);
        tempAcqi.computeNodes(nodesCollector, activation, forSingleHopPreparePhase);
        if (!nodesCollector.contains(ResolverUtils.TOK_ALL_NODES)) {
            if (routingKeys.contains(ResolverUtils.TOK_ALL_NODES)) {
                routingKeys.remove(ResolverUtils.TOK_ALL_NODES);
                routingKeys.addAll(nodesCollector);
            } else {
                routingKeys.retainAll(nodesCollector);
            }
        }
    }

    AbstractConditionQueryInfo groupParameterizedConditions(Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
        Iterator<AbstractConditionQueryInfo> itr = this.parameterizedConditions.iterator();
        assert (itr.hasNext());
        AbstractConditionQueryInfo tempAcqi = itr.next();
        while (itr.hasNext()) {
            tempAcqi = tempAcqi.createOrAddToGroup(itr.next(), true, activation, forSingleHopPreparePhase);
        }
        return tempAcqi;
    }

    @Override
    boolean isWhereClauseDynamic() {
        return true;
    }
}

