/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.util.concurrent.StoppableCountDownLatch;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResponseCode;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdWaitingReplyProcessorBase;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.Collection;
import java.util.Set;

public final class GfxdWaitingReplyProcessor
extends GfxdWaitingReplyProcessorBase {
    private final THashSet grantedMembers = new THashSet();
    private final boolean ignoreNodeDown;
    private final StoppableCountDownLatch waitLatch;

    public GfxdWaitingReplyProcessor(DM dm, Set<DistributedMember> members, boolean ignoreNodeDown, boolean useLatchForWaiters) {
        super(dm, members, true);
        this.ignoreNodeDown = ignoreNodeDown;
        this.waitLatch = useLatchForWaiters ? new StoppableCountDownLatch(this.getDistributionManager().getCancelCriterion(), 1) : null;
    }

    @Override
    protected Set<DistributedMember> virtualReset() {
        assert (Thread.holdsLock((Object)this));
        this.waitLatch.countDown();
        THashSet members = new THashSet(this.grantedMembers.size());
        members.addAll((Collection)this.grantedMembers);
        this.grantedMembers.clear();
        return members;
    }

    public final synchronized Set<DistributedMember> getGrantedMembers() {
        THashSet members = new THashSet(this.grantedMembers.size());
        members.addAll((Collection)this.grantedMembers);
        return members;
    }

    public final synchronized boolean hasGrantedMembers() {
        return this.grantedMembers.size() > 0;
    }

    @Override
    protected final void addGrantedMember(DistributedMember member) {
        assert (Thread.holdsLock((Object)this));
        this.grantedMembers.add((Object)member);
    }

    public final StoppableCountDownLatch getWaitersLatch() {
        return this.waitLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkWaiters() {
        if (this.waitLatch == null) {
            return;
        }
        int numMembers = this.numMembers();
        GfxdWaitingReplyProcessor gfxdWaitingReplyProcessor = this;
        synchronized (gfxdWaitingReplyProcessor) {
            int numWaitingMembers = 0;
            if (this.waiters != null) {
                numWaitingMembers = this.waiters.size();
            }
            if (SanityManager.isFinerEnabled) {
                SanityManager.DEBUG_PRINT((String)"finer:TRACE", (String)(this.toString() + "#checkWaiters: waitingMembers: " + numWaitingMembers + ", total members: " + numMembers));
            }
            if (numWaitingMembers >= numMembers) {
                this.waitLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DistributionMessage msg) {
        boolean superProcess = true;
        boolean waiting = false;
        try {
            if (msg instanceof GfxdReplyMessage) {
                GfxdReplyMessage reply = (GfxdReplyMessage)msg;
                GfxdResponseCode responseCode = reply.getResponseCode();
                waiting = this.processResponseCode(reply, responseCode);
                boolean bl = superProcess = !waiting;
                if (!responseCode.isGrant()) {
                    ReplyException replyEx;
                    if (this.ignoreNodeDown && (replyEx = reply.getException()) != null && GemFireXDUtils.retryToBeDone(replyEx)) {
                        InternalDistributedMember member = reply.getSender();
                        this.removeMember(member, true);
                        if (GemFireXDUtils.TraceFunctionException) {
                            SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)("GfxdWaitingReplyProcessor: ignoring node down for " + member), (Throwable)replyEx);
                        }
                        superProcess = false;
                        return;
                    }
                    this.setResponseCode(responseCode);
                    if (waiting) {
                        this.checkWaiters();
                    }
                }
            } else {
                ReplyMessage reply = (ReplyMessage)msg;
                if (reply.getException() == null) {
                    this.addGrantedMember((DistributedMember)reply.getSender(), 1);
                }
            }
        }
        finally {
            if (superProcess) {
                super.process(msg);
            }
            if (DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("Finished processing " + msg));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeMemberFromLists(InternalDistributedMember member, boolean departed) {
        GfxdWaitingReplyProcessor gfxdWaitingReplyProcessor = this;
        synchronized (gfxdWaitingReplyProcessor) {
            if (this.waiters != null) {
                this.waiters.remove((Object)member);
            }
            if (departed) {
                this.grantedMembers.remove((Object)member);
            }
        }
        this.checkWaiters();
    }
}

