/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.ObjToByteArraySerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public final class GfxdHeapDataOutputStream
extends HeapDataOutputStream
implements ObjToByteArraySerializer {
    static final int MIN_SIZE = Integer.getInteger("gemfirexd.heap-output-stream-size", 512);
    final GfxdHeapThresholdListener thresholdListener;
    final String query;
    final boolean wrapBytes;

    public GfxdHeapDataOutputStream(GfxdHeapThresholdListener thresholdListener, String query, boolean wrapBytes, Version v) {
        this(MIN_SIZE, thresholdListener, query, wrapBytes, v);
    }

    public GfxdHeapDataOutputStream(int minSize, GfxdHeapThresholdListener thresholdListener, String query, boolean wrapBytes, Version v) {
        super(minSize, v);
        this.thresholdListener = thresholdListener;
        this.query = query;
        this.wrapBytes = wrapBytes;
        this.markForReuse();
    }

    public final void write(byte[] source, int offset, int len) {
        if (this.wrapBytes && this.buffer.remaining() < len) {
            this.writeWithByteArrayWrappedConditionally(source, offset, len);
        } else {
            super.write(source, offset, len);
        }
    }

    public final void writeNoWrap(byte[] source, int offset, int len) {
        super.write(source, offset, len);
    }

    public final void copyMemory(Object src, long srcOffset, int length) {
        Unsafe unsafe = UnsafeHolder.getUnsafe();
        ByteBuffer buffer = this.buffer;
        byte[] dst = buffer.array();
        int offset = buffer.arrayOffset();
        int pos = buffer.position();
        int remainingSpace = buffer.capacity() - pos;
        if (remainingSpace < length) {
            UnsafeHolder.copyMemory((Object)src, (long)srcOffset, (Object)dst, (long)(UnsafeHolder.arrayBaseOffset + (long)offset + (long)pos), (long)remainingSpace, (Unsafe)unsafe);
            buffer.position(pos + remainingSpace);
            srcOffset += (long)remainingSpace;
            this.ensureCapacity(length -= remainingSpace);
            buffer = this.buffer;
            dst = buffer.array();
            offset = buffer.arrayOffset();
            pos = buffer.position();
        }
        UnsafeHolder.copyMemory((Object)src, (long)srcOffset, (Object)dst, (long)(UnsafeHolder.arrayBaseOffset + (long)offset + (long)pos), (long)length, (Unsafe)unsafe);
        buffer.position(pos + length);
    }

    protected final void expand(int amount) {
        Misc.checkMemoryRuntime(this.thresholdListener, this.query, amount);
        super.expand(amount);
    }

    public final byte[] toByteArrayCopy() {
        byte[] bytes = new byte[this.size()];
        this.sendTo(bytes, 0);
        return bytes;
    }
}

