/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.wan;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.internal.cache.InternalDeltaEvent;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.internal.engine.ddl.AbstractEventImpl;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;

public final class WBCLEventImpl
extends AbstractEventImpl {
    private final AsyncEvent<Object, Object> event;

    public WBCLEventImpl(AsyncEvent<Object, Object> ev) {
        super(WBCLEventImpl.getOpType(ev), false);
        this.event = ev;
    }

    private static Event.Type getOpType(AsyncEvent<Object, Object> ev) {
        Operation op = ev.getOperation();
        InternalDeltaEvent event = (InternalDeltaEvent)ev;
        if (event.isGFXDCreate(false)) {
            return Event.Type.AFTER_INSERT;
        }
        if (event.hasDelta()) {
            return Event.Type.AFTER_UPDATE;
        }
        if (op.isDestroy()) {
            return Event.Type.AFTER_DELETE;
        }
        throw new UnsupportedOperationException("Operation type = " + op + " not supported yet");
    }

    @Override
    public Object getNewValue() {
        Event.Type eventType = this.getType();
        if (eventType == Event.Type.AFTER_DELETE) {
            return null;
        }
        Object val = this.event.getDeserializedValue();
        if (val instanceof GemFireContainer.SerializableDelta) {
            return ((GemFireContainer.SerializableDelta)val).getChangedRow();
        }
        return val;
    }

    @Override
    public Object getOldValue() {
        Event.Type eventType = this.getType();
        if (eventType == Event.Type.AFTER_INSERT || eventType == Event.Type.AFTER_UPDATE) {
            return null;
        }
        return this.event.getDeserializedValue();
    }

    @Override
    protected GemFireContainer getGemFireContainer() {
        return (GemFireContainer)this.event.getRegion().getUserAttribute();
    }

    public AsyncEvent<Object, Object> getAsyncEvent() {
        return this.event;
    }

    @Override
    public GemFireContainer.SerializableDelta getSerializableDelta() {
        assert (this.getType() == Event.Type.AFTER_UPDATE);
        return (GemFireContainer.SerializableDelta)this.event.getDeserializedValue();
    }

    @Override
    public boolean isPossibleDuplicate() {
        return this.event.getPossibleDuplicate();
    }

    @Override
    public boolean isTransactional() {
        Object cbArg = this.event.getCallbackArgument();
        return cbArg != null && cbArg instanceof GfxdCallbackArgument && ((GfxdCallbackArgument)cbArg).isTransactional();
    }

    @Override
    public Object extractKey() {
        return this.event.getKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof WBCLEventImpl) {
            return ((WBCLEventImpl)o).event.equals(this.event);
        }
        return false;
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    @Override
    public String toString() {
        return String.valueOf(this.event);
    }

    @Override
    public boolean isLoad() {
        return this.event.getOperation().isLoad();
    }

    @Override
    public boolean isExpiration() {
        return this.event.getOperation().isExpiration();
    }

    @Override
    public boolean isEviction() {
        return this.event.getOperation().equals(Operation.EVICT_DESTROY);
    }
}

