/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SubQueryInfo;
import com.pivotal.gemfirexd.internal.engine.procedure.ProcedureChunkMessage;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.ProcedureSender;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class GemFireXDQueryObserverHolder
implements GemFireXDQueryObserver {
    private static volatile GemFireXDQueryObserverHolder _instance = null;
    static final GemFireXDQueryObserverAdapter _adapterInstance = new GemFireXDQueryObserverAdapter();
    private static boolean _instanceSet = false;
    private static final Object _instanceLock = new Object();
    private volatile GemFireXDQueryObserver[] observerCollection = new GemFireXDQueryObserver[0];
    private volatile QueryObserver[] allObserverCollection = new QueryObserver[0];
    private static final boolean noVolatileRead = !Boolean.getBoolean("gemfirexd-impl.observer-volatile-read");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putInstance(QueryObserver observer) {
        if (observer == null) {
            throw new NullPointerException("putInstance: null observer");
        }
        Object object = _instanceLock;
        synchronized (object) {
            GemFireXDQueryObserverHolder holder = _instanceSet ? _instance : new GemFireXDQueryObserverHolder();
            QueryObserver[] observers = holder.allObserverCollection;
            int sz = observers.length;
            QueryObserver[] newObservers = new QueryObserver[sz + 1];
            System.arraycopy(observers, 0, newObservers, 0, sz);
            newObservers[sz] = observer;
            holder.allObserverCollection = newObservers;
            if (observer instanceof GemFireXDQueryObserver) {
                GemFireXDQueryObserver[] qobservers = holder.observerCollection;
                sz = qobservers.length;
                GemFireXDQueryObserver[] newqObservers = new GemFireXDQueryObserver[sz + 1];
                System.arraycopy(qobservers, 0, newqObservers, 0, sz);
                newqObservers[sz] = (GemFireXDQueryObserver)observer;
                holder.observerCollection = newqObservers;
            }
            if (!_instanceSet) {
                _instance = holder;
                _instanceSet = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryObserver putInstanceIfAbsent(QueryObserver observer) {
        if (observer == null) {
            throw new NullPointerException("putInstanceIfAbsent: null observer");
        }
        Object object = _instanceLock;
        synchronized (object) {
            QueryObserver[] observers;
            GemFireXDQueryObserverHolder holder = _instanceSet ? _instance : new GemFireXDQueryObserverHolder();
            QueryObserver existingObserver = null;
            for (QueryObserver collObserver : observers = holder.allObserverCollection) {
                if (collObserver.getClass() != observer.getClass()) continue;
                existingObserver = collObserver;
                break;
            }
            if (!_instanceSet) {
                _instance = holder;
                _instanceSet = true;
            }
            if (existingObserver == null) {
                GemFireXDQueryObserverHolder.putInstance(observer);
            }
            return existingObserver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GemFireXDQueryObserver setInstance(GemFireXDQueryObserver observer) {
        if (observer == null) {
            throw new NullPointerException("setInstance: null observer");
        }
        Object object = _instanceLock;
        synchronized (object) {
            GemFireXDQueryObserverHolder holder = _instanceSet ? _instance : new GemFireXDQueryObserverHolder();
            GemFireXDQueryObserver existingObserver = null;
            GemFireXDQueryObserver[] observers = holder.observerCollection;
            if (observers.length > 0) {
                existingObserver = observers[0];
            }
            holder.observerCollection = new GemFireXDQueryObserver[]{observer};
            holder.allObserverCollection = new QueryObserver[]{observer};
            if (!_instanceSet) {
                _instance = holder;
                _instanceSet = true;
            }
            return existingObserver;
        }
    }

    public static GemFireXDQueryObserver getInstance() {
        if (noVolatileRead && !_instanceSet) {
            return null;
        }
        return _instance;
    }

    public static <T extends QueryObserver> T getObserver(Class<T> c) {
        GemFireXDQueryObserverHolder holder;
        if (c == null) {
            throw new NullPointerException("getObserver: null class");
        }
        if (_instanceSet && (holder = _instance) != null) {
            QueryObserver[] allObservers;
            for (QueryObserver observer : allObservers = holder.allObserverCollection) {
                if (!observer.getClass().equals(c)) continue;
                return (T)observer;
            }
        }
        return null;
    }

    public static <T extends QueryObserver> Collection<T> getObservers(Class<T> c) {
        GemFireXDQueryObserverHolder holder;
        if (c == null) {
            throw new NullPointerException("getObservers: null class");
        }
        if (_instanceSet && (holder = _instance) != null) {
            QueryObserver[] allObservers = holder.allObserverCollection;
            ArrayList<QueryObserver> observers = new ArrayList<QueryObserver>(4);
            for (QueryObserver observer : allObservers) {
                if (!observer.getClass().equals(c)) continue;
                observers.add(observer);
            }
            if (observers.size() > 0) {
                return observers;
            }
        }
        return null;
    }

    public static Collection<QueryObserver> getAllObservers() {
        QueryObserver[] observers;
        GemFireXDQueryObserverHolder holder;
        if (_instanceSet && (holder = _instance) != null && (observers = holder.allObserverCollection) != null) {
            return new ArrayList<QueryObserver>(Arrays.asList(observers));
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeObserver(Class<? extends QueryObserver> c) {
        if (c == null) {
            throw new NullPointerException("removeObserver: null class");
        }
        Object object = _instanceLock;
        synchronized (object) {
            GemFireXDQueryObserverHolder holder;
            if (_instanceSet && (holder = _instance) != null) {
                int numRemoved1 = 0;
                int numRemoved2 = 0;
                QueryObserver[] observers = holder.allObserverCollection;
                QueryObserver[] qobservers = holder.observerCollection;
                for (QueryObserver observer : observers) {
                    if (!observer.getClass().equals(c)) continue;
                    if (observer instanceof GemFireXDQueryObserver) {
                        for (GemFireXDQueryObserver gemFireXDQueryObserver : qobservers) {
                            if (!gemFireXDQueryObserver.equals(observer)) continue;
                            ++numRemoved2;
                            break;
                        }
                    }
                    ++numRemoved1;
                }
                if (numRemoved1 > 0) {
                    QueryObserver[] newObservers = new QueryObserver[observers.length - numRemoved1];
                    if (newObservers.length > 0) {
                        GemFireXDQueryObserverHolder.copyAndRemove(observers, newObservers, c);
                    }
                    holder.allObserverCollection = newObservers;
                    if (numRemoved2 > 0) {
                        QueryObserver[] newqObservers = new GemFireXDQueryObserver[qobservers.length - numRemoved2];
                        if (newqObservers.length > 0) {
                            GemFireXDQueryObserverHolder.copyAndRemove(qobservers, newqObservers, c);
                        }
                        holder.observerCollection = newqObservers;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeObserver(QueryObserver removeObserver) {
        if (removeObserver == null) {
            throw new NullPointerException("removeObserver: null observer");
        }
        Object object = _instanceLock;
        synchronized (object) {
            GemFireXDQueryObserverHolder holder;
            if (_instanceSet && (holder = _instance) != null) {
                int numRemoved1 = 0;
                int numRemoved2 = 0;
                QueryObserver[] observers = holder.allObserverCollection;
                QueryObserver[] qobservers = holder.observerCollection;
                for (QueryObserver observer : observers) {
                    if (!observer.equals(removeObserver)) continue;
                    ++numRemoved1;
                }
                for (QueryObserver qobserver : qobservers) {
                    if (!qobserver.equals(removeObserver)) continue;
                    ++numRemoved2;
                }
                if (numRemoved1 > 0) {
                    QueryObserver[] newObservers = new QueryObserver[observers.length - numRemoved1];
                    if (newObservers.length > 0) {
                        GemFireXDQueryObserverHolder.copyAndRemove(observers, newObservers, removeObserver);
                    }
                    holder.allObserverCollection = newObservers;
                }
                if (numRemoved2 > 0) {
                    QueryObserver[] newqObservers = new GemFireXDQueryObserver[qobservers.length - numRemoved2];
                    if (newqObservers.length > 0) {
                        GemFireXDQueryObserverHolder.copyAndRemove(qobservers, newqObservers, removeObserver);
                    }
                    holder.observerCollection = newqObservers;
                }
                return numRemoved1 > 0;
            }
            return false;
        }
    }

    private static void copyAndRemove(QueryObserver[] observers, QueryObserver[] newObservers, Object remove) {
        Class observerClass;
        QueryObserver removeObserver;
        int index = 0;
        if (remove instanceof QueryObserver) {
            removeObserver = (QueryObserver)remove;
            observerClass = null;
        } else {
            removeObserver = null;
            observerClass = (Class)remove;
        }
        for (QueryObserver observer : observers) {
            if (removeObserver != null) {
                if (observer.equals(removeObserver)) continue;
                newObservers[index++] = observer;
                continue;
            }
            if (observer.getClass().equals(observerClass)) continue;
            newObservers[index++] = observer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInstance() {
        Object object = _instanceLock;
        synchronized (object) {
            if (_instanceSet && _instance != null) {
                _instance.close();
                GemFireXDQueryObserverHolder._instance.observerCollection = new GemFireXDQueryObserver[0];
                GemFireXDQueryObserverHolder._instance.allObserverCollection = new QueryObserver[0];
            }
            _instanceSet = false;
            _instance = null;
        }
    }

    @Override
    public void afterBulkOpDBSynchExecution(Event.Type type, int numRowsModified, Statement ps, String dml) {
        QueryObserver[] observers;
        for (QueryObserver observer : observers = this.allObserverCollection) {
            observer.afterBulkOpDBSynchExecution(type, numRowsModified, ps, dml);
        }
    }

    @Override
    public void afterPKBasedDBSynchExecution(Event.Type type, int numRowsModified, Statement ps) {
        QueryObserver[] observers;
        for (QueryObserver observer : observers = this.allObserverCollection) {
            observer.afterPKBasedDBSynchExecution(type, numRowsModified, ps);
        }
    }

    @Override
    public void afterCommitDBSynchExecution(List<Event> batchProcessed) {
        QueryObserver[] observers;
        for (QueryObserver observer : observers = this.allObserverCollection) {
            observer.afterCommitDBSynchExecution(batchProcessed);
        }
    }

    @Override
    public PreparedStatement afterQueryPrepareFailure(Connection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, SQLException sqle) throws SQLException {
        QueryObserver[] observers;
        PreparedStatement result = null;
        for (QueryObserver observer : observers = this.allObserverCollection) {
            PreparedStatement ps = observer.afterQueryPrepareFailure(conn, sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, columnIndexes, columnNames, sqle);
            if (ps == null) continue;
            result = ps;
        }
        return result;
    }

    @Override
    public boolean afterQueryExecution(CallbackStatement stmt, SQLException sqle) throws SQLException {
        QueryObserver[] observers;
        boolean result = false;
        for (QueryObserver observer : observers = this.allObserverCollection) {
            result |= observer.afterQueryExecution(stmt, sqle);
        }
        return result;
    }

    @Override
    public void afterCommit(Connection conn) {
        QueryObserver[] observers;
        for (QueryObserver observer : observers = this.allObserverCollection) {
            observer.afterCommit(conn);
        }
    }

    @Override
    public void afterRollback(Connection conn) {
        QueryObserver[] observers;
        for (QueryObserver observer : observers = this.allObserverCollection) {
            observer.afterRollback(conn);
        }
    }

    @Override
    public void afterConnectionClose(Connection conn) {
        QueryObserver[] observers;
        for (QueryObserver observer : observers = this.allObserverCollection) {
            observer.afterConnectionClose(conn);
        }
    }

    public void close() {
        QueryObserver[] observers;
        for (QueryObserver observer : observers = this.allObserverCollection) {
            observer.close();
        }
    }

    @Override
    public void afterQueryParsing(String query, StatementNode qt, LanguageConnectionContext lcc) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterQueryParsing(query, qt, lcc);
        }
    }

    @Override
    public void beforeOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeOptimizedParsedTree(query, qt, lcc);
        }
    }

    @Override
    public void afterOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterOptimizedParsedTree(query, qt, lcc);
        }
    }

    @Override
    public void beforeQueryExecution(EmbedStatement stmt, Activation activation) throws SQLException {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeQueryExecution(stmt, activation);
        }
    }

    @Override
    public void beforeBatchQueryExecution(EmbedStatement stmt, int batchSize) throws SQLException {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeBatchQueryExecution(stmt, batchSize);
        }
    }

    @Override
    public void afterBatchQueryExecution(EmbedStatement stmt, int batchSize) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterBatchQueryExecution(stmt, batchSize);
        }
    }

    @Override
    public void beforeGemFireActivationCreate(AbstractGemFireActivation ac) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeGemFireActivationCreate(ac);
        }
    }

    @Override
    public void afterGemFireActivationCreate(AbstractGemFireActivation ac) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterGemFireActivationCreate(ac);
        }
    }

    @Override
    public void beforeGemFireResultSetOpen(AbstractGemFireResultSet rs, LanguageConnectionContext lcc) throws StandardException {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeGemFireResultSetOpen(rs, lcc);
        }
    }

    @Override
    public void afterGemFireResultSetOpen(AbstractGemFireResultSet rs, LanguageConnectionContext lcc) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterGemFireResultSetOpen(rs, lcc);
        }
    }

    @Override
    public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeGemFireResultSetExecuteOnActivation(activation);
        }
    }

    @Override
    public void afterGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterGemFireResultSetExecuteOnActivation(activation);
        }
    }

    @Override
    public void beforeComputeRoutingObjects(AbstractGemFireActivation activation) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeComputeRoutingObjects(activation);
        }
    }

    @Override
    public void afterComputeRoutingObjects(AbstractGemFireActivation activation) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterComputeRoutingObjects(activation);
        }
    }

    @Override
    public <T extends Serializable> void beforeQueryDistribution(StatementExecutorMessage<T> executorMessage, boolean streaming) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeQueryDistribution(executorMessage, streaming);
        }
    }

    @Override
    public <T extends Serializable> void afterQueryDistribution(StatementExecutorMessage<T> executorMessage, boolean streaming) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterQueryDistribution(executorMessage, streaming);
        }
    }

    @Override
    public void beforeGemFireResultSetClose(AbstractGemFireResultSet rs, String query) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeGemFireResultSetClose(rs, query);
        }
    }

    @Override
    public void beforeEmbedResultSetClose(EmbedResultSet rs, String query) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeEmbedResultSetClose(rs, query);
        }
    }

    @Override
    public void afterGemFireResultSetClose(AbstractGemFireResultSet rs, String query) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterGemFireResultSetClose(rs, query);
        }
    }

    @Override
    public void beforeResultHolderExecution(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeResultHolderExecution(wrapper, es);
        }
    }

    @Override
    public void afterResultHolderExecution(GfxdConnectionWrapper wrapper, EmbedStatement es, String query) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterResultHolderExecution(wrapper, es, query);
        }
    }

    @Override
    public void beforeResultHolderIteration(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeResultHolderIteration(wrapper, es);
        }
    }

    @Override
    public void afterResultHolderIteration(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterResultHolderIteration(wrapper, es);
        }
    }

    @Override
    public void beforeResultHolderSerialization(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeResultHolderSerialization(wrapper, es);
        }
    }

    @Override
    public void afterResultHolderSerialization(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterResultHolderSerialization(wrapper, es);
        }
    }

    @Override
    public void beforeResultSetHolderRowRead(RowFormatter rf, Activation act) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeResultSetHolderRowRead(rf, act);
        }
    }

    @Override
    public void afterResultSetHolderRowRead(RowFormatter rf, ExecRow row, Activation act) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterResultSetHolderRowRead(rf, row, act);
        }
    }

    @Override
    public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeQueryExecutionByStatementQueryExecutor(wrapper, stmt, query);
        }
    }

    @Override
    public void afterQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterQueryExecutionByStatementQueryExecutor(wrapper, stmt, query);
        }
    }

    @Override
    public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeQueryExecutionByPrepStatementQueryExecutor(wrapper, pstmt, query);
        }
    }

    @Override
    public void afterQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterQueryExecutionByPrepStatementQueryExecutor(wrapper, pstmt, query);
        }
    }

    @Override
    public void createdGemFireXDResultSet(ResultSet rs) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.createdGemFireXDResultSet(rs);
        }
    }

    @Override
    public void beforeIndexUpdatesAtRegionLevel(LocalRegion owner, EntryEventImpl event, RegionEntry entry) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeIndexUpdatesAtRegionLevel(owner, event, entry);
        }
    }

    @Override
    public void beforeForeignKeyConstraintCheckAtRegionLevel() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeForeignKeyConstraintCheckAtRegionLevel();
        }
    }

    @Override
    public void beforeUniqueConstraintCheckAtRegionLevel() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeUniqueConstraintCheckAtRegionLevel();
        }
    }

    @Override
    public void beforeGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeGlobalIndexLookup(lcc, indexRegion, indexKey);
        }
    }

    @Override
    public void afterGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey, Object result) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterGlobalIndexLookup(lcc, indexRegion, indexKey, result);
        }
    }

    @Override
    public void scanControllerOpened(Object sc, Conglomerate conglom) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.scanControllerOpened(sc, conglom);
        }
    }

    @Override
    public void beforeConnectionCloseByExecutorFunction(long[] connectionIDs) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeConnectionCloseByExecutorFunction(connectionIDs);
        }
    }

    @Override
    public void afterConnectionCloseByExecutorFunction(long[] connectionIDs) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterConnectionCloseByExecutorFunction(connectionIDs);
        }
    }

    @Override
    public void beforeORM(Activation activation, AbstractGemFireResultSet rs) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeORM(activation, rs);
        }
    }

    @Override
    public void afterORM(Activation activation, AbstractGemFireResultSet rs) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterORM(activation, rs);
        }
    }

    @Override
    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.queryInfoObjectFromOptmizedParsedTree(qInfo, gps, lcc);
        }
    }

    @Override
    public void queryInfoObjectAfterPreparedStatementCompletion(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.queryInfoObjectAfterPreparedStatementCompletion(qInfo, gps, lcc);
        }
    }

    @Override
    public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
        GemFireXDQueryObserver[] observers;
        double resCost = optimizerEvalutatedCost;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            double newCost = observer.overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(memIndex, optimizerEvalutatedCost);
            if (newCost == optimizerEvalutatedCost) continue;
            resCost = newCost;
        }
        return resCost;
    }

    @Override
    public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimizerEvalutatedCost) {
        GemFireXDQueryObserver[] observers;
        double resCost = optimizerEvalutatedCost;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            double newCost = observer.overrideDerbyOptimizerCostForMemHeapScan(gfContainer, optimizerEvalutatedCost);
            if (newCost == optimizerEvalutatedCost) continue;
            resCost = newCost;
        }
        return resCost;
    }

    @Override
    public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
        GemFireXDQueryObserver[] observers;
        double resCost = optimizerEvalutatedCost;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            double newCost = observer.overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(memIndex, optimizerEvalutatedCost);
            if (newCost == optimizerEvalutatedCost) continue;
            resCost = newCost;
        }
        return resCost;
    }

    @Override
    public void beforeQueryExecution(GenericPreparedStatement stmt, LanguageConnectionContext lcc) throws StandardException {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeQueryExecution(stmt, lcc);
        }
    }

    @Override
    public void afterQueryExecution(GenericPreparedStatement stmt, Activation activation) throws StandardException {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterQueryExecution(stmt, activation);
        }
    }

    @Override
    public void afterResultSetOpen(GenericPreparedStatement stmt, LanguageConnectionContext lcc, ResultSet resultSet) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterResultSetOpen(stmt, lcc, resultSet);
        }
    }

    @Override
    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, ResultSet theResults) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.onEmbedResultSetMovePosition(rs, newRow, theResults);
        }
    }

    @Override
    public void criticalUpMemoryEvent(GfxdHeapThresholdListener listener) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.criticalUpMemoryEvent(listener);
        }
    }

    @Override
    public void criticalDownMemoryEvent(GfxdHeapThresholdListener listener) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.criticalDownMemoryEvent(listener);
        }
    }

    @Override
    public void estimatingMemoryUsage(String stmtText, Object resultSet) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.estimatingMemoryUsage(stmtText, resultSet);
        }
    }

    @Override
    public long estimatedMemoryUsage(String stmtText, long memused) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.estimatedMemoryUsage(stmtText, memused);
        }
        return memused;
    }

    @Override
    public void putAllCalledWithMapSize(int size) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.putAllCalledWithMapSize(size);
        }
    }

    @Override
    public void afterClosingWrapperPreparedStatement(long wrapperPrepStatementID, long wrapperConnectionID) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterClosingWrapperPreparedStatement(wrapperPrepStatementID, wrapperConnectionID);
        }
    }

    @Override
    public void updatingColocationCriteria(ComparisonQueryInfo cqi) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.updatingColocationCriteria(cqi);
        }
    }

    @Override
    public void statementStatsBeforeExecutingStatement(StatementStats stats) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.statementStatsBeforeExecutingStatement(stats);
        }
    }

    @Override
    public void reset() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.reset();
        }
    }

    @Override
    public void subqueryNodeProcessedData(SelectQueryInfo qInfo, GenericPreparedStatement gps, String subquery, List<Integer> paramPositions) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.subqueryNodeProcessedData(qInfo, gps, subquery, paramPositions);
        }
    }

    @Override
    public void insertMultipleRowsBeingInvoked(int numElements) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.insertMultipleRowsBeingInvoked(numElements);
        }
    }

    @Override
    public void keyAndContainerAfterLocalIndexInsert(Object key, Object rowLocation, GemFireContainer container) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.keyAndContainerAfterLocalIndexInsert(key, rowLocation, container);
        }
    }

    @Override
    public void keyAndContainerAfterLocalIndexDelete(Object key, Object rowLocation, GemFireContainer container) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.keyAndContainerAfterLocalIndexDelete(key, rowLocation, container);
        }
    }

    @Override
    public void keyAndContainerBeforeLocalIndexDelete(Object key, Object rowLocation, GemFireContainer container) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.keyAndContainerBeforeLocalIndexDelete(key, rowLocation, container);
        }
    }

    @Override
    public void getAllInvoked(int numKeys) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.getAllInvoked(numKeys);
        }
    }

    @Override
    public void getAllGlobalIndexInvoked(int numKeys) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.getAllGlobalIndexInvoked(numKeys);
        }
    }

    @Override
    public void getAllLocalIndexInvoked(int numKeys) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.getAllLocalIndexInvoked(numKeys);
        }
    }

    @Override
    public void getAllLocalIndexExecuted() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.getAllLocalIndexExecuted();
        }
    }

    @Override
    public void ncjPullResultSetOpenCoreInvoked() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.ncjPullResultSetOpenCoreInvoked();
        }
    }

    @Override
    public void getStatementIDs(long stID, long rootID, int stLevel) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.getStatementIDs(stID, rootID, stLevel);
        }
    }

    @Override
    public void ncjPullResultSetVerifyBatchSize(int value) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.ncjPullResultSetVerifyBatchSize(value);
        }
    }

    @Override
    public void ncjPullResultSetVerifyCacheSize(int value) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.ncjPullResultSetVerifyCacheSize(value);
        }
    }

    @Override
    public void ncjPullResultSetVerifyVarInList(boolean value) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.ncjPullResultSetVerifyVarInList(value);
        }
    }

    @Override
    public void independentSubqueryResultsetFetched(Activation activation, ResultSet results) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.independentSubqueryResultsetFetched(activation, results);
        }
    }

    @Override
    public void subQueryInfoObjectFromOptmizedParsedTree(List<SubQueryInfo> qInfoList, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.subQueryInfoObjectFromOptmizedParsedTree(qInfoList, gps, lcc);
        }
    }

    @Override
    public void beforeInvokingContainerGetTxRowLocation(RowLocation regionEntry) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeInvokingContainerGetTxRowLocation(regionEntry);
        }
    }

    @Override
    public void afterGetRoutingObject(Object routingObject) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterGetRoutingObject(routingObject);
        }
    }

    @Override
    public long overrideUniqueID(long actualUniqueID, boolean forRegionKey) {
        GemFireXDQueryObserver[] observers;
        long retVal = actualUniqueID;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            long newID = observer.overrideUniqueID(actualUniqueID, forRegionKey);
            if (newID == actualUniqueID) continue;
            retVal = newID;
        }
        return retVal;
    }

    @Override
    public boolean beforeProcedureResultSetSend(ProcedureSender sender, EmbedResultSet rs) {
        GemFireXDQueryObserver[] observers;
        boolean result = true;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            result &= observer.beforeProcedureResultSetSend(sender, rs);
        }
        return result;
    }

    @Override
    public boolean beforeProcedureOutParamsSend(ProcedureSender sender, ParameterValueSet pvs) {
        GemFireXDQueryObserver[] observers;
        boolean result = true;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            result &= observer.beforeProcedureOutParamsSend(sender, pvs);
        }
        return result;
    }

    @Override
    public void beforeProcedureChunkMessageSend(ProcedureChunkMessage msg) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeProcedureChunkMessageSend(msg);
        }
    }

    @Override
    public void lockingRowForTX(TXStateProxy tx, GemFireContainer container, RegionEntry entry, boolean writeLock) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.lockingRowForTX(tx, container, entry, writeLock);
        }
    }

    @Override
    public void attachingKeyInfoForUpdate(GemFireContainer container, RegionEntry entry) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.attachingKeyInfoForUpdate(container, entry);
        }
    }

    @Override
    public int overrideSortBufferSize(ColumnOrdering[] columnOrdering, int sortBufferMax) {
        GemFireXDQueryObserver[] observers;
        int resBufferMax = sortBufferMax;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            int newBufferMax = observer.overrideSortBufferSize(columnOrdering, sortBufferMax);
            if (newBufferMax == sortBufferMax) continue;
            resBufferMax = newBufferMax;
        }
        return resBufferMax;
    }

    @Override
    public boolean avoidMergeRuns() {
        GemFireXDQueryObserver[] observers;
        boolean avoid = true;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            boolean newValue = observer.avoidMergeRuns();
            if (newValue == avoid) continue;
            avoid = newValue;
        }
        return avoid;
    }

    @Override
    public void callAtOldValueSameAsNewValueCheckInSM2IIOp() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.callAtOldValueSameAsNewValueCheckInSM2IIOp();
        }
    }

    @Override
    public void onGetNextRowCore(ResultSet resultSet) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.onGetNextRowCore(resultSet);
        }
    }

    @Override
    public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.onGetNextRowCoreOfBulkTableScan(resultSet);
        }
    }

    @Override
    public void onGetNextRowCoreOfGfxdSubQueryResultSet(ResultSet resultSet) {
        for (GemFireXDQueryObserver observer : this.observerCollection) {
            observer.onGetNextRowCoreOfGfxdSubQueryResultSet(resultSet);
        }
    }

    @Override
    public void onDeleteResultSetOpen(ResultSet resultSet) {
        for (GemFireXDQueryObserver observer : this.observerCollection) {
            observer.onDeleteResultSetOpen(resultSet);
        }
    }

    @Override
    public void onDeleteResultSetOpenAfterRefChecks(ResultSet resultSet) {
        for (GemFireXDQueryObserver observer : this.observerCollection) {
            observer.onDeleteResultSetOpenAfterRefChecks(resultSet);
        }
    }

    @Override
    public void onDeleteResultSetOpenBeforeRefChecks(ResultSet resultSet) {
        for (GemFireXDQueryObserver observer : this.observerCollection) {
            observer.onDeleteResultSetOpenBeforeRefChecks(resultSet);
        }
    }

    @Override
    public void setRoutingObjectsBeforeExecution(Set<Object> routingKeysToExecute) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.setRoutingObjectsBeforeExecution(routingKeysToExecute);
        }
    }

    @Override
    public void beforeDropGatewayReceiver() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeDropGatewayReceiver();
        }
    }

    @Override
    public void beforeDropDiskStore() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeDropDiskStore();
        }
    }

    @Override
    public void memberConnectionAuthenticationSkipped(boolean skipped) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.memberConnectionAuthenticationSkipped(skipped);
        }
    }

    @Override
    public void userConnectionAuthenticationSkipped(boolean skipped) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.userConnectionAuthenticationSkipped(skipped);
        }
    }

    @Override
    public void regionSizeOptimizationTriggered(FromBaseTable fbt, SelectNode selectNode) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.regionSizeOptimizationTriggered(fbt, selectNode);
        }
    }

    @Override
    public void regionSizeOptimizationTriggered2(SelectNode selectNode) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.regionSizeOptimizationTriggered2(selectNode);
        }
    }

    @Override
    public void beforeFlushBatch(ResultSet rs, LanguageConnectionContext lcc) throws StandardException {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeFlushBatch(rs, lcc);
        }
    }

    @Override
    public void afterFlushBatch(ResultSet rs, LanguageConnectionContext lcc) throws StandardException {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterFlushBatch(rs, lcc);
        }
    }

    @Override
    public void invokeCacheCloseAtMultipleInsert() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.invokeCacheCloseAtMultipleInsert();
        }
    }

    @Override
    public boolean isCacheClosedForTesting() {
        GemFireXDQueryObserver[] observers;
        boolean result = false;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            result |= observer.isCacheClosedForTesting();
        }
        return result;
    }

    @Override
    public void afterGlobalIndexInsert(boolean posDup) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterGlobalIndexInsert(posDup);
        }
    }

    @Override
    public boolean needIndexRecoveryAccounting() {
        GemFireXDQueryObserver[] observers;
        boolean result = false;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            result |= observer.needIndexRecoveryAccounting();
        }
        return result;
    }

    @Override
    public void setIndexRecoveryAccountingMap(THashMap map) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.setIndexRecoveryAccountingMap(map);
        }
    }

    @Override
    public void beforeQueryReprepare(GenericPreparedStatement gpst, LanguageConnectionContext lcc) throws StandardException {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeQueryReprepare(gpst, lcc);
        }
    }

    @Override
    public boolean throwPutAllPartialException() {
        GemFireXDQueryObserver[] observers;
        boolean result = false;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            result |= observer.throwPutAllPartialException();
        }
        return result;
    }

    @Override
    public void afterIndexRowRequalification(Boolean success, CompactCompositeIndexKey ccKey, ExecRow row, Activation activation) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterIndexRowRequalification(success, ccKey, row, activation);
        }
    }

    @Override
    public void beforeRowTrigger(LanguageConnectionContext lcc, ExecRow execRow, ExecRow newRow) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeRowTrigger(lcc, execRow, newRow);
        }
    }

    @Override
    public void afterRowTrigger(TriggerDescriptor trigD, GenericParameterValueSet gpvs) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterRowTrigger(trigD, gpvs);
        }
    }

    @Override
    public void beforeGlobalIndexDelete() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeGlobalIndexDelete();
        }
    }

    @Override
    public void onSortResultSetOpen(ResultSet resultSet) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.onSortResultSetOpen(resultSet);
        }
    }

    @Override
    public void onGroupedAggregateResultSetOpen(ResultSet resultSet) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.onGroupedAggregateResultSetOpen(resultSet);
        }
    }

    @Override
    public void onUpdateResultSetOpen(ResultSet resultSet) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.onUpdateResultSetOpen(resultSet);
        }
    }

    @Override
    public void onUpdateResultSetDoneUpdate(ResultSet resultSet) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.onUpdateResultSetDoneUpdate(resultSet);
        }
    }

    @Override
    public void beforeDeferredUpdate() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeDeferredUpdate();
        }
    }

    @Override
    public void beforeDeferredDelete() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeDeferredDelete();
        }
    }

    @Override
    public void bucketIdcalculated(int bid) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.bucketIdcalculated(bid);
        }
    }

    @Override
    public void beforeReturningCachedVal(Serializable globalIndexKey, Object cachedVal) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.beforeReturningCachedVal(globalIndexKey, cachedVal);
        }
    }

    @Override
    public void afterPuttingInCached(Serializable globalIndexKey, Object result) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterPuttingInCached(globalIndexKey, result);
        }
    }

    @Override
    public void afterSingleRowInsert(Object routingObj) {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterSingleRowInsert(routingObj);
        }
    }

    @Override
    public void afterLockingTableDuringImport() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterLockingTableDuringImport();
        }
    }

    @Override
    public boolean testIndexRecreate() {
        return false;
    }

    @Override
    public void afterQueryPlanGeneration() {
        GemFireXDQueryObserver[] observers;
        for (GemFireXDQueryObserver observer : observers = this.observerCollection) {
            observer.afterQueryPlanGeneration();
        }
    }
}

