/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.catalog.types;

import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.info.JVMInfo;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BaseTypeIdImpl
implements Formatable {
    private int formatId;
    protected String schemaName;
    String unqualifiedName;
    transient int JDBCTypeId;

    public BaseTypeIdImpl() {
    }

    public BaseTypeIdImpl(int formatId) {
        this.formatId = formatId;
        this.setTypeIdSpecificInstanceVariables();
    }

    BaseTypeIdImpl(String SQLTypeName) {
        this.schemaName = null;
        this.unqualifiedName = SQLTypeName;
    }

    BaseTypeIdImpl(String schemaName, String unqualifiedName) {
        this.schemaName = schemaName;
        this.unqualifiedName = unqualifiedName;
    }

    public String getSQLTypeName() {
        if (this.schemaName == null) {
            return this.unqualifiedName;
        }
        return IdUtil.mkQualifiedName(this.schemaName, this.unqualifiedName);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getUnqualifiedName() {
        return this.unqualifiedName;
    }

    public boolean isAnsiUDT() {
        return this.schemaName != null;
    }

    public int getJDBCTypeId() {
        return this.JDBCTypeId;
    }

    public String toParsableString(TypeDescriptor td) {
        String retval = this.getSQLTypeName();
        switch (this.getTypeFormatId()) {
            case 28: 
            case 30: {
                int rparen = retval.indexOf(41);
                String lead = retval.substring(0, rparen);
                retval = lead + td.getMaximumWidth() + retval.substring(rparen);
                break;
            }
            case 17: 
            case 25: 
            case 442: 
            case 446: {
                retval = retval + "(" + td.getMaximumWidth() + ")";
                break;
            }
            case 198: {
                retval = retval + "(" + td.getPrecision() + "," + td.getScale() + ")";
            }
        }
        return retval;
    }

    public boolean userType() {
        return false;
    }

    public String toString() {
        return MessageService.getTextMessage("44X00.U") + ": " + this.getSQLTypeName();
    }

    public boolean equals(Object that) {
        if (that instanceof BaseTypeIdImpl) {
            return this.getSQLTypeName().equals(((BaseTypeIdImpl)that).getSQLTypeName());
        }
        return false;
    }

    public int hashCode() {
        return this.getSQLTypeName().hashCode();
    }

    @Override
    public int getTypeFormatId() {
        if (this.formatId != 0) {
            return this.formatId;
        }
        if ("BOOLEAN".equals(this.unqualifiedName)) {
            return 16;
        }
        if ("BIGINT".equals(this.unqualifiedName)) {
            return 23;
        }
        if ("INTEGER".equals(this.unqualifiedName)) {
            return 19;
        }
        if ("SMALLINT".equals(this.unqualifiedName)) {
            return 22;
        }
        if ("TINYINT".equals(this.unqualifiedName)) {
            return 196;
        }
        if ("LONGINT".equals(this.unqualifiedName)) {
            return 23;
        }
        if ("DECIMAL".equals(this.unqualifiedName)) {
            return 198;
        }
        if ("NUMERIC".equals(this.unqualifiedName)) {
            return 198;
        }
        if ("DOUBLE".equals(this.unqualifiedName)) {
            return 18;
        }
        if ("REAL".equals(this.unqualifiedName)) {
            return 20;
        }
        if ("REF".equals(this.unqualifiedName)) {
            return 21;
        }
        if ("CHAR".equals(this.unqualifiedName)) {
            return 17;
        }
        if ("VARCHAR".equals(this.unqualifiedName)) {
            return 25;
        }
        if ("LONG VARCHAR".equals(this.unqualifiedName)) {
            return 231;
        }
        if ("CLOB".equals(this.unqualifiedName)) {
            return 446;
        }
        if ("JSON".equals(this.unqualifiedName)) {
            return 477;
        }
        if ("CHAR FOR BIT DATA".equals(this.unqualifiedName)) {
            return 28;
        }
        if ("VARCHAR FOR BIT DATA".equals(this.unqualifiedName)) {
            return 30;
        }
        if ("LONG VARCHAR FOR BIT DATA".equals(this.unqualifiedName)) {
            return 233;
        }
        if ("BLOB".equals(this.unqualifiedName)) {
            return 442;
        }
        if ("DATE".equals(this.unqualifiedName)) {
            return 32;
        }
        if ("TIME".equals(this.unqualifiedName)) {
            return 33;
        }
        if ("TIMESTAMP".equals(this.unqualifiedName)) {
            return 34;
        }
        if ("XML".equals(this.unqualifiedName)) {
            return 457;
        }
        return 0;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.unqualifiedName = in.readUTF();
        if (this.unqualifiedName.charAt(0) == '\"') {
            this.schemaName = this.stripQuotes(this.unqualifiedName);
            this.unqualifiedName = in.readUTF();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.schemaName == null) {
            out.writeUTF(this.unqualifiedName);
        } else {
            out.writeUTF(this.doubleQuote(this.schemaName));
            out.writeUTF(this.unqualifiedName);
        }
    }

    private void setTypeIdSpecificInstanceVariables() {
        switch (this.getTypeFormatId()) {
            case 16: {
                this.schemaName = null;
                this.unqualifiedName = "BOOLEAN";
                this.JDBCTypeId = JVMInfo.JAVA_SQL_TYPES_BOOLEAN;
                break;
            }
            case 19: {
                this.schemaName = null;
                this.unqualifiedName = "INTEGER";
                this.JDBCTypeId = 4;
                break;
            }
            case 22: {
                this.schemaName = null;
                this.unqualifiedName = "SMALLINT";
                this.JDBCTypeId = 5;
                break;
            }
            case 196: {
                this.schemaName = null;
                this.unqualifiedName = "TINYINT";
                this.JDBCTypeId = -6;
                break;
            }
            case 23: {
                this.schemaName = null;
                this.unqualifiedName = "BIGINT";
                this.JDBCTypeId = -5;
                break;
            }
            case 198: {
                this.schemaName = null;
                this.unqualifiedName = "DECIMAL";
                this.JDBCTypeId = 3;
                break;
            }
            case 18: {
                this.schemaName = null;
                this.unqualifiedName = "DOUBLE";
                this.JDBCTypeId = 8;
                break;
            }
            case 20: {
                this.schemaName = null;
                this.unqualifiedName = "REAL";
                this.JDBCTypeId = 7;
                break;
            }
            case 21: {
                this.schemaName = null;
                this.unqualifiedName = "REF";
                this.JDBCTypeId = 1111;
                break;
            }
            case 17: {
                this.schemaName = null;
                this.unqualifiedName = "CHAR";
                this.JDBCTypeId = 1;
                break;
            }
            case 25: {
                this.schemaName = null;
                this.unqualifiedName = "VARCHAR";
                this.JDBCTypeId = 12;
                break;
            }
            case 231: {
                this.schemaName = null;
                this.unqualifiedName = "LONG VARCHAR";
                this.JDBCTypeId = -1;
                break;
            }
            case 446: {
                this.schemaName = null;
                this.unqualifiedName = "CLOB";
                this.JDBCTypeId = 2005;
                break;
            }
            case 28: {
                this.schemaName = null;
                this.unqualifiedName = "CHAR () FOR BIT DATA";
                this.JDBCTypeId = -2;
                break;
            }
            case 30: {
                this.schemaName = null;
                this.unqualifiedName = "VARCHAR () FOR BIT DATA";
                this.JDBCTypeId = -3;
                break;
            }
            case 233: {
                this.schemaName = null;
                this.unqualifiedName = "LONG VARCHAR FOR BIT DATA";
                this.JDBCTypeId = -4;
                break;
            }
            case 442: {
                this.schemaName = null;
                this.unqualifiedName = "BLOB";
                this.JDBCTypeId = 2004;
                break;
            }
            case 32: {
                this.schemaName = null;
                this.unqualifiedName = "DATE";
                this.JDBCTypeId = 91;
                break;
            }
            case 33: {
                this.schemaName = null;
                this.unqualifiedName = "TIME";
                this.JDBCTypeId = 92;
                break;
            }
            case 34: {
                this.schemaName = null;
                this.unqualifiedName = "TIMESTAMP";
                this.JDBCTypeId = 93;
                break;
            }
            case 457: {
                this.schemaName = null;
                this.unqualifiedName = "XML";
                this.JDBCTypeId = 2009;
                break;
            }
            case 477: {
                this.schemaName = null;
                this.unqualifiedName = "JSON";
                this.JDBCTypeId = 4001;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unexpected formatId " + this.getTypeFormatId()));
            }
        }
    }

    private String doubleQuote(String raw) {
        return '\"' + raw + '\"';
    }

    private String stripQuotes(String quoted) {
        return quoted.substring(1, quoted.length() - 1);
    }
}

