/*
 * Copyright (c) 2016 SnappyData, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */

package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.reference.SQLState;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;

import java.sql.SQLWarning;
import java.sql.Timestamp;

public abstract class AbstractSnappyResultSet implements ResultSet {

  final protected Activation activation;

  protected boolean isClosed;

  public AbstractSnappyResultSet(Activation ac) {
    this.activation = ac;
  }

  @Override
  public abstract boolean returnsRows();

  @Override
  public int modifiedRowCount() {
    return 0;
  }

  @Override
  public Activation getActivation() {
    return this.activation;
  }

  @Override
  public final void checkCancellationFlag() throws StandardException {
    final Activation act = this.activation;
    if (act != null && act.isQueryCancelled()) {
      act.checkCancellationFlag();
    }
  }

  @Override
  public void open() throws StandardException {
  }

  @Override
  public ExecRow getAbsoluteRow(int row) throws StandardException {
    throw StandardException.newException(SQLState.LANG_DOES_NOT_RETURN_ROWS,
      "absolute");
  }

  @Override
  public ExecRow getRelativeRow(int row) throws StandardException {
    throw StandardException.newException(SQLState.LANG_DOES_NOT_RETURN_ROWS,
      "relative");
  }

  @Override
  public ExecRow setBeforeFirstRow() throws StandardException {
    throw StandardException.newException(SQLState.LANG_DOES_NOT_RETURN_ROWS,
      "beforeFirst");
  }

  @Override
  public ExecRow getFirstRow() throws StandardException {
    throw StandardException.newException(SQLState.LANG_DOES_NOT_RETURN_ROWS,
      "first");
  }

  @Override
  public ExecRow getNextRow() throws StandardException {
    throw StandardException.newException(SQLState.LANG_DOES_NOT_RETURN_ROWS,
      "getNextRow");
  }

  @Override
  public ExecRow getPreviousRow() throws StandardException {
    throw StandardException.newException(SQLState.LANG_DOES_NOT_RETURN_ROWS,
      "previous");
  }

  @Override
  public ExecRow getLastRow() throws StandardException {
    throw StandardException.newException(SQLState.LANG_DOES_NOT_RETURN_ROWS,
      "last");
  }

  @Override
  public ExecRow setAfterLastRow() throws StandardException {
    throw StandardException.newException(SQLState.LANG_DOES_NOT_RETURN_ROWS,
      "afterLast");
  }

  @Override
  public void clearCurrentRow() {
  }

  @Override
  public boolean checkRowPosition(int isType) throws StandardException {
    throw new UnsupportedOperationException("Not supported yet");
  }

  @Override
  public int getRowNumber() {
    return 0;
  }

  @Override
  public void close(boolean cleanupOnError) throws StandardException {
    // TODO: Need to see what needs to go here. activation close??
  }

  @Override
  public void cleanUp(boolean cleanupOnError) throws StandardException {
    close(cleanupOnError);
  }

  @Override
  public boolean isClosed() {
    return this.isClosed;
  }

  @Override
  public void finish() throws StandardException {
    close(false);
  }

  @Override
  public long getExecuteTime() {
    return -1;
  }

  @Override
  public Timestamp getBeginExecutionTimestamp() {
    // TODO: probably needs an implementation
    return null;
  }

  @Override
  public Timestamp getEndExecutionTimestamp() {
    // TODO: probably needs an implementation
    return null;
  }

  @Override
  public long getTimeSpent(int type, int timeType) {
    // TODO: probably needs an implementation
    return 0;
  }

  @Override
  public NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
    return new NoPutResultSet[0];
  }

  @Override
  public ResultSet getAutoGeneratedKeysResultset() {
    throw new UnsupportedOperationException("requires implementation in child");
  }

  @Override
  public UUID getExecutionPlanID() {
    // TODO: probably needs an implementation
    return null;
  }

  @Override
  public boolean hasAutoGeneratedKeysResultSet() {
    return false;
  }

  @Override
  public void flushBatch() throws StandardException {

  }

  @Override
  public void closeBatch() throws StandardException {

  }

  @Override
  public String getCursorName() {
    return null;
  }

  @Override
  public SQLWarning getWarnings() {
    // TODO: warnings we might need
    return null;
  }

  @Override
  public void accept(ResultSetStatisticsVisitor visitor) {
  }

  @Override
  public void markLocallyExecuted() {
  }

  @Override
  public void resetStatistics() {
  }

  @Override
  public boolean isDistributedResultSet() {
    return false;
  }

  @Override
  public boolean addLockReference(GemFireTransaction tran) {
    return false;
  }

  @Override
  public boolean releaseLocks(GemFireTransaction tran) {
    return false;
  }
}
