/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.pxf.plugins.gemfirexd.util;

import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.RowInputFormat;
import com.pivotal.pxf.api.io.DataType;
import com.pivotal.pxf.api.utilities.ColumnDescriptor;
import com.pivotal.pxf.api.utilities.InputData;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GemFireXDManager {
    private static Object lockObject = new Object();
    private static boolean lonerSystemInUse = false;
    private static long latestDDLFilesTimestamp = -1L;
    private InputData inputData;
    private String homeDir = "";
    private InputSplit split;
    private String schemaTableName = "";
    private ArrayList<String> gfxdColumnNames;
    private ArrayList<Integer> gfxdColumnTypes;
    private Logger logger;
    public static final byte RESTART_LONER_SYSTEM_CODE = 1;
    public static final byte HOME_DIR_CODE = 2;
    public static final byte SCHEMA_TABLE_NAME_CODE = 3;
    public static final byte SPLIT_CODE = 4;
    public static final int WAIT_ITERATION_LIMIT = 30;
    public static final String DATE_PATTERN = "yyyy.MM.dd'-'HH:mm:ss";
    public static final String DATE_PATTERN_Z = "yyyy.MM.dd'-'HH:mm:ssz";
    public static final String LOCATION_FORMAT = "LOCATION format: 'pxf://namenode_rest_host:namenode_rest_port/hdfsstore_homedir/schemaname.tablename?PROFILE=GemFireXD[&attribute=value]*'";
    public static final String RESERVED_COLUMN_TIMESTAMP = "GFXD_PXF_TS";
    public static final String RESERVED_COLUMN_EVENTTYPE = "GFXD_PXF_EVENTTYPE";
    public static final String GFXD_PROTOCOL = "jdbc:gemfirexd:";
    public static final String DRIVER_FOR_STAND_ALONE_GFXDIRE = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    public static final String CHECKPOINT_NAME = "CHECKPOINT";
    public static final String STARTTIME_NAME = "STARTTIME";
    public static final String ENDTIME_NAME = "ENDTIME";
    public static final long RESTART_INTERVAL = 60000L;
    private static final int NUM_OF_RESERVED_COLUMNS = 2;

    public GemFireXDManager(InputData inData) {
        this(inData, false);
    }

    public GemFireXDManager(InputData inData, boolean isFragmenter) {
        this.inputData = inData;
        if (isFragmenter) {
            String[] info = GemFireXDManager.deconstructPath(inData.getDataSource());
            this.homeDir = info[0];
            this.schemaTableName = info[1].toUpperCase(Locale.ENGLISH) + "." + info[2].toUpperCase(Locale.ENGLISH);
        }
        this.logger = LoggerFactory.getLogger(GemFireXDManager.class);
    }

    private void loadTableMetaData(ResultSet rs) throws SQLException {
        this.gfxdColumnNames = new ArrayList();
        this.gfxdColumnTypes = new ArrayList();
        while (rs.next()) {
            String name = rs.getString("COLUMN_NAME");
            int type = rs.getInt("DATA_TYPE");
            this.logger.debug("gfxd column name, type " + name + ", " + type);
            this.gfxdColumnNames.add(name);
            this.gfxdColumnTypes.add(type);
        }
    }

    public String verifyUserAttributes() {
        String readMode = null;
        String start = null;
        String end = null;
        StringBuilder msg = new StringBuilder();
        readMode = this.inputData.getUserProperty(CHECKPOINT_NAME);
        if (readMode != null && !"true".equalsIgnoreCase(readMode) && !"false".equalsIgnoreCase(readMode)) {
            msg.append("Value for optional attribute 'CHECKPOINT' must either be 'true' or 'false'. ");
            this.logger.error(msg.toString());
        }
        start = this.inputData.getUserProperty(STARTTIME_NAME);
        end = this.inputData.getUserProperty(ENDTIME_NAME);
        String errorMsg = this.validateTime(start);
        if (errorMsg == null) {
            errorMsg = this.validateTime(end);
            if (errorMsg != null) {
                msg.append(errorMsg);
            }
        } else {
            msg.append(errorMsg);
        }
        return msg.toString();
    }

    private String validateTime(String time) {
        if (time == null || time.trim().equals("")) {
            return null;
        }
        SimpleDateFormat sdfz = new SimpleDateFormat(DATE_PATTERN_Z);
        sdfz.setTimeZone(TimeZone.getTimeZone("GMT"));
        String str = null;
        try {
            sdfz.parse(time);
        }
        catch (ParseException pe) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                sdf.parse(time);
            }
            catch (ParseException pez) {
                str = "Value of STARTTIME and/or ENDTIME could not be parsed. Expected format is 'yyyy.MM.dd'-'HH:mm:ss' without the single quotes, e.g. 2013.12.31-23:59:59 or, with timezone, 2013.12.31-23:59:59PST";
                this.logger.error(str);
            }
        }
        return str;
    }

    public boolean verifyTableSchema() {
        int extColumns = this.inputData.getColumns();
        if (extColumns <= 0 || this.gfxdColumnNames.size() + 2 < extColumns) {
            this.logger.error("Number of columns (" + extColumns + ") in external table do no match with those (" + this.gfxdColumnNames.size() + ") in GemFireXD table.");
            return false;
        }
        return this.checkColumns(extColumns);
    }

    private boolean checkColumns(int extColumns) {
        boolean response = true;
        boolean[] match = new boolean[extColumns];
        for (int extIdx = 0; extIdx < extColumns; ++extIdx) {
            ColumnDescriptor extColumn = this.inputData.getColumn(extIdx);
            for (int gfxdIdx = 0; gfxdIdx < this.gfxdColumnNames.size(); ++gfxdIdx) {
                if (!this.gfxdColumnNames.get(gfxdIdx).equalsIgnoreCase(extColumn.columnName()) || !GemFireXDManager.matchColumnTypes(this.gfxdColumnTypes.get(gfxdIdx), extColumn.columnTypeCode())) continue;
                match[extIdx] = true;
                break;
            }
            if (extColumn.columnName().equalsIgnoreCase(RESERVED_COLUMN_TIMESTAMP)) {
                if (extColumn.columnTypeCode() == DataType.TIMESTAMP.getOID()) {
                    match[extIdx] = true;
                } else {
                    this.logger.error("Column 'GFXD_PXF_TS' must be of type 'TIMESTAMP', if defined.");
                    response = false;
                }
            }
            if (!extColumn.columnName().equalsIgnoreCase(RESERVED_COLUMN_EVENTTYPE)) continue;
            if (extColumn.columnTypeCode() == DataType.VARCHAR.getOID()) {
                match[extIdx] = true;
                continue;
            }
            this.logger.error("Column 'GFXD_PXF_EVENTTYPE' must be of type 'VARCHAR', if defined.");
            response = false;
        }
        for (int i = 0; i < extColumns; ++i) {
            if (match[i]) continue;
            ColumnDescriptor cd = this.inputData.getColumn(i);
            this.logger.error("Did not find '" + cd.columnName() + "' with type id " + cd.columnTypeCode() + " in " + this.schemaTableName);
            response = false;
        }
        return response;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static boolean matchColumnTypes(int sqlType, int pxfType) {
        switch (DataType.get((int)pxfType)) {
            case SMALLINT: {
                return sqlType == 5;
            }
            case INTEGER: {
                return sqlType == 4;
            }
            case BIGINT: {
                return sqlType == -5;
            }
            case REAL: {
                return sqlType == 7;
            }
            case FLOAT8: {
                return sqlType == 8;
            }
            case VARCHAR: {
                return sqlType == 12;
            }
            case BOOLEAN: {
                return sqlType == 16;
            }
            case NUMERIC: {
                return sqlType == 2;
            }
            case TIMESTAMP: {
                return sqlType == 93;
            }
            case BPCHAR: {
                return sqlType == 12 || sqlType == 1;
            }
            case BYTEA: {
                return sqlType == -2 || sqlType == 2004;
            }
            case TEXT: {
                return sqlType == 12;
            }
            case DATE: {
                return sqlType == 91;
            }
            case TIME: {
                return sqlType == 92;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDDLTimeStampChanged() throws IOException {
        boolean tsChanged = false;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return true;
        }
        ArrayList stores = cache.getAllHDFSStores();
        long newTimestamp = -1L;
        long ts = latestDDLFilesTimestamp;
        for (HDFSStoreImpl store : stores) {
            newTimestamp = store.getDDLHoplogOrganizer().getCurrentHoplogTimeStamp();
            if (ts >= newTimestamp) continue;
            if (latestDDLFilesTimestamp != -1L) {
                this.logger.info("Update to DDLs at " + store.getHomeDir() + " detected. Loner system will be restarted. Old and new timestamps are " + latestDDLFilesTimestamp + ", " + newTimestamp);
            }
            ts = newTimestamp;
        }
        Object object = lockObject;
        synchronized (object) {
            if (latestDDLFilesTimestamp < ts) {
                tsChanged = true;
            }
            latestDDLFilesTimestamp = ts;
        }
        return tsChanged;
    }

    public void updateDDLTimeStampIfNeeded() throws IOException {
        if (latestDDLFilesTimestamp == -1L) {
            this.isDDLTimeStampChanged();
        }
    }

    public boolean shutdown() {
        return this.shutdown(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(Properties props) {
        Object object = lockObject;
        synchronized (object) {
            block7: {
                try {
                    FabricService service;
                    if (props == null) {
                        props = new Properties();
                    }
                    if ((service = FabricServiceManager.currentFabricServiceInstance()) != null) {
                        service.stop(props);
                    }
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == 50000 && "XJ015".equals(sqle.getSQLState())) break block7;
                    return false;
                }
            }
            return true;
        }
    }

    public InputFormat<Key, Row> getInputFormat() {
        RowInputFormat inFormat = new RowInputFormat();
        return inFormat;
    }

    public void configureJob(JobConf jobConf, String homeDirs) {
        String checkpoint = null;
        String start = null;
        String end = null;
        checkpoint = this.inputData.getUserProperty(CHECKPOINT_NAME);
        if (checkpoint == null) {
            checkpoint = "TRUE";
        }
        start = this.inputData.getUserProperty(STARTTIME_NAME);
        end = this.inputData.getUserProperty(ENDTIME_NAME);
        this.logger.debug("Setting checkpoint mode to " + checkpoint);
        jobConf.set("gfxd.input.checkpointmode", checkpoint);
        if (start != null && !start.trim().equals("")) {
            jobConf.set("gfxd.input.starttimemillis", this.getTime(start, 0L));
        }
        if (end != null && !end.trim().equals("")) {
            jobConf.set("gfxd.input.endtimemillis", this.getTime(end, System.currentTimeMillis()));
        }
        this.logger.debug("Setting home-dir and schema.table in jobConf: " + this.homeDir + ", " + this.schemaTableName);
        jobConf.set("gfxd.input.homedir", homeDirs);
        jobConf.set("gfxd.input.tablename", this.schemaTableName);
    }

    private String getTime(String time, long defaultTime) {
        long longTime = defaultTime;
        SimpleDateFormat sdfz = new SimpleDateFormat(DATE_PATTERN_Z);
        sdfz.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            longTime = sdfz.parse(time).getTime();
        }
        catch (ParseException pe) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                longTime = sdf.parse(time).getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return String.valueOf(longTime);
    }

    public static String[] deconstructPath(String path) {
        String[] result = new String[]{"", "", ""};
        int index = path.lastIndexOf("/");
        if (index <= 0 || index == path.length() - 1) {
            throw new IllegalArgumentException("Invalid LOCATION: " + path + ". " + LOCATION_FORMAT);
        }
        result[0] = "/" + path.substring(0, index);
        int periodIndex = path.indexOf(".");
        if (periodIndex <= 0 || periodIndex == path.length() - 1) {
            throw new IllegalArgumentException("No schemaname specified in LOCATION: " + path + ". " + LOCATION_FORMAT);
        }
        result[1] = path.substring(index + 1, periodIndex);
        result[2] = path.substring(periodIndex + 1);
        return result;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String getTable() {
        return this.schemaTableName;
    }

    public byte[] populateUserData(CombineFileSplit cSplit) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.write(2);
        out.writeUTF(this.homeDir);
        out.write(3);
        out.writeUTF(this.schemaTableName);
        out.write(4);
        cSplit.write((DataOutput)out);
        return baos.toByteArray();
    }

    public void readUserData() throws IOException {
        byte[] data = this.inputData.getFragmentMetadata();
        if (data != null && data.length > 0) {
            boolean done = false;
            ByteArrayDataInput in = new ByteArrayDataInput();
            in.initialize(data, null);
            block7: while (!done) {
                try {
                    switch (in.readByte()) {
                        case 2: {
                            this.homeDir = in.readUTF();
                            this.logger.debug("Accessor received home dir: " + this.homeDir);
                            continue block7;
                        }
                        case 3: {
                            this.schemaTableName = in.readUTF();
                            this.logger.debug("Accessor received schemaTable name: " + this.schemaTableName);
                            continue block7;
                        }
                        case 4: {
                            this.split = new CombineFileSplit();
                            this.split.readFields((DataInput)in);
                            this.logger.debug("Accessor split read, total length: " + this.split.getLength());
                            done = true;
                            continue block7;
                        }
                    }
                    this.logger.error("Internal error: Invalid data from fragmenter.");
                    done = true;
                }
                catch (EOFException eofe) {
                    this.logger.error("Internal error: Invalid data from fragmenter.");
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLonerSystemInUse() {
        Object object = lockObject;
        synchronized (object) {
            lonerSystemInUse = false;
            lockObject.notifyAll();
        }
    }

    public InputSplit getSplit() {
        return this.split;
    }
}

