/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot;

import com.gemstone.gemfire.internal.cache.snapshot.GFSnapshot;
import com.gemstone.gemfire.internal.cache.snapshot.SnapshotPacket;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.pivotal.gemfirexd.internal.tools.dataextractor.extractor.GemFireXDDataExtractorImpl;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.views.RegionViewInfoPerMember;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExportStat;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

public final class GFXDSnapshot
extends GFSnapshot {
    private static final String DDL_META_REGION_PATH = "/_DDL_STMTS_META_REGION";
    public static final String QUEUE_REGION_PREFIX = "/AsyncEventQueue_GEMFIRE_HDFS_BUCKETSORTED_QUEUE";
    public static final String QUEUE_REGION_STRING = "AsyncEventQueue_GEMFIRE_HDFS_BUCKETSORTED_QUEUE";
    public static final String QUEUE_REGION_SHORT = "GF_QUEUE";
    public static final String PDX_TYPES_REGION = "/GFXD_PdxTypes";

    private GFXDSnapshot() {
        super(true);
    }

    public static GFSnapshot.SnapshotWriter create(File snapshot, String region, List<GFXDSnapshotExportStat> listOfStats, RegionViewInfoPerMember regionViewInfo, String stringDelimiter) throws IOException {
        try {
            final GFXDSnapshotExporter out = new GFXDSnapshotExporter(snapshot, region, listOfStats, regionViewInfo, stringDelimiter);
            if (!out.isInitOk()) {
                return null;
            }
            return new GFSnapshot.SnapshotWriter(){

                public void snapshotEntry(SnapshotPacket.SnapshotRecord entry) throws IOException {
                }

                public void snapshotEntry(Object key, Object value, VersionTag versionTag, long lastModified) throws IOException {
                    out.writeSnapshotEntry(key, value, versionTag, lastModified);
                }

                public void snapshotEntry(SnapshotPacket.SnapshotRecord entry, VersionTag versionTag, long lastModified) throws IOException {
                    out.writeSnapshotEntry(entry, versionTag, lastModified);
                }

                public void snapshotComplete() throws IOException {
                    out.close();
                }
            };
        }
        catch (FileNotFoundException fnfe) {
            GemFireXDDataExtractorImpl.logSevere("Unable to export table due to " + fnfe, true);
            return null;
        }
    }

    public static String[] getSchemaTableBucketNames(String regionName) {
        String schemaName = null;
        String tableName = null;
        String bucketName = null;
        String[] names = new String[3];
        if (regionName.equals(DDL_META_REGION_PATH)) {
            tableName = regionName;
        } else if (regionName.startsWith("/_")) {
            tableName = regionName;
        } else if (!regionName.contains(QUEUE_REGION_SHORT)) {
            String[] regionStrings = regionName.split("/");
            schemaName = regionStrings[1];
            tableName = regionStrings[2];
            if (regionStrings.length > 4) {
                bucketName = regionStrings[4];
                bucketName = bucketName.replace("/", "_");
            }
        }
        names[0] = schemaName;
        names[1] = tableName;
        names[2] = bucketName;
        return names;
    }
}

