/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.domain;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ServerInfo {
    private String serverName;
    private List<String> diskStoreNames;
    private List<String> diskStoreDirectories;
    private String dataDictionaryLocation;
    private String serverDirectory;

    private ServerInfo(Builder builder) {
        this.setServerName(builder.serverName);
        this.setServerDirectory(builder.serverDirectory);
        this.setDataDictionaryLocation(builder.dataDictionaryLocation);
        this.setDiskStoreDirectories(builder.diskStoreDirectories);
        this.setDiskStoreNames(builder.diskStoreNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ServerInfo> createServerInfoList(String propFilePath) throws IOException {
        HashMap<String, ServerInfo> serverInfoMap = new HashMap<String, ServerInfo>();
        Properties props = new Properties();
        File file = new File(propFilePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Properties file: " + propFilePath + " does not exist, please specify the properties file");
        }
        try (FileReader reader = new FileReader(file);){
            props.load(reader);
            if (!props.isEmpty()) {
                Set<Object> keys = props.keySet();
                for (Object key : keys) {
                    String serverName = (String)key;
                    String diskStoreCSL = props.getProperty(serverName);
                    String[] diskDirs = diskStoreCSL.split(",");
                    if (diskDirs == null || diskDirs.length <= 0) continue;
                    String serverDirectory = diskDirs[0];
                    Builder builder = new Builder();
                    builder.serverName(serverName);
                    builder.serverDirectory(serverDirectory);
                    List<String> diskStoreDirs = Arrays.asList(diskDirs);
                    builder.diskStoreDirs(diskStoreDirs);
                    ServerInfo serverInfo = builder.build();
                    serverInfoMap.put(serverName, serverInfo);
                }
            }
        }
        return serverInfoMap;
    }

    public List<String> getDiskStoreNames() {
        return this.diskStoreNames;
    }

    public void setDiskStoreNames(List<String> diskStoreNames) {
        this.diskStoreNames = diskStoreNames;
    }

    public List<String> getDiskStoreDirectories() {
        return this.diskStoreDirectories;
    }

    public void setDiskStoreDirectories(List<String> diskStoreDirectories) {
        this.diskStoreDirectories = diskStoreDirectories;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getDataDictionaryLocation() {
        return this.dataDictionaryLocation;
    }

    public void setDataDictionaryLocation(String dataDictionaryLocation) {
        this.dataDictionaryLocation = dataDictionaryLocation;
    }

    public String getServerDirectory() {
        return this.serverDirectory;
    }

    public void setServerDirectory(String serverDirectory) {
        this.serverDirectory = serverDirectory;
    }

    public static class Builder {
        private String serverName;
        private List<String> diskStoreNames;
        private List<String> diskStoreDirectories;
        private String dataDictionaryLocation;
        private String serverDirectory;

        public ServerInfo build() {
            return new ServerInfo(this);
        }

        public Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public Builder diskStoreNames(List<String> diskStoreNames) {
            this.diskStoreNames = diskStoreNames;
            return this;
        }

        public Builder diskStoreDirs(List<String> diskStoreDirs) {
            this.diskStoreDirectories = new ArrayList<String>();
            Iterator<String> iterator = diskStoreDirs.iterator();
            while (iterator.hasNext()) {
                this.diskStoreDirectories.add(iterator.next().trim());
            }
            return this;
        }

        public Builder dataDictionaryLocation(String dataDictionaryLocation) {
            this.dataDictionaryLocation = dataDictionaryLocation;
            return this;
        }

        public Builder serverDirectory(String serverDirectory) {
            this.serverDirectory = serverDirectory;
            return this;
        }
    }
}

