/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.StreamContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.DropOnCommit;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.StreamFileContainer;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;

final class StreamFileContainerHandle
implements StreamContainerHandle,
Observer {
    private final UUID rawStoreId;
    protected final ContainerKey identity;
    protected boolean active;
    protected StreamFileContainer container;
    protected RawTransaction xact;
    private boolean hold;

    public StreamFileContainerHandle(UUID rawStoreId, RawTransaction xact, ContainerKey identity, boolean hold) {
        this.identity = identity;
        this.xact = xact;
        this.rawStoreId = rawStoreId;
        this.hold = hold;
    }

    public StreamFileContainerHandle(UUID rawStoreId, RawTransaction xact, StreamFileContainer container, boolean hold) {
        this.identity = container.getIdentity();
        this.xact = xact;
        this.rawStoreId = rawStoreId;
        this.hold = hold;
        this.container = container;
    }

    @Override
    public void getContainerProperties(Properties prop) throws StandardException {
        this.container.getContainerProperties(prop);
    }

    @Override
    public boolean fetchNext(ExecRow row) throws StandardException {
        return this.container.fetchNext(row.getRowArray());
    }

    @Override
    public void close() {
        if (this.xact == null) {
            SanityManager.ASSERT((!this.active ? 1 : 0) != 0);
            return;
        }
        this.active = false;
        this.container.close();
        this.container = null;
        this.xact.deleteObserver(this);
        this.xact = null;
    }

    @Override
    public void removeContainer() throws StandardException {
        this.container.removeContainer();
    }

    @Override
    public ContainerKey getId() {
        return this.identity;
    }

    @Override
    public void update(Observable obj, Object arg) {
        if (arg == null) {
            SanityManager.THROWASSERT((String)("still on observr list " + this));
        }
        if (this.xact == null) {
            return;
        }
        if (obj != this.xact) {
            SanityManager.THROWASSERT((String)("Observable passed to update is incorrect expected " + this.xact + " got " + obj));
        }
        if (arg.equals(RawTransaction.COMMIT) || arg.equals(RawTransaction.ABORT) || arg.equals(this.identity)) {
            this.close();
            return;
        }
        if (arg.equals(RawTransaction.SAVEPOINT_ROLLBACK)) {
            return;
        }
    }

    public boolean useContainer() throws StandardException {
        SanityManager.ASSERT((!this.active ? 1 : 0) != 0);
        SanityManager.ASSERT((this.container != null ? 1 : 0) != 0);
        if (!this.container.use(this)) {
            this.container = null;
            return false;
        }
        this.active = true;
        if (!this.hold) {
            this.xact.addObserver(this);
            this.xact.addObserver(new DropOnCommit(this.identity, true));
        }
        return true;
    }

    public final RawTransaction getTransaction() {
        SanityManager.ASSERT((this.xact != null ? 1 : 0) != 0);
        return this.xact;
    }

    @Override
    public ExecRow getTemplateRow() {
        return null;
    }

    public String toString() {
        String str = new String();
        str = str + "StreamContainerHandle:(" + this.identity.toString() + ")";
        return str;
    }
}

