/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.DataFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BufferedByteHolderInputStream;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.ByteHolder;
import java.io.IOException;
import java.io.InputStream;

public class DecryptInputStream
extends BufferedByteHolderInputStream {
    protected DataFactory dataFactory;
    protected InputStream in;

    public DecryptInputStream(InputStream in, ByteHolder bh, DataFactory dataFactory) throws IOException {
        super(bh);
        this.in = in;
        this.dataFactory = dataFactory;
        this.fillByteHolder();
    }

    @Override
    public void fillByteHolder() throws IOException {
        if (this.bh.available() == 0) {
            this.bh.clear();
            try {
                int realLen = CompressedNumber.readInt(this.in);
                if (realLen == -1) {
                    return;
                }
                int tail = realLen % this.dataFactory.getEncryptionBlockSize();
                int padding = tail == 0 ? 0 : this.dataFactory.getEncryptionBlockSize() - tail;
                int encryptedLen = realLen + padding;
                byte[] ciphertext = new byte[encryptedLen];
                this.in.read(ciphertext, 0, encryptedLen);
                byte[] cleartext = new byte[encryptedLen];
                this.dataFactory.decrypt(ciphertext, 0, encryptedLen, cleartext, 0);
                this.bh.write(cleartext, padding, realLen);
            }
            catch (StandardException se) {
                throw new IOException();
            }
            this.bh.startReading();
        }
    }
}

